/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.calendar;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;
import org.primefaces.component.calendar.Calendar;
import org.primefaces.component.calendar.CalendarUtils;
import org.primefaces.event.DateSelectEvent;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.resource.ResourceUtils;
import org.primefaces.util.ComponentUtils;

public class CalendarRenderer
extends CoreRenderer {
    public void decode(FacesContext facesContext, UIComponent component) {
        String param;
        Calendar calendar = (Calendar)component;
        Map params = facesContext.getExternalContext().getRequestParameterMap();
        if (params.containsKey(param = calendar.getClientId(facesContext) + "_input")) {
            calendar.setSubmittedValue(params.get(param));
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        Calendar calendar = (Calendar)component;
        String value = CalendarUtils.getValueAsString(facesContext, calendar);
        this.encodeMarkup(facesContext, calendar, value);
        this.encodeScript(facesContext, calendar, value);
    }

    protected void encodeMarkup(FacesContext facesContext, Calendar calendar, String value) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = calendar.getClientId(facesContext);
        String inputId = clientId + "_input";
        writer.startElement("span", (UIComponent)calendar);
        writer.writeAttribute("id", (Object)clientId, null);
        if (calendar.getStyle() != null) {
            writer.writeAttribute("style", (Object)calendar.getStyle(), null);
        }
        if (calendar.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)calendar.getStyleClass(), null);
        }
        if (!calendar.isPopup()) {
            writer.startElement("div", null);
            writer.writeAttribute("id", (Object)(clientId + "_inline"), null);
            writer.endElement("div");
        }
        String type = calendar.isPopup() ? "text" : "hidden";
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)inputId, null);
        writer.writeAttribute("name", (Object)inputId, null);
        writer.writeAttribute("type", (Object)type, null);
        if (value != null) {
            writer.writeAttribute("value", (Object)value, null);
        }
        if (calendar.isPopup()) {
            if (calendar.getInputStyle() != null) {
                writer.writeAttribute("style", (Object)calendar.getInputStyle(), null);
            }
            if (calendar.getInputStyleClass() != null) {
                writer.writeAttribute("class", (Object)calendar.getInputStyleClass(), null);
            }
            if (calendar.isReadOnlyInputText()) {
                writer.writeAttribute("readonly", (Object)"readonly", null);
            }
            if (calendar.isDisabled()) {
                writer.writeAttribute("disabled", (Object)"disabled", null);
            }
        }
        writer.endElement("input");
        writer.endElement("span");
    }

    protected void encodeScript(FacesContext facesContext, Calendar calendar, String value) throws IOException {
        String showOn;
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = calendar.getClientId(facesContext);
        String widgetVar = this.createUniqueWidgetVar(facesContext, (UIComponent)calendar);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("jQuery(function(){");
        writer.write(widgetVar + " = new PrimeFaces.widget.Calendar('" + clientId + "', {");
        writer.write("popup:" + calendar.isPopup());
        writer.write(",locale:'" + calendar.calculateLocale(facesContext).toString() + "'");
        if (value != null) {
            writer.write(",defaultDate:'" + value + "'");
        }
        if (calendar.getPattern() != null) {
            writer.write(",dateFormat:'" + CalendarUtils.convertPattern(calendar.getPattern()) + "'");
        }
        if (calendar.getPages() != 1) {
            writer.write(",numberOfMonths:" + calendar.getPages());
        }
        if (calendar.getMindate() != null) {
            writer.write(",minDate:'" + CalendarUtils.getDateAsString(calendar, calendar.getMindate() + "'"));
        }
        if (calendar.getMaxdate() != null) {
            writer.write(",maxDate:'" + CalendarUtils.getDateAsString(calendar, calendar.getMaxdate() + "'"));
        }
        if (calendar.isShowButtonPanel()) {
            writer.write(",showButtonPanel:true");
        }
        if (calendar.isShowWeek()) {
            writer.write(",showWeek:true");
        }
        if (calendar.isDisabled()) {
            writer.write(",disabled:true");
        }
        if (calendar.isNavigator()) {
            writer.write(",changeMonth:true");
            writer.write(",changeYear:true");
        }
        if (calendar.getEffect() != null) {
            writer.write(",showAnim:'" + calendar.getEffect() + "'");
            writer.write(",duration:'" + calendar.getEffectDuration() + "'");
        }
        if ((showOn = calendar.getShowOn()) != null) {
            writer.write(",showOn:'" + showOn + "'");
            if (showOn.equalsIgnoreCase("button")) {
                String iconSrc = calendar.getPopupIcon() != null ? this.getResourceURL(facesContext, calendar.getPopupIcon()) : ResourceUtils.getResourceURL(facesContext, Calendar.POPUP_ICON);
                writer.write(",buttonImage:'" + iconSrc + "'");
                writer.write(",buttonImageOnly:" + calendar.isPopupIconOnly());
            }
        }
        if (calendar.isShowOtherMonths()) {
            writer.write(",showOtherMonths:true");
            writer.write(",selectOtherMonths:" + calendar.isSelectOtherMonths());
        }
        if (calendar.getSelectListener() != null) {
            UIComponent form = ComponentUtils.findParentForm(facesContext, (UIComponent)calendar);
            if (form == null) {
                throw new FacesException("Calendar \"" + calendar.getClientId(facesContext) + "\" must be enclosed with a form when using ajax selection.");
            }
            writer.write(",formId:'" + form.getClientId(facesContext) + "'");
            writer.write(",url:'" + this.getActionURL(facesContext) + "'");
            writer.write(",hasSelectListener:true");
            if (calendar.getOnSelectUpdate() != null) {
                writer.write(",onSelectUpdate:'" + ComponentUtils.findClientIds(facesContext, (UIComponent)calendar, calendar.getOnSelectUpdate()) + "'");
            }
        }
        writer.write("});});");
        writer.endElement("script");
    }

    public Object getConvertedValue(FacesContext facesContext, UIComponent component, Object value) throws ConverterException {
        Calendar calendar = (Calendar)component;
        String submittedValue = (String)value;
        if (this.isValueBlank(submittedValue)) {
            return null;
        }
        if (calendar.getConverter() != null) {
            return calendar.getConverter().getAsObject(facesContext, (UIComponent)calendar, submittedValue);
        }
        try {
            Locale locale = calendar.calculateLocale(facesContext);
            SimpleDateFormat format = new SimpleDateFormat(calendar.getPattern(), locale);
            format.setTimeZone(calendar.calculateTimeZone());
            Date convertedValue = format.parse(submittedValue);
            calendar.queueEvent(new DateSelectEvent((UIComponent)calendar, convertedValue));
            return convertedValue;
        }
        catch (ParseException e) {
            throw new ConverterException((Throwable)e);
        }
    }
}

