/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.autocomplete;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.event.PhaseId;
import javax.servlet.ServletResponse;
import org.primefaces.component.autocomplete.AutoComplete;
import org.primefaces.event.SelectEvent;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.renderkit.PartialRenderer;
import org.primefaces.util.ComponentUtils;

public class AutoCompleteRenderer
extends CoreRenderer
implements PartialRenderer {
    public void decode(FacesContext facesContext, UIComponent component) {
        String valueParam;
        AutoComplete autoComplete = (AutoComplete)component;
        Map params = facesContext.getExternalContext().getRequestParameterMap();
        String clientId = autoComplete.getClientId(facesContext);
        String string = valueParam = autoComplete.getVar() == null ? clientId + "_input" : clientId + "_hinput";
        if (params.containsKey(valueParam)) {
            autoComplete.setSubmittedValue(params.get(valueParam));
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        AutoComplete autoComplete = (AutoComplete)component;
        this.encodeMarkup(facesContext, autoComplete);
        this.encodeScript(facesContext, autoComplete);
    }

    public void encodePartially(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        AutoComplete autoComplete = (AutoComplete)component;
        String clientId = autoComplete.getClientId(facesContext);
        String var = autoComplete.getVar();
        ServletResponse response = (ServletResponse)facesContext.getExternalContext().getResponse();
        response.setContentType("application/json");
        MethodExpression me = autoComplete.getCompleteMethod();
        String query = (String)facesContext.getExternalContext().getRequestParameterMap().get(clientId + "_query");
        List results = (List)me.invoke(facesContext.getELContext(), new Object[]{query});
        writer.write("{");
        writer.write("\"results\" : [");
        Iterator iterator = results.iterator();
        while (iterator.hasNext()) {
            Object result = iterator.next();
            if (result == null) continue;
            if (var == null) {
                writer.write("{\"label\":\"" + this.escapeQuotes((String)result) + "\"}");
            } else {
                facesContext.getExternalContext().getRequestMap().put(var, result);
                String itemLabel = this.escapeQuotes(autoComplete.getItemLabel());
                String itemValue = this.escapeQuotes(ComponentUtils.getStringValueToRender(facesContext, (UIComponent)autoComplete, autoComplete.getItemValue()));
                writer.write("{");
                writer.write("\"label\":\"" + itemLabel + "\"");
                writer.write(",\"data\":\"" + itemValue + "\"");
                writer.write("}");
            }
            if (!iterator.hasNext()) continue;
            writer.write(",");
        }
        if (var != null) {
            facesContext.getExternalContext().getRequestMap().remove(var);
        }
        writer.write("]");
        writer.write("}");
    }

    private String escapeQuotes(String value) {
        if (value == null) {
            return "";
        }
        return value.replaceAll("\"", "\\\\\"");
    }

    protected void encodeMarkup(FacesContext facesContext, AutoComplete ac) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = ac.getClientId(facesContext);
        Object value = ac.getValue();
        writer.startElement("span", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)(clientId + "_input"), null);
        writer.writeAttribute("name", (Object)(clientId + "_input"), null);
        writer.writeAttribute("type", (Object)"text", null);
        if (value != null) {
            if (ac.getVar() == null) {
                writer.writeAttribute("value", (Object)ComponentUtils.getStringValueToRender(facesContext, (UIComponent)ac), null);
            } else {
                facesContext.getExternalContext().getRequestMap().put(ac.getVar(), value);
                writer.writeAttribute("value", (Object)ac.getItemLabel(), null);
            }
        }
        if (ac.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        writer.endElement("input");
        if (ac.getVar() != null) {
            writer.startElement("input", null);
            writer.writeAttribute("id", (Object)(clientId + "_hinput"), null);
            writer.writeAttribute("name", (Object)(clientId + "_hinput"), null);
            writer.writeAttribute("type", (Object)"hidden", null);
            if (value != null) {
                writer.writeAttribute("value", (Object)ComponentUtils.getStringValueToRender(facesContext, (UIComponent)ac, ac.getItemValue()), null);
            }
            writer.endElement("input");
            facesContext.getExternalContext().getRequestMap().remove(ac.getVar());
        }
        writer.endElement("span");
    }

    protected void encodeScript(FacesContext facesContext, AutoComplete ac) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = ac.getClientId(facesContext);
        String var = this.createUniqueWidgetVar(facesContext, (UIComponent)ac);
        UIComponent form = ComponentUtils.findParentForm(facesContext, (UIComponent)ac);
        if (form == null) {
            throw new FacesException("AutoComplete : \"" + clientId + "\" must be inside a form");
        }
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("jQuery(function(){");
        writer.write(var + " = new PrimeFaces.widget.AutoComplete('" + clientId + "', {");
        writer.write("url:'" + this.getActionURL(facesContext) + "'");
        writer.write(",formId:'" + form.getClientId(facesContext) + "'");
        writer.write(",pojo:" + (ac.getVar() != null));
        writer.write(",maxResults:" + ac.getMaxResults());
        if (ac.getMinQueryLength() != 1) {
            writer.write(",minLength:" + ac.getMinQueryLength());
        }
        if (ac.getQueryDelay() != 300) {
            writer.write(",delay:" + ac.getQueryDelay());
        }
        if (ac.isDisabled()) {
            writer.write(",disabled:true");
        }
        if (ac.isForceSelection()) {
            writer.write(",forceSelection:true");
        }
        if (ac.getSelectListener() != null) {
            writer.write(",ajaxSelect:true");
            if (ac.getOnSelectUpdate() != null) {
                writer.write(",onSelectUpdate:'" + ComponentUtils.findClientIds(facesContext, (UIComponent)ac, ac.getOnSelectUpdate()) + "'");
            }
        }
        if (ac.getOnstart() != null) {
            writer.write(",onstart:function(request) {" + ac.getOnstart() + ";}");
        }
        if (ac.getOncomplete() != null) {
            writer.write(",oncomplete:function(response) {" + ac.getOncomplete() + ";}");
        }
        writer.write("});});");
        writer.endElement("script");
    }

    public Object getConvertedValue(FacesContext facesContext, UIComponent component, Object submittedValue) throws ConverterException {
        AutoComplete autoComplete = (AutoComplete)component;
        Object value = submittedValue;
        Converter converter = autoComplete.getConverter();
        if (converter != null) {
            value = converter.getAsObject(facesContext, (UIComponent)autoComplete, (String)submittedValue);
        } else {
            ValueExpression expr = autoComplete.getValueExpression("value");
            if (expr != null) {
                Class valueType = expr.getType(facesContext.getELContext());
                Converter converterForType = facesContext.getApplication().createConverter(valueType);
                if (converterForType != null) {
                    value = converterForType.getAsObject(facesContext, (UIComponent)autoComplete, (String)submittedValue);
                }
            }
        }
        if (facesContext.getExternalContext().getRequestParameterMap().containsKey(autoComplete.getClientId(facesContext) + "_ajaxSelect")) {
            SelectEvent selectEvent = new SelectEvent((UIComponent)autoComplete, value);
            selectEvent.setPhaseId(PhaseId.INVOKE_APPLICATION);
            autoComplete.queueEvent(selectEvent);
        }
        return value;
    }
}

