/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.junit.libdef;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.CRC32;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.MavenArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.api.autoupdate.UpdateUnitProvider;
import org.netbeans.api.autoupdate.UpdateUnitProviderFactory;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.autoupdate.ui.api.PluginManager;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.embedder.MavenEmbedder;
import org.netbeans.modules.maven.junit.libdef.Bundle;
import org.netbeans.spi.java.project.support.ui.BrokenReferencesSupport;
import org.openide.filesystems.FileUtil;

public class JUnitLibraryDefiner
implements BrokenReferencesSupport.LibraryDefiner {
    public Callable<Library> missingLibrary(final String name) {
        if (!name.matches("junit(_4)?")) {
            return null;
        }
        return new Callable<Library>(){
            Map<String, File> downloads;
            int count;
            ProgressHandle handle;
            MavenEmbedder online;
            List<ArtifactRepository> remoteArtifactRepositories;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Library call() throws Exception {
                this.downloads = new HashMap<String, File>();
                this.count = 0;
                this.handle = ProgressHandleFactory.createHandle((String)Bundle.MSG_Downloading_all());
                this.handle.start(6);
                try {
                    this.online = EmbedderFactory.getOnlineEmbedder();
                    this.remoteArtifactRepositories = Collections.singletonList(new MavenArtifactRepository("central", "http://repo1.maven.org/maven2/", (ArtifactRepositoryLayout)new DefaultRepositoryLayout(), new ArtifactRepositoryPolicy(), new ArtifactRepositoryPolicy()));
                    for (String version : new String[]{"3.8.2", "4.8.2"}) {
                        Artifact a = this.online.createArtifact("junit", "junit", version, "jar");
                        this.download(a, Bundle.MSG_Downloading_binary(version), "junit-" + version + ".jar");
                        this.download(this.online.createArtifactWithClassifier(a.getGroupId(), a.getArtifactId(), a.getVersion(), a.getType(), "javadoc"), Bundle.MSG_Downloading_javadoc(version), "junit-" + version + "-javadoc.jar");
                        this.download(this.online.createArtifactWithClassifier(a.getGroupId(), a.getArtifactId(), a.getVersion(), a.getType(), "sources"), Bundle.MSG_Downloading_sources(version), "junit-" + version + "-sources.jar");
                    }
                }
                finally {
                    this.handle.finish();
                    this.handle = null;
                    this.online = null;
                    this.remoteArtifactRepositories = null;
                }
                File junit4Module = new JARBuilder(File.createTempFile("o-n-l-ju4", ".jar")).entry("org/netbeans/libs/junit4/Bundle.properties", "OpenIDE-Module-Name=JUnit 4\n").header("AutoUpdate-Show-In-Client", "false").header("OpenIDE-Module", "org.netbeans.libs.junit4").header("OpenIDE-Module-Specification-Version", "1.13").header("OpenIDE-Module-Public-Packages", "junit.**, org.junit.**, org.hamcrest.**").header("OpenIDE-Module-Localizing-Bundle", "org/netbeans/libs/junit4/Bundle.properties").header("OpenIDE-Module-Requires", "org.openide.modules.ModuleFormat1").header("Class-Path", "ext/junit-4.8.2.jar").write();
                junit4Module.deleteOnExit();
                File junit4Package = new JARBuilder(File.createTempFile("o-n-l-ju4", ".nbm")).entry("Info/info.xml", JUnitLibraryDefiner.class.getResource("org-netbeans-libs-junit4-info.xml")).entry("netbeans/config/Modules/org-netbeans-libs-junit4.xml", JUnitLibraryDefiner.class.getResource("org-netbeans-libs-junit4.xml")).entry("netbeans/modules/org-netbeans-libs-junit4.jar", junit4Module).entry("netbeans/modules/ext/junit-4.8.2.jar", this.downloads.get("junit-4.8.2.jar")).write();
                junit4Package.deleteOnExit();
                File junitlibModule = new JARBuilder(File.createTempFile("o-n-m-jul", ".jar")).entry("org/netbeans/modules/junitlib/Bundle.properties", "OpenIDE-Module-Name=JUnit\nOpenIDE-Module-Display-Category=Java SE\nOpenIDE-Module-Short-Description=Bundles the JUnit test library.\nOpenIDE-Module-Long-Description=Includes JUnit 3.x and 4.x together with library definitions.\njunit=JUnit 3.8.2\njunit_4=JUnit 4.8.2\n").header("AutoUpdate-Show-In-Client", "true").header("OpenIDE-Module", "org.netbeans.modules.junitlib").header("OpenIDE-Module-Specification-Version", "1.0").header("OpenIDE-Module-Module-Dependencies", "org.netbeans.libs.junit4 > 1.13").header("OpenIDE-Module-Localizing-Bundle", "org/netbeans/modules/junitlib/Bundle.properties").header("OpenIDE-Module-Layer", "org/netbeans/modules/junitlib/layer.xml").header("OpenIDE-Module-Requires", "org.openide.modules.ModuleFormat1").header("OpenIDE-Module-Public-Packages", "-").entry("org/netbeans/modules/junitlib/layer.xml", JUnitLibraryDefiner.class.getResource("layer.xml")).entry("org/netbeans/modules/junitlib/junit-3.8.2.xml", JUnitLibraryDefiner.class.getResource("junit-3.8.2.xml")).entry("org/netbeans/modules/junitlib/junit-4.8.2.xml", JUnitLibraryDefiner.class.getResource("junit-4.8.2.xml")).write();
                junitlibModule.deleteOnExit();
                File junitlibPackage = new JARBuilder(File.createTempFile("o-n-m-jul", ".nbm")).entry("Info/info.xml", JUnitLibraryDefiner.class.getResource("org-netbeans-modules-junitlib-info.xml")).entry("netbeans/config/Modules/org-netbeans-modules-junitlib.xml", JUnitLibraryDefiner.class.getResource("org-netbeans-modules-junitlib.xml")).entry("netbeans/modules/org-netbeans-modules-junitlib.jar", junitlibModule).entry("netbeans/modules/ext/junit-3.8.2.jar", this.downloads.get("junit-3.8.2.jar")).entry("netbeans/docs/junit-3.8.2-api.zip", this.downloads.get("junit-3.8.2-javadoc.jar")).entry("netbeans/docs/junit-3.8.2-src.jar", this.downloads.get("junit-3.8.2-sources.jar")).entry("netbeans/docs/junit-4.8.2-api.zip", this.downloads.get("junit-4.8.2-javadoc.jar")).entry("netbeans/docs/junit-4.8.2-src.jar", this.downloads.get("junit-4.8.2-sources.jar")).write();
                junitlibPackage.deleteOnExit();
                OperationContainer oc = OperationContainer.createForInstall();
                UpdateUnitProvider uup = UpdateUnitProviderFactory.getDefault().create(Bundle.LBL_separate_download(), new File[]{junit4Package, junitlibPackage});
                try {
                    for (UpdateUnit uu : uup.getUpdateUnits(new UpdateManager.TYPE[]{UpdateManager.TYPE.MODULE})) {
                        for (UpdateElement ue : uu.getAvailableUpdates()) {
                            oc.add(ue);
                        }
                    }
                    if (!PluginManager.openInstallWizard((OperationContainer)oc)) {
                        throw new Exception("user canceled update");
                    }
                }
                finally {
                    UpdateUnitProviderFactory.getDefault().remove(uup);
                }
                for (int i = 0; i < 10; ++i) {
                    Library lib = LibraryManager.getDefault().getLibrary(name);
                    if (lib != null) {
                        return lib;
                    }
                    Thread.sleep(1000L);
                }
                throw new Exception("failed to install properly");
            }

            private void download(Artifact a, String message, String key) throws Exception {
                this.handle.progress(message, ++this.count);
                this.online.resolve(a, this.remoteArtifactRepositories, this.online.getLocalRepository());
                File file = a.getFile();
                if (!file.exists()) {
                    throw new IOException("failed to download " + key);
                }
                this.downloads.put(key, file);
            }
        };
    }

    private static class JARBuilder {
        private final File jar;
        private final Map<String, String> textEntries = new LinkedHashMap<String, String>();
        private final Map<String, URL> otherEntries = new LinkedHashMap<String, URL>();
        private final Manifest manifest = new Manifest();

        public JARBuilder(File jar) {
            this.jar = jar;
            this.manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        }

        public JARBuilder entry(String name, String text) {
            this.textEntries.put(name, text);
            return this;
        }

        public JARBuilder entry(String name, URL content) {
            this.otherEntries.put(name, content);
            return this;
        }

        public JARBuilder entry(String name, File content) {
            try {
                return this.entry(name, content.toURI().toURL());
            }
            catch (MalformedURLException x) {
                throw new AssertionError((Object)x);
            }
        }

        public JARBuilder header(String key, String value) {
            this.manifest.getMainAttributes().putValue(key, value);
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public File write() throws IOException {
            FileOutputStream os = new FileOutputStream(this.jar);
            try {
                JarOutputStream jos = new JarOutputStream((OutputStream)os, this.manifest);
                HashSet<String> parents = new HashSet<String>();
                for (Map.Entry<String, String> entry : this.textEntries.entrySet()) {
                    this.writeEntry(entry.getKey(), parents, jos, entry.getValue().getBytes("UTF-8"));
                }
                for (Map.Entry<String, Object> entry : this.otherEntries.entrySet()) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    InputStream is = ((URL)entry.getValue()).openStream();
                    try {
                        FileUtil.copy((InputStream)is, (OutputStream)baos);
                    }
                    finally {
                        is.close();
                    }
                    this.writeEntry(entry.getKey(), parents, jos, baos.toByteArray());
                }
                jos.finish();
                jos.close();
            }
            finally {
                ((OutputStream)os).close();
            }
            return this.jar;
        }

        private void writeEntry(String name, Set<String> parents, JarOutputStream jos, byte[] data) throws IOException {
            for (int i = 0; i < name.length(); ++i) {
                String parent;
                if (name.charAt(i) != '/' || !parents.add(parent = name.substring(0, i + 1))) continue;
                JarEntry je = new JarEntry(parent);
                je.setMethod(0);
                je.setSize(0L);
                je.setCrc(0L);
                jos.putNextEntry(je);
                jos.closeEntry();
            }
            JarEntry je = new JarEntry(name);
            je.setMethod(0);
            je.setSize(data.length);
            CRC32 crc = new CRC32();
            crc.update(data);
            je.setCrc(crc.getValue());
            jos.putNextEntry(je);
            jos.write(data, 0, data.length);
            jos.closeEntry();
        }
    }
}

