/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.junit;

import java.io.File;
import java.io.InputStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.ChangeListener;
import org.codehaus.plexus.util.StringUtils;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gsf.testrunner.api.Manager;
import org.netbeans.modules.gsf.testrunner.api.RerunHandler;
import org.netbeans.modules.gsf.testrunner.api.RerunType;
import org.netbeans.modules.gsf.testrunner.api.Status;
import org.netbeans.modules.gsf.testrunner.api.TestRunnerNodeFactory;
import org.netbeans.modules.gsf.testrunner.api.TestSession;
import org.netbeans.modules.gsf.testrunner.api.TestSuite;
import org.netbeans.modules.gsf.testrunner.api.Testcase;
import org.netbeans.modules.gsf.testrunner.api.Trouble;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.api.execute.RunUtils;
import org.netbeans.modules.maven.api.output.OutputProcessor;
import org.netbeans.modules.maven.api.output.OutputVisitor;
import org.netbeans.modules.maven.junit.nodes.JUnitTestRunnerNodeFactory;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class JUnitOutputListenerProvider
implements OutputProcessor {
    private Project prj;
    private NbMavenProject mavenproject;
    TestSession session;
    private Pattern runningPattern;
    private Pattern outDirPattern2;
    private Pattern outDirPattern;
    String outputDir;
    String runningTestClass;
    private static final Logger LOG = Logger.getLogger(JUnitOutputListenerProvider.class.getName());
    private RunConfig config;
    private static Pattern COMPARISON_PATTERN = Pattern.compile(".*expected:<(.*)> but was:<(.*)>$");

    public JUnitOutputListenerProvider(Project project, RunConfig config) {
        this.prj = project;
        this.mavenproject = (NbMavenProject)this.prj.getLookup().lookup(NbMavenProject.class);
        this.runningPattern = Pattern.compile("(?:\\[surefire\\] )?Running (.*)", 32);
        this.outDirPattern = Pattern.compile("Surefire report directory\\: (.*)", 32);
        this.outDirPattern2 = Pattern.compile("Setting reports dir\\: (.*)", 32);
        this.config = config;
    }

    public String[] getRegisteredOutputSequences() {
        return new String[]{"mojo-execute#surefire:test"};
    }

    public void processLine(String line, OutputVisitor visitor) {
        if (this.session == null) {
            return;
        }
        Matcher match = this.outDirPattern.matcher(line);
        if (match.matches()) {
            this.outputDir = match.group(1);
            return;
        }
        match = this.outDirPattern2.matcher(line);
        if (match.matches()) {
            this.outputDir = match.group(1);
            return;
        }
        match = this.runningPattern.matcher(line);
        if (match.matches()) {
            if (this.runningTestClass != null && this.outputDir != null) {
                FileObject report = this.getTestReportFileObject(this.outputDir, "TEST-" + this.runningTestClass + ".xml");
                this.generateTest(report);
            }
            this.runningTestClass = match.group(1);
            return;
        }
    }

    public void sequenceStart(String sequenceId, OutputVisitor visitor) {
        if (this.session == null) {
            TestSession.SessionType type = TestSession.SessionType.TEST;
            String action = this.config.getActionName();
            if (action != null && action.contains("debug")) {
                type = TestSession.SessionType.DEBUG;
            }
            final TestSession.SessionType fType = type;
            this.session = new TestSession(this.mavenproject.getMavenProject().getId(), this.prj, TestSession.SessionType.TEST, (TestRunnerNodeFactory)new JUnitTestRunnerNodeFactory(this.session, this.prj));
            this.session.setRerunHandler(new RerunHandler(){

                public void rerun() {
                    RunUtils.executeMaven((RunConfig)JUnitOutputListenerProvider.this.config);
                }

                public void rerun(Set<Testcase> tests) {
                }

                public boolean enabled(RerunType type) {
                    return RerunType.ALL.equals((Object)type) && fType.equals((Object)TestSession.SessionType.TEST);
                }

                public void addChangeListener(ChangeListener listener) {
                }

                public void removeChangeListener(ChangeListener listener) {
                }
            });
            Manager.getInstance().testStarted(this.session);
        }
    }

    public void sequenceEnd(String sequenceId, OutputVisitor visitor) {
        if (this.session == null) {
            return;
        }
        if (this.runningTestClass != null && this.outputDir != null) {
            FileObject report = this.getTestReportFileObject(this.outputDir, "TEST-" + this.runningTestClass + ".xml");
            this.generateTest(report);
        }
        Manager.getInstance().sessionFinished(this.session);
        this.runningTestClass = null;
        this.outputDir = null;
    }

    static Trouble constructTrouble(String type, String message, String text, boolean error) {
        Matcher match;
        Trouble t = new Trouble(error);
        if (message != null && (match = COMPARISON_PATTERN.matcher(message)).matches()) {
            t.setComparisonFailure(new Trouble.ComparisonFailure(match.group(1), match.group(2)));
        }
        if (text != null) {
            String[] strs = StringUtils.split((String)text, (String)"\n");
            ArrayList<String> lines = new ArrayList<String>();
            lines.add(message);
            lines.add(type);
            for (int i = 1; i < strs.length; ++i) {
                lines.add(strs[i]);
            }
            t.setStackTrace(lines.toArray(new String[0]));
        }
        return t;
    }

    private FileObject getTestReportFileObject(String outputDirectory, String reportFileName) {
        assert (outputDirectory != null);
        File file = FileUtil.normalizeFile((File)new File(this.outputDir));
        FileUtil.refreshFor((File[])new File[]{file});
        FileObject outDir = FileUtil.toFileObject((File)file);
        if (outDir != null) {
            FileObject report = outDir.getFileObject(reportFileName);
            return report;
        }
        return null;
    }

    public void sequenceFail(String sequenceId, OutputVisitor visitor) {
        this.sequenceEnd(sequenceId, visitor);
    }

    private void generateTest(FileObject report) {
        if (report == null) {
            return;
        }
        try {
            SAXBuilder builder = new SAXBuilder();
            InputStream stream = report.getInputStream();
            Document document = builder.build(stream);
            Element testSuite = document.getRootElement();
            assert ("testsuite".equals(testSuite.getName())) : "Root name " + testSuite.getName();
            TestSuite suite = new TestSuite(testSuite.getAttributeValue("name"));
            this.session.addSuite(suite);
            Manager.getInstance().displaySuiteRunning(this.session, suite.getName());
            List testcases = testSuite.getChildren("testcase");
            for (Element testcase : testcases) {
                String classname;
                String time;
                Element error;
                String name = testcase.getAttributeValue("name");
                Testcase test = new Testcase(name, null, this.session);
                Element stdout = testcase.getChild("system-out");
                if (stdout != null) {
                    this.logText(stdout.getText(), test, false);
                }
                Element failure = testcase.getChild("failure");
                Status status = Status.PASSED;
                Trouble trouble = null;
                if (failure != null) {
                    status = Status.FAILED;
                    trouble = JUnitOutputListenerProvider.constructTrouble(failure.getAttributeValue("type"), failure.getAttributeValue("message"), failure.getText(), false);
                }
                if ((error = testcase.getChild("error")) != null) {
                    status = Status.ERROR;
                    trouble = JUnitOutputListenerProvider.constructTrouble(error.getAttributeValue("type"), error.getAttributeValue("message"), error.getText(), true);
                }
                test.setStatus(status);
                if (trouble != null) {
                    test.setTrouble(trouble);
                }
                if ((time = testcase.getAttributeValue("time")) != null) {
                    float fl = NumberFormat.getNumberInstance().parse(time).floatValue();
                    test.setTimeMillis((long)(fl * 1000.0f));
                }
                if ((classname = testcase.getAttributeValue("classname")) != null) {
                    test.setClassName(classname);
                    test.setLocation(test.getClassName().replace('.', '/') + ".java");
                }
                this.session.addTestCase(test);
            }
            String time = testSuite.getAttributeValue("time");
            float fl = NumberFormat.getNumberInstance().parse(time).floatValue();
            long timeinmilis = (long)(fl * 1000.0f);
            Manager.getInstance().displayReport(this.session, this.session.getReport(timeinmilis));
        }
        catch (JDOMException x) {
            LOG.log(Level.INFO, "parsing " + report, x);
        }
        catch (Exception x) {
            LOG.log(Level.WARNING, "parsing " + report, x);
        }
    }

    private void logText(String text, Testcase test, boolean failure) {
        StringTokenizer tokens = new StringTokenizer(text, "\n");
        ArrayList<String> lines = new ArrayList<String>();
        while (tokens.hasMoreTokens()) {
            lines.add(tokens.nextToken());
        }
        Manager.getInstance().displayOutput(this.session, text, failure);
        test.addOutputLines(lines);
    }
}

