/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.api.restricted;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.spi.DeploymentManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.modules.glassfish.eecommon.api.UrlData;
import org.netbeans.modules.glassfish.eecommon.api.Utils;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.common.api.DatasourceAlreadyExistsException;
import org.netbeans.modules.j2ee.deployment.common.api.MessageDestination;
import org.netbeans.modules.j2ee.sun.api.ResourceConfiguratorInterface;
import org.netbeans.modules.j2ee.sun.api.restricted.ResourceUtils;
import org.netbeans.modules.j2ee.sun.api.restricted.SunDatasource;
import org.netbeans.modules.j2ee.sun.api.restricted.SunMessageDestination;
import org.netbeans.modules.j2ee.sun.dd.api.DDProvider;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.AdminObjectResource;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.ConnectorConnectionPool;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.ConnectorResource;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.JdbcConnectionPool;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.JdbcResource;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.PropertyElement;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.Resources;
import org.netbeans.modules.j2ee.sun.sunresources.beans.DatabaseUtils;
import org.netbeans.modules.j2ee.sun.sunresources.beans.Field;
import org.netbeans.modules.j2ee.sun.sunresources.beans.FieldGroup;
import org.netbeans.modules.j2ee.sun.sunresources.beans.FieldGroupHelper;
import org.netbeans.modules.j2ee.sun.sunresources.beans.FieldHelper;
import org.netbeans.modules.j2ee.sun.sunresources.beans.Wizard;
import org.netbeans.modules.j2ee.sun.sunresources.beans.WizardConstants;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;

public class ResourceConfigurator
implements ResourceConfiguratorInterface {
    public static final String __SunResourceExt = "sun-resource";
    private static final char BLANK = ' ';
    private static final char DOT = '.';
    private static final char[] ILLEGAL_FILENAME_CHARS = new char[]{'/', '\\', ':', '*', '?', '\"', '<', '>', '|', ',', '=', ';'};
    private static final char REPLACEMENT_CHAR = '_';
    private static final char DASH = '-';
    private static final String DATAFILE = "org/netbeans/modules/j2ee/sun/sunresources/beans/CPWizard.xml";
    private DeploymentManager currentDM = null;
    public static final String JDBC_RESOURCE = "jdbc";
    public static final String JMS_RESOURCE = "jms";
    public static final String JMS_PREFIX = "jms/";
    ResourceBundle bundle = ResourceBundle.getBundle("org.netbeans.modules.j2ee.sun.ide.sunresources.beans.Bundle");
    private static final Logger LOG = Logger.getLogger(ResourceConfigurator.class.getName());

    public void setDeploymentManager(DeploymentManager dm) {
        this.currentDM = dm;
    }

    @Override
    public boolean isJMSResourceDefined(String jndiName, File dir) {
        return this.requiredResourceExists(jndiName, dir, JMS_RESOURCE);
    }

    @Override
    public MessageDestination createJMSResource(String jndiName, MessageDestination.Type type, String ejbName, File dir, String baseName) {
        SunMessageDestination msgDest = null;
        if (!jndiName.startsWith(JMS_PREFIX)) {
            jndiName = JMS_PREFIX + jndiName;
        }
        Resources resources = ResourceUtils.getServerResourcesGraph(dir);
        AdminObjectResource aoresource = resources.newAdminObjectResource();
        aoresource.setJndiName(jndiName);
        PropertyElement prop = aoresource.newPropertyElement();
        prop.setName("Name");
        if (MessageDestination.Type.QUEUE.equals((Object)type)) {
            aoresource.setResType("javax.jms.Queue");
            prop.setValue("PhysicalQueue");
        } else if (MessageDestination.Type.TOPIC.equals((Object)type)) {
            aoresource.setResType("javax.jms.Topic");
            prop.setValue("PhysicalTopic");
        }
        aoresource.setResAdapter("jmsra");
        aoresource.setEnabled("true");
        aoresource.setDescription("");
        aoresource.addPropertyElement(prop);
        resources.addAdminObjectResource(aoresource);
        ConnectorResource connresource = resources.newConnectorResource();
        ConnectorConnectionPool connpoolresource = resources.newConnectorConnectionPool();
        String connectionFactoryJndiName = jndiName + "Factory";
        String connectionFactoryPoolName = jndiName + "FactoryPool";
        connresource.setJndiName(connectionFactoryJndiName);
        connresource.setDescription("");
        connresource.setEnabled("true");
        connresource.setPoolName(connectionFactoryPoolName);
        connpoolresource.setName(connectionFactoryPoolName);
        connpoolresource.setResourceAdapterName("jmsra");
        if (type.equals((Object)MessageDestination.Type.QUEUE)) {
            connpoolresource.setConnectionDefinitionName("javax.jms.QueueConnectionFactory");
        } else if (type.equals((Object)MessageDestination.Type.TOPIC)) {
            connpoolresource.setConnectionDefinitionName("javax.jms.TopicConnectionFactory");
        } else assert (false);
        resources.addConnectorResource(connresource);
        resources.addConnectorConnectionPool(connpoolresource);
        ResourceUtils.createFile(dir, resources, baseName);
        msgDest = new SunMessageDestination(jndiName, type);
        return msgDest;
    }

    @Override
    public void createJMSResource(String jndiName, String msgDstnType, String msgDstnName, String ejbName, File dir, String baseName) {
        FileObject location = FileUtil.toFileObject((File)dir);
        Resources resources = ResourceUtils.getServerResourcesGraph(location, baseName.contains("glassfish-resources") ? "1.50" : "1.30");
        AdminObjectResource aoresource = resources.newAdminObjectResource();
        aoresource.setJndiName(jndiName);
        aoresource.setResType(msgDstnType);
        aoresource.setResAdapter("jmsra");
        aoresource.setEnabled("true");
        aoresource.setDescription("");
        PropertyElement prop = aoresource.newPropertyElement();
        prop.setName("Name");
        prop.setValue(ejbName);
        aoresource.addPropertyElement(prop);
        resources.addAdminObjectResource(aoresource);
        ConnectorResource connresource = resources.newConnectorResource();
        ConnectorConnectionPool connpoolresource = resources.newConnectorConnectionPool();
        String connectionFactoryJndiName = JMS_PREFIX + msgDstnName + "Factory";
        connresource.setJndiName(connectionFactoryJndiName);
        connresource.setDescription("");
        connresource.setEnabled("true");
        connresource.setPoolName(connectionFactoryJndiName);
        connpoolresource.setName(connectionFactoryJndiName);
        connpoolresource.setResourceAdapterName("jmsra");
        if (msgDstnType.equals("javax.jms.Queue")) {
            connpoolresource.setConnectionDefinitionName("javax.jms.QueueConnectionFactory");
        } else if (msgDstnType.equals("javax.jms.Topic")) {
            connpoolresource.setConnectionDefinitionName("javax.jms.TopicConnectionFactory");
        } else assert (false);
        resources.addConnectorResource(connresource);
        resources.addConnectorConnectionPool(connpoolresource);
        ResourceUtils.createFile(location, resources, baseName);
    }

    @Override
    public void createJDBCDataSourceFromRef(String refName, String databaseInfo, File dir) {
    }

    @Override
    public String createJDBCDataSourceForCmp(String beanName, String databaseInfo, File dir) {
        return null;
    }

    private boolean isLegalFilename(String filename) {
        for (int i = 0; i < ILLEGAL_FILENAME_CHARS.length; ++i) {
            if (filename.indexOf(ILLEGAL_FILENAME_CHARS[i]) < 0) continue;
            return false;
        }
        return true;
    }

    private boolean isFriendlyFilename(String filename) {
        if (filename.indexOf(32) >= 0 || filename.indexOf(46) >= 0) {
            return false;
        }
        return this.isLegalFilename(filename);
    }

    private String makeLegalFilename(String filename) {
        for (int i = 0; i < ILLEGAL_FILENAME_CHARS.length; ++i) {
            filename = filename.replace(ILLEGAL_FILENAME_CHARS[i], '_');
        }
        return filename;
    }

    private String makeShorterLegalFilename(String filename) {
        if (filename.indexOf("://") != -1) {
            filename = filename.substring(0, filename.indexOf("://")) + "_" + filename.substring(filename.indexOf("://") + 3, filename.length());
        }
        if (filename.indexOf("//") != -1) {
            filename = filename.substring(0, filename.indexOf("//")) + "_" + filename.substring(filename.indexOf("//") + 2, filename.length());
        }
        filename = this.makeLegalFilename(filename);
        return filename;
    }

    private void ensureFolderExists(File folder) throws IOException {
        if (!folder.exists()) {
            FileUtil.createFolder((File)folder);
        }
    }

    private String getFileName(String beanName, String resourceType) {
        assert (beanName != null);
        assert (beanName.length() != 0);
        assert (resourceType != null);
        assert (resourceType.length() != 0);
        String fileName = resourceType;
        if (!this.isFriendlyFilename(beanName)) {
            beanName = this.makeLegalFilename(beanName);
        }
        if (!this.isFriendlyFilename(fileName)) {
            fileName = this.makeLegalFilename(fileName);
        }
        fileName = fileName + '-' + beanName + '.' + __SunResourceExt;
        return fileName;
    }

    private JdbcConnectionPool setDerbyProps(String url, JdbcConnectionPool jdbcConnectionPool) {
        UrlData urlData = new UrlData(url);
        String hostName = urlData.getHostName();
        String portNumber = urlData.getPort();
        String databaseName = urlData.getDatabaseName();
        url = this.stripExtraDBInfo(url);
        String workingUrl = url.substring(url.indexOf("//") + 2, url.length());
        PropertyElement servName = jdbcConnectionPool.newPropertyElement();
        servName.setName("serverName");
        servName.setValue(hostName);
        PropertyElement portno = jdbcConnectionPool.newPropertyElement();
        portno.setName("PortNumber");
        portno.setValue(portNumber);
        PropertyElement dbName = jdbcConnectionPool.newPropertyElement();
        dbName.setName("DatabaseName");
        dbName.setValue(databaseName);
        String connectionAttr = this.getDerbyConnAttrs(workingUrl);
        if (!connectionAttr.equals("")) {
            PropertyElement connAttr = jdbcConnectionPool.newPropertyElement();
            connAttr.setName("connectionAttributes");
            connAttr.setValue(connectionAttr);
            jdbcConnectionPool.addPropertyElement(connAttr);
        }
        jdbcConnectionPool.addPropertyElement(servName);
        jdbcConnectionPool.addPropertyElement(portno);
        jdbcConnectionPool.addPropertyElement(dbName);
        return jdbcConnectionPool;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private JdbcConnectionPool setAdditionalProps(String vendorName, String url, JdbcConnectionPool jdbcConnectionPool) {
        UrlData urlData = new UrlData(url);
        String hostName = urlData.getHostName();
        String portNumber = urlData.getPort();
        String databaseName = urlData.getDatabaseName();
        String workingUrl = url = this.stripExtraDBInfo(url);
        if (vendorName.equals("sybase2")) {
            int index = url.indexOf("Tds:");
            if (index == -1) return jdbcConnectionPool;
            workingUrl = url.substring(index + 4, url.length());
        } else {
            workingUrl = url.substring(url.indexOf("//") + 2, url.length());
        }
        PropertyElement servName = jdbcConnectionPool.newPropertyElement();
        servName.setName("serverName");
        if (vendorName.contains("informix")) {
            String informixSname = this.getInformixServerName(urlData);
            if (vendorName.equals("informix")) {
                servName.setValue(informixSname);
                PropertyElement informixhostName = jdbcConnectionPool.newPropertyElement();
                informixhostName.setName("IfxIFXHOST");
                informixhostName.setValue(hostName);
                jdbcConnectionPool.addPropertyElement(informixhostName);
            } else {
                PropertyElement informixserver = jdbcConnectionPool.newPropertyElement();
                informixserver.setName("InformixServer");
                informixserver.setValue(informixSname);
                jdbcConnectionPool.addPropertyElement(informixserver);
                servName.setValue(hostName);
            }
        } else {
            servName.setValue(hostName);
        }
        jdbcConnectionPool.addPropertyElement(servName);
        if (Utils.notEmpty((String)portNumber)) {
            PropertyElement portno = jdbcConnectionPool.newPropertyElement();
            portno.setName("portNumber");
            portno.setValue(portNumber);
            jdbcConnectionPool.addPropertyElement(portno);
        }
        if (!Arrays.asList(WizardConstants.VendorsDBNameProp).contains(vendorName)) return jdbcConnectionPool;
        PropertyElement dbName = jdbcConnectionPool.newPropertyElement();
        if (vendorName.equals("sun_oracle") || vendorName.equals("datadirect_oracle")) {
            dbName.setName("SID");
        } else {
            dbName.setName("databaseName");
        }
        if (databaseName == null) return jdbcConnectionPool;
        dbName.setValue(databaseName);
        jdbcConnectionPool.addPropertyElement(dbName);
        return jdbcConnectionPool;
    }

    private String getDatasourceClassName(String vendorName, boolean isXA, Wizard wizard) {
        if (vendorName == null) {
            return null;
        }
        try {
            FieldGroup generalGroup = FieldGroupHelper.getFieldGroup(wizard, "general");
            Field dsField = null;
            dsField = isXA ? FieldHelper.getField(generalGroup, "datasource-classname-xa") : FieldHelper.getField(generalGroup, "datasource-classname");
            return FieldHelper.getConditionalFieldValue(dsField, vendorName);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "getDatasourceClassName failed", ex);
            return null;
        }
    }

    public static String getDatabaseVendorName(String url, Wizard wizard) {
        String vendorName = "";
        try {
            if (wizard == null) {
                wizard = ResourceConfigurator.getWizardInfo();
            }
            FieldGroup propGroup = FieldGroupHelper.getFieldGroup(wizard, "propertiesUrl");
            Field urlField = FieldHelper.getField(propGroup, "vendorUrls");
            vendorName = FieldHelper.getOptionNameFromValue(urlField, url);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "getDatabaseVendorName failed", ex);
        }
        return vendorName;
    }

    private String convertToValidName(String database) {
        String vendorName = ResourceConfigurator.getDatabaseVendorName(database = this.stripExtraDBInfo(database), null);
        if (vendorName != null) {
            if (!vendorName.equals("")) {
                if (!this.isFriendlyFilename(vendorName)) {
                    vendorName = this.makeLegalFilename(vendorName);
                }
            } else {
                vendorName = this.makeShorterLegalFilename(database);
            }
        }
        return vendorName;
    }

    private String isSameDatabaseConnection(JdbcConnectionPool connPool, String databaseUrl, String username, String password) {
        String poolJndiName;
        block15: {
            PropertyElement[] pl;
            block14: {
                poolJndiName = null;
                UrlData urlData = new UrlData(databaseUrl);
                String prefix = urlData.getPrefix();
                pl = connPool.getPropertyElement();
                if (prefix == null || !prefix.equals("jdbc:derby:")) break block14;
                String hostName = urlData.getHostName();
                String portNumber = urlData.getPort();
                String databaseName = urlData.getDatabaseName();
                String hostProp = null;
                String portProp = null;
                String dbProp = null;
                String dbUser = null;
                String dbPwd = null;
                for (int i = 0; i < pl.length; ++i) {
                    String prop = pl[i].getName();
                    if (prop.equalsIgnoreCase("serverName")) {
                        hostProp = pl[i].getValue();
                        continue;
                    }
                    if (prop.equals("PortNumber")) {
                        portProp = pl[i].getValue();
                        continue;
                    }
                    if (prop.equals("DatabaseName")) {
                        dbProp = pl[i].getValue();
                        continue;
                    }
                    if (prop.equals("User")) {
                        dbUser = pl[i].getValue();
                        continue;
                    }
                    if (!prop.equals("Password")) continue;
                    dbPwd = pl[i].getValue();
                }
                if (!Utils.strEquivalent((String)hostName, hostProp) || !Utils.strEquivalent((String)portNumber, portProp) || !Utils.strEquivalent((String)databaseName, dbProp) || dbUser == null || dbPwd == null || !dbUser.equals(username) || !dbPwd.equals(password)) break block15;
                poolJndiName = connPool.getName();
                break block15;
            }
            String hostName = "";
            String portNumber = "";
            String databaseName = "";
            String sid = "";
            String user = "";
            String pwd = "";
            for (int i = 0; i < pl.length; ++i) {
                String prop = pl[i].getName();
                if (prop.equalsIgnoreCase("serverName")) {
                    hostName = pl[i].getValue();
                    continue;
                }
                if (prop.equals("portNumber")) {
                    portNumber = pl[i].getValue();
                    continue;
                }
                if (prop.equalsIgnoreCase("databaseName")) {
                    databaseName = pl[i].getValue();
                    continue;
                }
                if (prop.equals("SID")) {
                    sid = pl[i].getValue();
                    continue;
                }
                if (prop.equals("User")) {
                    user = pl[i].getValue();
                    continue;
                }
                if (!prop.equals("Password")) continue;
                pwd = pl[i].getValue();
            }
            String serverPort = hostName;
            if (null != portNumber && portNumber.length() > 0) {
                serverPort = serverPort + ":" + portNumber;
            }
            if (null != databaseUrl && databaseUrl.indexOf(serverPort) != -1 && (databaseUrl.indexOf(databaseName) != -1 || databaseUrl.indexOf(sid) != -1) && username != null && user.equals(username) && password != null && pwd.equals(password)) {
                for (int i = 0; i < pl.length; ++i) {
                    String urlValue;
                    String prop = pl[i].getName();
                    if (!prop.equals("URL") && !prop.equals("databaseName") || !(urlValue = pl[i].getValue()).equals(databaseUrl)) continue;
                    poolJndiName = connPool.getName();
                    break;
                }
            }
        }
        return poolJndiName;
    }

    private String stripExtraDBInfo(String dbConnectionString) {
        if (dbConnectionString.indexOf("[") != -1) {
            dbConnectionString = dbConnectionString.substring(0, dbConnectionString.indexOf("[")).trim();
        }
        return dbConnectionString;
    }

    public static void showInformation(final String msg) {
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)msg, 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
            }
        });
    }

    private static Wizard getWizardInfo() {
        Wizard wizard = null;
        try {
            InputStream in = Wizard.class.getClassLoader().getResourceAsStream(DATAFILE);
            wizard = Wizard.createGraph(in);
            in.close();
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(4096, (Throwable)ex);
        }
        return wizard;
    }

    public String getDerbyServerName(String url) {
        String hostName = "";
        int index = url.indexOf(":");
        if (index != -1) {
            hostName = url.substring(0, index);
        } else {
            index = url.indexOf("/");
            if (index != -1) {
                hostName = url.substring(0, index);
            }
        }
        return hostName;
    }

    public String getDerbyPortNo(String url) {
        String portNumber = "";
        int index = url.indexOf(":");
        if (index != -1) {
            portNumber = url.substring(index + 1, url.indexOf("/"));
        }
        return portNumber;
    }

    public String getDerbyDatabaseName(String url) {
        String databaseName = "";
        int index = url.indexOf("/");
        if (index != -1) {
            int colonIndex = url.indexOf(";");
            databaseName = colonIndex != -1 ? url.substring(index + 1, colonIndex) : url.substring(index + 1, url.length());
        }
        return databaseName;
    }

    private String getDerbyConnAttrs(String url) {
        String connAttr = "";
        int colonIndex = url.indexOf(";");
        if (colonIndex != -1) {
            connAttr = url.substring(colonIndex, url.length());
        }
        return connAttr;
    }

    private String getInformixServerName(UrlData urlData) {
        String informixServer = "";
        Map props = urlData.getProperties();
        for (String propName : props.keySet()) {
            if (!propName.toLowerCase(Locale.ENGLISH).equals("informixserver")) continue;
            informixServer = (String)props.get(propName);
        }
        return informixServer;
    }

    @Override
    public HashSet getServerDataSources() {
        return ResourceUtils.getServerDataSources(this.currentDM);
    }

    @Override
    public HashSet getResources(File resourceDir) {
        return ResourceConfigurator.getResourcesFromFile(resourceDir);
    }

    public static HashSet getResourcesFromFile(File resourceDir) {
        HashSet serverresources = new HashSet();
        File resourceFile = ResourceConfigurator.getServerResourceFiles(resourceDir);
        if (resourceFile == null) {
            return serverresources;
        }
        HashSet<SunDatasource> dsources = new HashSet<SunDatasource>();
        HashMap connPools = ResourceConfigurator.getConnectionPools(resourceFile);
        HashMap dataSources = ResourceConfigurator.getJdbcResources(resourceFile);
        for (JdbcResource datasourceBean : dataSources.values()) {
            String poolName = datasourceBean.getPoolName();
            try {
                JdbcConnectionPool connectionPoolBean = (JdbcConnectionPool)connPools.get(poolName);
                String url = "";
                String username = "";
                String password = "";
                String driverClass = "";
                String serverName = "";
                String portNo = "";
                String dbName = "";
                String sid = "";
                if (connectionPoolBean != null) {
                    PropertyElement[] props = connectionPoolBean.getPropertyElement();
                    String dsClass = connectionPoolBean.getDatasourceClassname();
                    String resType = connectionPoolBean.getResType();
                    for (int j = 0; j < props.length; ++j) {
                        String propName;
                        String val = props[j].getValue();
                        String propValue = "";
                        if (val != null) {
                            propValue = val.toString();
                        }
                        if ((propName = props[j].getName()).equalsIgnoreCase("databaseName")) {
                            if (dsClass.indexOf("pointbase") != -1) {
                                url = propValue;
                                continue;
                            }
                            if (dsClass.indexOf("derby") != -1) {
                                dbName = propValue;
                                continue;
                            }
                            dbName = propValue;
                            continue;
                        }
                        if (propName.equalsIgnoreCase("User")) {
                            username = propValue;
                            continue;
                        }
                        if (propName.equalsIgnoreCase("Password")) {
                            password = propValue;
                            continue;
                        }
                        if (propName.equalsIgnoreCase("URL")) {
                            url = propValue;
                            continue;
                        }
                        if (propName.equalsIgnoreCase("serverName")) {
                            serverName = propValue;
                            continue;
                        }
                        if (propName.equalsIgnoreCase("PortNumber")) {
                            portNo = propValue;
                            continue;
                        }
                        if (propName.equalsIgnoreCase("SID")) {
                            sid = propValue;
                            continue;
                        }
                        if (propName.equalsIgnoreCase("URL")) {
                            url = propValue;
                            continue;
                        }
                        if (!propName.equalsIgnoreCase("driverClass")) continue;
                        driverClass = propValue;
                    }
                    if (url == null || url.equals("")) {
                        if (dsClass.indexOf("derby") != -1) {
                            url = "jdbc:derby://";
                            if (serverName != null) {
                                url = url + serverName;
                                if (portNo != null && portNo.length() > 0) {
                                    url = url + ":" + portNo;
                                }
                                url = url + "/" + dbName;
                            }
                        } else {
                            String urlPrefix = DatabaseUtils.getUrlPrefix(dsClass, resType);
                            String vName = ResourceConfigurator.getDatabaseVendorName(urlPrefix, null);
                            if (serverName != null) {
                                url = vName.equals("sybase2") ? urlPrefix + serverName : urlPrefix + "//" + serverName;
                                if (portNo != null && portNo.length() > 0) {
                                    url = url + ":" + portNo;
                                }
                            }
                            if (vName.equals("sun_oracle") || vName.equals("datadirect_oracle")) {
                                url = url + ";SID=" + sid;
                            } else if (Arrays.asList(WizardConstants.Reqd_DBName).contains(vName)) {
                                url = url + ";databaseName=" + dbName;
                            } else if (Arrays.asList(WizardConstants.VendorsDBNameProp).contains(vName)) {
                                url = url + "/" + dbName;
                            }
                        }
                    }
                    if (url == null || url.equals("")) continue;
                    if (driverClass == null || driverClass.equals("")) {
                        DatabaseConnection databaseConnection = ResourceUtils.getDatabaseConnection(url);
                        if (databaseConnection != null) {
                            driverClass = databaseConnection.getDriverClass();
                        } else {
                            String drivername = DatabaseUtils.getDriverName(url);
                            if (drivername != null) {
                                driverClass = drivername;
                            }
                        }
                    }
                    SunDatasource sunResource = new SunDatasource(datasourceBean.getJndiName(), url, username, password, driverClass);
                    sunResource.setResourceDir(resourceDir);
                    dsources.add(sunResource);
                    continue;
                }
                HashMap poolValues = ResourceUtils.getConnPoolValues(resourceDir, poolName);
                if (poolValues.isEmpty() || (url = (String)poolValues.get("URL")) == null || url.equals("")) continue;
                username = (String)poolValues.get("User");
                password = (String)poolValues.get("Password");
                driverClass = (String)poolValues.get("driverClass");
                SunDatasource sunResource = new SunDatasource(datasourceBean.getJndiName(), url, username, password, driverClass);
                sunResource.setResourceDir(resourceDir);
                dsources.add(sunResource);
            }
            catch (Exception ex) {
                ErrorManager.getDefault().log(1, "Cannot construct SunDatasource for jdbc resource : " + datasourceBean.getJndiName() + "with pool " + poolName);
            }
        }
        return dsources;
    }

    @Override
    public Datasource createDataSource(String jndiName, String url, String username, String password, String driver, File dir, String baseName) throws DatasourceAlreadyExistsException {
        SunDatasource ds = null;
        try {
            if (this.isDataSourcePresent(jndiName, dir)) {
                throw new DatasourceAlreadyExistsException((Datasource)new SunDatasource(jndiName, url, username, password, driver));
            }
            if (url != null) {
                String vendorName = this.convertToValidName(url);
                if (vendorName == null) {
                    vendorName = jndiName;
                } else if (vendorName.equals("derby_embedded")) {
                    NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)this.bundle.getString("Err_UnSupportedDerby"), 2);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
                    return null;
                }
                this.ensureFolderExists(dir);
                String poolName = this.createCheckForConnectionPool(vendorName, url, username, password, driver, dir, baseName);
                boolean jdbcExists = this.requiredResourceExists(jndiName, dir, JDBC_RESOURCE);
                if (jdbcExists) {
                    ds = null;
                } else {
                    this.createJDBCResource(jndiName, poolName, dir, baseName);
                    ds = new SunDatasource(jndiName, url, username, password, driver);
                }
            }
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(4096, (Throwable)ex);
        }
        return ds;
    }

    private void createCPPoolResource(String name, String databaseUrl, String username, String password, String driver, File resourceDir, String baseName) throws IOException {
        FileObject location = FileUtil.toFileObject((File)resourceDir);
        Resources resources = ResourceUtils.getServerResourcesGraph(location, baseName.contains("glassfish-resources") ? "1.50" : "1.30");
        JdbcConnectionPool jdbcConnectionPool = resources.newJdbcConnectionPool();
        jdbcConnectionPool.setName(name);
        jdbcConnectionPool.setResType("javax.sql.DataSource");
        Wizard wizard = ResourceConfigurator.getWizardInfo();
        String vendorName = ResourceConfigurator.getDatabaseVendorName(databaseUrl, wizard);
        String datasourceClassName = "";
        if (!vendorName.equals("")) {
            datasourceClassName = this.getDatasourceClassName(vendorName, false, wizard);
        }
        if (datasourceClassName.equals("") && ((datasourceClassName = DatabaseUtils.getDSClassName(databaseUrl)) == null || datasourceClassName.equals(""))) {
            datasourceClassName = driver;
        }
        if (datasourceClassName != null) {
            jdbcConnectionPool.setDatasourceClassname(datasourceClassName);
        }
        PropertyElement user = jdbcConnectionPool.newPropertyElement();
        user.setName("User");
        user.setValue(username);
        PropertyElement passElement = jdbcConnectionPool.newPropertyElement();
        passElement.setName("Password");
        jdbcConnectionPool.addPropertyElement(user);
        if (username != null && (password == null || password.trim().length() == 0)) {
            password = "()";
        }
        passElement.setValue(password);
        jdbcConnectionPool.addPropertyElement(passElement);
        if (vendorName.equals("derby_net")) {
            jdbcConnectionPool = this.setDerbyProps(databaseUrl, jdbcConnectionPool);
        } else if (Arrays.asList(WizardConstants.VendorsExtraProps).contains(vendorName)) {
            jdbcConnectionPool = this.setAdditionalProps(vendorName, databaseUrl, jdbcConnectionPool);
        } else if (vendorName.equals("pointbase")) {
            PropertyElement databaseOrUrl = jdbcConnectionPool.newPropertyElement();
            databaseOrUrl.setName("databaseName");
            databaseOrUrl.setValue(databaseUrl);
            jdbcConnectionPool.addPropertyElement(databaseOrUrl);
        }
        PropertyElement url = jdbcConnectionPool.newPropertyElement();
        url.setName("URL");
        url.setValue(databaseUrl);
        jdbcConnectionPool.addPropertyElement(url);
        PropertyElement driverClass = jdbcConnectionPool.newPropertyElement();
        driverClass.setName("driverClass");
        driverClass.setValue(driver);
        jdbcConnectionPool.addPropertyElement(driverClass);
        resources.addJdbcConnectionPool(jdbcConnectionPool);
        ResourceUtils.createFile(location, resources, baseName);
        try {
            Thread.sleep(1000L);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "createCPPoolResource failed", ex);
        }
    }

    private void createJDBCResource(String jndiName, String poolName, File resourceDir, String baseName) throws IOException {
        FileObject location = FileUtil.toFileObject((File)resourceDir);
        Resources resources = ResourceUtils.getServerResourcesGraph(location, baseName.contains("glassfish-resources") ? "1.50" : "1.30");
        JdbcResource jdbcResource = resources.newJdbcResource();
        jdbcResource.setPoolName(poolName);
        jdbcResource.setJndiName(jndiName);
        resources.addJdbcResource(jdbcResource);
        ResourceUtils.createFile(location, resources, baseName);
    }

    private static File getServerResourceFiles(File resourceDir) {
        File resourceFile = null;
        if (resourceDir != null) {
            resourceFile = ResourceUtils.getServerResourcesFile(FileUtil.toFileObject((File)resourceDir), true);
        }
        return resourceFile;
    }

    private static HashMap getConnectionPools(File resourceFile) {
        HashMap<String, JdbcConnectionPool> connPools = new HashMap<String, JdbcConnectionPool>();
        Resources resources = ResourceConfigurator.getResourcesGraph(resourceFile);
        JdbcConnectionPool[] pools = resources.getJdbcConnectionPool();
        for (int i = 0; i < pools.length; ++i) {
            JdbcConnectionPool pool = pools[i];
            connPools.put(pool.getName(), pool);
        }
        return connPools;
    }

    private static HashMap getJdbcResources(File resourceFile) {
        HashMap<String, JdbcResource> jdbcResources = new HashMap<String, JdbcResource>();
        Resources resources = ResourceConfigurator.getResourcesGraph(resourceFile);
        JdbcResource[] dsources = resources.getJdbcResource();
        for (int i = 0; i < dsources.length; ++i) {
            JdbcResource datasource = dsources[i];
            jdbcResources.put(datasource.getJndiName(), datasource);
        }
        return jdbcResources;
    }

    private HashMap getAdminObjectResources(File resourceFile) {
        HashMap<String, AdminObjectResource> aoResources = new HashMap<String, AdminObjectResource>();
        Resources resources = ResourceConfigurator.getResourcesGraph(resourceFile);
        AdminObjectResource[] adminObjects = resources.getAdminObjectResource();
        for (int i = 0; i < adminObjects.length; ++i) {
            AdminObjectResource aObject = adminObjects[i];
            aoResources.put(aObject.getJndiName(), aObject);
        }
        return aoResources;
    }

    private static Resources getResourcesGraph(File resourceFile) {
        Resources resourceGraph = DDProvider.getDefault().getResourcesGraph("1.30");
        try {
            if (!resourceFile.isDirectory()) {
                FileInputStream in = new FileInputStream(resourceFile);
                resourceGraph = DDProvider.getDefault().getResourcesGraph((InputStream)in);
            }
        }
        catch (RuntimeException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        return resourceGraph;
    }

    private boolean isDataSourcePresent(String jndiName, File dir) {
        boolean exists = false;
        HashMap serverResources = this.getDataSourceMap(this.getResources(dir));
        if (serverResources.containsKey(jndiName)) {
            exists = true;
        }
        return exists;
    }

    private HashMap getDataSourceMap(HashSet resources) {
        HashMap<String, SunDatasource> dSources = new HashMap<String, SunDatasource>();
        for (SunDatasource ds : resources) {
            dSources.put(ds.getJndiName(), ds);
        }
        return dSources;
    }

    private String createCheckForConnectionPool(String vendorName, String url, String username, String password, String driver, File dir, String baseName) {
        boolean createResource = true;
        String poolName = this.createPoolName(url, vendorName, username);
        File resourceFile = ResourceConfigurator.getServerResourceFiles(dir);
        if (resourceFile != null) {
            HashMap pools = ResourceConfigurator.getConnectionPools(resourceFile);
            if (pools.containsKey(poolName)) {
                JdbcConnectionPool pool = (JdbcConnectionPool)pools.get(poolName);
                String poolJndiName = this.isSameDatabaseConnection(pool, url, username, password);
                if (poolJndiName == null) {
                    poolName = ResourceUtils.getUniqueResourceName(poolName, pools);
                } else {
                    createResource = false;
                }
            } else {
                for (JdbcConnectionPool pool : pools.values()) {
                    String poolJndiName = this.isSameDatabaseConnection(pool, url, username, password);
                    if (poolJndiName == null) continue;
                    poolName = poolJndiName;
                    createResource = false;
                    break;
                }
            }
        } else {
            createResource = true;
        }
        if (createResource) {
            try {
                this.createCPPoolResource(poolName, url, username, password, driver, dir, baseName);
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify(4096, (Throwable)ex);
            }
        }
        return poolName;
    }

    private String createPoolName(String url, String vendorName, String username) {
        UrlData urlData = new UrlData(url);
        StringBuffer poolName = new StringBuffer(vendorName);
        String dbName = ResourceConfigurator.getDatabaseName(urlData);
        if (dbName != null) {
            poolName.append("_" + dbName);
        }
        if (username != null) {
            poolName.append("_" + username);
        }
        poolName.append("Pool");
        return poolName.toString();
    }

    private static String getDatabaseName(UrlData urlData) {
        String databaseName = urlData.getDatabaseName();
        if (databaseName == null) {
            databaseName = urlData.getAlternateDBName();
        }
        return databaseName;
    }

    @Override
    public HashSet getMessageDestinations(File resourceDir) {
        HashSet serverresources = new HashSet();
        File resourceFile = ResourceConfigurator.getServerResourceFiles(resourceDir);
        if (resourceFile == null) {
            return serverresources;
        }
        HashSet<SunMessageDestination> destinations = new HashSet<SunMessageDestination>();
        HashMap jmsResources = this.getAdminObjectResources(resourceFile);
        for (AdminObjectResource aoBean : jmsResources.values()) {
            String jmsName = aoBean.getJndiName();
            String type = aoBean.getResType();
            SunMessageDestination sunMessage = null;
            sunMessage = type.equals("javax.jms.Queue") ? new SunMessageDestination(jmsName, MessageDestination.Type.QUEUE) : new SunMessageDestination(jmsName, MessageDestination.Type.TOPIC);
            sunMessage.setResourceDir(resourceDir);
            destinations.add(sunMessage);
        }
        return destinations;
    }

    @Override
    public HashSet getServerDestinations() {
        return ResourceUtils.getServerDestinations(this.currentDM);
    }

    private boolean requiredResourceExists(String jndiName, File dir, String resType) {
        boolean resourceExists = false;
        File resourceFile = ResourceConfigurator.getServerResourceFiles(dir);
        if (resourceFile != null) {
            HashMap resources = new HashMap();
            if (resType.equals(JDBC_RESOURCE)) {
                resources = ResourceConfigurator.getJdbcResources(resourceFile);
            } else if (resType.equals(JMS_RESOURCE)) {
                resources = this.getAdminObjectResources(resourceFile);
            }
            for (String resJndiName : resources.keySet()) {
                if (!resJndiName.equals(jndiName)) continue;
                resourceExists = true;
                break;
            }
        }
        return resourceExists;
    }
}

