/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.structure.document;

import java.awt.Color;
import java.awt.Image;
import java.awt.Paint;
import org.netbeans.api.visual.border.Border;
import org.netbeans.api.visual.border.BorderFactory;
import org.netbeans.api.visual.layout.Layout;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.model.ObjectScene;
import org.netbeans.api.visual.widget.ImageWidget;
import org.netbeans.api.visual.widget.LabelWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.SeparatorWidget;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.vmd.api.model.ComponentDescriptor;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PaletteDescriptor;
import org.netbeans.modules.vmd.api.model.PropertyDescriptor;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.structure.document.DocumentScene;
import org.openide.util.ImageUtilities;

public class ComponentWidget
extends Widget {
    private static final Layout LAYOUT = LayoutFactory.createHorizontalFlowLayout();
    private static final Layout LAYOUT_NODES = LayoutFactory.createVerticalFlowLayout((LayoutFactory.SerialAlignment)LayoutFactory.SerialAlignment.JUSTIFY, (int)10);
    private static final Layout LAYOUT_LABEL = LayoutFactory.createVerticalFlowLayout();
    private static final Border BORDER_SEPARATOR = BorderFactory.createEmptyBorder((int)8, (int)0);
    private static final Border BORDER_IMAGE = BorderFactory.createEmptyBorder((int)4, (int)8, (int)4, (int)0);
    private static final Border BORDER_LABEL = BorderFactory.createEmptyBorder((int)8, (int)4);
    private Widget components;
    private DesignComponent component;

    public ComponentWidget(DocumentScene scene, DesignComponent component, boolean selected) {
        super((Scene)scene);
        this.component = component;
        ComponentDescriptor descriptor = component.getComponentDescriptor();
        Color validityColor = descriptor != null ? Color.WHITE : Color.MAGENTA;
        PaletteDescriptor paletteDescriptor = descriptor != null ? descriptor.getPaletteDescriptor() : null;
        Image image = paletteDescriptor != null ? ImageUtilities.loadImage((String)paletteDescriptor.getSmallIcon()) : null;
        this.setLayout(LAYOUT);
        SeparatorWidget separator = new SeparatorWidget((Scene)scene, SeparatorWidget.Orientation.VERTICAL);
        separator.setBorder(BORDER_SEPARATOR);
        this.addChild((Widget)separator);
        if (image != null) {
            ImageWidget imageWidget = new ImageWidget((Scene)scene, image);
            imageWidget.setBorder(BORDER_IMAGE);
            imageWidget.setOpaque(true);
            imageWidget.setBackground((Paint)(selected ? DocumentScene.COLOR_SELECTED : validityColor));
            this.addChild((Widget)imageWidget);
        }
        Widget descriptionWidget = new Widget((Scene)scene);
        descriptionWidget.setBorder(BORDER_LABEL);
        descriptionWidget.setOpaque(true);
        descriptionWidget.setBackground((Paint)(selected ? DocumentScene.COLOR_SELECTED : validityColor));
        descriptionWidget.setLayout(LAYOUT_LABEL);
        this.addChild(descriptionWidget);
        LabelWidget idWidget = new LabelWidget((Scene)scene, component.getComponentID() + " : " + (descriptor != null ? descriptor.getTypeDescriptor().getThisType().toString() : "<Unknown>"));
        idWidget.setFont(scene.getDefaultFont().deriveFont(1));
        descriptionWidget.addChild((Widget)idWidget);
        if (descriptor != null) {
            for (PropertyDescriptor propertyDescriptor : descriptor.getPropertyDescriptors()) {
                String name = propertyDescriptor.getName();
                PropertyValue value = component.readProperty(name);
                descriptionWidget.addChild((Widget)new LabelWidget((Scene)scene, name + "=" + value.serialize()));
            }
        }
        this.components = new Widget((Scene)scene);
        this.components.setLayout(LAYOUT_NODES);
        this.addChild(this.components);
        descriptionWidget.getActions().addAction(scene.getHoverAction());
        this.getActions().addAction(scene.getSelectAction());
    }

    public void addChildComponentWidget(ComponentWidget widget) {
        this.components.addChild((Widget)widget);
        ((ObjectScene)widget.getScene()).addObject((Object)widget.getComponent(), new Widget[]{widget});
    }

    public DesignComponent getComponent() {
        return this.component;
    }
}

