/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.java.api.MemberInfo;
import org.netbeans.modules.refactoring.java.plugins.MoveTransformer;
import org.netbeans.modules.refactoring.java.spi.RefactoringVisitor;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class PushDownTransformer
extends RefactoringVisitor {
    private MemberInfo<ElementHandle<? extends Element>>[] members;
    private Problem problem;

    public Problem getProblem() {
        return this.problem;
    }

    public PushDownTransformer(MemberInfo<ElementHandle<? extends Element>>[] members) {
        this.members = members;
    }

    @Override
    public Tree visitClass(ClassTree tree, Element p) {
        Element el = this.workingCopy.getTrees().getElement(this.getCurrentPath());
        GeneratorUtilities genUtils = GeneratorUtilities.get((WorkingCopy)this.workingCopy);
        ClassTree njuClass = tree;
        if (((Object)el).equals(p)) {
            boolean classIsAbstract = el.getKind().isInterface();
            for (Tree tree2 : njuClass.getImplementsClause()) {
                Element currentInterface = this.workingCopy.getTrees().getElement(TreePath.getPath(this.getCurrentPath(), tree2));
                for (int i = 0; i < this.members.length; ++i) {
                    if (this.members[i].getGroup() != MemberInfo.Group.IMPLEMENTS || !((Object)currentInterface).equals(this.members[i].getElementHandle().resolve((CompilationInfo)this.workingCopy))) continue;
                    njuClass = this.make.removeClassImplementsClause(njuClass, tree2);
                    this.rewrite(tree, njuClass);
                }
            }
            for (Tree tree3 : njuClass.getMembers()) {
                for (int i = 0; i < this.members.length; ++i) {
                    Element current = this.workingCopy.getTrees().getElement(TreePath.getPath(this.workingCopy.getCompilationUnit(), tree3));
                    if (this.members[i].getGroup() == MemberInfo.Group.IMPLEMENTS || current == null || !((Object)current).equals(this.members[i].getElementHandle().resolve((CompilationInfo)this.workingCopy))) continue;
                    if (this.members[i].isMakeAbstract()) {
                        if (!el.getKind().isClass()) continue;
                        if (!classIsAbstract) {
                            classIsAbstract = true;
                            HashSet<Modifier> mod = new HashSet<Modifier>(njuClass.getModifiers().getFlags());
                            mod.add(Modifier.ABSTRACT);
                            ModifiersTree modifiers = this.make.Modifiers(mod);
                            this.rewrite(njuClass.getModifiers(), modifiers);
                        }
                        MethodTree method = (MethodTree)tree3;
                        HashSet<Modifier> mod = new HashSet<Modifier>(method.getModifiers().getFlags());
                        mod.add(Modifier.ABSTRACT);
                        if (mod.contains((Object)Modifier.PRIVATE)) {
                            mod.remove((Object)Modifier.PRIVATE);
                            mod.add(Modifier.PROTECTED);
                        }
                        MethodTree nju = this.make.Method(this.make.Modifiers(mod), (CharSequence)method.getName(), method.getReturnType(), method.getTypeParameters(), method.getParameters(), method.getThrows(), (BlockTree)null, (ExpressionTree)method.getDefaultValue());
                        this.rewrite(method, nju);
                        continue;
                    }
                    njuClass = this.make.removeClassMember(njuClass, tree3);
                    this.rewrite(tree, njuClass);
                }
            }
        } else {
            TypeMirror tm = el.asType();
            Types types = this.workingCopy.getTypes();
            if (types.isSubtype(types.erasure(tm), types.erasure(p.asType()))) {
                ArrayList<String> arrayList = new ArrayList<String>();
                boolean makeClassAbstract = false;
                for (int i = 0; i < this.members.length; ++i) {
                    Element member = this.members[i].getElementHandle().resolve((CompilationInfo)this.workingCopy);
                    if (this.members[i].getGroup() == MemberInfo.Group.IMPLEMENTS) {
                        if (((TypeElement)el).getInterfaces().contains(member.asType())) {
                            this.problem = MoveTransformer.createProblem(this.problem, false, NbBundle.getMessage(PushDownTransformer.class, (String)"ERR_PushDown_AlreadyExists", (Object)member.getSimpleName(), (Object)el.getSimpleName()));
                        }
                        arrayList.add(((Object)member.asType()).toString());
                        njuClass = this.make.addClassImplementsClause(njuClass, (Tree)this.make.Identifier(member));
                        continue;
                    }
                    if (this.members[i].getGroup() == MemberInfo.Group.METHOD && member.getModifiers().contains((Object)Modifier.ABSTRACT) && el.getKind().isClass() && p.getKind().isInterface()) {
                        if (RetoucheUtils.elementExistsIn((TypeElement)el, member, (CompilationInfo)this.workingCopy)) {
                            this.problem = MoveTransformer.createProblem(this.problem, false, NbBundle.getMessage(PushDownTransformer.class, (String)"ERR_PushDown_AlreadyExists", (Object)member.getSimpleName(), (Object)el.getSimpleName()));
                        }
                        MethodTree methodTree = this.workingCopy.getTrees().getTree((ExecutableElement)member);
                        ModifiersTree mods = RetoucheUtils.makeAbstract(this.make, methodTree.getModifiers());
                        mods = this.make.addModifiersModifier(mods, Modifier.PUBLIC);
                        MethodTree njuMethod = this.make.Method(mods, (CharSequence)methodTree.getName(), methodTree.getReturnType(), methodTree.getTypeParameters(), methodTree.getParameters(), methodTree.getThrows(), (BlockTree)null, null);
                        RetoucheUtils.copyJavadoc(member, njuMethod, this.workingCopy);
                        njuClass = genUtils.insertClassMember(njuClass, (Tree)njuMethod);
                        makeClassAbstract = true;
                        continue;
                    }
                    if (RetoucheUtils.elementExistsIn((TypeElement)el, member, (CompilationInfo)this.workingCopy)) {
                        this.problem = MoveTransformer.createProblem(this.problem, false, NbBundle.getMessage(PushDownTransformer.class, (String)"ERR_PushDown_AlreadyExists", (Object)member.getSimpleName(), (Object)el.getSimpleName()));
                    }
                    TreePath path = this.workingCopy.getTrees().getPath(member);
                    Tree memberTree = genUtils.importComments(path.getLeaf(), path.getCompilationUnit());
                    memberTree = genUtils.importFQNs(memberTree);
                    RetoucheUtils.copyJavadoc(member, memberTree, this.workingCopy);
                    if (this.members[i].isMakeAbstract() && memberTree.getKind() == Tree.Kind.METHOD && member.getModifiers().contains((Object)Modifier.PRIVATE)) {
                        MethodTree oldOne = (MethodTree)memberTree;
                        MethodTree m = this.make.Method(this.make.addModifiersModifier(this.make.removeModifiersModifier(oldOne.getModifiers(), Modifier.PRIVATE), Modifier.PROTECTED), (CharSequence)oldOne.getName(), oldOne.getReturnType(), oldOne.getTypeParameters(), oldOne.getParameters(), oldOne.getThrows(), oldOne.getBody(), (ExpressionTree)oldOne.getDefaultValue());
                        RetoucheUtils.copyJavadoc(member, m, this.workingCopy);
                        njuClass = genUtils.insertClassMember(njuClass, (Tree)m);
                    } else {
                        njuClass = genUtils.insertClassMember(njuClass, memberTree);
                    }
                    makeClassAbstract |= member.getModifiers().contains((Object)Modifier.ABSTRACT);
                }
                if (makeClassAbstract && !njuClass.getModifiers().getFlags().contains((Object)Modifier.ABSTRACT)) {
                    njuClass = this.make.Class(RetoucheUtils.makeAbstract(this.make, njuClass.getModifiers()), (CharSequence)njuClass.getSimpleName(), njuClass.getTypeParameters(), njuClass.getExtendsClause(), njuClass.getImplementsClause(), njuClass.getMembers());
                }
                try {
                    if (arrayList.size() > 0) {
                        CompilationUnitTree newCut = RetoucheUtils.addImports(this.workingCopy.getCompilationUnit(), arrayList, this.make);
                        this.rewrite(this.workingCopy.getCompilationUnit(), newCut);
                    }
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                this.rewrite(tree, njuClass);
            }
        }
        return (Tree)super.visitClass(tree, p);
    }
}

