/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import org.netbeans.modules.java.navigation.ClassMemberPanelUI;
import org.netbeans.modules.java.navigation.ElementNode;
import org.netbeans.modules.java.navigation.actions.SortActionSupport;
import org.netbeans.modules.java.navigation.base.FiltersDescription;
import org.netbeans.modules.java.navigation.base.FiltersManager;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public final class ClassMemberFilters {
    private ClassMemberPanelUI ui;
    private static final String SHOW_NON_PUBLIC = "show_non_public";
    private static final String SHOW_STATIC = "show_static";
    private static final String SHOW_FIELDS = "show_fields";
    private static final String SHOW_INHERITED = "show_inherited";
    private static final String SORT_ALPHA = "sort_alpha";
    private static final String SORT_POSITION = "sort_position";
    private FiltersManager filters;
    private boolean naturalSort = false;
    private JToggleButton sortByNameButton;
    private JToggleButton sortByPositionButton;

    ClassMemberFilters(ClassMemberPanelUI ui) {
        this.ui = ui;
        this.naturalSort = NbPreferences.forModule(ClassMemberFilters.class).getBoolean("naturalSort", false);
    }

    public FiltersManager getInstance() {
        if (this.filters == null) {
            this.filters = ClassMemberFilters.createFilters();
        }
        return this.filters;
    }

    public JComponent getComponent() {
        FiltersManager f = this.getInstance();
        return f.getComponent(this.createSortButtons());
    }

    public Collection<ElementNode.Description> filter(Collection<ElementNode.Description> original) {
        boolean non_public = this.filters.isSelected(SHOW_NON_PUBLIC);
        boolean statik = this.filters.isSelected(SHOW_STATIC);
        boolean fields = this.filters.isSelected(SHOW_FIELDS);
        boolean inherited = this.filters.isSelected(SHOW_INHERITED);
        ArrayList<ElementNode.Description> result = new ArrayList<ElementNode.Description>(original.size());
        for (ElementNode.Description description : original) {
            if (!inherited && description.isInherited || !non_public && !description.modifiers.contains((Object)Modifier.PUBLIC) || !statik && description.modifiers.contains((Object)Modifier.STATIC) || !fields && description.kind == ElementKind.FIELD) continue;
            result.add(description);
        }
        Collections.sort(result, this.isNaturalSort() ? ElementNode.Description.POSITION_COMPARATOR : ElementNode.Description.ALPHA_COMPARATOR);
        return result;
    }

    public boolean isNaturalSort() {
        return this.naturalSort;
    }

    public void setNaturalSort(boolean naturalSort) {
        this.naturalSort = naturalSort;
        NbPreferences.forModule(ClassMemberFilters.class).putBoolean("naturalSort", naturalSort);
        if (null != this.sortByNameButton) {
            this.sortByNameButton.setSelected(!naturalSort);
        }
        if (null != this.sortByPositionButton) {
            this.sortByPositionButton.setSelected(naturalSort);
        }
        this.ui.sort();
    }

    private static FiltersManager createFilters() {
        FiltersDescription desc = new FiltersDescription();
        desc.addFilter(SHOW_INHERITED, NbBundle.getMessage(ClassMemberFilters.class, (String)"LBL_ShowInherited"), NbBundle.getMessage(ClassMemberFilters.class, (String)"LBL_ShowInheritedTip"), false, ImageUtilities.loadImageIcon((String)"org/netbeans/modules/java/navigation/resources/filterHideInherited.png", (boolean)false), null);
        desc.addFilter(SHOW_FIELDS, NbBundle.getMessage(ClassMemberFilters.class, (String)"LBL_ShowFields"), NbBundle.getMessage(ClassMemberFilters.class, (String)"LBL_ShowFieldsTip"), true, ImageUtilities.loadImageIcon((String)"org/netbeans/modules/java/navigation/resources/filterHideFields.png", (boolean)false), null);
        desc.addFilter(SHOW_STATIC, NbBundle.getMessage(ClassMemberFilters.class, (String)"LBL_ShowStatic"), NbBundle.getMessage(ClassMemberFilters.class, (String)"LBL_ShowStaticTip"), true, ImageUtilities.loadImageIcon((String)"org/netbeans/modules/java/navigation/resources/filterHideStatic.png", (boolean)false), null);
        desc.addFilter(SHOW_NON_PUBLIC, NbBundle.getMessage(ClassMemberFilters.class, (String)"LBL_ShowNonPublic"), NbBundle.getMessage(ClassMemberFilters.class, (String)"LBL_ShowNonPublicTip"), true, ImageUtilities.loadImageIcon((String)"org/netbeans/modules/java/navigation/resources/filterHideNonPublic.png", (boolean)false), null);
        return FiltersDescription.createManager(desc);
    }

    private JToggleButton[] createSortButtons() {
        JToggleButton[] res = new JToggleButton[2];
        if (null == this.sortByNameButton) {
            this.sortByNameButton = new JToggleButton(new SortActionSupport.SortByNameAction(this));
            this.sortByNameButton.setToolTipText(this.sortByNameButton.getText());
            this.sortByNameButton.setText(null);
            this.sortByNameButton.setSelected(!this.naturalSort);
            this.sortByNameButton.setFocusable(false);
        }
        res[0] = this.sortByNameButton;
        if (null == this.sortByPositionButton) {
            this.sortByPositionButton = new JToggleButton(new SortActionSupport.SortBySourceAction(this));
            this.sortByPositionButton.setToolTipText(this.sortByPositionButton.getText());
            this.sortByPositionButton.setText(null);
            this.sortByPositionButton.setSelected(this.naturalSort);
            this.sortByPositionButton.setFocusable(false);
        }
        res[1] = this.sortByPositionButton;
        return res;
    }
}

