/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.remote.RemoteFileUtil;
import org.netbeans.modules.cnd.makeproject.api.ProjectSupport;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.ui.MakeLogicalViewProvider;
import org.netbeans.modules.cnd.makeproject.ui.utils.PathPanel;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.ui.FileChooser;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileSystem;
import org.openide.util.NbBundle;

public class AddExternalItemAction
extends AbstractAction {
    private Project project;

    public AddExternalItemAction(Project project) {
        this.putValue("Name", NbBundle.getBundle(this.getClass()).getString("CTL_AddExternalItem"));
        this.project = project;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ConfigurationDescriptorProvider pdp = (ConfigurationDescriptorProvider)this.project.getLookup().lookup(ConfigurationDescriptorProvider.class);
        MakeConfigurationDescriptor projectDescriptor = pdp.getConfigurationDescriptor();
        MakeConfigurationDescriptor makeProjectDescriptor = projectDescriptor;
        if (!makeProjectDescriptor.okToChange()) {
            return;
        }
        String seed = null;
        if (FileChooser.getCurrentChooserFile() != null) {
            seed = FileChooser.getCurrentChooserFile().getPath();
        }
        if (seed == null) {
            seed = makeProjectDescriptor.getBaseDir();
        }
        JFileChooser fileChooser = RemoteFileUtil.createFileChooser((FileSystem)makeProjectDescriptor.getBaseDirFileSystem(), (String)NbBundle.getBundle(this.getClass()).getString("LBL_FileChooserTitle"), (String)NbBundle.getBundle(this.getClass()).getString("LBL_SelectButton"), (int)2, null, (String)seed, (boolean)true);
        PathPanel pathPanel = new PathPanel();
        fileChooser.setAccessory(pathPanel);
        fileChooser.setMultiSelectionEnabled(true);
        int ret = fileChooser.showOpenDialog(null);
        if (ret == 1) {
            return;
        }
        File[] files = fileChooser.getSelectedFiles();
        ArrayList<Item> items = new ArrayList<Item>();
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].exists()) {
                String errormsg = NbBundle.getMessage(AddExternalItemAction.class, (String)"FILE_DOESNT_EXISTS", (Object)files[i].getPath());
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)errormsg, 0));
                continue;
            }
            String itemPath = ProjectSupport.toProperPath(makeProjectDescriptor.getBaseDir(), files[i].getPath(), this.project);
            itemPath = CndPathUtilitities.normalizeSlashes((String)itemPath);
            Item item = makeProjectDescriptor.getExternalItemFolder().findItemByPath(itemPath);
            if (item != null) {
                items.add(item);
                continue;
            }
            item = Item.createInFileSystem(makeProjectDescriptor.getBaseDirFileSystem(), itemPath);
            makeProjectDescriptor.getExternalItemFolder().addItem(item);
            items.add(item);
        }
        if (items.size() > 0) {
            MakeLogicalViewProvider.setVisible(this.project, items.toArray(new Item[items.size()]));
        }
    }
}

