/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.configurations.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.netbeans.modules.cnd.makeproject.api.PackagerDescriptor;
import org.netbeans.modules.cnd.makeproject.api.PackagerInfoElement;
import org.netbeans.modules.cnd.makeproject.api.PackagerManager;
import org.netbeans.modules.cnd.makeproject.api.configurations.PackagingConfiguration;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class PackagingNewEntryPanel
extends JPanel {
    private PackagingConfiguration packagingConfiguration;
    private JTextArea docArea;
    private JComboBox entryComboBox;
    private JLabel entryLabel;
    private JTextArea entryValueTextArea;
    private JScrollPane jScrollPane1;
    private JScrollPane scrollPane;
    private JLabel valueLabel;
    private static ResourceBundle bundle;

    public PackagingNewEntryPanel(PackagingConfiguration packagingConfiguration) {
        this.initComponents();
        this.packagingConfiguration = packagingConfiguration;
        PackagerDescriptor packager = PackagerManager.getDefault().getPackager(packagingConfiguration.getType().getValue());
        List<String> optionalEntries = packager.getOptionalInfoList();
        if (optionalEntries != null) {
            for (String entry : optionalEntries) {
                this.entryComboBox.addItem(entry);
            }
        }
    }

    private void initComponents() {
        this.entryLabel = new JLabel();
        this.entryComboBox = new JComboBox();
        this.scrollPane = new JScrollPane();
        this.docArea = new JTextArea();
        this.docArea.setBackground(this.getBackground());
        this.valueLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.entryValueTextArea = new JTextArea();
        this.setPreferredSize(new Dimension(600, 250));
        this.setRequestFocusEnabled(false);
        this.setLayout(new GridBagLayout());
        this.entryLabel.setLabelFor(this.entryComboBox);
        Mnemonics.setLocalizedText((JLabel)this.entryLabel, (String)NbBundle.getMessage(PackagingNewEntryPanel.class, (String)"PackagingNewEntryPanel.entryLabel.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(16, 16, 0, 0);
        this.add((Component)this.entryLabel, gridBagConstraints);
        this.entryComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PackagingNewEntryPanel.this.entryComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(14, 4, 0, 0);
        this.add((Component)this.entryComboBox, gridBagConstraints);
        this.entryComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PackagingNewEntryPanel.class, (String)"PackagingNewEntryPanel.entryComboBox.AccessibleContext.accessibleName"));
        this.entryComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PackagingNewEntryPanel.class, (String)"PackagingNewEntryPanel.entryComboBox.AccessibleContext.accessibleDescription"));
        this.scrollPane.setBorder(null);
        this.docArea.setEditable(false);
        this.docArea.setLineWrap(true);
        this.docArea.setRows(5);
        this.docArea.setWrapStyleWord(true);
        this.scrollPane.setViewportView(this.docArea);
        this.docArea.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PackagingNewEntryPanel.class, (String)"PackagingNewEntryPanel.docArea.AccessibleContext.accessibleName"));
        this.docArea.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PackagingNewEntryPanel.class, (String)"PackagingNewEntryPanel.docArea.AccessibleContext.accessibleDescription"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(8, 16, 16, 16);
        this.add((Component)this.scrollPane, gridBagConstraints);
        this.valueLabel.setLabelFor(this.entryValueTextArea);
        Mnemonics.setLocalizedText((JLabel)this.valueLabel, (String)NbBundle.getMessage(PackagingNewEntryPanel.class, (String)"PackagingNewEntryPanel.valueLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(16, 16, 0, 0);
        this.add((Component)this.valueLabel, gridBagConstraints);
        this.entryValueTextArea.setColumns(20);
        this.entryValueTextArea.setRows(5);
        this.jScrollPane1.setViewportView(this.entryValueTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(16, 4, 0, 16);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
    }

    private void entryComboBoxActionPerformed(ActionEvent evt) {
        String elemName = (String)this.entryComboBox.getSelectedItem();
        this.docArea.setText("");
        if (elemName.equals("BASEDIR")) {
            this.docArea.setText(PackagingNewEntryPanel.getString("PACKAGING_BASEDIR_DOC"));
        } else if (elemName.equals("CLASSES")) {
            this.docArea.setText(PackagingNewEntryPanel.getString("PACKAGING_CLASSES_DOC"));
        } else if (elemName.equals("DESC")) {
            this.docArea.setText(PackagingNewEntryPanel.getString("PACKAGING_DESC_DOC"));
        } else if (elemName.equals("EMAIL")) {
            this.docArea.setText(PackagingNewEntryPanel.getString("PACKAGING_EMAIL_DOC"));
        } else if (elemName.equals("HOTLINE")) {
            this.docArea.setText(PackagingNewEntryPanel.getString("PACKAGING_HOTLINE_DOC"));
        } else if (elemName.equals("INTONLY")) {
            this.docArea.setText(PackagingNewEntryPanel.getString("PACKAGING_INTONLY_DOC"));
        } else if (elemName.equals("ISTATES")) {
            this.docArea.setText(PackagingNewEntryPanel.getString("PACKAGING_ISTATES_DOC"));
        } else if (elemName.equals("MAXINST")) {
            this.docArea.setText(PackagingNewEntryPanel.getString("PACKAGING_MAXINST_DOC"));
        } else if (elemName.equals("ORDER")) {
            this.docArea.setText(PackagingNewEntryPanel.getString("PACKAGING_ORDER_DOC"));
        } else if (elemName.equals("PSTAMP")) {
            this.docArea.setText(PackagingNewEntryPanel.getString("PACKAGING_PSTAMP_DOC"));
        } else if (elemName.equals("RSTATES")) {
            this.docArea.setText(PackagingNewEntryPanel.getString("PACKAGING_RSTATES_DOC"));
        } else if (elemName.equals("SUNW_ISA")) {
            this.docArea.setText(PackagingNewEntryPanel.getString("PACKAGING_SUNW_ISA_DOC"));
        } else if (elemName.equals("SUNW_LOC")) {
            this.docArea.setText(PackagingNewEntryPanel.getString("PACKAGING_SUNW_LOC_DOC"));
        } else if (elemName.equals("SUNW_PKG_DIR")) {
            this.docArea.setText(PackagingNewEntryPanel.getString("PACKAGING_SUNW_PKG_DIR_DOC"));
        } else if (elemName.equals("SUNW_PKG_ALLZONES")) {
            this.docArea.setText(PackagingNewEntryPanel.getString("PACKAGING_SUNW_PKG_ALLZONES_DOC"));
        } else if (elemName.equals("SUNW_PKG_HOLLOW")) {
            this.docArea.setText(PackagingNewEntryPanel.getString("PACKAGING_SUNW_PKG_HOLLOW_DOC"));
        } else if (elemName.equals("SUNW_PKG_THISZONE")) {
            this.docArea.setText(PackagingNewEntryPanel.getString("PACKAGING_SUNW_PKG_THISZONE_DOC"));
        } else if (elemName.equals("SUNW_PKGLIST")) {
            this.docArea.setText(PackagingNewEntryPanel.getString("PACKAGING_SUNW_PKGLIST_DOC"));
        } else if (elemName.equals("SUNW_PKGTYPE")) {
            this.docArea.setText(PackagingNewEntryPanel.getString("PACKAGING_SUNW_PKGTYPE_DOC"));
        } else if (elemName.equals("SUNW_PKGVERS")) {
            this.docArea.setText(PackagingNewEntryPanel.getString("PACKAGING_SUNW_PKGVERS_DOC"));
        } else if (elemName.equals("SUNW_PRODNAME")) {
            this.docArea.setText(PackagingNewEntryPanel.getString("PACKAGING_SUNW_PRODNAME_DOC"));
        } else if (elemName.equals("SUNW_PRODVERS")) {
            this.docArea.setText(PackagingNewEntryPanel.getString("PACKAGING_SUNW_PRODVERS_DOC"));
        } else if (elemName.equals("ULIMIT")) {
            this.docArea.setText(PackagingNewEntryPanel.getString("PACKAGING_ULIMIT_DOC"));
        } else if (elemName.equals("VENDOR")) {
            this.docArea.setText(PackagingNewEntryPanel.getString("PACKAGING_VENDOR_DOC"));
        } else if (elemName.equals("VSTOCK")) {
            this.docArea.setText(PackagingNewEntryPanel.getString("PACKAGING_VSTOCK_DOC"));
        }
    }

    public PackagerInfoElement getInfoElement() {
        String name = (String)this.entryComboBox.getSelectedItem();
        String value = this.entryValueTextArea.getText();
        StringBuilder sb = new StringBuilder();
        StringTokenizer tokennizer = new StringTokenizer(value, "\n");
        while (tokennizer.hasMoreTokens()) {
            sb.append(tokennizer.nextToken());
            if (!tokennizer.hasMoreTokens()) continue;
            sb.append("\\n");
        }
        return new PackagerInfoElement(this.packagingConfiguration.getType().getValue(), name, sb.toString());
    }

    private static String getString(String s) {
        if (bundle == null) {
            bundle = NbBundle.getBundle(PackagingNewEntryPanel.class);
        }
        return bundle.getString(s);
    }
}

