/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.configurations;

import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.makeproject.SmartOutputStream;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCCCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.ItemConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.LibraryItem;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.VectorConfiguration;
import org.netbeans.modules.cnd.makeproject.configurations.ConfigurationMakefileWriter;
import org.netbeans.modules.cnd.makeproject.configurations.CppUtils;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.FSPath;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class QmakeProjectWriter {
    private static final String PROJECT_PREFIX = "nbproject/qt-";
    private static final String PROJECT_SUFFIX = ".pro";
    private final MakeConfigurationDescriptor projectDescriptor;
    private final MakeConfiguration configuration;

    public QmakeProjectWriter(MakeConfigurationDescriptor projectDescriptor, MakeConfiguration configuration) {
        this.projectDescriptor = projectDescriptor;
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write() throws IOException {
        if (this.configuration.isQmakeConfiguration()) {
            FSPath baseFSPath = this.configuration.getBaseFSPath();
            FileObject confBaseFO = baseFSPath.getFileObject();
            if (confBaseFO == null) {
                throw new FileNotFoundException("FileObject not found: " + baseFSPath);
            }
            FileObject qmakeProjectFO = FileUtil.createData((FileObject)confBaseFO, (String)(PROJECT_PREFIX + this.configuration.getName() + PROJECT_SUFFIX));
            BufferedWriter bw = null;
            try {
                bw = new BufferedWriter(new OutputStreamWriter(SmartOutputStream.getSmartOutputStream(qmakeProjectFO)));
                this.write(bw);
            }
            finally {
                if (bw != null) {
                    bw.close();
                }
            }
        }
    }

    private void write(BufferedWriter bw) throws IOException {
        bw.write("# This file is generated automatically. Do not edit.\n");
        bw.write("# Use project properties -> Build -> Qt -> Expert -> Custom Definitions.\n");
        this.write(bw, Variable.TEMPLATE, Operation.SET, this.getTemplate());
        this.write(bw, Variable.DESTDIR, Operation.SET, this.expandAndQuote(this.configuration.getQmakeConfiguration().getDestdirValue()));
        this.write(bw, Variable.TARGET, Operation.SET, this.expandAndQuote(this.configuration.getQmakeConfiguration().getTargetValue()));
        this.write(bw, Variable.VERSION, Operation.SET, this.expandAndQuote(this.configuration.getQmakeConfiguration().getVersion().getValue()));
        this.write(bw, Variable.CONFIG, Operation.SUB, "debug_and_release app_bundle lib_bundle");
        this.write(bw, Variable.CONFIG, Operation.ADD, this.getConfig());
        this.write(bw, Variable.QT, Operation.SET, this.configuration.getQmakeConfiguration().getEnabledModules());
        Item[] items = this.projectDescriptor.getProjectItems();
        this.write(bw, Variable.SOURCES, Operation.ADD, this.getItems(items, "text/x-c", "text/x-c++"));
        this.write(bw, Variable.HEADERS, Operation.ADD, this.getItems(items, "text/x-h"));
        this.write(bw, Variable.FORMS, Operation.ADD, this.getItems(items, "text/qtui+xml"));
        this.write(bw, Variable.RESOURCES, Operation.ADD, this.getItems(items, "text/qtresource+xml"));
        this.write(bw, Variable.TRANSLATIONS, Operation.ADD, this.getItems(items, "text/qttranslation+xml"));
        this.write(bw, Variable.OBJECTS_DIR, Operation.SET, this.expandAndQuote(ConfigurationMakefileWriter.getObjectDir(this.configuration)));
        this.write(bw, Variable.MOC_DIR, Operation.SET, this.expandAndQuote(this.configuration.getQmakeConfiguration().getMocDir().getValue()));
        this.write(bw, Variable.RCC_DIR, Operation.SET, this.expandAndQuote(this.configuration.getQmakeConfiguration().getRccDir().getValue()));
        this.write(bw, Variable.UI_DIR, Operation.SET, this.expandAndQuote(this.configuration.getQmakeConfiguration().getUiDir().getValue()));
        this.write(bw, Variable.QMAKE_CC, Operation.SET, ConfigurationMakefileWriter.getCompilerName(this.configuration, PredefinedToolKind.CCompiler));
        this.write(bw, Variable.QMAKE_CXX, Operation.SET, ConfigurationMakefileWriter.getCompilerName(this.configuration, PredefinedToolKind.CCCompiler));
        CompilerSet compilerSet = this.configuration.getCompilerSet().getCompilerSet();
        CCCCompilerConfiguration.OptionToString defineVisitor = new CCCCompilerConfiguration.OptionToString(compilerSet, null);
        this.write(bw, Variable.DEFINES, Operation.ADD, this.configuration.getCCCompilerConfiguration().getPreprocessorConfiguration().toString(defineVisitor));
        IncludeToString includeVisitor = new IncludeToString(compilerSet);
        this.write(bw, Variable.INCLUDEPATH, Operation.ADD, this.configuration.getCCCompilerConfiguration().getIncludeDirectories().toString(includeVisitor));
        this.write(bw, Variable.LIBS, Operation.ADD, this.getLibs());
        for (String line : this.configuration.getQmakeConfiguration().getCustomDefs().getValue()) {
            bw.write(line);
            bw.write(10);
        }
    }

    private void write(BufferedWriter bw, Variable var, Operation op, String value) throws IOException {
        bw.write(var.toString());
        bw.write(32);
        bw.write(op.getOp());
        bw.write(32);
        bw.write(value);
        bw.write(10);
    }

    private void write(BufferedWriter bw, Variable var, Operation op, List<String> values) throws IOException {
        bw.write(var.toString());
        bw.write(32);
        bw.write(op.getOp());
        for (String value : values) {
            bw.write(32);
            bw.write(value);
        }
        bw.write(10);
    }

    private List<String> getItems(Item[] items, String ... mimeTypes) {
        ArrayList<String> list = new ArrayList<String>();
        block0: for (Item item : items) {
            FileObject fo;
            ItemConfiguration itemConf = item.getItemConfiguration(this.configuration);
            if (itemConf.getExcluded().getValue() || (fo = item.getFileObject()) == null) continue;
            String actualMimeType = fo.getMIMEType();
            for (String mimeType : mimeTypes) {
                if (!mimeType.equals(actualMimeType)) continue;
                list.add(CndPathUtilitities.quoteIfNecessary((String)item.getPath()));
                continue block0;
            }
        }
        return list;
    }

    private String getTemplate() {
        switch (this.configuration.getConfigurationType().getValue()) {
            case 4: {
                return "app";
            }
            case 5: 
            case 6: {
                return "lib";
            }
        }
        return "";
    }

    private List<String> getConfig() {
        ArrayList<String> list = new ArrayList<String>();
        switch (this.configuration.getConfigurationType().getValue()) {
            case 5: {
                list.add("dll");
                break;
            }
            case 6: {
                list.add("staticlib");
            }
        }
        list.add(this.configuration.getQmakeConfiguration().getBuildMode().getOption());
        return list;
    }

    private String getLibs() {
        StringBuilder buf = new StringBuilder();
        CompilerSet compilerSet = this.configuration.getCompilerSet().getCompilerSet();
        LibraryToString libVisitor = new LibraryToString(compilerSet);
        buf.append(this.configuration.getLinkerConfiguration().getLibrariesConfiguration().toString(libVisitor));
        if (compilerSet != null) {
            if (0 < buf.length()) {
                buf.append(' ');
            }
            CCCCompilerConfiguration.OptionToString dynamicSearchVisitor = new CCCCompilerConfiguration.OptionToString(compilerSet, compilerSet.getCompilerFlavor().getToolchainDescriptor().getLinker().getDynamicLibrarySearchFlag());
            buf.append(this.configuration.getLinkerConfiguration().getDynamicSearch().toString(dynamicSearchVisitor));
        }
        return buf.toString();
    }

    private String expandAndQuote(String s) {
        return CndPathUtilitities.quoteIfNecessary((String)this.configuration.expandMacros(s));
    }

    private static class IncludeToString
    implements VectorConfiguration.ToString<String> {
        private final CompilerSet compilerSet;

        public IncludeToString(CompilerSet compilerSet) {
            this.compilerSet = compilerSet;
        }

        @Override
        public String toString(String item) {
            if (0 < item.length()) {
                if (this.compilerSet != null) {
                    item = CppUtils.normalizeDriveLetter(this.compilerSet, item);
                }
                return CndPathUtilitities.quoteIfNecessary((String)item);
            }
            return "";
        }
    }

    private static class LibraryToString
    implements VectorConfiguration.ToString<LibraryItem> {
        private final CompilerSet compilerSet;

        public LibraryToString(CompilerSet compilerSet) {
            this.compilerSet = compilerSet;
        }

        @Override
        public String toString(LibraryItem item) {
            switch (item.getType()) {
                case 0: 
                case 3: {
                    return this.libFileToOptionsString(item.getPath());
                }
                case 1: 
                case 2: 
                case 4: {
                    return item.getOption(null);
                }
            }
            return "";
        }

        private String libFileToOptionsString(String path) {
            StringBuilder buf = new StringBuilder();
            if (this.compilerSet != null && this.isDynamicLib(path)) {
                String searchOption = this.compilerSet.getCompilerFlavor().getToolchainDescriptor().getLinker().getDynamicLibrarySearchFlag();
                if (searchOption.length() == 0) {
                    searchOption = this.compilerSet.getCompilerFlavor().getToolchainDescriptor().getLinker().getLibrarySearchFlag();
                }
                buf.append(searchOption);
                String dirName = CndPathUtilitities.getDirName((String)path);
                if (dirName != null && dirName.length() > 0) {
                    buf.append(CndPathUtilitities.quoteIfNecessary((String)dirName));
                    buf.append(' ');
                }
            }
            buf.append(CndPathUtilitities.quoteIfNecessary((String)path));
            return buf.toString();
        }

        private boolean isDynamicLib(String path) {
            return path.endsWith(".dll") || path.endsWith(".dylib") || path.endsWith(".so") || 0 <= path.indexOf(".so.");
        }
    }

    private static enum Operation {
        SET("="),
        ADD("+="),
        SUB("-=");

        private final String op;

        private Operation(String op) {
            this.op = op;
        }

        public String getOp() {
            return this.op;
        }
    }

    private static enum Variable {
        TEMPLATE,
        DESTDIR,
        TARGET,
        VERSION,
        CONFIG,
        QT,
        SOURCES,
        HEADERS,
        FORMS,
        RESOURCES,
        TRANSLATIONS,
        DEFINES,
        INCLUDEPATH,
        LIBS,
        QMAKE_CC,
        QMAKE_CXX,
        MOC_DIR,
        RCC_DIR,
        UI_DIR,
        OBJECTS_DIR;

    }
}

