/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.configurations;

import java.io.IOException;
import java.io.OutputStream;
import org.netbeans.modules.cnd.api.xml.XMLDocWriter;
import org.netbeans.modules.cnd.api.xml.XMLEncoderStream;
import org.netbeans.modules.cnd.makeproject.SmartOutputStream;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.configurations.AuxConfigurationXMLCodec;
import org.netbeans.modules.cnd.makeproject.configurations.CommonConfigurationXMLCodec;
import org.netbeans.modules.cnd.makeproject.configurations.ConfigurationXMLCodec;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class ConfigurationXMLWriter
extends XMLDocWriter {
    private FileObject projectDirectory;
    private MakeConfigurationDescriptor projectDescriptor;
    private CommonConfigurationXMLCodec encoder;

    public ConfigurationXMLWriter(FileObject projectDirectory, MakeConfigurationDescriptor projectDescriptor) {
        this.projectDirectory = projectDirectory;
        this.projectDescriptor = projectDescriptor;
    }

    public void write() throws IOException {
        if (this.projectDescriptor == null) {
            return;
        }
        String tag = "configurationDescriptor";
        this.encoder = new ConfigurationXMLCodec(tag, null, this.projectDescriptor, null);
        assert (this.projectDescriptor.getState() != ConfigurationDescriptor.State.READING);
        this.write("nbproject/configurations.xml");
        this.encoder = new AuxConfigurationXMLCodec(tag, this.projectDescriptor);
        this.write("nbproject/private/configurations.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(String relPath) throws IOException {
        FileObject xml = FileUtil.createData((FileObject)this.projectDirectory, (String)relPath);
        try {
            FileLock lock = xml.lock();
            try {
                OutputStream os = SmartOutputStream.getSmartOutputStream(xml, lock);
                this.write(os);
            }
            finally {
                lock.releaseLock();
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void encode(XMLEncoderStream xes) {
        this.encoder.encode(xes);
    }
}

