/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.remote.RemoteFileUtil;
import org.netbeans.modules.cnd.api.toolchain.ui.ToolsPanelSupport;
import org.netbeans.modules.cnd.api.utils.CndFileVisibilityQuery;
import org.netbeans.modules.cnd.api.utils.CndVisibilityQuery;
import org.netbeans.modules.cnd.makeproject.FullRemoteExtension;
import org.netbeans.modules.cnd.makeproject.MakeOptions;
import org.netbeans.modules.cnd.makeproject.MakeProject;
import org.netbeans.modules.cnd.makeproject.MakeProjectUtils;
import org.netbeans.modules.cnd.makeproject.MakeSources;
import org.netbeans.modules.cnd.makeproject.NativeProjectProvider;
import org.netbeans.modules.cnd.makeproject.api.MakeProjectOptions;
import org.netbeans.modules.cnd.makeproject.api.ProjectSupport;
import org.netbeans.modules.cnd.makeproject.api.SourceFolderInfo;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationAuxObject;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configurations;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.ItemConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.LibrariesConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.LibraryItem;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.support.MakeProjectHelper;
import org.netbeans.modules.cnd.makeproject.configurations.ConfigurationMakefileWriter;
import org.netbeans.modules.cnd.makeproject.configurations.ConfigurationXMLWriter;
import org.netbeans.modules.cnd.makeproject.configurations.CppUtils;
import org.netbeans.modules.cnd.makeproject.ui.MakeLogicalViewProvider;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.cnd.utils.FileObjectFilter;
import org.netbeans.modules.cnd.utils.MIMEExtensions;
import org.netbeans.modules.cnd.utils.ui.ModalMessageDlg;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class MakeConfigurationDescriptor
extends ConfigurationDescriptor
implements ChangeListener {
    public static final String EXTERNAL_FILES_FOLDER = "ExternalFiles";
    public static final String TEST_FILES_FOLDER = "TestFiles";
    public static final String SOURCE_FILES_FOLDER = "SourceFiles";
    public static final String HEADER_FILES_FOLDER = "HeaderFiles";
    public static final String RESOURCE_FILES_FOLDER = "ResourceFiles";
    public static final String ICONBASE = "org/netbeans/modules/cnd/makeproject/ui/resources/makeProject";
    public static final String ICON = "org/netbeans/modules/cnd/makeproject/ui/resources/makeProject.gif";
    public static final Icon MAKEFILE_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/cnd/makeproject/ui/resources/makeProject.gif", (boolean)false);
    public static final String DEFAULT_IGNORE_FOLDERS_PATTERN = "^(nbproject|build|test|tests)$";
    public static final String DEFAULT_IGNORE_FOLDERS_PATTERN_EXISTING_PROJECT = "^(nbproject)$";
    public static final String DEFAULT_NO_IGNORE_FOLDERS_PATTERN = "^$";
    private static final Logger LOGGER = Logger.getLogger("org.netbeans.modules.cnd.makeproject");
    private Project project = null;
    private final FileObject baseDirFO;
    private final FileSystem baseDirFS;
    private final FileObject projectDirFO;
    private boolean modified = false;
    private Folder externalFileItems = null;
    private Folder testItems = null;
    private Folder rootFolder = null;
    private Map<String, Item> projectItems = null;
    private final List<String> sourceRoots = new ArrayList<String>();
    private final List<String> testRoots = new ArrayList<String>();
    private final Set<ChangeListener> projectItemsChangeListeners = new HashSet<ChangeListener>();
    private volatile NativeProject nativeProject = null;
    public static final String DEFAULT_PROJECT_MAKFILE_NAME = "Makefile";
    private String projectMakefileName = "Makefile";
    private RequestProcessor.Task initTask = null;
    private CndVisibilityQuery folderVisibilityQuery = null;
    private static ConcurrentHashMap<String, Object> projectWriteLocks = new ConcurrentHashMap();

    public MakeConfigurationDescriptor(FileObject projectDirFO) {
        this(projectDirFO, projectDirFO);
    }

    public MakeConfigurationDescriptor(FileObject projectDirFO, FileObject baseDirFO) {
        Parameters.notNull((CharSequence)"projectDirFO", (Object)projectDirFO);
        Parameters.notNull((CharSequence)"baseDirFO", (Object)baseDirFO);
        this.baseDirFO = baseDirFO;
        try {
            this.baseDirFS = baseDirFO.getFileSystem();
        }
        catch (FileStateInvalidException ex) {
            throw new IllegalStateException("Exception when getting file system for project folder object", ex);
        }
        this.projectDirFO = projectDirFO;
        this.rootFolder = new Folder(this, null, "root", "root", true, Folder.Kind.ROOT);
        this.projectItems = new ConcurrentHashMap<String, Item>();
        this.setModified();
        ToolsPanelSupport.addCompilerSetModifiedListener((ChangeListener)this);
    }

    @Override
    public void closed() {
        ToolsPanelSupport.removeCompilerSetModifiedListener((ChangeListener)this);
        for (Item item : this.getProjectItems()) {
            item.onClose();
        }
        this.closed(this.rootFolder);
    }

    private void closed(Folder folder) {
        if (folder != null) {
            for (Folder f : folder.getAllFolders(false)) {
                f.detachListener();
            }
            folder.detachListener();
        }
    }

    public void clean() {
        Configurations confs = this.getConfs();
        if (confs != null) {
            for (Configuration conf : confs.toArray()) {
                if (conf == null) continue;
                conf.setAuxObjects(Collections.<ConfigurationAuxObject>emptyList());
            }
        }
        this.projectItems.clear();
        this.rootFolder = null;
    }

    public static MakeConfigurationDescriptor getMakeConfigurationDescriptor(Project project) {
        ConfigurationDescriptorProvider pdp = (ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class);
        if (pdp != null) {
            MakeConfigurationDescriptor makeConfigurationDescriptor = pdp.getConfigurationDescriptor();
            return makeConfigurationDescriptor;
        }
        return null;
    }

    public MakeConfiguration getActiveConfiguration() {
        Configurations confs = this.getConfs();
        if (confs != null) {
            MakeConfiguration conf = (MakeConfiguration)confs.getActive();
            if (conf == null) {
                LOGGER.log(Level.FINE, "There are no active configuration in the project descriptor MakeConfigurationDescriptor@{0} for project {1}", new Object[]{System.identityHashCode(this), this.getBaseDir()});
            }
            return conf;
        }
        LOGGER.log(Level.FINE, "There are no configurations in the project descriptor MakeConfigurationDescriptor@{0} for project {1}", new Object[]{System.identityHashCode(this), this.getBaseDir()});
        return null;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.setModified();
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public Project getProject() {
        if (this.project == null) {
            try {
                this.project = ProjectManager.getDefault().findProject(this.projectDirFO);
            }
            catch (Exception e) {
                System.err.println("Cannot find project in '" + this.projectDirFO + "' " + e);
            }
        }
        return this.project;
    }

    public void init(Configuration def) {
        super.init(new Configuration[]{def}, 0);
        this.setModified();
    }

    public void setInitTask(RequestProcessor.Task task) {
        this.initTask = task;
    }

    synchronized void waitInitTask() {
        if (this.initTask == null) {
            return;
        }
        this.initTask.waitFinished();
        this.initTask = null;
    }

    public void initLogicalFolders(Iterator<SourceFolderInfo> sourceFileFolders, boolean createLogicalFolders, Iterator<SourceFolderInfo> testFileFolders, Iterator<String> importantItems, String mainFilePath, boolean addGeneratedMakefileToLogicalView) {
        SourceFolderInfo sourceFolderInfo;
        Folder srcFolder;
        if (createLogicalFolders) {
            this.rootFolder.addNewFolder(SOURCE_FILES_FOLDER, MakeConfigurationDescriptor.getString("SourceFilesTxt"), true, Folder.Kind.SOURCE_LOGICAL_FOLDER);
            this.rootFolder.addNewFolder(HEADER_FILES_FOLDER, MakeConfigurationDescriptor.getString("HeaderFilesTxt"), true, Folder.Kind.SOURCE_LOGICAL_FOLDER);
            this.rootFolder.addNewFolder(RESOURCE_FILES_FOLDER, MakeConfigurationDescriptor.getString("ResourceFilesTxt"), true, Folder.Kind.SOURCE_LOGICAL_FOLDER);
            this.testItems = this.rootFolder.addNewFolder(TEST_FILES_FOLDER, MakeConfigurationDescriptor.getString("TestsFilesTxt"), false, Folder.Kind.TEST_LOGICAL_FOLDER);
        }
        this.externalFileItems = this.rootFolder.addNewFolder(EXTERNAL_FILES_FOLDER, MakeConfigurationDescriptor.getString("ImportantFilesTxt"), false, Folder.Kind.IMPORTANT_FILES_FOLDER);
        if (!addGeneratedMakefileToLogicalView && !this.getProjectMakefileName().isEmpty()) {
            this.externalFileItems.addItem(Item.createInFileSystem(this.baseDirFS, this.getProjectMakefileName()));
        }
        if (importantItems != null) {
            while (importantItems.hasNext()) {
                this.externalFileItems.addItem(Item.createInFileSystem(this.baseDirFS, importantItems.next()));
            }
        }
        if (mainFilePath != null && (srcFolder = this.rootFolder.findFolderByName(SOURCE_FILES_FOLDER)) != null) {
            srcFolder.addItem(Item.createInFileSystem(this.baseDirFS, mainFilePath));
        }
        if (testFileFolders != null) {
            while (testFileFolders.hasNext()) {
                sourceFolderInfo = testFileFolders.next();
                this.addTestRoot(sourceFolderInfo.getFolderName());
            }
        }
        if (sourceFileFolders != null) {
            while (sourceFileFolders.hasNext()) {
                sourceFolderInfo = sourceFileFolders.next();
                this.addFilesFromRoot(this.getLogicalFolders(), sourceFolderInfo.getFileObject(), false, Folder.Kind.SOURCE_DISK_FOLDER, null);
            }
        }
        this.setModified();
    }

    public String getProjectMakefileName() {
        return this.projectMakefileName;
    }

    public void setProjectMakefileName(String projectMakefileName) {
        CndUtils.assertNotNull((Object)projectMakefileName, (String)"project makefile name should not be null");
        this.projectMakefileName = projectMakefileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void addProjectItemsChangeListener(ChangeListener cl) {
        Set<ChangeListener> set = this.projectItemsChangeListeners;
        synchronized (set) {
            this.projectItemsChangeListeners.add(cl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void removeProjectItemsChangeListener(ChangeListener cl) {
        Set<ChangeListener> set = this.projectItemsChangeListeners;
        synchronized (set) {
            this.projectItemsChangeListeners.remove(cl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireProjectItemsChangeEvent(Item item, int action) {
        Iterator<ChangeListener> it;
        Set<ChangeListener> set = this.projectItemsChangeListeners;
        synchronized (set) {
            it = new HashSet<ChangeListener>(this.projectItemsChangeListeners).iterator();
        }
        ProjectItemChangeEvent ev = new ProjectItemChangeEvent(this, item, action);
        while (it.hasNext()) {
            it.next().stateChanged(ev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ChangeListener> getProjectItemsChangeListeners() {
        Set<ChangeListener> set = this.projectItemsChangeListeners;
        synchronized (set) {
            return new HashSet<ChangeListener>(this.projectItemsChangeListeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProjectItemsChangeListeners(Set<ChangeListener> newChangeListeners) {
        Set<ChangeListener> set = this.projectItemsChangeListeners;
        synchronized (set) {
            this.projectItemsChangeListeners.clear();
            this.projectItemsChangeListeners.addAll(newChangeListeners);
        }
    }

    @Override
    public String getBaseDir() {
        return this.baseDirFO.getPath();
    }

    public FileObject getBaseDirFileObject() {
        return this.baseDirFO;
    }

    public FileSystem getBaseDirFileSystem() {
        return this.baseDirFS;
    }

    public String getProjectDir() {
        return this.projectDirFO.getPath();
    }

    public FileObject getProjectDirFileObject() {
        return this.projectDirFO;
    }

    public FileObject getNbprojectFileObject() {
        if (this.projectDirFO != null) {
            try {
                return FileUtil.createFolder((FileObject)this.projectDirFO, (String)"nbproject");
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return null;
    }

    public FileObject getNbPrivateProjectFileObject() {
        if (this.projectDirFO != null) {
            try {
                return FileUtil.createFolder((FileObject)this.projectDirFO, (String)"nbproject/private");
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return null;
    }

    public Map<String, Item> getProjectItemsMap() {
        return this.projectItems;
    }

    public void setProjectItemsMap(Map<String, Item> projectItems) {
        this.projectItems = projectItems;
    }

    public void init(Configuration[] confs) {
        super.init(confs, 0);
    }

    @Override
    public Icon getIcon() {
        return MAKEFILE_ICON;
    }

    @Override
    public Configuration defaultConf(String name, int type) {
        ExecutionEnvironment sourceHost;
        String defaultHost = CppUtils.getDefaultDevelopmentHost();
        Project proj = this.getProject();
        if (proj != null && (sourceHost = MakeProjectUtils.getSourceFileSystemHost(this.project)).isRemote()) {
            defaultHost = ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)sourceHost);
        }
        MakeConfiguration c = new MakeConfiguration(FSPath.toFSPath((FileObject)this.baseDirFO), name, type, defaultHost);
        Item[] items = this.getProjectItems();
        for (int i = 0; i < items.length; ++i) {
            c.addAuxObject(new ItemConfiguration(c, items[i]));
        }
        return c;
    }

    public void setExternalFileItems(List<String> items) {
        this.externalFileItems.reset();
        for (String s : items) {
            this.externalFileItems.addItem(Item.createInFileSystem(this.baseDirFS, s));
        }
    }

    public void setExternalFileItems(Folder folder) {
        this.externalFileItems = folder;
    }

    public Folder getExternalFileItems() {
        return this.externalFileItems;
    }

    public Item[] getExternalFileItemsAsArray() {
        return this.externalFileItems.getItemsAsArray();
    }

    public Folder getExternalItemFolder() {
        return this.externalFileItems;
    }

    public Folder getLogicalFolders() {
        return this.rootFolder;
    }

    public void setLogicalFolders(Folder logicalFolders) {
        this.rootFolder = logicalFolders;
    }

    public Item[] getProjectItems() {
        ArrayList<Item> res = new ArrayList<Item>(this.projectItems.values());
        return res.toArray(new Item[res.size()]);
    }

    public Item findItemByPathSlowly(String path) {
        Collection<Item> coll = this.projectItems.values();
        Iterator<Item> it = coll.iterator();
        Item canonicalItem = null;
        while (it.hasNext()) {
            Item item = it.next();
            if (item.getNormalizedPath().equals(path)) {
                return item;
            }
            if (canonicalItem != null || !item.getCanonicalPath().equals(path)) continue;
            canonicalItem = item;
        }
        return canonicalItem;
    }

    public Item findItemByFileObject(FileObject fileObject) {
        return this.findProjectItemByPath(fileObject.getPath());
    }

    public Item findProjectItemByPath(String path) {
        Item item = this.projectItems.get(path = CndPathUtilitities.normalizeSlashes((String)path));
        if (item == null) {
            String newPath = CndPathUtilitities.isPathAbsolute((CharSequence)path) ? CndPathUtilitities.toRelativePath((String)this.getBaseDir(), (String)CndPathUtilitities.naturalizeSlashes((String)path)) : CndPathUtilitities.toAbsolutePath((String)this.getBaseDir(), (String)path);
            newPath = CndPathUtilitities.normalizeSlashes((String)newPath);
            item = this.projectItems.get(newPath);
        }
        return item;
    }

    public Item findExternalItemByPath(String path) {
        if (this.externalFileItems == null) {
            return null;
        }
        Item item = this.externalFileItems.findItemByPath(path = CndPathUtilitities.normalizeSlashes((String)path));
        if (item == null) {
            String newPath = CndPathUtilitities.isPathAbsolute((CharSequence)path) ? CndPathUtilitities.toRelativePath((String)this.getBaseDir(), (String)CndPathUtilitities.naturalizeSlashes((String)path)) : CndPathUtilitities.toAbsolutePath((String)this.getBaseDir(), (String)path);
            newPath = CndPathUtilitities.normalizeSlashes((String)newPath);
            item = this.externalFileItems.findItemByPath(newPath);
        }
        return item;
    }

    public Folder findFolderByPath(String path) {
        return this.getLogicalFolders().findFolderByPath(path);
    }

    public void addProjectItem(Item item) {
        this.projectItems.put(item.getPath(), item);
        this.fireProjectItemsChangeEvent(item, 0);
    }

    public void fireFilesAdded(List<NativeFileItem> fileItems) {
        if (this.getNativeProject() != null) {
            this.getNativeProject().fireFilesAdded(fileItems);
        }
    }

    public void removeProjectItem(Item item) {
        this.projectItems.remove(item.getPath());
        this.fireProjectItemsChangeEvent(item, 1);
    }

    public void fireFilesRemoved(List<NativeFileItem> fileItems) {
        if (this.getNativeProject() != null) {
            this.getNativeProject().fireFilesRemoved(fileItems);
        }
    }

    public void fireFileRenamed(String oldPath, NativeFileItem newFileItem) {
        if (this.getNativeProject() != null) {
            this.getNativeProject().fireFileRenamed(oldPath, newFileItem);
        }
    }

    public void checkForChangedItems(Project project, Folder folder, Item item) {
        if (this.getNativeProject() != null) {
            this.getNativeProject().checkForChangedItems(folder, item);
        }
        MakeLogicalViewProvider.checkForChangedViewItemNodes(project, folder, item);
    }

    public void checkForChangedItems(ConfigurationDescriptorProvider.Delta delta) {
        if (this.getNativeProject() != null) {
            this.getNativeProject().checkForChangedItems(delta);
        }
        MakeLogicalViewProvider.checkForChangedViewItemNodes(this.project, delta);
    }

    @Override
    public void copyFromProjectDescriptor(ConfigurationDescriptor copyProjectDescriptor) {
        MakeConfigurationDescriptor copyExtProjectDescriptor = (MakeConfigurationDescriptor)copyProjectDescriptor;
        this.setConfs(copyExtProjectDescriptor.getConfs());
        this.setProjectMakefileName(copyExtProjectDescriptor.getProjectMakefileName());
        this.setExternalFileItems(copyExtProjectDescriptor.getExternalFileItems());
        this.setLogicalFolders(copyExtProjectDescriptor.getLogicalFolders());
        this.setProjectItemsMap(((MakeConfigurationDescriptor)copyProjectDescriptor).getProjectItemsMap());
        this.setProjectItemsChangeListeners(((MakeConfigurationDescriptor)copyProjectDescriptor).getProjectItemsChangeListeners());
        this.setSourceRoots(((MakeConfigurationDescriptor)copyProjectDescriptor).getSourceRootsRaw());
    }

    @Override
    public void assign(ConfigurationDescriptor clonedConfigurationDescriptor) {
        Configuration[] clonedConfs = clonedConfigurationDescriptor.getConfs().toArray();
        Configuration[] newConfs = new Configuration[clonedConfs.length];
        for (int i = 0; i < clonedConfs.length; ++i) {
            if (clonedConfs[i].getCloneOf() != null) {
                clonedConfs[i].getCloneOf().assign(clonedConfs[i]);
                newConfs[i] = clonedConfs[i].getCloneOf();
                continue;
            }
            newConfs[i] = clonedConfs[i];
        }
        this.init(newConfs, clonedConfigurationDescriptor.getConfs().getActiveAsIndex());
        this.setProjectMakefileName(((MakeConfigurationDescriptor)clonedConfigurationDescriptor).getProjectMakefileName());
        this.setExternalFileItems(((MakeConfigurationDescriptor)clonedConfigurationDescriptor).getExternalFileItems());
        this.setLogicalFolders(((MakeConfigurationDescriptor)clonedConfigurationDescriptor).getLogicalFolders());
        this.setProjectItemsMap(((MakeConfigurationDescriptor)clonedConfigurationDescriptor).getProjectItemsMap());
        this.setProjectItemsChangeListeners(((MakeConfigurationDescriptor)clonedConfigurationDescriptor).getProjectItemsChangeListeners());
        this.setSourceRoots(((MakeConfigurationDescriptor)clonedConfigurationDescriptor).getSourceRootsRaw());
        this.setTestRoots(((MakeConfigurationDescriptor)clonedConfigurationDescriptor).getTestRootsRaw());
        this.setFolderVisibilityQuery(((MakeConfigurationDescriptor)clonedConfigurationDescriptor).getFolderVisibilityQuery().getRegEx());
    }

    @Override
    public ConfigurationDescriptor cloneProjectDescriptor() {
        MakeConfigurationDescriptor clone = new MakeConfigurationDescriptor(this.getProjectDirFileObject(), this.getBaseDirFileObject());
        super.cloneProjectDescriptor(clone);
        clone.setProjectMakefileName(this.getProjectMakefileName());
        clone.setExternalFileItems(this.getExternalFileItems());
        clone.setLogicalFolders(this.getLogicalFolders());
        clone.setProjectItemsMap(this.getProjectItemsMap());
        clone.setProjectItemsChangeListeners(this.getProjectItemsChangeListeners());
        clone.setSourceRoots(this.getSourceRootsRaw());
        clone.setTestRoots(this.getTestRootsRaw());
        clone.setFolderVisibilityQuery(this.getFolderVisibilityQuery().getRegEx());
        return clone;
    }

    @Deprecated
    public boolean getModified() {
        return this.isModified();
    }

    @Override
    public boolean isModified() {
        return this.modified;
    }

    @Override
    public final void setModified() {
        this.setModified(true);
    }

    public void setModified(boolean modified) {
        this.modified = modified;
        if (modified && this.getConfs() != null) {
            Configuration[] confs = this.getConfs().toArray();
            for (int i = 0; i < confs.length; ++i) {
                ((MakeConfiguration)confs[i]).setRequiredLanguagesDirty(true);
            }
        }
    }

    public void refreshRequiredLanguages() {
        if (this.getConfs() != null) {
            Configuration[] confs = this.getConfs().toArray();
            for (int i = 0; i < confs.length; ++i) {
                ((MakeConfiguration)confs[i]).reCountLanguages(this);
            }
        }
    }

    public void saveAndClose() {
        this.save();
        this.closed();
    }

    @Override
    public boolean save() {
        return this.save(NbBundle.getMessage(MakeProject.class, (String)"ProjectNotSaved"));
    }

    @Override
    public boolean save(String extraMessage) {
        SaveRunnable saveRunnable = new SaveRunnable(extraMessage);
        if (SwingUtilities.isEventDispatchThread() && WindowManager.getDefault().getMainWindow().isVisible()) {
            ModalMessageDlg.runLongTask((Frame)WindowManager.getDefault().getMainWindow(), (Runnable)saveRunnable, null, null, (String)MakeConfigurationDescriptor.getString("MakeConfigurationDescriptor.SaveConfigurationTitle"), (String)MakeConfigurationDescriptor.getString("MakeConfigurationDescriptor.SaveConfigurationText"));
        } else {
            saveRunnable.run();
        }
        return saveRunnable.ret;
    }

    public boolean addAdditionalHeaderExtensions(Collection<String> needAdd) {
        return ((MakeProject)this.getProject()).addAdditionalHeaderExtensions(needAdd);
    }

    public CndVisibilityQuery getFolderVisibilityQuery() {
        if (this.folderVisibilityQuery == null) {
            this.folderVisibilityQuery = new CndVisibilityQuery(DEFAULT_IGNORE_FOLDERS_PATTERN);
        }
        return this.folderVisibilityQuery;
    }

    public void setFolderVisibilityQuery(String regex) {
        if (this.folderVisibilityQuery == null) {
            this.folderVisibilityQuery = new CndVisibilityQuery(regex);
        } else {
            this.folderVisibilityQuery.setPattern(regex);
        }
    }

    private static Object getWriteLock(Project project) {
        Object lock = new Object();
        Object oldLock = projectWriteLocks.putIfAbsent(project.getProjectDirectory().getPath(), lock);
        return oldLock == null ? lock : oldLock;
    }

    private boolean saveWorker(String extraMessage) {
        if (this.getState() != ConfigurationDescriptor.State.READY) {
            return false;
        }
        Configuration[] configurations = this.getConfs().toArray();
        for (int i = 0; i < configurations.length; ++i) {
            Configuration conf = configurations[i];
            ConfigurationAuxObject[] auxObjects = conf.getAuxObjects();
            for (int j = 0; j < auxObjects.length; ++j) {
                if (auxObjects[j].hasChanged()) {
                    this.setModified();
                }
                auxObjects[j].clearChanged();
            }
        }
        this.updateExtensionList();
        if (!this.isModified()) {
            new ConfigurationMakefileWriter(this).write();
            this.ConfigurationPrivateXMLWriter();
            this.saveProject();
            return true;
        }
        ArrayList<String> notOkFiles = new ArrayList<String>();
        FileObject[] metadataFileObjects = new FileObject[]{this.getBaseDirFileObject().getFileObject("nbproject"), this.getBaseDirFileObject().getFileObject("nbproject/private")};
        boolean allOk = true;
        for (FileObject file : metadataFileObjects) {
            if (file == null || !file.isValid() || file.canWrite()) continue;
            allOk = false;
            notOkFiles.add(FileUtil.getFileDisplayName((FileObject)file));
        }
        if (!allOk) {
            String projectName = CndPathUtilitities.getBaseName((String)this.getBaseDir());
            StringBuilder text = new StringBuilder();
            text.append(MakeConfigurationDescriptor.getString("CannotSaveTxt", projectName));
            for (int i = 0; i < notOkFiles.size(); ++i) {
                text.append("\n").append((String)notOkFiles.get(i));
            }
            if (extraMessage != null) {
                text.append("\n\n").append(extraMessage);
            }
            NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)text, 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
            return allOk;
        }
        FileObject fo = null;
        fo = this.getProjectDirFileObject();
        if (fo != null) {
            LOGGER.log(Level.FINE, "Start of writting project descriptor MakeConfigurationDescriptor@{0} for project {1} @{2}", new Object[]{System.identityHashCode(this), fo.getName(), System.identityHashCode(this.project)});
            try {
                new ConfigurationXMLWriter(fo, this).write();
            }
            catch (IOException ex) {
                LOGGER.log(Level.INFO, "Error writing configuration", ex);
            }
            new ConfigurationMakefileWriter(this).write();
            this.ConfigurationProjectXMLWriter();
            this.ConfigurationPrivateXMLWriter();
            this.saveProject();
            LOGGER.log(Level.FINE, "End of writting project descriptor MakeConfigurationDescriptor@{0} for project {1} @{2}", new Object[]{System.identityHashCode(this), fo.getName(), System.identityHashCode(this.project)});
        }
        this.setModified(false);
        return allOk;
    }

    private void ConfigurationProjectXMLWriter() {
        if (this.getProject() == null) {
            return;
        }
        MakeProjectHelper helper = ((MakeProject)this.getProject()).getMakeProjectHelper();
        Element data = helper.getPrimaryConfigurationData(true);
        Document doc = data.getOwnerDocument();
        NodeList nodeList = data.getElementsByTagName("make-dep-projects");
        if (nodeList != null && nodeList.getLength() > 0) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                data.removeChild(node);
            }
        }
        Element element = doc.createElementNS("http://www.netbeans.org/ns/make-project/1", "make-dep-projects");
        Set<String> subprojectLocations = this.getSubprojectLocations();
        for (String loc : subprojectLocations) {
            Element n1 = doc.createElement("make-dep-project");
            n1.appendChild(doc.createTextNode(loc));
            element.appendChild(n1);
        }
        data.appendChild(element);
        nodeList = data.getElementsByTagName("sourceRootList");
        if (nodeList != null && nodeList.getLength() > 0) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                data.removeChild(node);
            }
        }
        element = doc.createElementNS("http://www.netbeans.org/ns/make-project/1", "sourceRootList");
        List<String> sourceRootist = this.getSourceRoots();
        for (String loc : sourceRootist) {
            Element n1 = doc.createElement("sourceRootElem");
            n1.appendChild(doc.createTextNode(loc));
            element.appendChild(n1);
        }
        data.appendChild(element);
        nodeList = data.getElementsByTagName("confList");
        if (nodeList != null && nodeList.getLength() > 0) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                data.removeChild(node);
            }
        }
        element = doc.createElementNS("http://www.netbeans.org/ns/make-project/1", "confList");
        for (Configuration conf : this.getConfs().getConfigurations()) {
            Element element2 = doc.createElementNS("http://www.netbeans.org/ns/make-project/1", "confElem");
            Element n1 = doc.createElement("name");
            n1.appendChild(doc.createTextNode(conf.getName()));
            element2.appendChild(n1);
            n1 = doc.createElement("type");
            n1.appendChild(doc.createTextNode("" + ((MakeConfiguration)conf).getConfigurationType().getValue()));
            element2.appendChild(n1);
            element.appendChild(element2);
        }
        data.appendChild(element);
        nodeList = data.getElementsByTagName("sourceEncoding");
        if (nodeList != null && nodeList.getLength() > 0) {
            Node node = nodeList.item(0);
            node.setTextContent(((MakeProject)this.getProject()).getSourceEncoding());
        } else {
            Element nativeProjectType = doc.createElementNS("http://www.netbeans.org/ns/make-project/1", "sourceEncoding");
            nativeProjectType.appendChild(doc.createTextNode(((MakeProject)this.getProject()).getSourceEncoding()));
            data.appendChild(nativeProjectType);
        }
        helper.putPrimaryConfigurationData(data, true);
    }

    private void ConfigurationPrivateXMLWriter() {
        Element elem;
        Node node;
        if (this.getProject() == null) {
            return;
        }
        MakeProjectHelper helper = ((MakeProject)this.getProject()).getMakeProjectHelper();
        Element data = helper.getPrimaryConfigurationData(false);
        Document doc = data.getOwnerDocument();
        NodeList nodeList = data.getElementsByTagName("activeConfTypeElem");
        if (nodeList != null && nodeList.getLength() > 0) {
            node = nodeList.item(0);
            node.setTextContent("" + ((MakeConfiguration)this.getConfs().getActive()).getConfigurationType().getValue());
        } else {
            elem = doc.createElementNS("http://www.netbeans.org/ns/make-project-private/1", "activeConfTypeElem");
            elem.appendChild(doc.createTextNode("" + ((MakeConfiguration)this.getConfs().getActive()).getConfigurationType().getValue()));
            data.appendChild(elem);
        }
        nodeList = data.getElementsByTagName("activeConfIndexElem");
        if (nodeList != null && nodeList.getLength() > 0) {
            node = nodeList.item(0);
            node.setTextContent("" + this.getConfs().getActiveAsIndex());
        } else {
            elem = doc.createElementNS("http://www.netbeans.org/ns/make-project-private/1", "activeConfIndexElem");
            elem.appendChild(doc.createTextNode("" + this.getConfs().getActiveAsIndex()));
            data.appendChild(elem);
        }
        helper.putPrimaryConfigurationData(data, false);
    }

    private void saveProject() {
        if (this.getProject() == null) {
            return;
        }
        try {
            ProjectManager.getDefault().saveProject(this.project);
        }
        catch (IOException ex) {
            Set<Map.Entry<Thread, StackTraceElement[]>> entrySet = Thread.getAllStackTraces().entrySet();
            ex.printStackTrace();
            System.err.println("----- Start thread dump on catching IOException-----");
            for (Map.Entry<Thread, StackTraceElement[]> entry : entrySet) {
                System.err.println(entry.getKey().getName());
                for (StackTraceElement element : entry.getValue()) {
                    System.err.println("\tat " + element.toString());
                }
                System.err.println();
            }
            System.err.println("-----End thread dump on catching IOException-----");
        }
    }

    private void updateExtensionList() {
        Set<String> h = MakeProject.createExtensionSet();
        Set<String> c = MakeProject.createExtensionSet();
        Set<String> cpp = MakeProject.createExtensionSet();
        for (Item item : this.getProjectItems()) {
            String itemName = item.getName();
            String ext = FileUtil.getExtension((String)itemName);
            if (ext.length() <= 0 || h.contains(ext) || c.contains(ext) || cpp.contains(ext)) continue;
            if (MIMEExtensions.isRegistered((String)"text/x-h", (String)ext)) {
                h.add(ext);
                continue;
            }
            if (MIMEExtensions.isRegistered((String)"text/x-c", (String)ext)) {
                c.add(ext);
                continue;
            }
            if (!MIMEExtensions.isRegistered((String)"text/x-c++", (String)ext)) continue;
            cpp.add(ext);
        }
        MakeProject makeProject = (MakeProject)this.getProject();
        if (makeProject != null) {
            makeProject.updateExtensions(c, cpp, h);
        }
    }

    public Set<String> getSubprojectLocations() {
        HashSet<String> subProjects = new HashSet<String>();
        Configuration[] confs = this.getConfs().toArray();
        for (int i = 0; i < confs.length; ++i) {
            MakeConfiguration makeConfiguration = (MakeConfiguration)confs[i];
            LibrariesConfiguration librariesConfiguration = null;
            if (((MakeConfiguration)confs[i]).isLinkerConfiguration()) {
                librariesConfiguration = makeConfiguration.getLinkerConfiguration().getLibrariesConfiguration();
                for (LibraryItem item : librariesConfiguration.getValue()) {
                    if (!(item instanceof LibraryItem.ProjectItem)) continue;
                    LibraryItem projectItem = item;
                    subProjects.add(((LibraryItem.ProjectItem)projectItem).getMakeArtifact().getProjectLocation());
                }
            }
            for (LibraryItem item : makeConfiguration.getRequiredProjectsConfiguration().getValue()) {
                subProjects.add(((LibraryItem.ProjectItem)item).getMakeArtifact().getProjectLocation());
            }
        }
        return subProjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSourceRootRaw(String path) {
        List<String> list = this.sourceRoots;
        synchronized (list) {
            this.sourceRoots.add(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTestRootRaw(String path) {
        List<String> list = this.testRoots;
        synchronized (list) {
            this.testRoots.add(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTestRoot(String path) {
        String absPath = CndPathUtilitities.toAbsolutePath((String)this.getBaseDir(), (String)path);
        String relPath = CndPathUtilitities.normalizeSlashes((String)CndPathUtilitities.toRelativePath((String)this.getBaseDir(), (String)path));
        boolean addPath = true;
        List<String> list = this.testRoots;
        synchronized (list) {
            if (addPath) {
                String usePath = ProjectSupport.getPathMode(this.project) == MakeProjectOptions.PathMode.REL_OR_ABS ? CndPathUtilitities.normalizeSlashes((String)CndPathUtilitities.toAbsoluteOrRelativePath((String)this.getBaseDir(), (String)path)) : (ProjectSupport.getPathMode(this.project) == MakeProjectOptions.PathMode.REL ? relPath : absPath);
                this.testRoots.add(usePath);
                this.setModified();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSourceRoot(String path) {
        String absPath = CndPathUtilitities.toAbsolutePath((FileObject)this.getBaseDirFileObject(), (String)path);
        String canonicalPath = null;
        try {
            canonicalPath = FileSystemProvider.getCanonicalPath((FileSystem)this.baseDirFS, (String)absPath);
        }
        catch (IOException ioe) {
            canonicalPath = null;
        }
        String relPath = CndPathUtilitities.normalizeSlashes((String)CndPathUtilitities.toRelativePath((String)this.getBaseDir(), (String)path));
        boolean addPath = true;
        ArrayList<String> toBeRemoved = new ArrayList<String>();
        List<String> list = this.sourceRoots;
        synchronized (list) {
            if (canonicalPath != null) {
                int canonicalPathLength = canonicalPath.length();
                for (String sourceRoot : this.sourceRoots) {
                    String absSourceRoot = CndPathUtilitities.toAbsolutePath((String)this.getBaseDir(), (String)sourceRoot);
                    String canonicalSourceRoot = null;
                    try {
                        canonicalSourceRoot = FileSystemProvider.getCanonicalPath((FileSystem)this.baseDirFS, (String)absSourceRoot);
                    }
                    catch (IOException ioe) {
                        canonicalSourceRoot = null;
                    }
                    if (canonicalSourceRoot == null) continue;
                    int canonicalSourceRootLength = canonicalSourceRoot.length();
                    if (canonicalSourceRoot.equals(canonicalPath)) {
                        addPath = false;
                        break;
                    }
                    if (canonicalSourceRoot.startsWith(canonicalPath) && canonicalSourceRoot.charAt(canonicalPathLength) == File.separatorChar) {
                        toBeRemoved.add(sourceRoot);
                        continue;
                    }
                    if (!canonicalPath.startsWith(canonicalSourceRoot) || canonicalPath.charAt(canonicalSourceRootLength) != File.separatorChar) continue;
                    addPath = false;
                    break;
                }
            }
            if (toBeRemoved.size() > 0) {
                for (String toRemove : toBeRemoved) {
                    this.sourceRoots.remove(toRemove);
                }
            }
            if (addPath) {
                String usePath = ProjectSupport.getPathMode(this.project) == MakeProjectOptions.PathMode.REL_OR_ABS ? CndPathUtilitities.normalizeSlashes((String)CndPathUtilitities.toAbsoluteOrRelativePath((String)this.getBaseDir(), (String)path)) : (ProjectSupport.getPathMode(this.project) == MakeProjectOptions.PathMode.REL ? relPath : absPath);
                this.sourceRoots.add(usePath);
                this.setModified();
            }
        }
        MakeSources makeSources = (MakeSources)this.getProject().getLookup().lookup(MakeSources.class);
        if (makeSources != null) {
            makeSources.sourceRootsChanged();
        }
    }

    private List<String> getSourceRootsRaw() {
        return this.sourceRoots;
    }

    private List<String> getTestRootsRaw() {
        return this.testRoots;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSourceRoots(List<String> list) {
        List<String> list2 = this.sourceRoots;
        synchronized (list2) {
            this.sourceRoots.clear();
            this.sourceRoots.addAll(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTestRoots(List<String> list) {
        List<String> list2 = this.testRoots;
        synchronized (list2) {
            this.testRoots.clear();
            this.testRoots.addAll(list);
        }
    }

    private boolean inList(List<String> list, String s) {
        for (String l : list) {
            if (!l.equals(s)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkForChangedSourceRoots(List<String> oldList, List<String> newList) {
        List<String> list = this.sourceRoots;
        synchronized (list) {
            MakeSources makeSources;
            this.sourceRoots.clear();
            for (String l : newList) {
                this.addSourceRoot(l);
            }
            MakeConfiguration active = (MakeConfiguration)this.getConfs().getActive();
            if (!active.isMakefileConfiguration()) {
                MakeSources makeSources2 = (MakeSources)this.getProject().getLookup().lookup(MakeSources.class);
                if (makeSources2 != null) {
                    makeSources2.sourceRootsChanged();
                }
                return;
            }
            ArrayList<String> toBeAdded = new ArrayList<String>();
            for (String s : this.sourceRoots) {
                if (this.inList(oldList, s)) continue;
                toBeAdded.add(s);
            }
            ArrayList<String> toBeRemoved = new ArrayList<String>();
            for (String s : oldList) {
                if (this.inList(this.sourceRoots, s)) continue;
                toBeRemoved.add(s);
            }
            if (toBeAdded.size() > 0) {
                for (String root : toBeAdded) {
                    FileObject fo = RemoteFileUtil.getFileObject((FileObject)this.baseDirFO, (String)root);
                    this.addFilesFromRoot(this.getLogicalFolders(), fo, true, Folder.Kind.SOURCE_DISK_FOLDER, null);
                }
                this.setModified();
            }
            if (toBeRemoved.size() > 0) {
                for (String rootToBeRemoved : toBeRemoved) {
                    List<Folder> rootFolders = this.getLogicalFolders().getAllFolders(this.modified);
                    for (Folder root : rootFolders) {
                        if (!root.isDiskFolder() || root.getRoot() == null || !root.getRoot().equals(rootToBeRemoved)) continue;
                        this.getLogicalFolders().removeFolderAction(root);
                    }
                }
                this.setModified();
            }
            if ((toBeAdded.size() > 0 || toBeRemoved.size() > 0) && (makeSources = (MakeSources)this.getProject().getLookup().lookup(MakeSources.class)) != null) {
                makeSources.sourceRootsChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkForChangedTestRoots(List<String> oldList, List<String> newList) {
        List<String> list = this.testRoots;
        synchronized (list) {
            this.testRoots.clear();
            for (String l : newList) {
                this.addTestRoot(l);
            }
            ArrayList<String> toBeAdded = new ArrayList<String>();
            for (String s : this.testRoots) {
                if (this.inList(oldList, s)) continue;
                toBeAdded.add(s);
            }
            ArrayList<String> toBeRemoved = new ArrayList<String>();
            for (String s : oldList) {
                if (this.inList(this.testRoots, s)) continue;
                toBeRemoved.add(s);
            }
            if (toBeAdded.size() > 0 || toBeRemoved.size() > 0) {
                ArrayList<String> sourceRootsSave = new ArrayList<String>();
                sourceRootsSave.addAll(this.sourceRoots);
                this.checkForChangedSourceRoots(sourceRootsSave, new ArrayList<String>());
                this.checkForChangedSourceRoots(new ArrayList<String>(), sourceRootsSave);
                this.setModified();
            }
        }
    }

    public void checkConfigurations(Configuration oldActive, Configuration newActive) {
        this.getConfs().fireChangedActiveConfiguration(oldActive, newActive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getSourceRoots() {
        ArrayList<String> copy;
        List<String> list = this.sourceRoots;
        synchronized (list) {
            copy = new ArrayList<String>(this.sourceRoots);
        }
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getTestRoots() {
        ArrayList<String> copy;
        List<String> list = this.testRoots;
        synchronized (list) {
            copy = new ArrayList<String>(this.testRoots);
        }
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getAbsoluteSourceRoots() {
        ArrayList<String> copy = new ArrayList<String>();
        List<String> list = this.sourceRoots;
        synchronized (list) {
            for (String sr : this.sourceRoots) {
                copy.add(CndPathUtilitities.toAbsolutePath((FileObject)this.baseDirFO, (String)sr));
            }
        }
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getAbsoluteTestRoots() {
        ArrayList<String> copy = new ArrayList<String>();
        List<String> list = this.testRoots;
        synchronized (list) {
            for (String s : this.testRoots) {
                copy.add(CndPathUtilitities.toAbsolutePath((FileObject)this.baseDirFO, (String)s));
            }
        }
        return copy;
    }

    private NativeProjectProvider getNativeProject() {
        if (this.nativeProject == null) {
            FileObject fo = this.projectDirFO;
            try {
                Project aProject = ProjectManager.getDefault().findProject(fo);
                this.nativeProject = (NativeProject)aProject.getLookup().lookup(NativeProject.class);
            }
            catch (Exception e) {
                System.err.println("getNativeProject " + e);
            }
        }
        return (NativeProjectProvider)this.nativeProject;
    }

    public void addFilesFromRoot(Folder folder, FileObject dir, boolean attachListeners, Folder.Kind folderKind, @NullAllowed FileObjectFilter fileFilter) {
        CndUtils.assertTrueInConsole((folder != null ? 1 : 0) != 0, (String)"null folder");
        CndUtils.assertTrueInConsole((dir != null ? 1 : 0) != 0, (String)"null directory");
        if (folder == null || dir == null || !dir.isValid()) {
            return;
        }
        ArrayList<NativeFileItem> filesAdded = new ArrayList<NativeFileItem>();
        Folder top = folder.findFolderByAbsolutePath(dir.getPath());
        if (top == null) {
            top = new Folder(folder.getConfigurationDescriptor(), folder, dir.getNameExt(), dir.getNameExt(), true, folderKind);
            folder.addFolder(top, true);
        }
        assert (top.getKind() == folderKind);
        if (folderKind == Folder.Kind.SOURCE_DISK_FOLDER) {
            String rootPath = ProjectSupport.toProperPath(this.baseDirFO, dir, this.project);
            rootPath = CndPathUtilitities.normalizeSlashes((String)rootPath);
            top.setRoot(rootPath);
        }
        this.addFiles(top, dir, null, filesAdded, true, true, fileFilter);
        if (this.getNativeProject() != null) {
            this.getNativeProject().fireFilesAdded(filesAdded);
        }
        if (attachListeners) {
            top.attachListeners();
        }
        this.addSourceRoot(dir.getPath());
    }

    public Folder addFilesFromDir(Folder folder, FileObject dir, boolean attachListeners, boolean setModified, @NullAllowed FileObjectFilter fileFilter) {
        ArrayList<NativeFileItem> filesAdded = new ArrayList<NativeFileItem>();
        Folder top = new Folder(folder.getConfigurationDescriptor(), folder, dir.getNameExt(), dir.getNameExt(), true, null);
        folder.addFolder(top, setModified);
        this.addFiles(top, dir, null, filesAdded, true, setModified, fileFilter);
        if (this.getNativeProject() != null) {
            this.getNativeProject().fireFilesAdded(filesAdded);
        }
        if (attachListeners) {
            top.attachListeners();
        }
        return top;
    }

    private void addFiles(Folder folder, FileObject dir, ProgressHandle handle, ArrayList<NativeFileItem> filesAdded, boolean notify, boolean setModified, @NullAllowed FileObjectFilter fileFilter) {
        List<String> absTestRootsList = this.getAbsoluteTestRoots();
        FileObject[] files = dir.getChildren();
        if (files == null) {
            return;
        }
        boolean hideBinaryFiles = !MakeOptions.getInstance().getViewBinaryFiles();
        for (FileObject file : files) {
            if (!VisibilityQuery.getDefault().isVisible(file) || fileFilter != null && !fileFilter.accept(file) || hideBinaryFiles && CndFileVisibilityQuery.getDefault().isIgnored(file.getNameExt()) || file.isFolder() && this.getFolderVisibilityQuery().isVisible(file)) continue;
            if (file.isFolder()) {
                block8: {
                    try {
                        String canPath = RemoteFileUtil.getCanonicalPath((FileObject)file);
                        String absPath = RemoteFileUtil.getAbsolutePath((FileObject)file);
                        if (!absPath.equals(canPath) && absPath.startsWith(canPath)) {
                            LOGGER.log(Level.INFO, "Ignore recursive link {0} in folder {1}", new Object[]{absPath, folder.getPath()});
                        }
                        break block8;
                    }
                    catch (IOException ex) {
                        LOGGER.log(Level.INFO, ex.getMessage(), ex);
                    }
                    continue;
                }
                Folder dirfolder = folder;
                dirfolder = folder.findFolderByName(file.getNameExt());
                if (dirfolder == null) {
                    dirfolder = this.inList(absTestRootsList, RemoteFileUtil.getAbsolutePath((FileObject)file)) || folder.isTestLogicalFolder() ? folder.addNewFolder(file.getNameExt(), file.getNameExt(), true, Folder.Kind.TEST_LOGICAL_FOLDER) : folder.addNewFolder(file.getNameExt(), file.getNameExt(), true, Folder.Kind.SOURCE_LOGICAL_FOLDER);
                }
                this.addFiles(dirfolder, file, handle, filesAdded, notify, setModified, fileFilter);
                continue;
            }
            String path = ProjectSupport.toProperPath(this.baseDirFO, file, this.project);
            Item item = Item.createInBaseDir(this.baseDirFO, path);
            if (folder.addItem(item, notify, setModified) != null) {
                filesAdded.add(item);
            }
            if (handle == null) continue;
            handle.progress(item.getPath());
        }
    }

    public boolean okToChange() {
        int currentVersion;
        int previousVersion = this.getVersion();
        if (previousVersion < (currentVersion = 79)) {
            String txt = MakeConfigurationDescriptor.getString("UPGRADE_TXT");
            NotifyDescriptor.Confirmation d = new NotifyDescriptor.Confirmation((Object)txt, MakeConfigurationDescriptor.getString("UPGRADE_DIALOG_TITLE"), 0);
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)d) != NotifyDescriptor.YES_OPTION) {
                return false;
            }
            this.setVersion(currentVersion);
        }
        return true;
    }

    private static String getString(String s) {
        return NbBundle.getMessage(MakeConfigurationDescriptor.class, (String)s);
    }

    private static String getString(String s, String a1) {
        return NbBundle.getMessage(MakeConfigurationDescriptor.class, (String)s, (Object)a1);
    }

    public static class ProjectItemChangeEvent
    extends ChangeEvent {
        public static final int ITEM_ADDED = 0;
        public static final int ITEM_REMOVED = 1;
        private Item item;
        private int action;

        public ProjectItemChangeEvent(Object src, Item item, int action) {
            super(src);
            this.item = item;
            this.action = action;
        }

        public Item getItem() {
            return this.item;
        }

        public int getAction() {
            return this.action;
        }
    }

    private class SaveRunnable
    implements Runnable {
        private boolean ret = false;
        private String extraMessage;

        public SaveRunnable(String extraMessage) {
            this.extraMessage = extraMessage;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Project project = MakeConfigurationDescriptor.this.getProject();
            if (project == null) {
                return;
            }
            Object object = MakeConfigurationDescriptor.getWriteLock(project);
            synchronized (object) {
                FullRemoteExtension.configurationSaving(MakeConfigurationDescriptor.this);
                try {
                    this.ret = MakeConfigurationDescriptor.this.saveWorker(this.extraMessage);
                }
                finally {
                    FullRemoteExtension.configurationSaved(MakeConfigurationDescriptor.this, this.ret);
                }
            }
        }
    }
}

