/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.remote.RemoteProject;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.makeproject.MakeProject;
import org.netbeans.modules.cnd.makeproject.MakeProjectGeneratorImpl;
import org.netbeans.modules.cnd.makeproject.api.SourceFolderInfo;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.ui.wizards.MakeSampleProjectGenerator;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.filesystems.FileSystem;

public class ProjectGenerator {
    public static String getDefaultProjectFolder() {
        return MakeProjectGeneratorImpl.getDefaultProjectFolder();
    }

    public static String getDefaultProjectFolder(ExecutionEnvironment env) {
        return MakeProjectGeneratorImpl.getDefaultProjectFolder(env);
    }

    public static String getValidProjectName(String projectFolder) {
        return MakeProjectGeneratorImpl.getValidProjectName(projectFolder);
    }

    public static String getValidProjectName(String projectFolder, String suggestedProjectName) {
        return MakeProjectGeneratorImpl.getValidProjectName(projectFolder, suggestedProjectName);
    }

    public static Project createBlankProject(ProjectParameters prjParams) throws IOException {
        return MakeProjectGeneratorImpl.createBlankProject(prjParams);
    }

    public static Project createProject(ProjectParameters prjParams) throws IOException {
        MakeProject createdProject = MakeProjectGeneratorImpl.createProject(prjParams);
        ConfigurationDescriptorProvider.recordCreatedProjectMetrics(prjParams.getConfigurations());
        return createdProject;
    }

    public static void createProjectFromTemplate(URL templateResourceURL, ProjectParameters prjParams) throws IOException {
        MakeSampleProjectGenerator.createProjectFromTemplate(templateResourceURL.openStream(), prjParams);
    }

    private ProjectGenerator() {
    }

    public static final class ProjectParameters {
        private final String projectName;
        private final String projectFolderPath;
        private String makefile;
        private MakeConfiguration[] configurations;
        private boolean openFlag;
        private Iterator<SourceFolderInfo> sourceFolders;
        private String sourceFoldersFilter;
        private Iterator<String> importantFileItems;
        private Iterator<SourceFolderInfo> testFolders;
        private String mainFile;
        private String hostUID;
        private ExecutionEnvironment sourceEnv;
        private boolean fullRemote;
        private String fullRemoteNativeProjectPath;
        private CompilerSet cs;
        private boolean defaultToolchain;
        private String postCreationClassName;
        private String mainProject;
        private String subProjects;
        private Map<String, Object> templateParams;
        private String databaseConnection;

        public ProjectParameters(String projectName, File projectFolder) {
            this(projectName, new FSPath(CndFileUtils.getLocalFileSystem(), projectFolder.getAbsolutePath()));
        }

        public ProjectParameters(String projectName, FSPath projectFolder) {
            this.projectName = projectName;
            this.sourceEnv = FileSystemProvider.getExecutionEnvironment((FileSystem)projectFolder.getFileSystem());
            this.projectFolderPath = CndFileUtils.normalizeAbsolutePath((FileSystem)projectFolder.getFileSystem(), (String)projectFolder.getPath());
            this.makefile = "Makefile";
            this.configurations = new MakeConfiguration[0];
            this.openFlag = false;
            this.sourceFolders = null;
            this.sourceFoldersFilter = null;
            this.testFolders = null;
            this.importantFileItems = null;
            this.mainFile = "";
            this.postCreationClassName = null;
            this.mainProject = null;
            this.templateParams = Collections.emptyMap();
        }

        public ProjectParameters setMakefileName(String makefile) {
            CndUtils.assertNotNull((Object)makefile, (String)"project makefile name should not be null");
            this.makefile = makefile;
            return this;
        }

        public ProjectParameters setConfigurations(MakeConfiguration[] confs) {
            this.configurations = confs == null ? new MakeConfiguration[]{} : confs;
            return this;
        }

        public ProjectParameters setConfiguration(MakeConfiguration conf) {
            this.configurations = new MakeConfiguration[]{conf};
            return this;
        }

        public ProjectParameters setOpenFlag(boolean open) {
            this.openFlag = open;
            return this;
        }

        public ProjectParameters setSourceFolders(Iterator<SourceFolderInfo> sourceFolders) {
            this.sourceFolders = sourceFolders;
            return this;
        }

        public ProjectParameters setSourceFoldersFilter(String sourceFoldersFilter) {
            this.sourceFoldersFilter = sourceFoldersFilter;
            return this;
        }

        public ProjectParameters setTestFolders(Iterator<SourceFolderInfo> testFolders) {
            this.testFolders = testFolders;
            return this;
        }

        public ProjectParameters setImportantFiles(Iterator<String> importantItems) {
            this.importantFileItems = importantItems;
            return this;
        }

        public ProjectParameters setMainFile(String mainFile) {
            this.mainFile = mainFile == null ? "" : mainFile;
            return this;
        }

        public ProjectParameters setHostToolchain(String hostUID, CompilerSet cs, boolean defaultCS) {
            this.hostUID = hostUID;
            this.cs = cs;
            this.defaultToolchain = defaultCS;
            return this;
        }

        public ProjectParameters setFullRemote(boolean fullRemote) {
            this.fullRemote = fullRemote;
            return this;
        }

        public boolean getFullRemote() {
            return this.fullRemote;
        }

        public ProjectParameters setFullRemoteNativeProjectPath(String nativeProjectPath) {
            this.fullRemoteNativeProjectPath = nativeProjectPath;
            return this;
        }

        public String getFullRemoteNativeProjectPath() {
            return this.fullRemoteNativeProjectPath;
        }

        public RemoteProject.Mode getRemoteMode() {
            return this.fullRemote ? RemoteProject.Mode.REMOTE_SOURCES : RemoteProject.Mode.LOCAL_SOURCES;
        }

        public ProjectParameters setTemplateParams(Map<String, Object> params) {
            this.templateParams = params;
            return this;
        }

        public ProjectParameters setDatabaseConnection(String connection) {
            this.databaseConnection = connection;
            return this;
        }

        public File getProjectFolder() {
            return new File(this.projectFolderPath);
        }

        public String getProjectFolderPath() {
            return this.projectFolderPath;
        }

        public String getProjectName() {
            return this.projectName;
        }

        public MakeConfiguration[] getConfigurations() {
            return this.configurations;
        }

        public boolean getOpenFlag() {
            return this.openFlag;
        }

        public String getMakefileName() {
            return this.makefile;
        }

        public String getMainFile() {
            return this.mainFile;
        }

        public Iterator<SourceFolderInfo> getSourceFolders() {
            return this.sourceFolders;
        }

        public String getSourceFoldersFilter() {
            return this.sourceFoldersFilter;
        }

        public Iterator<SourceFolderInfo> getTestFolders() {
            return this.testFolders;
        }

        public Iterator<String> getImportantFiles() {
            return this.importantFileItems;
        }

        public String getHostUID() {
            return this.hostUID;
        }

        public ProjectParameters setHostUID(String hostUID) {
            this.hostUID = hostUID;
            return this;
        }

        public ExecutionEnvironment getSourceExecutionEnvironment() {
            return this.sourceEnv;
        }

        public FileSystem getSourceFileSystem() {
            return FileSystemProvider.getFileSystem((ExecutionEnvironment)this.sourceEnv);
        }

        public ProjectParameters setSourceExecutionEnvironment(ExecutionEnvironment env) {
            this.sourceEnv = env;
            return this;
        }

        public CompilerSet getToolchain() {
            return this.cs;
        }

        public boolean isDefaultToolchain() {
            return this.defaultToolchain;
        }

        public String getPostCreationClassName() {
            return this.postCreationClassName;
        }

        public ProjectParameters setPostCreationClassName(String postCreationClassName) {
            this.postCreationClassName = postCreationClassName;
            return this;
        }

        public String getMainProject() {
            return this.mainProject;
        }

        public ProjectParameters setMainProject(String mainProject) {
            this.mainProject = mainProject;
            return this;
        }

        public String getSubProjects() {
            return this.subProjects;
        }

        public ProjectParameters setSubProjects(String subProjects) {
            this.subProjects = subProjects;
            return this;
        }

        public Map<String, Object> getTemplateParams() {
            return this.templateParams;
        }

        public String getDatabaseConnection() {
            return this.databaseConnection;
        }

        public boolean isMakefileProject() {
            return this.configurations[0].isMakefileConfiguration();
        }
    }
}

