/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.ResourceBundle;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.remote.PathMap;
import org.netbeans.modules.cnd.api.remote.RemoteSyncSupport;
import org.netbeans.modules.cnd.api.utils.PlatformInfo;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.runprofiles.RunProfile;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class ProjectActionEvent {
    private final Project project;
    private final Type type;
    private String executable;
    private final MakeConfiguration configuration;
    private final RunProfile profile;
    private final boolean wait;
    private final Lookup context;
    private boolean isFinalExecutable;
    private String[] runCommandCache = null;
    private static ResourceBundle bundle;

    public ProjectActionEvent(Project project, Type type, String executable, MakeConfiguration configuration, RunProfile profile, boolean wait) {
        this(project, type, executable, configuration, profile, wait, Lookup.EMPTY);
    }

    public ProjectActionEvent(Project project, Type type, String executable, MakeConfiguration configuration, RunProfile profile, boolean wait, Lookup context) {
        this.project = project;
        this.type = type;
        this.executable = executable;
        this.configuration = configuration;
        this.profile = profile;
        this.wait = wait;
        this.context = context;
        if ((type == PredefinedType.BUILD || type == PredefinedType.CLEAN || type == PredefinedType.BUILD_TESTS || type == PredefinedType.TEST) && profile != null && profile.getConsoleType().getValue() != 2) assert (false) : type + " must not be run in " + profile.getConsoleType().getName() + " use OutputWindow instead";
    }

    public Project getProject() {
        return this.project;
    }

    public final Lookup getContext() {
        return this.context;
    }

    public Type getType() {
        return this.type;
    }

    public String getActionName() {
        return this.type.getLocalizedName();
    }

    private String getExecutableFromRunCommand() {
        ExecutionEnvironment execEnv;
        PlatformInfo pi;
        String qualifiedCommand;
        String[] runCommand = this.getRunCommand();
        if (runCommand.length == 0) {
            return "";
        }
        String command = runCommand[0];
        if (!FileSystemProvider.isAbsolute((String)command) && !command.contains("/") && (qualifiedCommand = (pi = PlatformInfo.getDefault((ExecutionEnvironment)(execEnv = this.configuration.getDevelopmentHost().getExecutionEnvironment()))).findCommand(command)) != null) {
            command = qualifiedCommand;
        }
        return command;
    }

    public String getExecutable() {
        String result;
        if (this.type == PredefinedType.RUN || this.type == PredefinedType.DEBUG || this.type == PredefinedType.DEBUG_STEPINTO) {
            result = this.getExecutableFromRunCommand();
            if (result != null && result.length() > 0) {
                ExecutionEnvironment execEnv = this.configuration.getDevelopmentHost().getExecutionEnvironment();
                if (!CndPathUtilitities.isPathAbsolute((CharSequence)result)) {
                    CndUtils.assertTrueInConsole((boolean)false, (String)"getExecutableFromRunCommand() returned non-absolute path", (Object)result);
                    String baseDir = this.configuration.getBaseDir();
                    if (execEnv.isRemote()) {
                        PathMap mapper = RemoteSyncSupport.getPathMap((Project)this.getProject());
                        baseDir = mapper.getRemotePath(baseDir, true);
                    }
                    result = baseDir + FileSystemProvider.getFileSeparatorChar((ExecutionEnvironment)execEnv) + result;
                }
                result = FileSystemProvider.normalizeAbsolutePath((String)result, (ExecutionEnvironment)execEnv);
            }
        } else {
            result = this.executable;
        }
        return result;
    }

    private String[] getRunCommand() {
        if (this.runCommandCache == null || this.runCommandCache.length == 0) {
            String command = this.getProfile().getRunCommand().getValue();
            assert (this.configuration.getPlatformInfo().isLocalhost() == this.configuration.getDevelopmentHost().isLocalhost());
            String outputValue = this.configuration.isLibraryConfiguration() ? "" : this.configuration.getOutputValue();
            if (outputValue.length() > 0) {
                outputValue = this.configuration.getAbsoluteOutputValue();
            }
            if (this.configuration.getPlatformInfo().isLocalhost()) {
                command = CndPathUtilitities.expandMacro((String)command, (String)"${OUTPUT_PATH}", (String)outputValue);
            } else {
                PathMap mapper = RemoteSyncSupport.getPathMap((Project)this.getProject());
                command = CndPathUtilitities.expandMacro((String)command, (String)"${OUTPUT_PATH}", (String)mapper.getRemotePath(outputValue, true));
            }
            this.runCommandCache = Utilities.parseParameters((String)this.configuration.expandMacros(command));
        }
        return this.runCommandCache;
    }

    public ArrayList<String> getArguments() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.type == PredefinedType.RUN) {
            String[] params = this.getRunCommand();
            if (params.length > 1) {
                result.addAll(Arrays.asList(Arrays.copyOfRange(params, 1, params.length)));
            }
        } else if (this.type == PredefinedType.DEBUG || this.type == PredefinedType.DEBUG_STEPINTO) {
            result.addAll(Arrays.asList(this.getProfile().getArgsArray()));
        } else {
            result.addAll(Arrays.asList(this.getProfile().getArgsArray()));
        }
        return result;
    }

    public MakeConfiguration getConfiguration() {
        return this.configuration;
    }

    public RunProfile getProfile() {
        if (this.profile != null) {
            return this.profile;
        }
        return this.configuration.getProfile();
    }

    public boolean getWait() {
        return this.wait;
    }

    void setExecutable(String executable) {
        this.executable = executable;
    }

    void setFinalExecutable() {
        this.isFinalExecutable = true;
    }

    boolean isFinalExecutable() {
        return this.isFinalExecutable || this.type == PredefinedType.RUN;
    }

    public String toString() {
        return "PAE " + this.type + " " + this.getActionName() + " exec: " + this.getExecutable();
    }

    private static String getString(String s) {
        if (bundle == null) {
            bundle = NbBundle.getBundle(ProjectActionEvent.class);
        }
        return bundle.getString(s);
    }

    public static enum PredefinedType implements Type
    {
        BUILD("Build"),
        CLEAN("Clean"),
        RUN("Run"),
        DEBUG("Debug"),
        DEBUG_STEPINTO("Debug"),
        DEBUG_TEST("Debug"),
        DEBUG_STEPINTO_TEST("Debug"),
        CHECK_EXECUTABLE("CheckExecutable"),
        CUSTOM_ACTION("Custom"),
        BUILD_TESTS("BuildTests"),
        TEST("Test");

        private final String localizedName;

        private PredefinedType(String resourceNamePrefix) {
            this.localizedName = ProjectActionEvent.getString(resourceNamePrefix + "ActionName");
        }

        @Override
        public String getLocalizedName() {
            return this.localizedName;
        }

        @Override
        public void setLocalizedName(String name) {
            throw new UnsupportedOperationException();
        }
    }

    public static interface Type {
        public int ordinal();

        public String name();

        public String getLocalizedName();

        public void setLocalizedName(String var1);
    }
}

