/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.actions;

import java.util.ResourceBundle;
import javax.swing.JButton;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.makeproject.actions.RunDialogAction;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionEvent;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionSupport;
import org.netbeans.modules.cnd.makeproject.api.RunDialogPanel;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationSupport;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.runprofiles.RunProfile;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.MIMENames;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class DebugDialogAction
extends NodeAction {
    protected JButton debugButton = null;
    private Object[] options;
    private ResourceBundle bundle;

    private void init() {
        if (this.debugButton == null) {
            this.debugButton = new JButton(this.getString("DebugButtonText"));
            this.debugButton.getAccessibleContext().setAccessibleDescription(this.getString("DebugButtonAD"));
            this.options = new Object[]{this.debugButton, DialogDescriptor.CANCEL_OPTION};
        }
    }

    public String getName() {
        return this.getString("DEBUG_COMMAND");
    }

    protected void performAction(Node[] activatedNodes) {
        FileObject executableFO = null;
        if (activatedNodes != null && activatedNodes.length == 1) {
            FileObject fo;
            DataObject dataObject = (DataObject)activatedNodes[0].getCookie(DataObject.class);
            String mime = this.getMime(dataObject);
            if (dataObject != null && dataObject.isValid() && MIMENames.isBinary((String)mime) && (fo = dataObject.getPrimaryFile()) != null) {
                executableFO = fo;
            }
        }
        this.perform(executableFO);
    }

    private String getMime(DataObject dob) {
        FileObject primaryFile = dob == null ? null : dob.getPrimaryFile();
        String mime = primaryFile == null ? "" : primaryFile.getMIMEType();
        return mime;
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length != 1) {
            return false;
        }
        DataObject dataObject = (DataObject)activatedNodes[0].getCookie(DataObject.class);
        String mime = this.getMime(dataObject);
        return MIMENames.isBinary((String)mime) && !"application/x-core+elf".equals(mime);
    }

    private void perform(FileObject executableFO) {
        if (this.debugButton == null) {
            this.init();
        }
        try {
            this.perform(new RunDialogPanel(executableFO, this.debugButton, true));
        }
        catch (FileStateInvalidException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    protected void perform(final RunDialogPanel runDialogPanel) {
        if (this.debugButton == null) {
            this.init();
        }
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)runDialogPanel, this.getString("DebugDialogTitle"), true, this.options, (Object)this.debugButton, 0, null, null);
        Object ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (ret == this.debugButton) {
            runDialogPanel.getSelectedProject(new RunDialogPanel.RunProjectAction(){

                @Override
                public void run(Project project) {
                    MakeConfiguration conf = ConfigurationSupport.getProjectActiveConfiguration(project);
                    if (conf != null) {
                        RunProfile profile = conf.getProfile();
                        String path = runDialogPanel.getExecutablePath();
                        path = CndPathUtilitities.toRelativePath((String)profile.getRunDirectory(), (String)path);
                        ProjectActionEvent projectActionEvent = new ProjectActionEvent(project, ProjectActionEvent.PredefinedType.DEBUG, path, conf, profile, false);
                        ProjectActionSupport.getInstance().fireActionPerformed(new ProjectActionEvent[]{projectActionEvent});
                    }
                }
            });
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(RunDialogAction.class);
    }

    private String getString(String s) {
        if (this.bundle == null) {
            this.bundle = NbBundle.getBundle(RunDialogAction.class);
        }
        return this.bundle.getString(s);
    }
}

