/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.Adler32;
import java.util.zip.Checksum;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class SmartOutputStream
extends OutputStream {
    private final FileObject fileObject;
    private final FileLock lock;
    private final FileOutputStream delegate;
    private final File tempFile;
    private final Checksum checksum;
    private static final Logger LOG = Logger.getLogger("remote.support.logger");

    public static OutputStream getSmartOutputStream(FileObject fileObject) throws IOException {
        return SmartOutputStream.getSmartOutputStream(fileObject, null);
    }

    public static OutputStream getSmartOutputStream(FileObject fileObject, FileLock lock) throws IOException {
        return new SmartOutputStream(fileObject, lock);
    }

    private SmartOutputStream(FileObject fileObject, FileLock lock) throws IOException {
        this.fileObject = fileObject;
        this.lock = lock;
        this.tempFile = File.createTempFile(fileObject.getName(), fileObject.getExt());
        this.delegate = new FileOutputStream(this.tempFile);
        this.checksum = new Adler32();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.delegate.write(b, off, len);
        this.checksum.update(b, off, len);
    }

    @Override
    public void write(int b) throws IOException {
        this.delegate.write(b);
        this.checksum.update(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.delegate.close();
        try {
            long oldCheckSum = SmartOutputStream.calculateCheckSum(this.fileObject);
            if (oldCheckSum != this.checksum.getValue()) {
                LOG.log(Level.FINEST, "Check sums differ for {0} - perform real writing", this.fileObject);
                this.realWrite();
            } else {
                LOG.log(Level.FINEST, "Check sums are same for {0} - no real writing is needed", this.fileObject);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
            LOG.log(Level.FINEST, "Exceptions occur for {0} - perform real writing", this.fileObject);
            this.realWrite();
        }
        finally {
            this.tempFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void realWrite() throws IOException {
        OutputStream os = null;
        InputStream is = null;
        IOException exceptionToThrow = null;
        try {
            os = this.lock == null ? this.fileObject.getOutputStream() : this.fileObject.getOutputStream(this.lock);
            is = new FileInputStream(this.tempFile);
            FileUtil.copy((InputStream)is, (OutputStream)os);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException ex) {
                    exceptionToThrow = ex;
                }
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    exceptionToThrow = ex;
                }
            }
            if (exceptionToThrow != null) {
                throw exceptionToThrow;
            }
        }
    }

    @Override
    public void flush() throws IOException {
        this.delegate.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long calculateCheckSum(FileObject fileObject) throws IOException {
        Adler32 checkSum = new Adler32();
        InputStream in = null;
        try {
            int read;
            in = fileObject.getInputStream();
            int bufSize = 16384;
            byte[] buffer = new byte[bufSize];
            while ((read = in.read(buffer, 0, bufSize)) > 0) {
                checkSum.update(buffer, 0, read);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        return checkSum.getValue();
    }
}

