/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject;

import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.remote.RemoteProject;
import org.netbeans.modules.cnd.makeproject.FullRemoteExtension;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.filesystems.FileObject;

public class MakeProjectUtils {
    private MakeProjectUtils() {
    }

    public static ExecutionEnvironment getSourceFileSystemHost(Project project) {
        RemoteProject remoteProject;
        ExecutionEnvironment env = ExecutionEnvironmentFactory.getLocal();
        if (project != null && (remoteProject = (RemoteProject)project.getLookup().lookup(RemoteProject.class)) != null) {
            env = remoteProject.getSourceFileSystemHost();
        }
        return env;
    }

    public static boolean canChangeHost(Project project, MakeConfiguration mk) {
        return MakeProjectUtils.isFullRemote(project) ? FullRemoteExtension.canChangeHost(mk) : true;
    }

    private static boolean isFullRemote(Project project) {
        if (project != null) {
            ExecutionEnvironment env;
            FileObject dir = project.getProjectDirectory();
            if (dir != null && (env = FileSystemProvider.getExecutionEnvironment((FileObject)dir)) != null && env.isRemote()) {
                return true;
            }
            RemoteProject remoteProject = (RemoteProject)project.getLookup().lookup(RemoteProject.class);
            if (remoteProject != null) {
                return remoteProject.getRemoteMode() == RemoteProject.Mode.REMOTE_SOURCES;
            }
        }
        return false;
    }
}

