/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.prefs.Preferences;
import org.netbeans.modules.cnd.makeproject.api.MakeProjectOptions;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.SharedClassObject;

public class MakeOptions
extends SharedClassObject
implements PropertyChangeListener {
    public static final String VIEW_BINARY_FILES = "viewBinaryFiles";
    private static MakeOptions instance = null;
    private static final String MAKE_OPTIONS = "makeOptions";
    private static String defaultMakeOptions = "";
    private static final String PATH_MODE = "pathMode";
    private static final String DEPENDENCY_CHECKING = "dependencyChecking";
    private static final String REBUILD_PROP_CHANGED = "rebuildPropChanged";
    private static final String SAVE = "save";
    private static final String REUSE = "reuse";
    private static final String SHOW_PROFILING = "showProfiling";
    private static final String SHOW_CONFIGURATION_WARNING = "showConfigurationWarning";
    private static final String DEF_EXE_PERM = "defexeperm";
    private static final String DEF_FILE_PERM = "deffileperm";
    private static final String DEF_OWNER = "defowner";
    private static final String DEF_GROUP = "defgroup";
    private static final String PREF_APP_LANGUAGE = "prefAppLanguage";
    public static final String FULL_FILE_INDEXER = "fullFileIndexer";
    public static final String FIX_UNRESOLVED_INCLUDE = "fixUnresolvedInclude";
    public static final String USE_BUILD_TRACE = "useBuildTrace";

    public static MakeOptions getInstance() {
        if (instance == null) {
            instance = (MakeOptions)SharedClassObject.findObject(MakeOptions.class, (boolean)true);
        }
        return instance;
    }

    public static void setDefaultMakeOptions(String makeOptions) {
        defaultMakeOptions = makeOptions;
    }

    public static String getDefaultMakeOptions() {
        return defaultMakeOptions;
    }

    public MakeOptions() {
        this.addPropertyChangeListener(this);
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(MakeOptions.class);
    }

    public String getMakeOptions() {
        return this.getPreferences().get(MAKE_OPTIONS, MakeOptions.getDefaultMakeOptions());
    }

    public void setMakeOptions(String value) {
        String oldValue = this.getMakeOptions();
        this.getPreferences().put(MAKE_OPTIONS, value);
        if (!oldValue.equals(value)) {
            this.firePropertyChange(MAKE_OPTIONS, oldValue, value);
        }
    }

    public MakeProjectOptions.PathMode getPathMode() {
        MakeProjectOptions.PathMode defaultValue = MakeProjectOptions.PathMode.REL;
        String stringValue = this.getPreferences().get(PATH_MODE, defaultValue.name());
        if (Character.isDigit(stringValue.charAt(0))) {
            int intValue;
            try {
                intValue = Integer.parseInt(stringValue);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
            for (MakeProjectOptions.PathMode pathMode : MakeProjectOptions.PathMode.values()) {
                if (pathMode.ordinal() != intValue) continue;
                return pathMode;
            }
            return defaultValue;
        }
        return MakeProjectOptions.PathMode.valueOf(stringValue);
    }

    public void setPathMode(MakeProjectOptions.PathMode pathMode) {
        MakeProjectOptions.PathMode oldValue = this.getPathMode();
        this.getPreferences().put(PATH_MODE, pathMode.name());
        if (oldValue != pathMode) {
            this.firePropertyChange(PATH_MODE, (Object)oldValue, (Object)pathMode);
        }
    }

    public boolean getDepencyChecking() {
        return this.getPreferences().getBoolean(DEPENDENCY_CHECKING, true);
    }

    public void setDepencyChecking(boolean dependencyChecking) {
        boolean oldValue = this.getDepencyChecking();
        this.getPreferences().putBoolean(DEPENDENCY_CHECKING, dependencyChecking);
        if (oldValue != dependencyChecking) {
            this.firePropertyChange(DEPENDENCY_CHECKING, oldValue, dependencyChecking);
        }
    }

    public boolean getRebuildPropChanged() {
        return this.getPreferences().getBoolean(REBUILD_PROP_CHANGED, false);
    }

    public void setRebuildPropChanged(boolean rebuildPropChanged) {
        boolean oldValue = this.getRebuildPropChanged();
        this.getPreferences().putBoolean(REBUILD_PROP_CHANGED, rebuildPropChanged);
        if (oldValue != rebuildPropChanged) {
            this.firePropertyChange(REBUILD_PROP_CHANGED, oldValue, rebuildPropChanged);
        }
    }

    public boolean getViewBinaryFiles() {
        return this.getPreferences().getBoolean(VIEW_BINARY_FILES, false);
    }

    public void setViewBinaryFiles(boolean viewBinaryFiles) {
        boolean oldValue = this.getViewBinaryFiles();
        this.getPreferences().putBoolean(VIEW_BINARY_FILES, viewBinaryFiles);
        if (oldValue != viewBinaryFiles) {
            this.firePropertyChange(VIEW_BINARY_FILES, oldValue, viewBinaryFiles);
        }
    }

    public boolean getSave() {
        return this.getPreferences().getBoolean(SAVE, true);
    }

    public void setSave(boolean save) {
        boolean oldValue = this.getSave();
        this.getPreferences().putBoolean(SAVE, save);
        if (oldValue != save) {
            this.firePropertyChange(SAVE, oldValue, save);
        }
    }

    public boolean getReuse() {
        return this.getPreferences().getBoolean(REUSE, true);
    }

    public void setReuse(boolean reuse) {
        boolean oldValue = this.getReuse();
        this.getPreferences().putBoolean(REUSE, reuse);
        if (oldValue != reuse) {
            this.firePropertyChange(REUSE, oldValue, reuse);
        }
    }

    public boolean getShowProfiling() {
        return this.getPreferences().getBoolean(SHOW_PROFILING, true);
    }

    public void setShowProfiling(boolean reuse) {
        boolean oldValue = this.getShowProfiling();
        this.getPreferences().putBoolean(SHOW_PROFILING, reuse);
        if (oldValue != reuse) {
            this.firePropertyChange(SHOW_PROFILING, oldValue, reuse);
        }
    }

    public boolean getShowConfigurationWarning() {
        return this.getPreferences().getBoolean(SHOW_CONFIGURATION_WARNING, true);
    }

    public void setShowConfigurationWarning(boolean val) {
        boolean oldValue = this.getShowConfigurationWarning();
        this.getPreferences().putBoolean(SHOW_CONFIGURATION_WARNING, val);
        if (oldValue != val) {
            this.firePropertyChange(SHOW_CONFIGURATION_WARNING, oldValue, val);
        }
    }

    public String getDefExePerm() {
        return this.getPreferences().get(DEF_EXE_PERM, "755");
    }

    public void setDefExePerm(String value) {
        String oldValue = this.getDefExePerm();
        this.getPreferences().put(DEF_EXE_PERM, value);
        if (!oldValue.equals(value)) {
            this.firePropertyChange(DEF_EXE_PERM, oldValue, value);
        }
    }

    public String getDefFilePerm() {
        return this.getPreferences().get(DEF_FILE_PERM, "644");
    }

    public void setDefFilePerm(String value) {
        String oldValue = this.getDefFilePerm();
        this.getPreferences().put(DEF_FILE_PERM, value);
        if (!oldValue.equals(value)) {
            this.firePropertyChange(DEF_FILE_PERM, oldValue, value);
        }
    }

    public String getDefOwner() {
        return this.getPreferences().get(DEF_OWNER, "root");
    }

    public void setDefOwner(String value) {
        String oldValue = this.getDefOwner();
        this.getPreferences().put(DEF_OWNER, value);
        if (!oldValue.equals(value)) {
            this.firePropertyChange(DEF_OWNER, oldValue, value);
        }
    }

    public String getDefGroup() {
        return this.getPreferences().get(DEF_GROUP, "bin");
    }

    public void setDefGroup(String value) {
        String oldValue = this.getDefGroup();
        this.getPreferences().put(DEF_GROUP, value);
        if (!oldValue.equals(value)) {
            this.firePropertyChange(DEF_GROUP, oldValue, value);
        }
    }

    public String getPrefApplicationLanguage() {
        return this.getPreferences().get(PREF_APP_LANGUAGE, "C++");
    }

    public void setPrefApplicationLanguage(String value) {
        String oldValue = this.getPrefApplicationLanguage();
        this.getPreferences().put(PREF_APP_LANGUAGE, value);
        if (!oldValue.equals(value)) {
            this.firePropertyChange(PREF_APP_LANGUAGE, oldValue, value);
        }
    }

    public boolean isFullFileIndexer() {
        return this.getPreferences().getBoolean(FULL_FILE_INDEXER, false);
    }

    public void setFullFileIndexer(boolean value) {
        boolean oldValue = this.isFullFileIndexer();
        this.getPreferences().putBoolean(FULL_FILE_INDEXER, value);
        if (oldValue != value) {
            this.firePropertyChange(FULL_FILE_INDEXER, oldValue, value);
        }
    }

    public boolean isFixUnresolvedInclude() {
        return this.getPreferences().getBoolean(FIX_UNRESOLVED_INCLUDE, true);
    }

    public void setFixUnresolvedInclude(boolean value) {
        boolean oldValue = this.isFixUnresolvedInclude();
        this.getPreferences().putBoolean(FIX_UNRESOLVED_INCLUDE, value);
        if (oldValue != value) {
            this.firePropertyChange(FIX_UNRESOLVED_INCLUDE, oldValue, value);
        }
    }

    public boolean isUseBuildTrace() {
        return this.getPreferences().getBoolean(USE_BUILD_TRACE, true);
    }

    public void setUseBuildTrace(boolean value) {
        boolean oldValue = this.isUseBuildTrace();
        this.getPreferences().putBoolean(USE_BUILD_TRACE, value);
        if (oldValue != value) {
            this.firePropertyChange(USE_BUILD_TRACE, oldValue, value);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
    }

    private static String getString(String s) {
        return NbBundle.getMessage(MakeOptions.class, (String)s);
    }
}

