/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.watcher;

import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.BaseFileObj;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.FileObjectFactory;
import org.netbeans.modules.masterfs.providers.AnnotationProvider;
import org.netbeans.modules.masterfs.providers.InterceptionListener;
import org.netbeans.modules.masterfs.providers.ProvidedExtensions;
import org.netbeans.modules.masterfs.watcher.FAMNotifier;
import org.netbeans.modules.masterfs.watcher.FOFile;
import org.netbeans.modules.masterfs.watcher.LinuxNotifier;
import org.netbeans.modules.masterfs.watcher.Notifier;
import org.netbeans.modules.masterfs.watcher.OSXNotifier;
import org.netbeans.modules.masterfs.watcher.WindowsNotifier;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public final class Watcher
extends AnnotationProvider {
    static final Logger LOG = Logger.getLogger(Watcher.class.getName());
    private final Ext<?> ext;
    private final Object lock = new Object();
    private Set<FileObject> pending;
    private static RequestProcessor RP = new RequestProcessor("Pending refresh", 1);
    private RequestProcessor.Task refreshTask = RP.create(new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Set toRefresh;
            Object object = Watcher.this.lock;
            synchronized (object) {
                toRefresh = Watcher.this.pending;
                Watcher.this.pending = null;
            }
            LOG.log(Level.FINE, "Refreshing {0} directories", toRefresh.size());
            for (FileObject fileObject : toRefresh) {
                LOG.log(Level.FINEST, "Refreshing {0}", fileObject);
                fileObject.refresh();
            }
            LOG.fine("Refresh finished");
        }
    });

    public Watcher() {
        if (Boolean.getBoolean("org.netbeans.modules.masterfs.watcher.disable")) {
            this.ext = null;
            return;
        }
        this.ext = this.make(Watcher.getNotifierForPlatform());
    }

    public static boolean isEnabled() {
        return ((Watcher)Lookup.getDefault().lookup(Watcher.class)).ext != null;
    }

    public static File wrap(File f, FileObject fo) {
        if (f instanceof FOFile) {
            return f;
        }
        return new FOFile(f, fo);
    }

    @Override
    public String annotateName(String name, Set<? extends FileObject> files) {
        return null;
    }

    @Override
    public Image annotateIcon(Image icon, int iconType, Set<? extends FileObject> files) {
        return null;
    }

    @Override
    public String annotateNameHtml(String name, Set<? extends FileObject> files) {
        return null;
    }

    @Override
    public Action[] actions(Set<? extends FileObject> files) {
        return null;
    }

    @Override
    public InterceptionListener getInterceptionListener() {
        return this.ext;
    }

    public void shutdown() {
        if (this.ext != null) {
            try {
                this.ext.shutdown();
            }
            catch (IOException ex) {
                LOG.log(Level.INFO, "Error on shutdown", ex);
            }
            catch (InterruptedException ex) {
                LOG.log(Level.INFO, "Error on shutdown", ex);
            }
        }
    }

    private <KEY> Ext<KEY> make(Notifier<KEY> impl) {
        return impl == null ? null : new Ext<KEY>(impl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueue(FileObject fo) {
        assert (fo != null);
        Object object = this.lock;
        synchronized (object) {
            if (this.pending == null) {
                this.refreshTask.schedule(1500);
                this.pending = new HashSet<FileObject>();
            }
            this.pending.add(fo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueueAll(Set<FileObject> fos) {
        assert (fos != null);
        assert (!fos.contains(null)) : "No nulls";
        Object object = this.lock;
        synchronized (object) {
            if (this.pending == null) {
                this.refreshTask.schedule(1500);
                this.pending = new HashSet<FileObject>();
            }
            this.pending.addAll(fos);
        }
    }

    private static Notifier<?> getNotifierForPlatform() {
        block10: {
            try {
                if (Utilities.isWindows()) {
                    return new WindowsNotifier();
                }
                if (Utilities.getOperatingSystem() == 16) {
                    return new LinuxNotifier();
                }
                if (Utilities.getOperatingSystem() == 4096) {
                    try {
                        OSXNotifier notifier = new OSXNotifier();
                        notifier.start();
                        return notifier;
                    }
                    catch (IOException ioe) {
                        LOG.log(Level.INFO, null, ioe);
                    }
                }
                if (Utilities.getOperatingSystem() != 8) break block10;
                try {
                    return new FAMNotifier();
                }
                catch (Exception e) {
                    LOG.log(Level.INFO, null, e);
                }
                catch (LinkageError x) {
                }
            }
            catch (LinkageError x) {
                LOG.warning(x.toString());
            }
        }
        return null;
    }

    private class Ext<KEY>
    extends ProvidedExtensions
    implements Runnable {
        private final Notifier<KEY> impl;
        private final Map<FileObject, KEY> map = new WeakHashMap<FileObject, KEY>();
        private final Thread watcher;
        private volatile boolean shutdown;

        public Ext(Notifier<KEY> impl) {
            this.impl = impl;
            this.watcher = new Thread((Runnable)this, "File Watcher");
            this.watcher.start();
        }

        @Override
        public long refreshRecursively(File dir, long lastTimeStamp, List<? super File> children) {
            assert (dir instanceof FOFile);
            FileObject fo = ((FOFile)dir).fo;
            String path = dir.getAbsolutePath();
            if (fo == null && !dir.exists()) {
                return -1L;
            }
            assert (fo != null) : "No fileobject for " + path;
            if (this.map.containsKey(fo)) {
                return -1L;
            }
            try {
                this.map.put(fo, this.impl.addWatch(path));
            }
            catch (IOException ex) {
                LOG.log(Level.WARNING, "Cannot add filesystem watch for {0}", path);
                LOG.log(Level.INFO, "Exception", ex);
            }
            return -1L;
        }

        @Override
        public void run() {
            while (!this.shutdown) {
                try {
                    String path = this.impl.nextEvent();
                    LOG.log(Level.FINEST, "nextEvent: {0}", path);
                    if (path == null) {
                        Watcher.this.enqueueAll(this.map.keySet());
                        continue;
                    }
                    File file = new File(path);
                    FileObjectFactory factory = FileObjectFactory.getInstance(file);
                    BaseFileObj fo = factory.getCachedOnly(file);
                    if (this.map.containsKey((Object)fo)) {
                        Watcher.this.enqueue(fo);
                        continue;
                    }
                    fo = factory.getCachedOnly(file.getParentFile());
                    if (!this.map.containsKey((Object)fo)) continue;
                    Watcher.this.enqueue(fo);
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (InterruptedException ie) {
                    if (this.shutdown) continue;
                    LOG.log(Level.INFO, "Interrupted", ie);
                }
                catch (Throwable t) {
                    LOG.log(Level.INFO, "Error dispatching FS changes", t);
                }
            }
        }

        final void shutdown() throws IOException, InterruptedException {
            this.shutdown = true;
            this.watcher.interrupt();
            this.impl.stop();
            this.watcher.join(1000L);
        }
    }
}

