/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.uid;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInheritance;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.UIDs;
import org.netbeans.modules.cnd.modelimpl.csm.core.CsmIdentifiable;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.uid.LazyCsmCollection;

public final class UIDCsmConverter {
    private UIDCsmConverter() {
    }

    public static boolean isIdentifiable(Object obj) {
        return obj instanceof CsmIdentifiable;
    }

    public static CsmFile UIDtoFile(CsmUID<CsmFile> uid) {
        try {
            CsmFile result = uid == null ? null : (CsmFile)uid.getObject();
            return result;
        }
        catch (StackOverflowError ex) {
            Exception ex2 = new Exception("StackOverflowError for UID " + uid);
            ex2.setStackTrace(ex.getStackTrace());
            DiagnosticExceptoins.register(ex2);
            return null;
        }
    }

    public static <T> T UIDtoCsmObject(CsmUID<T> uid) {
        return (T)(uid == null ? null : uid.getObject());
    }

    public static CsmNamespace UIDtoNamespace(CsmUID<CsmNamespace> uid) {
        return uid == null ? null : (CsmNamespace)uid.getObject();
    }

    public static CsmProject UIDtoProject(CsmUID<CsmProject> uid) {
        return uid == null ? null : (CsmProject)uid.getObject();
    }

    public static <T extends CsmDeclaration> T UIDtoDeclaration(CsmUID<T> uid) {
        return (T)(uid == null ? null : (CsmDeclaration)uid.getObject());
    }

    public static CsmScope UIDtoScope(CsmUID<CsmScope> uid) {
        return uid == null ? null : (CsmScope)uid.getObject();
    }

    public static CsmClass UIDtoClass(CsmUID<CsmClass> uid) {
        return uid == null ? null : (CsmClass)uid.getObject();
    }

    public static <T> Collection<T> UIDsToNamespaces(Collection<CsmUID<T>> uids) {
        Collection<T> out = UIDCsmConverter.UIDsToList(uids, false);
        return out;
    }

    public static <T extends CsmDeclaration> Collection<T> UIDsToDeclarations(Collection<CsmUID<T>> uids) {
        Collection<T> out = UIDCsmConverter.UIDsToList(uids, false);
        return out;
    }

    public static CsmInheritance UIDsToInheritance(CsmUID<CsmInheritance> uid) {
        return uid == null ? null : (CsmInheritance)uid.getObject();
    }

    public static <T extends CsmInheritance> Collection<T> UIDsToInheritances(Collection<CsmUID<T>> uids) {
        Collection<T> out = UIDCsmConverter.UIDsToList(uids, false);
        return out;
    }

    public static CsmUID<CsmInheritance> inheritanceToUID(CsmInheritance decl) {
        return decl == null ? null : UIDs.get((Object)decl);
    }

    public static <T extends CsmDeclaration> Iterator<T> UIDsToDeclarationsFiltered(Collection<CsmUID<T>> uids, CsmSelect.CsmFilter filter) {
        return new LazyCsmCollection(new ArrayList(uids), true).iterator(filter);
    }

    public static <T> Collection<T> UIDsToDeclarationsUnsafe(Collection<CsmUID<T>> uids) {
        Collection<T> out = UIDCsmConverter.UIDsToList(uids, true);
        return out;
    }

    public static <T> Collection<T> UIDsToMacros(Collection<CsmUID<T>> uids) {
        Collection<T> out = UIDCsmConverter.UIDsToList(uids, false);
        return out;
    }

    public static <T> Iterator<T> UIDsToMacros(Collection<CsmUID<T>> uids, CsmSelect.CsmFilter filter) {
        return new LazyCsmCollection(new ArrayList(uids), true).iterator(filter);
    }

    public static <T> Collection<T> UIDsToIncludes(Collection<CsmUID<T>> uids) {
        Collection<T> out = UIDCsmConverter.UIDsToList(uids, false);
        return out;
    }

    public static <T> Iterator<T> UIDsToIncludes(Collection<CsmUID<T>> uids, CsmSelect.CsmFilter filter) {
        return new LazyCsmCollection(new ArrayList(uids), true).iterator(filter);
    }

    public static <T> Collection<T> UIDsToInstantiations(Collection<CsmUID<T>> uids) {
        Collection<T> out = UIDCsmConverter.UIDsToList(uids, false);
        return out;
    }

    public static <T> Iterator<T> UIDsToInstantiations(Collection<CsmUID<T>> uids, CsmSelect.CsmFilter filter) {
        return new LazyCsmCollection(new ArrayList(uids), true).iterator(filter);
    }

    public static <T> Collection<T> UIDsToCsmObjects(Collection<CsmUID<T>> uids) {
        Collection<T> out = UIDCsmConverter.UIDsToList(uids, false);
        return out;
    }

    private static <T> Collection<T> UIDsToList(Collection<CsmUID<T>> uids, boolean allowNullsAndSkip) {
        return new LazyCsmCollection(new ArrayList(uids), allowNullsAndSkip |= TraceFlags.SAFE_UID_ACCESS);
    }

    public static <T> Iterator<T> UIDsToDeclarations(Collection<CsmUID<T>> nonSharedCollection, CsmSelect.CsmFilter filter) {
        return new LazyCsmCollection(nonSharedCollection, true).iterator(filter);
    }

    public static <T> T UIDtoIdentifiable(CsmUID<T> uid) {
        return (T)(uid == null ? null : uid.getObject());
    }

    public static CsmUID<CsmFile> fileToUID(CsmFile file) {
        return file == null ? null : UIDs.get((Object)file);
    }

    public static CsmUID<CsmNamespace> namespaceToUID(CsmNamespace ns) {
        return ns == null ? null : UIDs.get((Object)ns);
    }

    public static CsmUID<CsmProject> projectToUID(CsmProject project) {
        return project == null ? null : UIDs.get((Object)project);
    }

    public static <T extends CsmDeclaration> CsmUID<T> declarationToUID(T decl) {
        return decl == null ? null : UIDs.get(decl);
    }

    public static CsmUID<CsmScope> scopeToUID(CsmScope scope) {
        return scope == null ? null : UIDs.get((Object)scope);
    }

    public static <T> CsmUID<T> identifiableToUID(CsmIdentifiable obj) {
        if (obj == null) {
            return null;
        }
        CsmUID<?> res = obj.getUID();
        return res;
    }

    public static <T extends CsmObject> CsmUID<T> objectToUID(T obj) {
        if (obj == null) {
            return null;
        }
        return UIDs.get(obj);
    }

    public static <T extends CsmObject> Collection<CsmUID<T>> objectsToUIDs(Collection<T> objs) {
        if (objs == null) {
            return null;
        }
        if (objs.isEmpty()) {
            return new ArrayList<CsmUID<T>>(0);
        }
        ArrayList<CsmUID<T>> out = new ArrayList<CsmUID<T>>(objs.size());
        for (CsmObject csmObj : objs) {
            CsmUID uid = UIDs.get((Object)csmObj);
            out.add(uid);
        }
        return out;
    }
}

