/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.repository;

import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmInheritance;
import org.netbeans.modules.cnd.api.model.CsmInstantiation;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmNamedElement;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmParameterList;
import org.netbeans.modules.cnd.api.model.CsmVisibility;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableDeclarationBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.repository.FileKey;
import org.netbeans.modules.cnd.modelimpl.repository.IncludeKey;
import org.netbeans.modules.cnd.modelimpl.repository.InheritanceKey;
import org.netbeans.modules.cnd.modelimpl.repository.InstantiationKey;
import org.netbeans.modules.cnd.modelimpl.repository.KeyManager;
import org.netbeans.modules.cnd.modelimpl.repository.MacroKey;
import org.netbeans.modules.cnd.modelimpl.repository.NamespaceKey;
import org.netbeans.modules.cnd.modelimpl.repository.OffsetableDeclarationKey;
import org.netbeans.modules.cnd.modelimpl.repository.OffsetableKey;
import org.netbeans.modules.cnd.modelimpl.repository.ParamListKey;
import org.netbeans.modules.cnd.modelimpl.repository.ProjectFileNameBasedKey;
import org.netbeans.modules.cnd.modelimpl.repository.ProjectKey;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.repository.spi.Key;

public class KeyUtilities {
    private KeyUtilities() {
    }

    public static Key createFileKey(FileImpl file) {
        return KeyManager.instance().getSharedKey(new FileKey(file));
    }

    public static Key createNamespaceKey(CsmNamespace ns) {
        return new NamespaceKey(ns);
    }

    public static Key createProjectKey(ProjectBase project) {
        return KeyUtilities.createProjectKey(project.getUniqueName());
    }

    public static Key createProjectKey(CharSequence projectQualifiedName) {
        return new ProjectKey(projectQualifiedName);
    }

    public static Key createProjectKey(NativeProject nativeProject) {
        return KeyUtilities.createProjectKey(ProjectBase.getUniqueName(nativeProject));
    }

    public static Key createOffsetableDeclarationKey(OffsetableDeclarationBase<?> obj) {
        assert (obj != null);
        return new OffsetableDeclarationKey(obj);
    }

    public static Key createUnnamedOffsetableDeclarationKey(OffsetableDeclarationBase<?> obj, int index) {
        assert (obj != null);
        return new OffsetableDeclarationKey(obj, index);
    }

    public static Key createMacroKey(CsmMacro macro) {
        assert (macro != null);
        return new MacroKey(macro);
    }

    public static Key createIncludeKey(CsmInclude incl) {
        assert (incl != null);
        return KeyManager.instance().getSharedKey(new IncludeKey(incl));
    }

    public static Key createInheritanceKey(CsmInheritance inh) {
        assert (inh != null);
        return KeyManager.instance().getSharedKey(new InheritanceKey(inh));
    }

    public static <T extends CsmNamedElement> Key createParamListKey(CsmParameterList<T> paramList) {
        assert (paramList != null);
        return new ParamListKey(paramList);
    }

    public static Key createInstantiationKey(CsmInstantiation inst) {
        assert (inst != null);
        return new InstantiationKey(inst);
    }

    public static int getUnitId(CharSequence unitName) {
        return RepositoryUtils.getUnitId(unitName);
    }

    public static CharSequence getUnitName(int unitIndex) {
        return RepositoryUtils.getUnitName(unitIndex);
    }

    public static int getFileIdByName(int unitId, CharSequence fileName) {
        return RepositoryUtils.getFileIdByName(unitId, fileName);
    }

    public static CharSequence getFileNameById(int unitId, int fileId) {
        return RepositoryUtils.getFileNameById(unitId, fileId);
    }

    public static CharSequence getFileNameByIdSafe(int unitId, int fileId) {
        return RepositoryUtils.getFileNameByIdSafe(unitId, fileId);
    }

    public static CsmDeclaration.Kind getKeyKind(Key key) {
        if (key instanceof OffsetableDeclarationKey) {
            return Utils.getCsmDeclarationKind(((OffsetableDeclarationKey)key).getKind());
        }
        return null;
    }

    public static CsmVisibility getKeyVisibility(Key key) {
        if (key instanceof InheritanceKey) {
            Utils.getCsmVisibility(((InheritanceKey)key).getKind());
        }
        return null;
    }

    public static char getKeyChar(Key key) {
        if (key instanceof OffsetableKey) {
            return ((OffsetableKey)key).getKind();
        }
        return '\u0000';
    }

    public static CharSequence getKeyName(Key key) {
        if (key instanceof OffsetableKey) {
            return ((OffsetableKey)key).getName();
        }
        if (key instanceof FileKey) {
            return ((FileKey)key).getName();
        }
        if (key instanceof ProjectKey) {
            return ((ProjectKey)key).getProjectName();
        }
        return null;
    }

    public static int getProjectFileIndex(Key key) {
        if (key instanceof ProjectFileNameBasedKey) {
            return ((ProjectFileNameBasedKey)key).getProjectFileIndex();
        }
        return -1;
    }

    public static int getProjectIndex(Key key) {
        if (key instanceof ProjectFileNameBasedKey) {
            return ((ProjectFileNameBasedKey)key).getUnitId();
        }
        if (key instanceof ProjectKey) {
            return ((ProjectKey)key).getUnitId();
        }
        return -1;
    }

    public static int getKeyStartOffset(Key key) {
        if (key instanceof OffsetableKey) {
            return ((OffsetableKey)key).getStartOffset();
        }
        return -1;
    }

    public static int getKeyEndOffset(Key key) {
        if (key instanceof OffsetableKey) {
            return ((OffsetableKey)key).getEndOffset();
        }
        return -1;
    }
}

