/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.platform;

import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.platform.ModelSupport;
import org.openide.util.NbBundle;

final class ParsingProgress {
    private final ProgressHandle handle;
    private int curWorkedUnits = 0;
    private int maxWorkUnits = 0;
    private int addedAfterStartParsing = 0;
    private int allWork = 0;
    private static final double ALL_WORK_DOUBLE = 10000.0;
    private static final int ALL_WORK_INT = 10000;
    private boolean started = false;
    private boolean determinate = false;
    private static final int INITIAL_DELAY;

    public ParsingProgress(CsmProject project) {
        String msg = NbBundle.getMessage(ModelSupport.class, (String)"MSG_ParsingProgress", (Object)project.getName());
        this.handle = ProgressHandleFactory.createHandle((String)msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        ProgressHandle progressHandle = this.handle;
        synchronized (progressHandle) {
            if (!this.started) {
                this.started = true;
                this.handle.setInitialDelay(INITIAL_DELAY);
                this.handle.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        ProgressHandle progressHandle = this.handle;
        synchronized (progressHandle) {
            if (this.started) {
                this.handle.finish();
                this.started = false;
            }
        }
    }

    public void addedToParse(CsmFile file) {
        ++this.addedAfterStartParsing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nextCsmFile(CsmFile file) {
        ProgressHandle progressHandle = this.handle;
        synchronized (progressHandle) {
            if (!this.started || !this.determinate) {
                return;
            }
            if (this.curWorkedUnits < this.maxWorkUnits + this.addedAfterStartParsing) {
                int work;
                ++this.curWorkedUnits;
                double ratio = 1.0;
                if (this.maxWorkUnits + this.addedAfterStartParsing > 0) {
                    ratio = 10000.0 / (double)(this.maxWorkUnits + this.addedAfterStartParsing);
                }
                if (this.allWork <= (work = (int)(ratio * (double)this.curWorkedUnits)) && work < 10000) {
                    this.allWork = work;
                }
            }
            try {
                String msg = NbBundle.getMessage(ModelSupport.class, (String)"MSG_ParsingProgressFull", (Object)("" + this.curWorkedUnits), (Object)("" + (this.maxWorkUnits + this.addedAfterStartParsing)), (Object)((Object)file.getName()).toString());
                this.handle.progress(msg, this.allWork);
            }
            catch (NullPointerException ex) {
                DiagnosticExceptoins.register(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchToDeterminate(int maxWorkUnits) {
        ProgressHandle progressHandle = this.handle;
        synchronized (progressHandle) {
            if (!this.started) {
                return;
            }
            this.maxWorkUnits = maxWorkUnits;
            this.addedAfterStartParsing = 0;
            this.handle.switchToDeterminate(10000);
            this.determinate = true;
        }
    }

    static {
        int value = 1000;
        try {
            value = Integer.parseInt(NbBundle.getMessage(ParsingProgress.class, (String)"CSM_PARSING_PROGRESS_INITIAL_DELAY"));
            if (value < 0) {
                value = Integer.MAX_VALUE;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        INITIAL_DELAY = value;
    }
}

