/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.platform;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.StyledDocument;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmModelState;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeFileItemSet;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.project.NativeProjectRegistry;
import org.netbeans.modules.cnd.api.project.NativeProjectSettings;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileBuffer;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileBufferFile;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ModelImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.debug.Diagnostic;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.memory.LowMemoryEvent;
import org.netbeans.modules.cnd.modelimpl.platform.FileBufferDoc;
import org.netbeans.modules.cnd.modelimpl.spi.LowMemoryAlerter;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.spi.utils.CndFileSystemProvider;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.MIMENames;
import org.netbeans.modules.cnd.utils.NamedRunnable;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.dlight.libs.common.InvalidFileObjectSupport;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class ModelSupport
implements PropertyChangeListener {
    private static final ModelSupport instance = new ModelSupport();
    private ModelImpl theModel;
    private final Set<Lookup.Provider> openedProjects = new HashSet<Lookup.Provider>();
    private final ModifiedObjectsChangeListener modifiedListener = new ModifiedObjectsChangeListener();
    private FileChangeListener fileChangeListener;
    private static final boolean TRACE_STARTUP = Boolean.getBoolean("cnd.modelsupport.startup.trace");
    private volatile boolean postponeParse = false;
    private final RequestProcessor.Task openProjectsTask = new RequestProcessor("ModelSupport processor", 1).create(new Runnable(){

        @Override
        public void run() {
            ModelSupport.this.openProjects();
        }
    });
    private volatile boolean closed = false;

    private ModelSupport() {
    }

    public static ModelSupport instance() {
        return instance;
    }

    public static int getTabSize() {
        return 8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setModel(ModelImpl model) {
        this.theModel = model;
        ModelSupport modelSupport = this;
        synchronized (modelSupport) {
            if (this.fileChangeListener != null) {
                CndFileSystemProvider.removeFileChangeListener((FileChangeListener)this.fileChangeListener);
                this.fileChangeListener = null;
            }
            if (model != null) {
                this.fileChangeListener = new ExternalUpdateListener();
                CndFileSystemProvider.addFileChangeListener((FileChangeListener)this.fileChangeListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startup() {
        this.modifiedListener.clean();
        DataObject.getRegistry().addChangeListener((ChangeListener)this.modifiedListener);
        Set<Lookup.Provider> set = this.openedProjects;
        synchronized (set) {
            this.closed = false;
        }
        if (!CndUtils.isStandalone()) {
            this.openedProjects.clear();
            if (TRACE_STARTUP) {
                System.out.println("Model support: Inited");
            }
            if (TopComponent.getRegistry().getOpened().size() > 0) {
                if (TRACE_STARTUP) {
                    System.out.println("Model support: Open projects in Init");
                }
                this.postponeParse = false;
                NativeProjectRegistry.getDefault().addPropertyChangeListener((PropertyChangeListener)this);
                this.openProjectsTask.schedule(0);
            } else {
                if (TRACE_STARTUP) {
                    System.out.println("Model support: Postpone open projects");
                }
                this.postponeParse = true;
                WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

                    @Override
                    public void run() {
                        if (TRACE_STARTUP) {
                            System.out.println("Model support: invoked after ready UI");
                        }
                        ModelSupport.this.postponeParse = false;
                        NativeProjectRegistry.getDefault().addPropertyChangeListener((PropertyChangeListener)ModelSupport.this);
                        ModelSupport.this.openProjectsTask.schedule(0);
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        DataObject.getRegistry().removeChangeListener((ChangeListener)this.modifiedListener);
        this.modifiedListener.clean();
        ModelImpl model = this.theModel;
        if (model != null) {
            Set<Lookup.Provider> set = this.openedProjects;
            synchronized (set) {
                this.closed = true;
            }
            model.shutdown();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        try {
            if (TRACE_STARTUP) {
                System.out.println("Model support event:" + evt.getPropertyName() + " postponeParse=" + this.postponeParse);
            }
            if (evt.getPropertyName().equals("openNativeProjects") && !this.postponeParse) {
                if (TRACE_STARTUP) {
                    System.out.println("Model support: Open projects on OpenProjects.PROPERTY_OPEN_PROJECTS");
                }
                this.openProjectsTask.schedule(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openProjects() {
        Collection projects = NativeProjectRegistry.getDefault().getOpenProjects();
        if (TRACE_STARTUP) {
            System.out.println("Model support: openProjects size=" + projects.size() + " modelState=" + CsmModelAccessor.getModelState());
        }
        Set<Lookup.Provider> set = this.openedProjects;
        synchronized (set) {
            if (this.closed) {
                return;
            }
            if (TRACE_STARTUP) {
                System.out.println("Model support: openProjects new=" + projects.size() + " now=" + this.openedProjects.size());
            }
            HashSet<Lookup.Provider> nowOpened = new HashSet<Lookup.Provider>();
            for (NativeProject project : projects) {
                Lookup.Provider makeProject = project.getProject();
                nowOpened.add(makeProject);
                if (this.openedProjects.contains(makeProject)) continue;
                this.addProject(makeProject);
            }
            HashSet<Lookup.Provider> toClose = new HashSet<Lookup.Provider>();
            for (Lookup.Provider project : this.openedProjects) {
                if (nowOpened.contains(project)) continue;
                toClose.add(project);
            }
            for (Lookup.Provider project : toClose) {
                this.closeProject(project);
            }
        }
    }

    public static void trace(NativeFileItem nativeFile) {
        try {
            Diagnostic.trace("  native file item" + nativeFile.getAbsolutePath());
            Diagnostic.trace("    user includes: " + nativeFile.getUserIncludePaths());
            Diagnostic.trace("    user macros: " + nativeFile.getUserMacroDefinitions());
            Diagnostic.trace("    system includes: " + nativeFile.getSystemIncludePaths());
            Diagnostic.trace("    system macros: " + nativeFile.getSystemMacroDefinitions());
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
    }

    public static void dumpNativeProject(NativeProject nativeProject) {
        System.err.println("\n\n\nDumping project " + nativeProject.getProjectDisplayName());
        System.err.println("\nSystem include paths");
        Iterator it = nativeProject.getSystemIncludePaths().iterator();
        while (it.hasNext()) {
            System.err.println("    " + it.next());
        }
        System.err.println("\nUser include paths");
        it = nativeProject.getUserIncludePaths().iterator();
        while (it.hasNext()) {
            System.err.println("    " + it.next());
        }
        System.err.println("\nSystem macros");
        it = nativeProject.getSystemMacroDefinitions().iterator();
        while (it.hasNext()) {
            System.err.println("    " + (String)it.next());
        }
        System.err.println("\nUser macros");
        it = nativeProject.getUserMacroDefinitions().iterator();
        while (it.hasNext()) {
            System.err.println("    " + (String)it.next());
        }
        ArrayList<NativeFileItem> sources = new ArrayList<NativeFileItem>();
        ArrayList<NativeFileItem> headers = new ArrayList<NativeFileItem>();
        for (NativeFileItem item : nativeProject.getAllFiles()) {
            if (item.isExcluded()) continue;
            switch (item.getLanguage()) {
                case C: 
                case CPP: 
                case FORTRAN: {
                    sources.add(item);
                    break;
                }
                case C_HEADER: {
                    headers.add(item);
                    break;
                }
            }
        }
        System.err.println("\nSources: (" + sources.size() + " files )");
        for (NativeFileItem elem : sources) {
            System.err.println(elem.getAbsolutePath());
        }
        System.err.println("\nHeaders: (" + headers.size() + " files )");
        for (NativeFileItem elem : headers) {
            System.err.println(elem.getAbsolutePath());
        }
        System.err.println("End of project dump\n\n\n");
    }

    public static NativeProject getNativeProject(Object platformProject) {
        NativeProject nativeProject;
        NativeProject nativeProject2 = nativeProject = platformProject instanceof NativeProject ? (NativeProject)platformProject : null;
        if (platformProject instanceof Project) {
            Project project = (Project)platformProject;
            nativeProject = (NativeProject)project.getLookup().lookup(NativeProject.class);
        }
        return nativeProject;
    }

    private String toString(Lookup.Provider project) {
        StringBuilder sb = new StringBuilder();
        ProjectInformation pi = ProjectUtils.getInformation((Project)((Project)project));
        if (pi != null) {
            sb.append(" Name=").append(pi.getName());
            sb.append(" DisplayName=").append(pi.getDisplayName());
        }
        return sb.toString();
    }

    private void addProject(final Lookup.Provider project) {
        NativeProject nativeProject;
        if (TraceFlags.DEBUG) {
            Diagnostic.trace("### ModelSupport.addProject: " + this.toString(project));
        }
        if ((nativeProject = (NativeProject)project.getLookup().lookup(NativeProject.class)) != null) {
            CsmModelAccessor.getModel();
            final ModelImpl model = this.theModel;
            if (model == null) {
                return;
            }
            this.openedProjects.add(project);
            if (TraceFlags.DEBUG) {
                this.dumpProjectFiles(nativeProject);
            }
            String taskName = NbBundle.getMessage(this.getClass(), (String)"MSG_CodeAssistanceInitializationTask", (Object)nativeProject.getProjectDisplayName());
            NamedRunnable task = new NamedRunnable(taskName){

                protected void runImpl() {
                    NativeProjectSettings settings = (NativeProjectSettings)project.getLookup().lookup(NativeProjectSettings.class);
                    boolean enableModel = settings == null ? true : settings.isCodeAssistanceEnabled();
                    model.addProject(nativeProject, nativeProject.getProjectDisplayName(), enableModel);
                }
            };
            nativeProject.runOnProjectReadiness(task);
        }
    }

    private void dumpProjectFiles(NativeProject nativeProject) {
        if (TraceFlags.DEBUG) {
            Diagnostic.trace("+++ Sources:");
            ArrayList<NativeFileItem> sources = new ArrayList<NativeFileItem>();
            ArrayList<NativeFileItem> headers = new ArrayList<NativeFileItem>();
            for (NativeFileItem item : nativeProject.getAllFiles()) {
                if (item.isExcluded()) continue;
                switch (item.getLanguage()) {
                    case C: 
                    case CPP: 
                    case FORTRAN: {
                        sources.add(item);
                        break;
                    }
                    case C_HEADER: {
                        headers.add(item);
                        break;
                    }
                }
            }
            for (NativeFileItem elem : sources) {
                ModelSupport.trace(elem);
            }
            Diagnostic.trace("+++ Headers:");
            for (NativeFileItem elem : headers) {
                ModelSupport.trace(elem);
            }
        }
    }

    private void closeProject(Lookup.Provider project) {
        ModelImpl model;
        if (TraceFlags.DEBUG) {
            Diagnostic.trace("### ModelSupport.closeProject: " + this.toString(project));
        }
        if ((model = this.theModel) == null || model.getState() != CsmModelState.ON) {
            return;
        }
        NativeProject nativeProject = (NativeProject)project.getLookup().lookup(NativeProject.class);
        if (nativeProject != null) {
            model.closeProject(nativeProject);
        }
        this.openedProjects.remove(project);
    }

    private static FileBuffer createFileBuffer(DataObject dao) {
        StyledDocument doc;
        EditorCookie editor;
        FileObject fo = dao.getPrimaryFile();
        if (fo.isValid() && dao.isModified() && (editor = (EditorCookie)dao.getCookie(EditorCookie.class)) != null && (doc = editor.getDocument()) != null) {
            return new FileBufferDoc(fo, doc);
        }
        return new FileBufferFile(fo);
    }

    public static FileBuffer createFileBuffer(FileObject fo) {
        FileSystem fs;
        Parameters.notNull((CharSequence)"null file object", (Object)fo);
        if (fo.isValid()) {
            try {
                StyledDocument doc;
                EditorCookie editor;
                DataObject dao = DataObject.find((FileObject)fo);
                if (dao.isModified() && (editor = (EditorCookie)dao.getCookie(EditorCookie.class)) != null && (doc = editor.getDocument()) != null) {
                    return new FileBufferDoc(fo, doc);
                }
            }
            catch (DataObjectNotFoundException e) {
                // empty catch block
            }
            return new FileBufferFile(fo);
        }
        try {
            fs = fo.getFileSystem();
        }
        catch (FileStateInvalidException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            fs = InvalidFileObjectSupport.getDummyFileSystem();
        }
        return new FileBufferFile(InvalidFileObjectSupport.getInvalidFileObject((FileSystem)fs, (CharSequence)fo.getPath()));
    }

    public void onMemoryLow(LowMemoryEvent event, boolean fatal) {
        LowMemoryAlerter alerter = (LowMemoryAlerter)Lookup.getDefault().lookup(LowMemoryAlerter.class);
        if (alerter != null) {
            alerter.alert(event, fatal);
        }
    }

    public static void traceDataObjectRegistryStateChanged(ChangeEvent e) {
        Diagnostic.trace("state of registry changed:");
        Diagnostic.indent();
        if (e != null) {
            DataObject[] objs = DataObject.getRegistry().getModified();
            if (objs.length == 0) {
                Diagnostic.trace("all objects are saved");
            } else {
                Diagnostic.trace("set of edited objects:");
                for (int i = 0; i < objs.length; ++i) {
                    DataObject curObj = objs[i];
                    Diagnostic.trace("object " + i + ":" + curObj.getName());
                    Diagnostic.indent();
                    Diagnostic.trace("with file: " + curObj.getPrimaryFile());
                    NativeFileItemSet set = (NativeFileItemSet)curObj.getNodeDelegate().getLookup().lookup(NativeFileItemSet.class);
                    if (set == null) {
                        Diagnostic.trace("NativeFileItemSet == null");
                    } else {
                        Diagnostic.trace("NativeFileItemSet:");
                        for (NativeFileItem item : set.getItems()) {
                            Diagnostic.trace("\t" + item.getNativeProject().getProjectDisplayName());
                        }
                    }
                    EditorCookie editor = (EditorCookie)curObj.getCookie(EditorCookie.class);
                    Diagnostic.trace("has editor support: " + editor);
                    StyledDocument doc = editor != null ? editor.getDocument() : null;
                    Diagnostic.trace("with document: " + doc);
                    Diagnostic.unindent();
                }
            }
        } else {
            Diagnostic.trace("no additional info from event object");
        }
        Diagnostic.unindent();
    }

    private class ExternalUpdateListener
    extends FileChangeAdapter
    implements Runnable {
        private boolean isRunning;
        private final Map<FileObject, Boolean> changedFileObjects = new HashMap<FileObject, Boolean>();
        private final Map<FileObject, Long> eventTimes = new WeakHashMap<FileObject, Long>();

        private ExternalUpdateListener() {
        }

        public void fileChanged(FileEvent fe) {
            FileObject fo;
            ModelImpl model;
            if (TraceFlags.TRACE_EXTERNAL_CHANGES) {
                System.err.printf("External updates: fileChanged %s\n", fe);
            }
            if ((model = ModelSupport.this.theModel) != null && this.isCOrCpp(fo = fe.getFile())) {
                this.scheduleUpdate(fo, fe.getTime(), false);
            }
        }

        public void fileDataCreated(FileEvent fe) {
            FileObject fo;
            ModelImpl model;
            if (TraceFlags.TRACE_EXTERNAL_CHANGES) {
                System.err.printf("External updates: fileDataCreated %s\n", fe);
            }
            if ((model = ModelSupport.this.theModel) != null && this.isCOrCpp(fo = fe.getFile())) {
                this.scheduleUpdate(fo, fe.getTime(), true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void scheduleUpdate(FileObject fo, long eventTime, boolean isCreated) {
            ModelImpl model = ModelSupport.this.theModel;
            if (model != null) {
                ExternalUpdateListener externalUpdateListener = this;
                synchronized (externalUpdateListener) {
                    Long lastEvent = this.eventTimes.get(fo);
                    if (lastEvent != null && eventTime - lastEvent <= 500L) {
                        if (TraceFlags.TRACE_EXTERNAL_CHANGES) {
                            System.err.printf("External updates: SKIP EVENT By oldT:%s and newT:%d\n", lastEvent, eventTime);
                        }
                        return;
                    }
                    this.eventTimes.put(fo, eventTime);
                    if (TraceFlags.TRACE_EXTERNAL_CHANGES) {
                        System.err.printf("External updates: scheduling update for %s\n", fo);
                    }
                    if (!this.changedFileObjects.containsKey(fo)) {
                        this.changedFileObjects.put(fo, isCreated);
                    }
                    if (!this.isRunning) {
                        this.isRunning = true;
                        model.enqueueModelTask(this, "External File Updater");
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            if (TraceFlags.TRACE_EXTERNAL_CHANGES) {
                System.err.printf("External updates: running update task\n", new Object[0]);
            }
            block5: while (true) {
                var3_3 = this;
                synchronized (var3_3) {
                    if (this.changedFileObjects.isEmpty()) {
                        this.isRunning = false;
                        break;
                    }
                    it = this.changedFileObjects.entrySet().iterator();
                    entry = it.next();
                    fo = entry.getKey();
                    created = entry.getValue();
                    it.remove();
                }
                if (fo == null) continue;
                if (TraceFlags.TRACE_EXTERNAL_CHANGES) {
                    System.err.printf("Updating for %s\n", new Object[]{fo});
                }
                if (created) {
                    project = (ProjectBase)CsmUtilities.getCsmProject((FileObject)fo);
                    if (project != null) {
                        project.onFileExternalCreate(fo);
                        continue;
                    }
                    CndFileUtils.clearFileExistenceCache();
                    continue;
                }
                try {
                    files = CsmUtilities.getCsmFiles((DataObject)DataObject.find((FileObject)fo), (boolean)false, (boolean)false);
                }
                catch (DataObjectNotFoundException ex) {
                    files = new CsmFile[]{};
                }
                i = 0;
                while (true) {
                    if (i < files.length) ** break;
                    continue block5;
                    file = (FileImpl)files[i];
                    project = file.getProjectImpl(true);
                    project.onFileExternalChange(file);
                    ++i;
                }
                break;
            }
            if (TraceFlags.TRACE_EXTERNAL_CHANGES) {
                System.err.printf("External updates: update task finished\n", new Object[0]);
            }
        }

        private boolean isCOrCpp(FileObject fo) {
            String mime = fo.getMIMEType();
            if (mime == null) {
                mime = FileUtil.getMIMEType((FileObject)fo);
                if (TraceFlags.TRACE_EXTERNAL_CHANGES) {
                    System.err.printf("MIME resolved: %s\n", mime);
                }
            }
            return MIMENames.isFortranOrHeaderOrCppOrC((String)mime);
        }
    }

    private class ModifiedObjectsChangeListener
    implements ChangeListener {
        private final Map<DataObject, Collection<BufAndProj>> buffers = new HashMap<DataObject, Collection<BufAndProj>>();

        private ModifiedObjectsChangeListener() {
        }

        private Collection<BufAndProj> getBufNP(DataObject dao) {
            Collection<BufAndProj> bufNPcoll = this.buffers.get(dao);
            return bufNPcoll == null ? Collections.emptyList() : bufNPcoll;
        }

        private void addBufNP(DataObject dao, BufAndProj bufNP) {
            Collection<BufAndProj> bufNPcoll = this.buffers.get(dao);
            if (bufNPcoll == null) {
                bufNPcoll = new ArrayList<BufAndProj>();
                this.buffers.put(dao, bufNPcoll);
            }
            bufNPcoll.add(bufNP);
        }

        private void editStart(DataObject curObj) {
            ModelImpl model = ModelSupport.this.theModel;
            if (model == null) {
                return;
            }
            if (!curObj.isValid()) {
                return;
            }
            NativeFileItemSet set = (NativeFileItemSet)curObj.getLookup().lookup(NativeFileItemSet.class);
            if (set == null) {
                set = this.findCanonicalSet(curObj);
            }
            if (set != null && !set.isEmpty()) {
                StyledDocument doc;
                EditorCookie editor = (EditorCookie)curObj.getCookie(EditorCookie.class);
                StyledDocument styledDocument = doc = editor != null ? editor.getDocument() : null;
                if (doc.getProperty("cnd.refactoring.modification.event") != Boolean.TRUE) {
                    FileObject primaryFile = curObj.getPrimaryFile();
                    long lastModified = primaryFile.lastModified().getTime();
                    FileBufferDoc buffer = new FileBufferDoc(primaryFile, doc);
                    for (NativeFileItem nativeFile : set.getItems()) {
                        ProjectBase csmProject = (ProjectBase)model.getProject(nativeFile.getNativeProject());
                        if (csmProject == null) continue;
                        this.addBufNP(curObj, new BufAndProj(buffer, csmProject, nativeFile, lastModified));
                        csmProject.onFileEditStart(buffer, nativeFile);
                    }
                }
            }
        }

        private boolean isCndDataObject(FileObject fo) {
            String type = fo.getMIMEType();
            return MIMENames.isFortranOrHeaderOrCppOrC((String)type);
        }

        private NativeFileItemSet findCanonicalSet(DataObject curObj) {
            FileObject fo = curObj.getPrimaryFile();
            if (fo != null && this.isCndDataObject(fo)) {
                try {
                    fo = CndFileUtils.getCanonicalFileObject((FileObject)fo);
                    curObj = DataObject.find((FileObject)fo);
                    return (NativeFileItemSet)curObj.getLookup().lookup(NativeFileItemSet.class);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return null;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (TraceFlags.DEBUG) {
                ModelSupport.traceDataObjectRegistryStateChanged(e);
            }
            if (e != null) {
                Object[] objs = DataObject.getRegistry().getModified();
                HashSet<DataObject> toDelete = new HashSet<DataObject>();
                for (DataObject dao : this.buffers.keySet()) {
                    if (this.contains(objs, dao)) continue;
                    for (BufAndProj bufNP : this.getBufNP(dao)) {
                        if (bufNP != null) {
                            FileBuffer fileBuffer = ModelSupport.createFileBuffer(dao);
                            long lastModified = fileBuffer.lastModified();
                            bufNP.project.onFileEditEnd(fileBuffer, bufNP.nativeFile, bufNP.lastModified == lastModified);
                            continue;
                        }
                        System.err.println("no buffer for " + dao);
                    }
                    toDelete.add(dao);
                }
                Iterator<Object> iter = toDelete.iterator();
                while (iter.hasNext()) {
                    this.buffers.remove(iter.next());
                }
                for (int i = 0; i < objs.length; ++i) {
                    if (this.buffers.containsKey(objs[i])) continue;
                    this.editStart((DataObject)objs[i]);
                }
            }
        }

        private boolean contains(Object[] objs, Object o) {
            for (int i = 0; i < objs.length; ++i) {
                if (!objs[i].equals(o)) continue;
                return true;
            }
            return false;
        }

        private void clean() {
            this.buffers.clear();
        }
    }

    private static final class BufAndProj {
        public final FileBuffer buffer;
        public final ProjectBase project;
        public final NativeFileItem nativeFile;
        public final long lastModified;

        public BufAndProj(FileBuffer buffer, ProjectBase project, NativeFileItem nativeFile, long lastModified) {
            assert (buffer != null) : "null buffer";
            this.buffer = buffer;
            assert (project != null) : "null project";
            this.project = project;
            assert (nativeFile != null) : "null nativeFile";
            this.nativeFile = nativeFile;
            this.lastModified = lastModified;
        }
    }
}

