/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.parser.apt;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Level;
import org.netbeans.modules.cnd.apt.structure.APTFile;
import org.netbeans.modules.cnd.apt.structure.APTInclude;
import org.netbeans.modules.cnd.apt.support.APTAbstractWalker;
import org.netbeans.modules.cnd.apt.support.APTDriver;
import org.netbeans.modules.cnd.apt.support.APTFileBuffer;
import org.netbeans.modules.cnd.apt.support.APTFileCacheEntry;
import org.netbeans.modules.cnd.apt.support.APTFileCacheManager;
import org.netbeans.modules.cnd.apt.support.APTIncludeHandler;
import org.netbeans.modules.cnd.apt.support.APTPreprocHandler;
import org.netbeans.modules.cnd.apt.support.APTWalker;
import org.netbeans.modules.cnd.apt.support.PostIncludeData;
import org.netbeans.modules.cnd.apt.support.ResolvedPath;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.platform.ModelSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;

public class APTSelfWalker
extends APTAbstractWalker {
    protected APTSelfWalker(APTFile apt, APTPreprocHandler preprocHandler, APTFileCacheEntry cacheEntry) {
        super(apt, preprocHandler, cacheEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean include(ResolvedPath resolvedPath, APTInclude aptInclude, PostIncludeData postIncludeState) {
        if (resolvedPath != null) {
            CharSequence path = resolvedPath.getPath();
            FileObject fileObject = resolvedPath.getFileObject();
            if (fileObject != null) {
                APTIncludeHandler.IncludeState pushInclude = this.getIncludeHandler().pushInclude(path, aptInclude, resolvedPath.getIndex());
                if (pushInclude == APTIncludeHandler.IncludeState.Success) {
                    try {
                        APTFile apt = APTDriver.findAPTLight((APTFileBuffer)ModelSupport.createFileBuffer(fileObject));
                        APTPreprocHandler preprocHandler = this.getPreprocHandler();
                        APTFileCacheEntry cache = APTFileCacheManager.getInstance((FileSystem)resolvedPath.getFileSystem()).getEntry(path, preprocHandler, null);
                        this.createIncludeWalker(apt, this, path, cache).visit();
                    }
                    catch (FileNotFoundException ex) {
                        APTUtils.LOG.log(Level.WARNING, "APTSelfWalker: file {0} not found", new Object[]{path});
                        DiagnosticExceptoins.register(ex);
                    }
                    catch (IOException ex) {
                        APTUtils.LOG.log(Level.SEVERE, "APTSelfWalker: error on including {0}:\n{1}", new Object[]{path, ex});
                        DiagnosticExceptoins.register(ex);
                    }
                    finally {
                        this.getIncludeHandler().popInclude();
                    }
                }
                return postIncludeState == null || !postIncludeState.hasPostIncludeMacroState();
            }
        }
        return false;
    }

    protected APTWalker createIncludeWalker(APTFile apt, APTSelfWalker parent, CharSequence includePath, APTFileCacheEntry cache) {
        return new APTSelfWalker(apt, parent.getPreprocHandler(), cache);
    }

    protected boolean hasIncludeActionSideEffects() {
        return false;
    }
}

