/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.parser.apt;

import java.io.IOException;
import java.util.LinkedList;
import org.netbeans.modules.cnd.apt.structure.APTFile;
import org.netbeans.modules.cnd.apt.structure.APTInclude;
import org.netbeans.modules.cnd.apt.support.APTFileCacheEntry;
import org.netbeans.modules.cnd.apt.support.APTHandlersSupport;
import org.netbeans.modules.cnd.apt.support.APTIncludeHandler;
import org.netbeans.modules.cnd.apt.support.APTPreprocHandler;
import org.netbeans.modules.cnd.apt.support.PostIncludeData;
import org.netbeans.modules.cnd.apt.support.ResolvedPath;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.parser.apt.APTProjectFileBasedWalker;
import org.netbeans.modules.cnd.modelimpl.parser.apt.APTSelfWalker;

public class APTRestorePreprocStateWalker
extends APTProjectFileBasedWalker {
    private final String interestedFile;
    private final LinkedList<APTIncludeHandler.IncludeInfo> inclStack;
    private final APTIncludeHandler.IncludeInfo stopDirective;
    private final boolean searchInterestedFile;

    public APTRestorePreprocStateWalker(ProjectBase base, APTFile apt, FileImpl file, APTPreprocHandler preprocHandler, LinkedList<APTIncludeHandler.IncludeInfo> inclStack, String interestedFile, APTFileCacheEntry cacheEntry) {
        super(base, apt, file, preprocHandler, cacheEntry);
        this.searchInterestedFile = true;
        this.interestedFile = interestedFile;
        this.inclStack = inclStack;
        assert (!inclStack.isEmpty());
        this.stopDirective = this.inclStack.removeLast();
        assert (this.stopDirective != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected FileImpl includeAction(ProjectBase inclFileOwner, CharSequence inclPath, int mode, APTInclude apt, PostIncludeData postIncludeState) throws IOException {
        FileImpl csmFile = null;
        boolean foundDirective = false;
        if (this.searchInterestedFile && apt.getToken().getLine() == this.stopDirective.getIncludeDirectiveLine()) {
            if (inclPath.equals(this.stopDirective.getIncludedPath())) {
                foundDirective = true;
            } else {
                APTHandlersSupport.invalidatePreprocHandler((APTPreprocHandler)this.getPreprocHandler());
                super.stop();
                return null;
            }
        }
        try {
            csmFile = inclFileOwner.getFile(inclPath, false);
            if (csmFile == null) {
                FileImpl fileImpl = null;
                return fileImpl;
            }
            if (foundDirective) {
                assert (this.inclStack != null);
                if (!this.inclStack.isEmpty()) {
                    APTFile aptLight = inclFileOwner.getAPTLight(csmFile);
                    if (aptLight != null) {
                        APTPreprocHandler preprocHandler = this.getPreprocHandler();
                        APTFileCacheEntry cacheEntry = csmFile.getAPTCacheEntry(preprocHandler, null);
                        APTRestorePreprocStateWalker walker = new APTRestorePreprocStateWalker(this.getStartProject(), aptLight, csmFile, preprocHandler, this.inclStack, this.interestedFile, cacheEntry);
                        walker.visit();
                    } else {
                        csmFile = null;
                    }
                }
            } else {
                APTFile aptLight = inclFileOwner.getAPTLight(csmFile);
                if (aptLight != null) {
                    APTPreprocHandler preprocHandler = this.getPreprocHandler();
                    APTFileCacheEntry cacheEntry = csmFile.getAPTCacheEntry(preprocHandler, null);
                    APTSelfWalker walker = new APTSelfWalker(aptLight, preprocHandler, cacheEntry);
                    walker.visit();
                } else {
                    csmFile = null;
                }
            }
        }
        finally {
            if (foundDirective) {
                super.stop();
            } else {
                this.getIncludeHandler().popInclude();
            }
        }
        return csmFile;
    }

    protected boolean hasIncludeActionSideEffects() {
        return this.searchInterestedFile;
    }

    public void visit() {
        super.visit();
        if (this.searchInterestedFile && !super.isStopped()) {
            APTHandlersSupport.invalidatePreprocHandler((APTPreprocHandler)this.getPreprocHandler());
        }
    }

    @Override
    protected boolean include(ResolvedPath resolvedPath, APTInclude apt, PostIncludeData postIncludeState) {
        boolean ret = super.include(resolvedPath, apt, postIncludeState);
        if (this.hasIncludeActionSideEffects() && this.isStopped()) {
            ret = false;
        }
        return ret;
    }
}

