/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.impl.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.deep.CsmCompoundStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmGotoStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmIfStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmLabel;
import org.netbeans.modules.cnd.api.model.deep.CsmLoopStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmSwitchStatement;
import org.netbeans.modules.cnd.api.model.xref.CsmLabelResolver;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceSupport;
import org.openide.util.CharSequences;

public final class LabelResolverImpl
extends CsmLabelResolver {
    public Collection<CsmReference> getLabels(CsmFunctionDefinition referencedFunction, CharSequence label, Set<CsmLabelResolver.LabelKind> kinds) {
        Context res = new Context(referencedFunction, label, kinds);
        if (referencedFunction != null) {
            this.processInnerStatements((CsmStatement)referencedFunction.getBody(), res);
        }
        return res.collection;
    }

    private void processInnerStatements(CsmStatement statement, Context res) {
        if (statement != null) {
            switch (statement.getKind()) {
                case LABEL: {
                    res.addLabelDefinition((CsmLabel)statement);
                    break;
                }
                case GOTO: {
                    res.addLabelReference((CsmGotoStatement)statement);
                    break;
                }
                case COMPOUND: {
                    for (CsmStatement stmt : ((CsmCompoundStatement)statement).getStatements()) {
                        this.processInnerStatements(stmt, res);
                    }
                    break;
                }
                case WHILE: 
                case DO_WHILE: 
                case FOR: {
                    this.processInnerStatements(((CsmLoopStatement)statement).getBody(), res);
                    break;
                }
                case IF: {
                    this.processInnerStatements(((CsmIfStatement)statement).getThen(), res);
                    this.processInnerStatements(((CsmIfStatement)statement).getElse(), res);
                    break;
                }
                case SWITCH: {
                    this.processInnerStatements(((CsmSwitchStatement)statement).getBody(), res);
                    break;
                }
            }
        }
    }

    private static final class Context {
        private final Collection<CsmReference> collection = new ArrayList<CsmReference>();
        private final CharSequence label;
        private final Set<CsmLabelResolver.LabelKind> kinds;

        private Context(CsmFunctionDefinition owner, CharSequence label, Set<CsmLabelResolver.LabelKind> kinds) {
            this.label = label;
            this.kinds = kinds;
        }

        private void addLabelDefinition(CsmLabel stmt) {
            if (this.kinds.contains(CsmLabelResolver.LabelKind.Definiton) && (this.label == null || CharSequences.comparator().compare(this.label, stmt.getLabel()) == 0)) {
                this.collection.add(CsmReferenceSupport.createObjectReference((CsmOffsetable)stmt));
            }
        }

        private void addLabelReference(CsmGotoStatement stmt) {
            if (this.kinds.contains(CsmLabelResolver.LabelKind.Reference) && (this.label == null || CharSequences.comparator().compare(this.label, stmt.getLabel()) == 0)) {
                this.collection.add(CsmReferenceSupport.createObjectReference((CsmOffsetable)stmt));
            }
        }
    }
}

