/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.impl.services;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.modules.cnd.antlr.Token;
import org.netbeans.modules.cnd.antlr.TokenStream;
import org.netbeans.modules.cnd.antlr.TokenStreamException;
import org.netbeans.modules.cnd.api.model.CsmErrorDirective;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.services.CsmCompilationUnit;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.apt.structure.APTFile;
import org.netbeans.modules.cnd.apt.support.APTDriver;
import org.netbeans.modules.cnd.apt.support.APTFileBuffer;
import org.netbeans.modules.cnd.apt.support.APTHandlersSupport;
import org.netbeans.modules.cnd.apt.support.APTIncludeHandler;
import org.netbeans.modules.cnd.apt.support.APTPreprocHandler;
import org.netbeans.modules.cnd.apt.support.APTToken;
import org.netbeans.modules.cnd.apt.support.StartEntry;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.FilePreprocessorConditionState;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.PreprocessorStatePair;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.parser.apt.APTFindMacrosWalker;
import org.netbeans.modules.cnd.modelimpl.parser.apt.GuardBlockWalker;
import org.netbeans.modules.cnd.modelimpl.uid.UIDUtilities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.FSPath;

public final class FileInfoQueryImpl
extends CsmFileInfoQuery {
    private final ConcurrentMap<CsmFile, Object> macroUsagesLocks = new ConcurrentHashMap<CsmFile, Object>();

    public List<FSPath> getSystemIncludePaths(CsmFile file) {
        return this.getIncludePaths(file, true);
    }

    public List<FSPath> getUserIncludePaths(CsmFile file) {
        return this.getIncludePaths(file, false);
    }

    private List<FSPath> getIncludePaths(CsmFile file, boolean system) {
        NativeFileItem item;
        List out = Collections.emptyList();
        if (file instanceof FileImpl && (item = Utils.getCompiledFileItem((FileImpl)file)) != null) {
            if (item.getLanguage() == NativeFileItem.Language.C_HEADER) {
                NativeProject nativeProject = item.getNativeProject();
                if (nativeProject != null) {
                    out = system ? nativeProject.getSystemIncludePaths() : nativeProject.getUserIncludePaths();
                }
            } else {
                out = system ? item.getSystemIncludePaths() : item.getUserIncludePaths();
            }
        }
        return out;
    }

    public List<CsmOffsetable> getUnusedCodeBlocks(CsmFile file) {
        List<CsmOffsetable> out = Collections.emptyList();
        if (file instanceof FileImpl) {
            FileImpl fileImpl = (FileImpl)file;
            Collection<PreprocessorStatePair> statePairs = fileImpl.getPreprocStatePairs();
            List<CsmOffsetable> result = new ArrayList<CsmOffsetable>();
            boolean first = true;
            for (PreprocessorStatePair pair : statePairs) {
                FilePreprocessorConditionState state = pair.pcState;
                if (state == FilePreprocessorConditionState.PARSING) continue;
                List<CsmOffsetable> blocks = state.createBlocksForFile(fileImpl);
                if (first) {
                    result = blocks;
                    first = false;
                    continue;
                }
                if (!(result = FileInfoQueryImpl.intersection(result, blocks)).isEmpty()) continue;
                break;
            }
            CsmOffsetable error = null;
            Iterator<CsmErrorDirective> i$ = fileImpl.getErrors().iterator();
            if (i$.hasNext()) {
                CsmErrorDirective csmErrorDirective = i$.next();
                error = Utils.createOffsetable(fileImpl, csmErrorDirective.getEndOffset(), Integer.MAX_VALUE);
            }
            if (error != null) {
                CsmOffsetable offs;
                out = new ArrayList<CsmOffsetable>(result.size());
                i$ = result.iterator();
                while (i$.hasNext() && (offs = (CsmOffsetable)i$.next()).getEndOffset() < error.getStartOffset()) {
                    out.add(offs);
                }
                out.add(error);
            } else {
                out = result;
            }
        }
        return out;
    }

    private static boolean contains(CsmOffsetable bigger, CsmOffsetable smaller) {
        return bigger != null && smaller != null && bigger.getStartOffset() <= smaller.getStartOffset() && smaller.getEndOffset() <= bigger.getEndOffset();
    }

    private static List<CsmOffsetable> intersection(Collection<CsmOffsetable> first, Collection<CsmOffsetable> second) {
        ArrayList<CsmOffsetable> result = new ArrayList<CsmOffsetable>(Math.max(first.size(), second.size()));
        for (CsmOffsetable o1 : first) {
            for (CsmOffsetable o2 : second) {
                if (o1 == null) continue;
                if (o1.equals(o2)) {
                    result.add(o1);
                    continue;
                }
                if (FileInfoQueryImpl.contains(o1, o2)) {
                    result.add(o2);
                    continue;
                }
                if (!FileInfoQueryImpl.contains(o2, o1)) continue;
                result.add(o1);
            }
        }
        return result;
    }

    public CharSequence getName(CsmUID<CsmFile> fileUID) {
        return FileInfoQueryImpl.getFileName(fileUID);
    }

    public static CharSequence getFileName(CsmUID<CsmFile> fileUID) {
        CharSequence filePath = UIDUtilities.getFileName(fileUID);
        int indx = CharSequenceUtilities.lastIndexOf((CharSequence)filePath, (int)47);
        if (indx < 0) {
            indx = CharSequenceUtilities.lastIndexOf((CharSequence)filePath, (int)92);
        }
        if (indx > 0 && indx < filePath.length()) {
            filePath = CharSequenceUtilities.toString((CharSequence)filePath, (int)(indx + 1), (int)filePath.length());
        }
        return filePath;
    }

    public CharSequence getAbsolutePath(CsmUID<CsmFile> fileUID) {
        return UIDUtilities.getFileName(fileUID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public List<CsmReference> getMacroUsages(CsmFile file) {
        block19: {
            out = Collections.emptyList();
            if (!(file instanceof FileImpl)) break block19;
            fileImpl = (FileImpl)file;
            lock = new NamedLock(file.getAbsolutePath());
            prevLock = this.macroUsagesLocks.putIfAbsent(fileImpl, lock);
            lock = prevLock != null ? prevLock : lock;
            var6_6 = lock;
            synchronized (var6_6) {
                res = fileImpl.getLastMacroUsages();
                if (res == null) ** break block16
                var8_8 = res;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 6] lbl14 : MonitorExitStatement: MONITOREXIT : var6_6
                this.macroUsagesLocks.remove(fileImpl, lock);
            }
            return var8_8;
            {
                lastParsedTime = fileImpl.getLastParsedTime();
                apt = APTDriver.findAPT((APTFileBuffer)fileImpl.getBuffer(), (String)fileImpl.getFileLanguage());
                if (apt == null) ** GOTO lbl52
                handlers = fileImpl.getPreprocHandlers();
                if (!handlers.isEmpty()) ** break block17
                DiagnosticExceptoins.register(new IllegalStateException("Empty preprocessor handlers for " + file.getAbsolutePath()));
                var12_14 = Collections.emptyList();
                // MONITOREXIT @DISABLED, blocks:[2, 6] lbl26 : MonitorExitStatement: MONITOREXIT : var6_6
                this.macroUsagesLocks.remove(fileImpl, lock);
            }
            return var12_14;
            {
                try {
                    if (handlers.size() == 1) {
                        handler = handlers.iterator().next();
                        cacheEntry = fileImpl.getAPTCacheEntry(handler, Boolean.FALSE);
                        walker = new APTFindMacrosWalker(apt, fileImpl, handler, cacheEntry);
                        out = walker.collectMacros();
                        fileImpl.setAPTCacheEntry(handler, cacheEntry, false);
                    } else {
                        comparator = new OffsetableComparator<T>();
                        result = new TreeSet<T>(comparator);
                        for (APTPreprocHandler handler : handlers) {
                            cacheEntry = fileImpl.getAPTCacheEntry(handler, Boolean.FALSE);
                            walker = new APTFindMacrosWalker(apt, fileImpl, handler, cacheEntry);
                            result.addAll(walker.collectMacros());
                            fileImpl.setAPTCacheEntry(handler, cacheEntry, false);
                        }
                        out = new ArrayList<T>(result);
                    }
lbl52:
                    // 3 sources

                    if (lastParsedTime == fileImpl.getLastParsedTime()) {
                        fileImpl.setLastMacroUsages(out);
                    }
                }
                catch (FileNotFoundException ex) {
                }
                catch (IOException ex) {
                    System.err.println("skip marking macros\nreason:" + ex.getMessage());
                    DiagnosticExceptoins.register(ex);
                }
                break block19;
                {
                    catch (Throwable var18_24) {
                        throw var18_24;
                    }
                }
            }
            {
                finally {
                    this.macroUsagesLocks.remove(fileImpl, lock);
                }
            }
        }
        return out;
    }

    public CsmOffsetable getGuardOffset(CsmFile file) {
        if (file instanceof FileImpl) {
            FileImpl fileImpl = (FileImpl)file;
            try {
                APTFile apt = APTDriver.findAPT((APTFileBuffer)fileImpl.getBuffer(), (String)fileImpl.getFileLanguage());
                GuardBlockWalker guardWalker = new GuardBlockWalker(apt);
                TokenStream ts = guardWalker.getTokenStream();
                try {
                    Token token = ts.nextToken();
                    while (!APTUtils.isEOF((Token)token)) {
                        if (!APTUtils.isCommentToken((Token)token)) {
                            guardWalker.clearGuard();
                            break;
                        }
                        token = ts.nextToken();
                    }
                }
                catch (TokenStreamException ex) {
                    guardWalker.clearGuard();
                }
                Token guard = guardWalker.getGuard();
                if (guard != null && guard instanceof APTToken) {
                    APTToken aptGuard = (APTToken)guard;
                    return OffsetableBase.create(file, aptGuard.getOffset(), aptGuard.getEndOffset());
                }
            }
            catch (FileNotFoundException ex) {
            }
            catch (IOException ex) {
                System.err.println("IOExeption in getGuardOffset:" + ex.getMessage());
            }
        }
        return null;
    }

    public NativeFileItem getNativeFileItem(CsmFile file) {
        if (file instanceof FileImpl) {
            return ((FileImpl)file).getNativeFileItem();
        }
        return null;
    }

    public Collection<CsmCompilationUnit> getCompilationUnits(CsmFile file, int contextOffset) {
        CsmCompilationUnit backup = CsmCompilationUnit.createCompilationUnit((CsmProject)file.getProject(), (CharSequence)file.getAbsolutePath(), (CsmFile)file);
        ArrayList<CsmCompilationUnit> out = new ArrayList<CsmCompilationUnit>(1);
        boolean addBackup = true;
        if (file instanceof FileImpl) {
            FileImpl impl = (FileImpl)file;
            Collection<APTPreprocHandler.State> states = ((ProjectBase)impl.getProject()).getPreprocStates(impl);
            for (APTPreprocHandler.State state : states) {
                StartEntry startEntry = APTHandlersSupport.extractStartEntry((APTPreprocHandler.State)state);
                ProjectBase startProject = Utils.getStartProject(startEntry);
                if (startProject == null) continue;
                CharSequence path = startEntry.getStartFile();
                FileImpl startFile = startProject.getFile(path, false);
                if (startFile != null) {
                    addBackup = false;
                }
                CsmCompilationUnit cu = CsmCompilationUnit.createCompilationUnit((CsmProject)startProject, (CharSequence)path, (CsmFile)startFile);
                out.add(cu);
            }
        }
        if (addBackup) {
            out.add(backup);
        }
        return out;
    }

    public List<CsmInclude> getIncludeStack(CsmFile file) {
        if (file instanceof FileImpl) {
            FileImpl startFile;
            FileImpl impl = (FileImpl)file;
            Collection<APTPreprocHandler.State> preprocStates = ((ProjectBase)impl.getProject()).getPreprocStates(impl);
            if (preprocStates.isEmpty()) {
                return Collections.emptyList();
            }
            APTPreprocHandler.State state = preprocStates.iterator().next();
            CndUtils.assertNotNull((Object)state, (String)"state must not be null in non empty collection");
            LinkedList reverseInclStack = APTHandlersSupport.extractIncludeStack((APTPreprocHandler.State)state);
            StartEntry startEntry = APTHandlersSupport.extractStartEntry((APTPreprocHandler.State)state);
            ProjectBase startProject = Utils.getStartProject(startEntry);
            if (startProject != null && (startFile = startProject.getFile(startEntry.getStartFile(), false)) != null) {
                ArrayList<CsmInclude> res = new ArrayList<CsmInclude>();
                for (APTIncludeHandler.IncludeInfo info : reverseInclStack) {
                    int offset = info.getIncludeDirectiveOffset();
                    CsmInclude find = null;
                    for (CsmInclude inc : startFile.getIncludes()) {
                        if (offset != inc.getStartOffset()) continue;
                        find = inc;
                        break;
                    }
                    if (find == null) break;
                    res.add(find);
                    startFile = find.getIncludeFile();
                    if (startFile != null) continue;
                    break;
                }
                return res;
            }
        }
        return Collections.emptyList();
    }

    public boolean hasBrokenIncludes(CsmFile file) {
        if (file instanceof FileImpl) {
            return ((FileImpl)file).hasBrokenIncludes();
        }
        return false;
    }

    public Collection<CsmInclude> getBrokenIncludes(CsmFile file) {
        if (file instanceof FileImpl && ((FileImpl)file).hasBrokenIncludes()) {
            return ((FileImpl)file).getBrokenIncludes();
        }
        return Collections.emptyList();
    }

    public long getFileVersion(CsmFile file) {
        if (file instanceof FileImpl) {
            return FileImpl.getLongParseCount();
        }
        return 0L;
    }

    public long getOffset(CsmFile file, int line, int column) {
        if (file instanceof FileImpl) {
            return ((FileImpl)file).getOffset(line, column);
        }
        return 0L;
    }

    private static class OffsetableComparator<T extends CsmOffsetable>
    implements Comparator<T> {
        private OffsetableComparator() {
        }

        @Override
        public int compare(CsmOffsetable o1, CsmOffsetable o2) {
            int diff = o1.getStartOffset() - o2.getStartOffset();
            if (diff == 0) {
                return o1.getEndOffset() - o2.getEndOffset();
            }
            return diff;
        }
    }

    private static final class NamedLock {
        private final CharSequence name;

        public NamedLock(CharSequence name) {
            this.name = name;
        }

        public String toString() {
            return "getMacroUsages lock for " + this.name;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NamedLock other = (NamedLock)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public int hashCode() {
            int hash = 5;
            hash = 97 * hash + (this.name != null ? this.name.hashCode() : 0);
            return hash;
        }
    }
}

