/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.fsm;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmFunctionParameterList;
import org.netbeans.modules.cnd.api.model.CsmParameter;
import org.netbeans.modules.cnd.api.model.CsmProgram;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.deep.CsmCompoundStatement;
import org.netbeans.modules.cnd.modelimpl.csm.AstRendererException;
import org.netbeans.modules.cnd.modelimpl.csm.TypeFactory;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstUtil;
import org.netbeans.modules.cnd.modelimpl.csm.core.CsmIdentifiable;
import org.netbeans.modules.cnd.modelimpl.csm.core.Disposable;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableDeclarationBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.RawNamable;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.modelimpl.textcache.QualifiedNameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.openide.util.Exceptions;

public final class ProgramImpl<T>
extends OffsetableDeclarationBase<T>
implements CsmProgram,
CsmFunctionDefinition,
Disposable,
RawNamable {
    private final CharSequence name;
    private final CharSequence rawName;
    private CsmUID<CsmScope> scopeUID;

    private ProgramImpl(String name, CsmFile file, int startOffset, int endOffset, CsmType type, CsmScope scope) {
        super(file, startOffset, endOffset);
        this.rawName = this.name = QualifiedNameCache.getManager().getString((CharSequence)name);
        try {
            this._setScope(scope);
        }
        catch (AstRendererException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public static <T> ProgramImpl<T> create(String name, CsmFile file, int startOffset, int endOffset, CsmType type, CsmScope scope) {
        ProgramImpl<T> programImpl = new ProgramImpl<T>(name, file, startOffset, endOffset, type, scope);
        ProgramImpl.postObjectCreateRegistration(true, programImpl);
        return programImpl;
    }

    public CsmDeclaration.Kind getKind() {
        return CsmDeclaration.Kind.FUNCTION_DEFINITION;
    }

    public CharSequence getQualifiedName() {
        return this.name;
    }

    public CharSequence getName() {
        return this.name;
    }

    public CsmScope getScope() {
        return this._getScope();
    }

    public CharSequence getDeclarationText() {
        return this.name;
    }

    public CsmFunctionDefinition getDefinition() {
        return this;
    }

    public CsmFunction getDeclaration() {
        return this;
    }

    public boolean isOperator() {
        return false;
    }

    public CsmFunction.OperatorKind getOperatorKind() {
        return CsmFunction.OperatorKind.NONE;
    }

    public boolean isInline() {
        return false;
    }

    public boolean isStatic() {
        return false;
    }

    public CsmType getReturnType() {
        return TypeFactory.createBuiltinType("int", null, 0, null, this.getContainingFile());
    }

    public CsmFunctionParameterList getParameterList() {
        return null;
    }

    public Collection<CsmParameter> getParameters() {
        return Collections.emptyList();
    }

    public CharSequence getSignature() {
        return "";
    }

    public Collection<CsmScopeElement> getScopeElements() {
        return Collections.emptyList();
    }

    @Override
    public CharSequence[] getRawName() {
        return AstUtil.toRawName(this.rawName);
    }

    private void _setScope(CsmScope scope) throws AstRendererException {
        if (scope instanceof CsmIdentifiable) {
            this.scopeUID = UIDCsmConverter.scopeToUID(scope);
            assert (this.scopeUID != null || scope == null);
        }
    }

    private synchronized CsmScope _getScope() {
        CsmScope scope = UIDCsmConverter.UIDtoScope(this.scopeUID);
        return scope;
    }

    public CsmCompoundStatement getBody() {
        return null;
    }

    @Override
    public void write(RepositoryDataOutput output) throws IOException {
        super.write(output);
        assert (this.name != null);
        PersistentUtils.writeUTF(this.name, output);
        UIDObjectFactory factory = UIDObjectFactory.getDefaultFactory();
        PersistentUtils.writeUTF(this.rawName, output);
        factory.writeUID(this.scopeUID, output);
    }

    public ProgramImpl(RepositoryDataInput input) throws IOException {
        super(input);
        this.name = PersistentUtils.readUTF(input, QualifiedNameCache.getManager());
        assert (this.name != null);
        UIDObjectFactory factory = UIDObjectFactory.getDefaultFactory();
        this.rawName = PersistentUtils.readUTF(input, NameCache.getManager());
        this.scopeUID = factory.readUID(input);
    }
}

