/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.debug;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.modelimpl.csm.core.ModelImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ParserQueue;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.openide.LifecycleManager;
import org.openide.util.RequestProcessor;

public class Terminator
implements Runnable {
    private ProjectBase project;
    private static boolean timeout = false;
    private static final Object lock = new Lock();
    private static int inParse = 0;

    private Terminator(ProjectBase project) {
        this.project = project;
    }

    public static void create(ProjectBase project) {
        RequestProcessor.getDefault().post((Runnable)new Terminator(project));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = lock;
        synchronized (object) {
        }
        System.err.println("Parse started. " + ++inParse + " projects in list");
        if (TraceFlags.CLOSE_TIMEOUT > 0) {
            ActionListener terminator2 = new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent e) {
                    ((ModelImpl)CsmModelAccessor.getModel()).shutdown();
                    Object object = lock;
                    synchronized (object) {
                        timeout = true;
                    }
                }
            };
            new Timer(TraceFlags.CLOSE_TIMEOUT * 1000, terminator2).start();
        }
        this.project.waitParse();
        object = lock;
        synchronized (object) {
            System.err.println("Parse finished. " + --inParse + " projects left");
            if (inParse == 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Terminator.this.terminate();
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void terminate() {
        Object object = lock;
        synchronized (object) {
            long ptime = ParserQueue.instance().getStopWatchTime();
            System.err.println("disposing at " + ptime);
            String xmlOutput = System.getProperty("cnd.close.report.xml");
            if (xmlOutput != null) {
                try {
                    BufferedWriter out = new BufferedWriter(new FileWriter(xmlOutput, true));
                    String result = timeout ? "failed" : "passed";
                    out.write("<result>" + result + "</result>");
                    out.write("<parsetime>" + ptime + "</parsetime>");
                    out.close();
                }
                catch (IOException ex) {
                    DiagnosticExceptoins.register(ex);
                }
            }
        }
        LifecycleManager.getDefault().exit();
    }

    private static final class Lock {
        private Lock() {
        }
    }
}

