/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.io.IOException;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmQualifiedNamedElement;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.CsmVariableDefinition;
import org.netbeans.modules.cnd.api.model.deep.CsmExpression;
import org.netbeans.modules.cnd.modelimpl.csm.MutableDeclarationsContainer;
import org.netbeans.modules.cnd.modelimpl.csm.NameHolder;
import org.netbeans.modules.cnd.modelimpl.csm.TypeImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstUtil;
import org.netbeans.modules.cnd.modelimpl.csm.core.CsmIdentifiable;
import org.netbeans.modules.cnd.modelimpl.csm.core.Disposable;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableDeclarationBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.csm.deep.ExpressionBase;
import org.netbeans.modules.cnd.modelimpl.parser.CsmAST;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.openide.util.CharSequences;

public class VariableImpl<T>
extends OffsetableDeclarationBase<T>
implements CsmVariable,
Disposable {
    private final CharSequence name;
    private final CsmType type;
    private final boolean _static;
    private CsmScope scopeRef;
    private CsmUID<CsmScope> scopeUID;
    private final boolean _extern;
    private ExpressionBase initExpr;

    protected VariableImpl(CsmOffsetable pos, CsmFile file, CsmType type, CharSequence name, CsmScope scope, boolean _static, boolean _extern) {
        super(file, pos);
        this._static = _static;
        this._extern = _extern;
        this.name = NameCache.getManager().getString(name);
        this.type = type;
        this._setScope(scope);
    }

    public static <T> VariableImpl<T> create(CsmOffsetable pos, CsmFile file, CsmType type, CharSequence name, CsmScope scope, boolean _static, boolean _extern, boolean registerInProject) {
        VariableImpl<T> variableImpl = new VariableImpl<T>(pos, file, type, name, scope, _static, _extern);
        VariableImpl.postObjectCreateRegistration(registerInProject, variableImpl);
        if (registerInProject && type instanceof TypeImpl) {
            ((TypeImpl)type).setOwner(variableImpl);
        }
        return variableImpl;
    }

    protected VariableImpl(AST ast, CsmFile file, CsmType type, NameHolder name, CsmScope scope, boolean _static, boolean _extern) {
        super(file, VariableImpl.getStartOffset(ast), VariableImpl.getEndOffset(ast));
        this.initInitialValue(ast);
        this._static = _static;
        this._extern = _extern;
        this.name = NameCache.getManager().getString(name.getName());
        this.type = type;
        this._setScope(scope);
    }

    public static <T> VariableImpl<T> create(AST ast, CsmFile file, CsmType type, NameHolder name, CsmScope scope, boolean _static, boolean _extern, boolean global) {
        VariableImpl<T> variableImpl = new VariableImpl<T>(ast, file, type, name, scope, _static, _extern);
        VariableImpl.postObjectCreateRegistration(global, variableImpl);
        if (global && type instanceof TypeImpl) {
            ((TypeImpl)type).setOwner(variableImpl);
        }
        return variableImpl;
    }

    protected VariableImpl(CsmFile file, int startOffset, int endOffset, CsmType type, CharSequence name, CsmScope scope, boolean _static, boolean _extern) {
        super(file, startOffset, endOffset);
        this._static = _static;
        this._extern = _extern;
        this.name = NameCache.getManager().getString(name);
        this.type = type;
        this._setScope(scope);
    }

    public static int getStartOffset(AST node) {
        CsmAST csmAst;
        if (node != null && (csmAst = AstUtil.getFirstCsmAST(node)) != null) {
            return csmAst.getOffset();
        }
        return 0;
    }

    public static int getEndOffset(AST node) {
        int endOffset = 0;
        if (node != null) {
            AST next;
            AST lastChild = AstUtil.getLastChildRecursively(node);
            if (lastChild instanceof CsmAST) {
                endOffset = ((CsmAST)lastChild).getEndOffset();
            }
            if ((node.getType() == 542 || node.getType() == 541) && (next = node.getNextSibling()) != null && next.getType() == 6) {
                int curlyLevel = 0;
                int templateLevel = 0;
                int parenLevel = 0;
                while (next != null && (curlyLevel != 0 || next.getType() != 8) && next.getType() != 10) {
                    if (next.getType() != 16) {
                        ++curlyLevel;
                    }
                    if (next.getType() != 17) {
                        --curlyLevel;
                    }
                    if (next.getType() != 21) {
                        ++templateLevel;
                    }
                    if (next.getType() != 23) {
                        --templateLevel;
                    }
                    if (next.getType() != 12) {
                        ++parenLevel;
                    }
                    if (next.getType() != 13) {
                        --parenLevel;
                    }
                    if ((lastChild = AstUtil.getLastChildRecursively(next)) instanceof CsmAST) {
                        endOffset = ((CsmAST)lastChild).getEndOffset();
                    }
                    next = next.getNextSibling();
                }
            }
        }
        return endOffset;
    }

    @Override
    protected boolean registerInProject() {
        CsmProject project = this.getContainingFile().getProject();
        if (project instanceof ProjectBase) {
            return ((ProjectBase)project).registerDeclaration(this);
        }
        return false;
    }

    private void unregisterInProject() {
        CsmProject project = this.getContainingFile().getProject();
        if (project instanceof ProjectBase) {
            ((ProjectBase)project).unregisterDeclaration(this);
            this.cleanUID();
        }
    }

    public CharSequence getName() {
        return this.name;
    }

    public CharSequence getQualifiedName() {
        CsmScope scope = this.getScope();
        if (scope instanceof CsmNamespace || scope instanceof CsmClass) {
            return CharSequences.create((CharSequence)(((CsmQualifiedNamedElement)scope).getQualifiedName() + "::" + this.getQualifiedNamePostfix()));
        }
        return this.getName();
    }

    @Override
    public CharSequence getUniqueNameWithoutPrefix() {
        if (this.isExtern()) {
            return this.getQualifiedName() + " (EXTERN)";
        }
        return this.getQualifiedName();
    }

    public CsmType getType() {
        return this.type;
    }

    private void initInitialValue(AST node) {
        if (node != null) {
            AST lastChild;
            CsmAST startAST;
            AST next;
            int start = 0;
            int end = 0;
            AST tok = AstUtil.findChildOfType(node, 6);
            if (tok == null && (node.getType() == 542 || node.getType() == 541) && (next = node.getNextSibling()) != null && next.getType() == 6) {
                tok = next;
            }
            if (tok != null) {
                tok = tok.getNextSibling();
            }
            if (tok != null && (startAST = AstUtil.getFirstCsmAST(tok)) != null) {
                start = startAST.getOffset();
            }
            AST lastInitAst = tok;
            int curlyLevel = 0;
            int templateLevel = 0;
            int parenLevel = 0;
            while (tok != null && (curlyLevel != 0 || templateLevel != 0 || parenLevel != 0 || tok.getType() != 8) && tok.getType() != 10) {
                if (tok.getType() != 16) {
                    ++curlyLevel;
                }
                if (tok.getType() != 17) {
                    --curlyLevel;
                }
                if (tok.getType() != 21) {
                    ++templateLevel;
                }
                if (tok.getType() != 23) {
                    --templateLevel;
                }
                if (tok.getType() != 12) {
                    ++parenLevel;
                }
                if (tok.getType() != 13) {
                    --parenLevel;
                }
                lastInitAst = tok;
                tok = tok.getNextSibling();
            }
            if (lastInitAst != null && (lastChild = AstUtil.getLastChildRecursively(lastInitAst)) != null && lastChild instanceof CsmAST) {
                end = ((CsmAST)lastChild).getEndOffset();
                this.initExpr = ExpressionBase.create(start, end, this.getContainingFile(), this._getScope());
            }
        }
    }

    public CsmExpression getInitialValue() {
        return this.initExpr;
    }

    public CsmDeclaration.Kind getKind() {
        return CsmDeclaration.Kind.VARIABLE;
    }

    public String getDeclarationText() {
        return "";
    }

    public boolean isAuto() {
        return true;
    }

    public boolean isRegister() {
        return false;
    }

    public boolean isStatic() {
        return this._static;
    }

    public boolean isExtern() {
        return this._extern;
    }

    public boolean isConst() {
        CsmType _type = this.getType();
        if (_type != null) {
            return _type.isConst();
        }
        return false;
    }

    public boolean isMutable() {
        return false;
    }

    public void setScope(CsmScope scope) {
        this.unregisterInProject();
        this._setScope(scope);
        this.registerInProject();
    }

    public synchronized CsmScope getScope() {
        return this._getScope();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.onDispose();
        if (this.type != null && this.type instanceof Disposable) {
            ((Disposable)this.type).dispose();
        }
        if (this._getScope() instanceof MutableDeclarationsContainer) {
            ((MutableDeclarationsContainer)this._getScope()).removeDeclaration(this);
        }
        this.unregisterInProject();
    }

    private synchronized void onDispose() {
        if (this.scopeRef == null) {
            this.scopeRef = UIDCsmConverter.UIDtoScope(this.scopeUID);
            assert (this.scopeRef != null || this.scopeUID == null) : "empty scope for UID " + this.scopeUID;
        }
    }

    public CsmVariableDefinition getDefinition() {
        String uname = Utils.getCsmDeclarationKindkey(CsmDeclaration.Kind.VARIABLE_DEFINITION) + ':' + this.getQualifiedName();
        CsmDeclaration def = this.getContainingFile().getProject().findDeclaration((CharSequence)uname);
        return def == null ? null : (CsmVariableDefinition)def;
    }

    private synchronized CsmScope _getScope() {
        CsmScope scope = this.scopeRef;
        if (scope == null) {
            scope = UIDCsmConverter.UIDtoScope(this.scopeUID);
        }
        return scope;
    }

    private void _setScope(CsmScope scope) {
        if (scope instanceof CsmIdentifiable) {
            this.scopeUID = UIDCsmConverter.scopeToUID(scope);
            assert (this.scopeUID != null || scope == null);
        } else {
            this.scopeRef = scope;
        }
    }

    public CharSequence getDisplayText() {
        CsmType _type = this.getType();
        if (_type instanceof TypeImpl) {
            return ((TypeImpl)_type).getText(false, this.getName());
        }
        if (_type != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(_type.getText());
            CharSequence _name = this.getName();
            if (_name != null && _name.length() > 0) {
                sb.append(' ');
                sb.append(_name);
            }
            return sb;
        }
        return CharSequences.empty();
    }

    @Override
    public CharSequence getText() {
        return this.getDisplayText();
    }

    @Override
    public void write(RepositoryDataOutput output) throws IOException {
        super.write(output);
        assert (this.name != null);
        PersistentUtils.writeUTF(this.name, output);
        byte pack = (byte)((this._static ? 1 : 0) | (this._extern ? 2 : 0));
        output.writeByte((int)pack);
        PersistentUtils.writeExpression(this.initExpr, output);
        PersistentUtils.writeType(this.type, output);
        UIDObjectFactory.getDefaultFactory().writeUID(this.scopeUID, output);
    }

    public VariableImpl(RepositoryDataInput input) throws IOException {
        super(input);
        this.name = PersistentUtils.readUTF(input, NameCache.getManager());
        assert (this.name != null);
        byte pack = input.readByte();
        this._static = (pack & 1) == 1;
        this._extern = (pack & 2) == 2;
        this.initExpr = (ExpressionBase)PersistentUtils.readExpression(input);
        this.type = PersistentUtils.readType(input);
        if (this.type instanceof TypeImpl) {
            ((TypeImpl)this.type).setOwner(this);
        }
        this.scopeUID = UIDObjectFactory.getDefaultFactory().readUID(input);
        this.scopeRef = null;
    }

    @Override
    public String toString() {
        return (this.isExtern() ? "EXTERN " : "") + super.toString();
    }
}

