/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunctionPointerType;
import org.netbeans.modules.cnd.api.model.CsmParameter;
import org.netbeans.modules.cnd.api.model.CsmSpecializationParameter;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.modelimpl.csm.TypeImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstRenderer;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstUtil;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableBase;
import org.netbeans.modules.cnd.modelimpl.impl.services.InstantiationProviderImpl;
import org.netbeans.modules.cnd.modelimpl.parser.CsmAST;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;

public final class TypeFunPtrImpl
extends TypeImpl
implements CsmFunctionPointerType {
    private Collection<CsmUID<CsmParameter>> functionParameters;
    private short functionPointerDepth;

    TypeFunPtrImpl(CsmFile file, int pointerDepth, boolean reference, int arrayDepth, boolean _const, int startOffset, int endOffset) {
        super(file, pointerDepth, reference, arrayDepth, _const, startOffset, endOffset);
    }

    TypeFunPtrImpl(TypeFunPtrImpl type, int pointerDepth, boolean reference, int arrayDepth, boolean _const) {
        super(type, pointerDepth, reference, arrayDepth, _const);
        if (type.functionParameters != null) {
            this.functionParameters = new ArrayList<CsmUID<CsmParameter>>(type.functionParameters);
        }
        this.functionPointerDepth = type.functionPointerDepth;
    }

    TypeFunPtrImpl(TypeFunPtrImpl type, List<CsmSpecializationParameter> instantiationParams) {
        super(type, instantiationParams);
        if (type.functionParameters != null) {
            this.functionParameters = new ArrayList<CsmUID<CsmParameter>>(type.functionParameters);
        }
        this.functionPointerDepth = type.functionPointerDepth;
    }

    void init(AST ast, boolean inFunctionParameters, boolean inTypedef) {
        TypeFunPtrImpl.initFunctionPointerParamList(ast, this, inFunctionParameters, inTypedef);
    }

    public Collection<CsmParameter> getParameters() {
        if (this.functionParameters == null) {
            return Collections.emptyList();
        }
        return UIDCsmConverter.UIDsToDeclarations(this.functionParameters);
    }

    @Override
    public CharSequence decorateText(CharSequence classifierText, CsmType decorator, boolean canonical, CharSequence variableNameToInsert) {
        int i;
        StringBuilder sb = new StringBuilder();
        if (decorator.isConst()) {
            sb.append("const ");
        }
        sb.append(classifierText);
        for (i = 0; i < decorator.getPointerDepth(); ++i) {
            sb.append('*');
        }
        if (decorator.isReference()) {
            sb.append('&');
        }
        for (i = 0; i < decorator.getArrayDepth(); ++i) {
            sb.append(canonical ? "*" : "[]");
        }
        sb.append('(');
        for (i = 0; i < this.functionPointerDepth; ++i) {
            sb.append('*');
            if (variableNameToInsert == null) continue;
            sb.append(variableNameToInsert);
        }
        sb.append(')');
        InstantiationProviderImpl.appendParametersSignature(this.getParameters(), sb);
        return sb;
    }

    @Override
    public boolean isPointer() {
        return true;
    }

    public static boolean isFunctionPointerParamList(AST ast, boolean inFunctionParameters) {
        return TypeFunPtrImpl.isFunctionPointerParamList(ast, inFunctionParameters, false);
    }

    public static boolean isFunctionPointerParamList(AST ast, boolean inFunctionParameters, boolean inTypedef) {
        return TypeFunPtrImpl.initFunctionPointerParamList(ast, null, inFunctionParameters, inTypedef);
    }

    private static boolean initFunctionPointerParamList(AST ast, TypeFunPtrImpl instance, boolean inFunctionParams, boolean inTypedef) {
        AST next = null;
        AST brace = AstUtil.findSiblingOfType(ast, 12);
        if (brace != null) {
            next = brace.getNextSibling();
            if (next == null) {
                return false;
            }
            if (inFunctionParams && next.getType() == 500) {
                next = AstUtil.findSiblingOfType(ast, 508);
            } else if (!inTypedef || next.getType() != 500) {
                if (next.getType() == 540) {
                    do {
                        next = next.getNextSibling();
                        if (instance == null) continue;
                        instance.functionPointerDepth = (short)(instance.functionPointerDepth + 1);
                    } while (next != null && next.getType() == 540);
                } else if (inTypedef) {
                    brace = AstUtil.findLastSiblingOfType(ast, 12);
                    next = brace.getNextSibling();
                    if (next.getType() != 500) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
        }
        if (inFunctionParams && next == null) {
            next = AstUtil.findSiblingOfType(ast, 508);
        }
        if (inFunctionParams && next != null && next.getType() == 13) {
            next = next.getNextSibling();
        }
        if (next == null) {
            return false;
        }
        if (next.getType() != 542 && next.getType() != 541 && next.getType() == 508) {
            AST lookahead2;
            AST lookahead = next.getNextSibling();
            AST aST = lookahead2 = lookahead == null ? null : lookahead.getNextSibling();
            if (lookahead == null || lookahead.getType() != 13) {
                if (inFunctionParams && lookahead != null && lookahead.getType() == 12 && lookahead2 != null && lookahead2.getType() == 500) {
                    next = lookahead;
                } else {
                    next = lookahead;
                    if (next == null || next.getType() != 12) {
                        return false;
                    }
                    if ((next = next.getNextSibling()) == null) {
                        return false;
                    }
                    if (next.getType() == 500 && (next = next.getNextSibling()) == null) {
                        return false;
                    }
                    if (next.getType() != 13) {
                        return false;
                    }
                }
            }
        }
        if (inTypedef && next.getType() == 500) {
            if (instance != null) {
                instance.functionParameters = RepositoryUtils.put(AstRenderer.renderParameters(next, instance.getContainingFile(), null, false));
            }
            return true;
        }
        if ((next = next.getNextSibling()) != null && next.getType() == 13) {
            if ((next = next.getNextSibling()) != null && next.getType() == 12) {
                next = next.getNextSibling();
            }
            if (next == null) {
                return false;
            }
            if (next.getType() == 500) {
                if (instance != null) {
                    instance.functionParameters = RepositoryUtils.put(AstRenderer.renderParameters(next, instance.getContainingFile(), null, false));
                }
                return true;
            }
            return next.getType() == 13;
        }
        if (inFunctionParams && next != null && next.getType() == 500) {
            if (instance != null) {
                instance.functionParameters = RepositoryUtils.put(AstRenderer.renderParameters(next, instance.getContainingFile(), null, false));
            }
            return true;
        }
        return false;
    }

    public static int getEndOffset(AST node) {
        AST ast = node;
        if (ast == null) {
            return 0;
        }
        if (TypeFunPtrImpl.isTypeDefAST(ast)) {
            return OffsetableBase.getEndOffset(ast);
        }
        if ((ast = TypeFunPtrImpl.getLastNode(ast)) instanceof CsmAST) {
            return ((CsmAST)ast).getEndOffset();
        }
        return OffsetableBase.getEndOffset(node);
    }

    private static AST getLastNode(AST first) {
        AST last;
        for (AST token = last = first; token != null; token = token.getNextSibling()) {
            switch (token.getType()) {
                case 508: 
                case 541: 
                case 542: 
                case 543: {
                    return AstUtil.getLastChildRecursively(last);
                }
                case 13: {
                    return AstUtil.getLastChildRecursively(token);
                }
            }
            last = token;
        }
        return null;
    }

    private static boolean isTypeDefAST(AST ast) {
        return ast != null && (ast.getType() == 497 || ast.getType() == 494);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.functionParameters != null) {
            RepositoryUtils.remove(this.functionParameters);
        }
    }

    @Override
    public void write(RepositoryDataOutput output) throws IOException {
        super.write(output);
        output.writeShort((int)this.functionPointerDepth);
        UIDObjectFactory factory = UIDObjectFactory.getDefaultFactory();
        factory.writeUIDCollection(this.functionParameters, output, false);
    }

    public TypeFunPtrImpl(RepositoryDataInput input) throws IOException {
        super(input);
        this.functionPointerDepth = input.readShort();
        UIDObjectFactory factory = UIDObjectFactory.getDefaultFactory();
        int collSize = input.readInt();
        this.functionParameters = collSize < 0 ? null : factory.readUIDCollection(new ArrayList(collSize), input, collSize);
    }
}

