/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInstantiation;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmSpecializationParameter;
import org.netbeans.modules.cnd.api.model.CsmTemplate;
import org.netbeans.modules.cnd.api.model.CsmTemplateParameter;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmTypeBasedSpecializationParameter;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelimpl.csm.ExpressionBasedSpecializationParameterImpl;
import org.netbeans.modules.cnd.modelimpl.csm.NestedType;
import org.netbeans.modules.cnd.modelimpl.csm.TemplateParameterImpl;
import org.netbeans.modules.cnd.modelimpl.csm.TemplateParameterTypeImpl;
import org.netbeans.modules.cnd.modelimpl.csm.TypeBasedSpecializationParameterImpl;
import org.netbeans.modules.cnd.modelimpl.csm.TypeFactory;
import org.netbeans.modules.cnd.modelimpl.csm.TypeImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstRenderer;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstUtil;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableBase;
import org.netbeans.modules.cnd.modelimpl.csm.deep.ExpressionStatementImpl;

public class TemplateUtils {
    public static final String TYPENAME_STRING = "class";

    public static String getSpecializationSuffix(AST qIdToken, List<CsmTemplateParameter> parameters) {
        StringBuilder sb = new StringBuilder();
        for (AST child = qIdToken.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getType() != 21) continue;
            TemplateUtils.addSpecializationSuffix(child, sb, parameters);
            break;
        }
        return sb.toString();
    }

    public static String getClassSpecializationSuffix(AST qIdToken, List<CsmTemplateParameter> parameters) {
        StringBuilder sb = new StringBuilder();
        TemplateUtils.addSpecializationSuffix(qIdToken.getFirstChild(), sb, parameters);
        return sb.toString();
    }

    public static void addSpecializationSuffix(AST firstChild, StringBuilder res, List<CsmTemplateParameter> parameters) {
        TemplateUtils.addSpecializationSuffix(firstChild, res, parameters, false);
    }

    public static void addSpecializationSuffix(AST firstChild, StringBuilder res, List<CsmTemplateParameter> parameters, boolean checkForSpecialization) {
        int depth = 0;
        int paramsNumber = 0;
        StringBuilder sb = new StringBuilder(res.toString());
        for (AST child = firstChild; child != null; child = child.getNextSibling()) {
            AST grandChild;
            if (child.getType() == 21) {
                ++depth;
            }
            if (460 <= child.getType() && child.getType() <= 547) {
                grandChild = child.getFirstChild();
                if (grandChild == null) continue;
                TemplateUtils.addSpecializationSuffix(grandChild, sb, parameters);
                ++paramsNumber;
                continue;
            }
            if (child != null && child.getType() == 115) {
                sb.append(child.getText());
                sb.append('<');
                grandChild = child.getFirstChild();
                if (grandChild != null) {
                    TemplateUtils.addSpecializationSuffix(grandChild, sb, parameters);
                }
                TemplateUtils.addGREATERTHAN(sb);
                sb.append(' ');
                ++paramsNumber;
                continue;
            }
            if (child.getType() == 23) {
                TemplateUtils.addGREATERTHAN(sb);
                if (--depth != 0) continue;
                break;
            }
            String text = child.getText();
            if (parameters != null) {
                for (CsmTemplateParameter param : parameters) {
                    if (!((Object)param.getName()).toString().equals(text)) continue;
                    text = TYPENAME_STRING;
                    ++paramsNumber;
                }
            }
            assert (text != null);
            assert (text.length() > 0);
            if (sb.length() > 0 && Character.isJavaIdentifierPart(sb.charAt(sb.length() - 1)) && Character.isJavaIdentifierPart(text.charAt(0))) {
                sb.append(' ');
            }
            sb.append(text);
        }
        if (!checkForSpecialization || parameters == null || paramsNumber != parameters.size()) {
            res.append(sb.toString().substring(res.length()));
        }
    }

    public static void addGREATERTHAN(StringBuilder sb) {
        if (sb.length() > 0 && sb.charAt(sb.length() - 1) == '>') {
            sb.append(' ');
        }
        sb.append('>');
    }

    public static boolean isPartialClassSpecialization(AST ast) {
        if (ast.getType() == 482) {
            for (AST node = ast.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getType() != 508) continue;
                for (AST child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    if (child.getType() != 21) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static AST getTemplateStart(AST ast) {
        for (AST child = ast; child != null; child = child.getNextSibling()) {
            if (child.getType() != 115) continue;
            return child;
        }
        return null;
    }

    public static List<CsmTemplateParameter> getTemplateParameters(AST ast, CsmFile file, CsmScope scope, boolean global) {
        assert (ast != null && ast.getType() == 115);
        ArrayList<CsmTemplateParameter> res = new ArrayList<CsmTemplateParameter>();
        AST parameterStart = null;
        block10: for (AST child = ast.getFirstChild(); child != null; child = child.getNextSibling()) {
            switch (child.getType()) {
                case 129: 
                case 157: {
                    parameterStart = child;
                    continue block10;
                }
                case 90: {
                    AST assign;
                    AST fakeAST = null;
                    fakeAST = parameterStart == null ? (parameterStart = child) : AstUtil.createAST(parameterStart, child);
                    if (child.getNextSibling() != null && (assign = child.getNextSibling()).getType() == 6 && assign.getNextSibling() != null) {
                        AST type = assign.getNextSibling();
                        if (type != null && type.getType() == 129 && type.getNextSibling() != null) {
                            type = type.getNextSibling();
                        }
                        if (type.getType() == 475 || type.getType() == 474) {
                            res.add((CsmTemplateParameter)new TemplateParameterImpl(fakeAST, AstUtil.getText(child), file, scope, global, type));
                            parameterStart = null;
                            continue block10;
                        }
                    }
                    res.add((CsmTemplateParameter)new TemplateParameterImpl(fakeAST, AstUtil.getText(child), file, scope, global));
                    parameterStart = null;
                    continue block10;
                }
                case 473: {
                    parameterStart = child;
                    AST varDecl = child.getFirstChild();
                    if (varDecl != null) {
                        varDecl = AstRenderer.getFirstSiblingSkipQualifiers(varDecl);
                    }
                    if (varDecl != null && varDecl.getType() == 129) {
                        varDecl = varDecl.getNextSibling();
                    }
                    if (varDecl != null && varDecl.getType() == 117 && ((varDecl = varDecl.getNextSibling()) == null || varDecl.getType() != 475)) continue block10;
                    if (varDecl != null && varDecl.getNextSibling() != null && varDecl.getNextSibling().getType() == 542) {
                        varDecl = varDecl.getNextSibling();
                    }
                    if (varDecl == null) continue block10;
                    block6 : switch (varDecl.getType()) {
                        case 542: {
                            AST pn = varDecl.getFirstChild();
                            if (pn == null) break;
                            res.add((CsmTemplateParameter)new TemplateParameterImpl(parameterStart, AstUtil.getText(pn), file, scope, global));
                            break;
                        }
                        case 474: 
                        case 475: {
                            for (AST p = varDecl.getFirstChild(); p != null; p = p.getNextSibling()) {
                                if (p.getType() != 90) continue;
                                res.add((CsmTemplateParameter)new TemplateParameterImpl(parameterStart, AstUtil.getText(p), file, scope, global));
                                break block6;
                            }
                            break;
                        }
                    }
                    continue block10;
                }
                case 484: {
                    parameterStart = child;
                    for (AST paramChild = child.getFirstChild(); paramChild != null; paramChild = paramChild.getNextSibling()) {
                        if (paramChild.getType() != 90) continue;
                        res.add((CsmTemplateParameter)new TemplateParameterImpl(parameterStart, AstUtil.getText(paramChild), file, scope, global));
                    }
                    continue block10;
                }
            }
        }
        return res;
    }

    public static List<CsmSpecializationParameter> getSpecializationParameters(AST ast, CsmFile file, CsmScope scope, boolean global) {
        AST start;
        assert (ast != null);
        ArrayList<CsmSpecializationParameter> res = new ArrayList<CsmSpecializationParameter>();
        for (start = ast.getFirstChild(); start != null; start = start.getNextSibling()) {
            if (start.getType() != 21) continue;
            start = start.getNextSibling();
            break;
        }
        if (start != null) {
            AST ptr = null;
            AST type = null;
            block7: for (AST child = start; child != null; child = child.getNextSibling()) {
                switch (child.getType()) {
                    case 540: {
                        ptr = child;
                        continue block7;
                    }
                    case 474: 
                    case 475: {
                        type = child;
                        continue block7;
                    }
                    case 533: {
                        res.add((CsmSpecializationParameter)ExpressionBasedSpecializationParameterImpl.create(ExpressionStatementImpl.create(child, file, scope), file, OffsetableBase.getStartOffset(child), OffsetableBase.getEndOffset(child)));
                        continue block7;
                    }
                    case 8: 
                    case 23: {
                        if (type != null) {
                            res.add((CsmSpecializationParameter)new TypeBasedSpecializationParameterImpl(TypeFactory.createType(type, file, ptr, 0, scope), file, OffsetableBase.getStartOffset(type), OffsetableBase.getEndOffset(type)));
                        }
                        type = null;
                        ptr = null;
                    }
                }
            }
        }
        return res;
    }

    public static CsmType checkTemplateType(CsmType type, CsmScope scope) {
        if (!(type instanceof TypeImpl)) {
            return type;
        }
        if (type instanceof NestedType) {
            NestedType nestedType = (NestedType)type;
            type = NestedType.create(TemplateUtils.checkTemplateType(nestedType.getParent(), scope), nestedType);
        }
        if (type.isInstantiation()) {
            TypeImpl typeImpl = (TypeImpl)type;
            List<CsmSpecializationParameter> params = typeImpl.getInstantiationParams();
            for (CsmSpecializationParameter instParam : params) {
                CsmType newType;
                if (!CsmKindUtilities.isTypeBasedSpecalizationParameter((CsmObject)instParam) || (newType = TemplateUtils.checkTemplateType(((CsmTypeBasedSpecializationParameter)instParam).getType(), scope)) == instParam) continue;
                params.set(params.indexOf(instParam), (CsmSpecializationParameter)new TypeBasedSpecializationParameterImpl(newType));
            }
        }
        while (scope != null) {
            List params;
            if (CsmKindUtilities.isTemplate((CsmObject)scope) && !(params = ((CsmTemplate)scope).getTemplateParameters()).isEmpty()) {
                String classifierText = ((Object)((TypeImpl)type).getClassifierText()).toString();
                for (CsmTemplateParameter param : params) {
                    if (!((Object)param.getName()).toString().equals(classifierText)) continue;
                    return new TemplateParameterTypeImpl(type, param);
                }
            }
            if (!(scope instanceof CsmScopeElement)) break;
            scope = ((CsmScopeElement)scope).getScope();
        }
        return type;
    }

    public static Map<CsmTemplateParameter, CsmSpecializationParameter> gatherMapping(CsmInstantiation inst) {
        HashMap<CsmTemplateParameter, CsmSpecializationParameter> newMapping = new HashMap<CsmTemplateParameter, CsmSpecializationParameter>();
        if (inst != null) {
            CsmOffsetableDeclaration decl = inst.getTemplateDeclaration();
            if (decl instanceof CsmInstantiation) {
                newMapping.putAll(TemplateUtils.gatherMapping((CsmInstantiation)decl));
            }
            newMapping.putAll(inst.getMapping());
        }
        return newMapping;
    }

    public static boolean isTemplateQualifiedName(String name) {
        return name.contains("<");
    }

    public static String getTemplateQualifiedNameWithoutSiffix(String name) {
        return name.replaceAll("<.*", "");
    }

    private TemplateUtils() {
    }
}

