/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunctionInstantiation;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmParameter;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmQualifiedNamedElement;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.modelimpl.csm.AstRendererException;
import org.netbeans.modules.cnd.modelimpl.csm.FunctionParameterListImpl;
import org.netbeans.modules.cnd.modelimpl.csm.MutableDeclarationsContainer;
import org.netbeans.modules.cnd.modelimpl.csm.NameHolder;
import org.netbeans.modules.cnd.modelimpl.csm.core.CsmIdentifiable;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableDeclarationBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.QualifiedNameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.openide.util.CharSequences;

public final class FunctionInstantiationImpl
extends OffsetableDeclarationBase<CsmFunctionInstantiation>
implements CsmFunctionInstantiation {
    private final FunctionParameterListImpl parameterList;
    private CsmScope scopeRef;
    private CsmUID<CsmScope> scopeUID;
    private final CharSequence name;

    private FunctionInstantiationImpl(AST ast, CsmFile file, CsmScope scope, NameHolder nameHolder, boolean global) throws AstRendererException {
        super(ast, file);
        this.parameterList = this.createParameterList(ast, !global);
        this._setScope(scope);
        this.name = QualifiedNameCache.getManager().getString(nameHolder.getName());
    }

    public static FunctionInstantiationImpl create(AST ast, CsmFile file, boolean register) throws AstRendererException {
        NameHolder nameHolder = NameHolder.createFunctionName(ast);
        FunctionInstantiationImpl res = new FunctionInstantiationImpl(ast, file, null, nameHolder, register);
        FunctionInstantiationImpl.postObjectCreateRegistration(register, res);
        nameHolder.addReference(file, res);
        return res;
    }

    private FunctionParameterListImpl createParameterList(AST funAST, boolean isLocal) {
        return FunctionParameterListImpl.create(this.getContainingFile(), funAST, this.getScope(), isLocal);
    }

    public CsmDeclaration.Kind getKind() {
        return CsmDeclaration.Kind.FUNCTION_INSTANTIATION;
    }

    public CharSequence getName() {
        return this.name;
    }

    public CharSequence getQualifiedName() {
        CharSequence scopeQName;
        CsmScope scope = this.getScope();
        if ((scope instanceof CsmNamespace || scope instanceof CsmClass || scope instanceof CsmNamespaceDefinition) && (scopeQName = ((CsmQualifiedNamedElement)scope).getQualifiedName()) != null && scopeQName.length() > 0) {
            return CharSequences.create((CharSequence)(((Object)scopeQName).toString() + "::" + this.getQualifiedNamePostfix()));
        }
        return this.getName();
    }

    public CsmScope getScope() {
        return this._getScope();
    }

    private void _setScope(CsmScope scope) {
        if (scope instanceof CsmIdentifiable) {
            this.scopeUID = UIDCsmConverter.scopeToUID(scope);
            assert (this.scopeUID != null || scope == null);
        } else {
            this.scopeRef = scope;
        }
    }

    private synchronized CsmScope _getScope() {
        CsmScope scope = this.scopeRef;
        if (scope == null) {
            scope = UIDCsmConverter.UIDtoScope(this.scopeUID);
        }
        return scope;
    }

    public Collection<CsmScopeElement> getScopeElements() {
        ArrayList<CsmScopeElement> l = new ArrayList<CsmScopeElement>();
        l.addAll(this.getParameters());
        return l;
    }

    public Collection<CsmParameter> getParameters() {
        return this._getParameters();
    }

    private Collection<CsmParameter> _getParameters() {
        if (this.parameterList == null) {
            return Collections.emptyList();
        }
        return this.parameterList.getParameters();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.onDispose();
        CsmScope scope = this._getScope();
        if (scope instanceof MutableDeclarationsContainer) {
            ((MutableDeclarationsContainer)scope).removeDeclaration(this);
        }
        this.unregisterInProject();
        this._disposeParameters();
    }

    private void _disposeParameters() {
        if (this.parameterList != null) {
            this.parameterList.dispose();
        }
    }

    private void unregisterInProject() {
        CsmProject project = this.getContainingFile().getProject();
        if (project instanceof ProjectBase) {
            ((ProjectBase)project).unregisterDeclaration(this);
            this.cleanUID();
        }
    }

    private synchronized void onDispose() {
        if (this.scopeRef == null) {
            this.scopeRef = UIDCsmConverter.UIDtoScope(this.scopeUID);
            assert (this.scopeRef != null || this.scopeUID == null) : "empty scope for UID " + this.scopeUID;
        }
    }

    public FunctionInstantiationImpl(RepositoryDataInput input) throws IOException {
        super(input);
        this.name = PersistentUtils.readUTF(input, QualifiedNameCache.getManager());
        assert (this.name != null);
        this.parameterList = (FunctionParameterListImpl)PersistentUtils.readParameterList(input);
        UIDObjectFactory factory = UIDObjectFactory.getDefaultFactory();
        this.scopeUID = factory.readUID(input);
        this.scopeRef = null;
    }

    @Override
    public void write(RepositoryDataOutput output) throws IOException {
        super.write(output);
        assert (this.name != null);
        PersistentUtils.writeUTF(this.name, output);
        PersistentUtils.writeParameterList(this.parameterList, output);
        UIDObjectFactory factory = UIDObjectFactory.getDefaultFactory();
        factory.writeUID(this.scopeUID, output);
    }
}

