/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmParameter;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmQualifiedNamedElement;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmSpecializationParameter;
import org.netbeans.modules.cnd.api.model.CsmTemplate;
import org.netbeans.modules.cnd.api.model.CsmTemplateParameter;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.deep.CsmCompoundStatement;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelimpl.csm.AstRendererException;
import org.netbeans.modules.cnd.modelimpl.csm.CastUtils;
import org.netbeans.modules.cnd.modelimpl.csm.FriendFunctionImpl;
import org.netbeans.modules.cnd.modelimpl.csm.FunctionParameterListImpl;
import org.netbeans.modules.cnd.modelimpl.csm.MutableDeclarationsContainer;
import org.netbeans.modules.cnd.modelimpl.csm.NameHolder;
import org.netbeans.modules.cnd.modelimpl.csm.NamespaceImpl;
import org.netbeans.modules.cnd.modelimpl.csm.TemplateDescriptor;
import org.netbeans.modules.cnd.modelimpl.csm.TemplateUtils;
import org.netbeans.modules.cnd.modelimpl.csm.TypeFactory;
import org.netbeans.modules.cnd.modelimpl.csm.TypeImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstRenderer;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstUtil;
import org.netbeans.modules.cnd.modelimpl.csm.core.CsmIdentifiable;
import org.netbeans.modules.cnd.modelimpl.csm.core.Disposable;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableDeclarationBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.RawNamable;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.impl.services.InstantiationProviderImpl;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.modelimpl.textcache.QualifiedNameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.openide.util.CharSequences;

public class FunctionImpl<T>
extends OffsetableDeclarationBase<T>
implements CsmFunction,
Disposable,
RawNamable,
CsmTemplate {
    private static final String OPERATOR = "operator";
    private final CharSequence name;
    private final CsmType returnType;
    private final FunctionParameterListImpl parameterList;
    private CharSequence signature;
    private CsmScope scopeRef;
    private CsmUID<CsmScope> scopeUID;
    private final CharSequence rawName;
    private final TemplateDescriptor templateDescriptor;
    protected final CharSequence classTemplateSuffix;
    private static final byte FLAGS_VOID_PARMLIST = 1;
    private static final byte FLAGS_STATIC = 2;
    private static final byte FLAGS_CONST = 4;
    private static final byte FLAGS_OPERATOR = 8;
    private static final byte FLAGS_INVALID = 16;
    protected static final int LAST_USED_FLAG_INDEX = 4;
    private byte flags;
    private static final boolean CHECK_SCOPE = false;

    protected FunctionImpl(AST ast, CsmFile file, CsmType type, CsmScope scope, NameHolder nameHolder, boolean global) throws AstRendererException {
        super(ast, file);
        this.name = QualifiedNameCache.getManager().getString(nameHolder.getName());
        if (this.name.length() == 0) {
            throw new AstRendererException((FileImpl)file, this.getStartOffset(), "Empty function name.");
        }
        this.rawName = this.initRawName(ast);
        AST child = ast.getFirstChild();
        if (child != null) {
            this.setStatic(child.getType() == 132);
        } else {
            System.err.println("function ast " + ast.getText() + " without childs in file " + file.getAbsolutePath());
        }
        if (!this.isStatic()) {
            CsmSelect.CsmFilter filter = CsmSelect.getFilterBuilder().createNameFilter(this.name, true, true, false);
            Iterator it = CsmSelect.getStaticFunctions((CsmFile)file, (CsmSelect.CsmFilter)filter);
            while (it.hasNext()) {
                CsmFunction fun = (CsmFunction)it.next();
                if (!this.name.equals(fun.getName())) continue;
                this.setStatic(true);
                break;
            }
        }
        if (scope instanceof CsmNamespace && !NamespaceImpl.isNamespaceScope(this)) {
            scope = file;
        }
        this._setScope(scope);
        boolean _const = FunctionImpl.initConst(ast);
        this.setFlags((byte)4, _const);
        if (((Object)this.name).toString().startsWith(OPERATOR) && this.name.length() > OPERATOR.length() && !Character.isJavaIdentifierPart(this.name.charAt(OPERATOR.length()))) {
            this.setFlags((byte)8, true);
        }
        FunctionImpl.temporaryRepositoryRegistration(global, this);
        StringBuilder clsTemplateSuffix = new StringBuilder();
        this.templateDescriptor = this.createTemplateDescriptor(ast, (CsmScope)this, clsTemplateSuffix, global);
        this.classTemplateSuffix = NameCache.getManager().getString((CharSequence)clsTemplateSuffix);
        this.returnType = type != null ? type : this.initReturnType(ast);
        this.parameterList = this.createParameterList(ast, !global);
        if (this.parameterList == null || this.parameterList.isEmpty()) {
            this.setFlags((byte)1, this.isVoidParameter(ast));
        } else {
            this.setFlags((byte)1, false);
        }
        if (this.parameterList == null) {
            System.err.println("NO PARAM LIST FOR FUNC:" + this.name + " at " + AstUtil.getOffsetString(ast) + " in " + file.getAbsolutePath());
        }
    }

    public static <T> FunctionImpl<T> create(AST ast, CsmFile file, CsmType type, CsmScope scope, boolean register) throws AstRendererException {
        NameHolder nameHolder = NameHolder.createFunctionName(ast);
        FunctionImpl<T> functionImpl = new FunctionImpl<T>(ast, file, type, scope, nameHolder, register);
        FunctionImpl.postObjectCreateRegistration(register, functionImpl);
        nameHolder.addReference(file, functionImpl);
        return functionImpl;
    }

    public static <T> FunctionImpl<T> create(CsmFile file, CsmType type, CsmScope scope, String name, FunctionParameterListImpl parameterList, boolean isStatic, boolean isConst, boolean register, int startOffset, int endOffset) {
        FunctionImpl<T> functionImpl = new FunctionImpl<T>(file, type, scope, name, parameterList, isStatic, isConst, register, startOffset, endOffset);
        FunctionImpl.postObjectCreateRegistration(register, functionImpl);
        return functionImpl;
    }

    private FunctionImpl(CsmFile file, CsmType type, CsmScope scope, String name, FunctionParameterListImpl parameterList, boolean isStatic, boolean isConst, boolean global, int startOffset, int endOffset) {
        super(file, startOffset, endOffset);
        this.name = QualifiedNameCache.getManager().getString((CharSequence)name);
        this.rawName = null;
        this.setStatic(isStatic);
        if (scope instanceof CsmNamespace && !NamespaceImpl.isNamespaceScope(this)) {
            scope = file;
        }
        this._setScope(scope);
        this.setFlags((byte)4, isConst);
        if (name.toString().startsWith(OPERATOR) && name.length() > OPERATOR.length() && !Character.isJavaIdentifierPart(name.charAt(OPERATOR.length()))) {
            this.setFlags((byte)8, true);
        }
        FunctionImpl.temporaryRepositoryRegistration(global, this);
        this.templateDescriptor = null;
        this.classTemplateSuffix = null;
        this.returnType = type;
        this.parameterList = parameterList;
        if (!this.parameterList.isEmpty()) {
            this.setFlags((byte)1, false);
        }
    }

    public void setScope(CsmScope scope) {
        this.unregisterInProject();
        this._setScope(scope);
        this.registerInProject();
    }

    private void _setScope(CsmScope scope) {
        if (scope instanceof CsmIdentifiable) {
            this.scopeUID = UIDCsmConverter.scopeToUID(scope);
            assert (this.scopeUID != null || scope == null);
        } else {
            this.scopeRef = scope;
        }
    }

    public boolean isPureDefinition() {
        return this.getKind() == CsmDeclaration.Kind.FUNCTION_DEFINITION || this.getKind() == CsmDeclaration.Kind.FUNCTION_FRIEND_DEFINITION;
    }

    protected boolean hasFlags(byte mask) {
        return (this.flags & mask) == mask;
    }

    protected final void setFlags(byte mask, boolean value) {
        this.flags = value ? (byte)(this.flags | mask) : (byte)(this.flags & ~mask);
    }

    public final boolean isStatic() {
        return this.hasFlags((byte)2);
    }

    protected final void setStatic(boolean value) {
        this.setFlags((byte)2, value);
    }

    private AST findParameterNode(AST node) {
        AST ast2;
        AST ast = AstUtil.findChildOfType(node, 500);
        if (ast != null && (ast2 = AstUtil.findSiblingOfType(ast.getNextSibling(), 501)) != null) {
            ast = ast2;
        }
        return ast;
    }

    protected CharSequence getScopeSuffix() {
        return this.classTemplateSuffix != null ? this.classTemplateSuffix : CharSequences.empty();
    }

    protected final CharSequence initRawName(AST node) {
        return FunctionImpl.findFunctionRawName(node);
    }

    public CharSequence getDisplayName() {
        return this.templateDescriptor != null ? CharSequences.create((CharSequence)(((Object)this.getName()).toString() + this.templateDescriptor.getTemplateSuffix())) : this.getName();
    }

    public List<CsmTemplateParameter> getTemplateParameters() {
        return this.templateDescriptor != null ? this.templateDescriptor.getTemplateParameters() : Collections.emptyList();
    }

    public List<CsmTemplateParameter> getInheritedTemplateParameters() {
        List<CsmTemplateParameter> allTemplateParams = this.getTemplateParameters();
        ArrayList<CsmTemplateParameter> params = new ArrayList<CsmTemplateParameter>();
        if (allTemplateParams != null) {
            int inheritedTemplateParametersNumber;
            int n = inheritedTemplateParametersNumber = this.templateDescriptor != null ? this.templateDescriptor.getInheritedTemplateParametersNumber() : 0;
            if (allTemplateParams.size() > inheritedTemplateParametersNumber) {
                Iterator<CsmTemplateParameter> iter = allTemplateParams.iterator();
                for (int i = 0; i < inheritedTemplateParametersNumber && iter.hasNext(); ++i) {
                    params.add(iter.next());
                }
            }
        }
        return params;
    }

    public List<CsmTemplateParameter> getOwnTemplateParameters() {
        List<CsmTemplateParameter> allTemplateParams = this.getTemplateParameters();
        ArrayList<CsmTemplateParameter> params = new ArrayList<CsmTemplateParameter>();
        if (allTemplateParams != null) {
            int inheritedTemplateParametersNumber;
            int n = inheritedTemplateParametersNumber = this.templateDescriptor != null ? this.templateDescriptor.getInheritedTemplateParametersNumber() : 0;
            if (allTemplateParams.size() > inheritedTemplateParametersNumber) {
                Iterator<CsmTemplateParameter> iter = allTemplateParams.iterator();
                for (int i = 0; i < inheritedTemplateParametersNumber && iter.hasNext(); ++i) {
                    iter.next();
                }
                while (iter.hasNext()) {
                    params.add(iter.next());
                }
            }
        }
        return params;
    }

    public boolean isVoidParameterList() {
        return this.hasFlags((byte)1);
    }

    private static CharSequence findFunctionRawName(AST ast) {
        if (CastUtils.isCast(ast)) {
            return CastUtils.getFunctionRawName(ast);
        }
        return AstUtil.getRawNameInChildren(ast);
    }

    protected boolean isCStyleStatic() {
        return this.isStatic() && CsmKindUtilities.isFile((CsmObject)this.getScope());
    }

    @Override
    protected boolean registerInProject() {
        if (this.isCStyleStatic()) {
            return false;
        }
        CsmProject project = this.getContainingFile().getProject();
        if (project instanceof ProjectBase) {
            return ((ProjectBase)project).registerDeclaration(this);
        }
        return false;
    }

    private void unregisterInProject() {
        CsmProject project = this.getContainingFile().getProject();
        if (project instanceof ProjectBase) {
            ((ProjectBase)project).unregisterDeclaration(this);
            this.cleanUID();
        }
    }

    public CharSequence getName() {
        return this.name;
    }

    public CharSequence getQualifiedName() {
        CharSequence scopeQName;
        CsmScope scope = this.getScope();
        if ((scope instanceof CsmNamespace || scope instanceof CsmClass || scope instanceof CsmNamespaceDefinition) && (scopeQName = ((CsmQualifiedNamedElement)scope).getQualifiedName()) != null && scopeQName.length() > 0) {
            return CharSequences.create((CharSequence)(((Object)scopeQName).toString() + (!CsmKindUtilities.isSpecialization((CsmObject)scope) ? this.getScopeSuffix() : "") + "::" + this.getQualifiedNamePostfix()));
        }
        return this.getName();
    }

    @Override
    public CharSequence[] getRawName() {
        return AstUtil.toRawName(this.rawName);
    }

    @Override
    public CharSequence getUniqueNameWithoutPrefix() {
        return ((Object)this.getQualifiedName()).toString() + ((Object)this.getSignature()).toString().substring(this.getName().length());
    }

    public CsmDeclaration.Kind getKind() {
        return CsmDeclaration.Kind.FUNCTION;
    }

    public String getDeclarationText() {
        return "";
    }

    public CsmFunctionDefinition getDefinition() {
        return this.getDefinition(null);
    }

    public CsmFunctionDefinition getDefinition(CsmClass baseClass) {
        CsmFunctionDefinition def;
        block17: {
            Iterator<Object> i$;
            List<CsmSpecializationParameter> specializationParameters;
            ProjectBase dependent;
            CsmProject lib;
            Iterator<Object> i$2;
            if (this.isCStyleStatic()) {
                CsmSelect.CsmFilter filter = CsmSelect.getFilterBuilder().createNameFilter(this.getName(), true, true, false);
                Iterator it = CsmSelect.getDeclarations((CsmFile)this.getContainingFile(), (CsmSelect.CsmFilter)filter);
                while (it.hasNext()) {
                    CsmDeclaration decl = (CsmDeclaration)it.next();
                    if (!CsmKindUtilities.isFunctionDefinition((CsmObject)decl) || !this.getName().equals(decl.getName())) continue;
                    CsmFunctionDefinition fun = (CsmFunctionDefinition)decl;
                    if (!this.getSignature().equals(fun.getSignature())) continue;
                    return fun;
                }
                return null;
            }
            String uname = baseClass == null ? Utils.getCsmDeclarationKindkey(CsmDeclaration.Kind.FUNCTION_DEFINITION) + ':' + this.getUniqueNameWithoutPrefix() : Utils.getCsmDeclarationKindkey(CsmDeclaration.Kind.FUNCTION_DEFINITION) + ':' + ((Object)baseClass.getQualifiedName()).toString() + "::" + this.getSignature();
            CsmProject prj = this.getContainingFile().getProject();
            def = this.findDefinition(prj, uname);
            if (def == null) {
                i$2 = prj.getLibraries().iterator();
                while (i$2.hasNext() && (def = this.findDefinition(lib = (CsmProject)i$2.next(), uname)) == null) {
                }
            }
            if (def == null && prj instanceof ProjectBase) {
                i$2 = ((ProjectBase)prj).getDependentProjects().iterator();
                while (i$2.hasNext() && (def = this.findDefinition(dependent = (ProjectBase)i$2.next(), uname)) == null) {
                }
            }
            if (def == null) {
                uname = baseClass == null ? Utils.getCsmDeclarationKindkey(CsmDeclaration.Kind.FUNCTION_FRIEND_DEFINITION) + ':' + this.getUniqueNameWithoutPrefix() : Utils.getCsmDeclarationKindkey(CsmDeclaration.Kind.FUNCTION_FRIEND_DEFINITION) + ':' + ((Object)baseClass.getQualifiedName()).toString() + "::" + this.getSignature();
                def = this.findDefinition(prj, uname);
                if (def == null) {
                    i$2 = prj.getLibraries().iterator();
                    while (i$2.hasNext() && (def = this.findDefinition(lib = (CsmProject)i$2.next(), uname)) == null) {
                    }
                }
                if (def == null && prj instanceof ProjectBase) {
                    i$2 = ((ProjectBase)prj).getDependentProjects().iterator();
                    while (i$2.hasNext() && (def = this.findDefinition(dependent = (ProjectBase)i$2.next(), uname)) == null) {
                    }
                }
            }
            if (def != null || !(this instanceof FriendFunctionImpl) || (specializationParameters = ((FriendFunctionImpl)this).getSpecializationParameters()).isEmpty()) break block17;
            StringBuilder tparams = new StringBuilder();
            tparams.append('<');
            for (int i = 0; i < specializationParameters.size(); ++i) {
                if (i != 0) {
                    tparams.append(',');
                }
                tparams.append("class");
            }
            tparams.append('>');
            StringBuilder params = new StringBuilder();
            InstantiationProviderImpl.appendParametersSignature(this.getParameters(), params);
            uname = Utils.getCsmDeclarationKindkey(CsmDeclaration.Kind.FUNCTION_DEFINITION) + ':' + ((Object)this.getQualifiedName()).toString() + tparams.toString() + params.toString();
            def = this.findDefinition(prj, uname);
            if (def == null) {
                CsmProject lib2;
                i$ = prj.getLibraries().iterator();
                while (i$.hasNext() && (def = this.findDefinition(lib2 = (CsmProject)i$.next(), uname)) == null) {
                }
            }
            if (def == null && prj instanceof ProjectBase) {
                ProjectBase dependent2;
                i$ = ((ProjectBase)prj).getDependentProjects().iterator();
                while (i$.hasNext() && (def = this.findDefinition(dependent2 = (ProjectBase)i$.next(), uname)) == null) {
                }
            }
        }
        return def;
    }

    private CsmDeclaration fixCastOperator(CsmProject prj, String uname) {
        String s;
        int j;
        int i = uname.indexOf("operator ");
        if (i > 0 && (j = (s = uname.substring(i + 9)).lastIndexOf("::")) > 0) {
            s = uname.substring(0, i + 9) + " " + s.substring(j + 2);
            return prj.findDeclaration((CharSequence)s);
        }
        return null;
    }

    public static boolean isObjectVisibleInFile(CsmFile currentFile, CsmOffsetableDeclaration item) {
        CsmFile file = item.getContainingFile();
        if (file.equals(currentFile)) {
            return true;
        }
        return ((ProjectBase)currentFile.getProject()).getGraphStorage().isFileIncluded(currentFile, file);
    }

    private CsmFunctionDefinition findDefinition(CsmProject prj, String uname) {
        Collection defs = prj.findDeclarations((CharSequence)uname);
        CsmDeclaration res = null;
        if (defs.isEmpty()) {
            if (this.isOperator()) {
                res = this.fixCastOperator(prj, uname);
            }
        } else if (defs.size() == 1) {
            res = (CsmDeclaration)defs.iterator().next();
        } else {
            for (CsmOffsetableDeclaration decl : defs) {
                if (!(decl instanceof CsmFunctionDefinition)) continue;
                if (FunctionImpl.isObjectVisibleInFile(decl.getContainingFile(), this)) {
                    res = decl;
                    break;
                }
                if (res != null) continue;
                res = decl;
            }
        }
        if (res instanceof CsmFunctionDefinition) {
            return (CsmFunctionDefinition)res;
        }
        if (prj instanceof ProjectBase) {
            int parmSize = this.getParameters().size();
            boolean isVoid = this.isVoidParameterList();
            String from = uname.substring(0, uname.indexOf(40) + 1);
            Collection<CsmOffsetableDeclaration> decls = ((ProjectBase)prj).findDeclarationsByPrefix(from);
            CsmFunctionDefinition candidate = null;
            for (CsmOffsetableDeclaration decl : decls) {
                CsmFunctionDefinition def = (CsmFunctionDefinition)decl;
                int candidateParamSize = def.getParameters().size();
                if (!isVoid && parmSize == 0 && !Utils.isCppFile(decl.getContainingFile())) {
                    return def;
                }
                if (parmSize != candidateParamSize || candidate != null) continue;
                candidate = def;
            }
            return candidate;
        }
        return null;
    }

    public boolean isTemplate() {
        return this.templateDescriptor != null;
    }

    public boolean isSpecialization() {
        return this.templateDescriptor != null && this.templateDescriptor.isSpecialization();
    }

    public boolean isExplicitSpecialization() {
        return false;
    }

    public CsmCompoundStatement getBody() {
        return null;
    }

    public boolean isInline() {
        return false;
    }

    private CsmType initReturnType(AST node) {
        TypeImpl ret = null;
        AST token = FunctionImpl.getTypeToken(node);
        if (token != null) {
            ret = AstRenderer.renderType(token, this.getContainingFile());
        }
        if (ret == null) {
            ret = TypeFactory.createBuiltinType("int", null, 0, null, this.getContainingFile());
        }
        return TemplateUtils.checkTemplateType(ret, (CsmScope)this);
    }

    public CsmType getReturnType() {
        return this.returnType;
    }

    private static AST getTypeToken(AST node) {
        for (AST token = node.getFirstChild(); token != null; token = token.getNextSibling()) {
            int type = token.getType();
            switch (type) {
                case 129: 
                case 157: 
                case 158: 
                case 159: 
                case 474: 
                case 475: {
                    return token;
                }
            }
            if (!AstRenderer.isCVQualifier(type)) continue;
            return token;
        }
        return null;
    }

    private FunctionParameterListImpl createParameterList(AST funAST, boolean isLocal) {
        return FunctionParameterListImpl.create(this.getContainingFile(), funAST, (CsmScope)this, isLocal);
    }

    private boolean isVoidParameter(AST node) {
        AST ast = this.findParameterNode(node);
        return AstRenderer.isVoidParameter(ast);
    }

    public FunctionParameterListImpl getParameterList() {
        return this.parameterList;
    }

    public Collection<CsmParameter> getParameters() {
        return this._getParameters();
    }

    public CsmScope getScope() {
        return this._getScope();
    }

    public CharSequence getSignature() {
        if (this.signature == null) {
            this.signature = QualifiedNameCache.getManager().getString(this.createSignature());
        }
        return this.signature;
    }

    public CsmFunction getDeclaration() {
        return this;
    }

    public boolean isOperator() {
        return this.hasFlags((byte)8);
    }

    public CsmFunction.OperatorKind getOperatorKind() {
        CsmFunction.OperatorKind out = CsmFunction.OperatorKind.NONE;
        if (this.isOperator()) {
            int nrParams;
            String strName = ((Object)this.getName()).toString();
            int start = strName.indexOf(OPERATOR);
            assert (start >= 0) : "must have word \"operator\" in name";
            String signText = strName.substring(start += OPERATOR.length()).trim();
            CsmFunction.OperatorKind binaryKind = CsmFunction.OperatorKind.getKindByImage((String)signText, (boolean)true);
            CsmFunction.OperatorKind nonBinaryKind = CsmFunction.OperatorKind.getKindByImage((String)signText, (boolean)false);
            out = binaryKind != CsmFunction.OperatorKind.NONE && nonBinaryKind != CsmFunction.OperatorKind.NONE ? ((nrParams = this.getNrParameters()) == 0 ? nonBinaryKind : (nrParams == 1 ? (CsmKindUtilities.isClass((CsmObject)this.getScope()) ? binaryKind : nonBinaryKind) : (nrParams == 2 ? binaryKind : nonBinaryKind))) : (binaryKind != CsmFunction.OperatorKind.NONE ? binaryKind : nonBinaryKind);
        }
        return out;
    }

    public Collection<CsmScopeElement> getScopeElements() {
        ArrayList<CsmScopeElement> l = new ArrayList<CsmScopeElement>();
        l.addAll(this.getParameters());
        return l;
    }

    private CharSequence createSignature() {
        StringBuilder sb = new StringBuilder(this.getName());
        this.appendTemplateSignature(sb);
        InstantiationProviderImpl.appendParametersSignature(this.getParameters(), sb);
        if (this.isConst()) {
            sb.append(" const");
        }
        return sb;
    }

    private void appendTemplateSignature(StringBuilder sb) {
        InstantiationProviderImpl.appendTemplateParamsSignature(this.getOwnTemplateParameters(), sb);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.onDispose();
        CsmScope scope = this._getScope();
        if (scope instanceof MutableDeclarationsContainer) {
            ((MutableDeclarationsContainer)scope).removeDeclaration(this);
        }
        this.unregisterInProject();
        this._disposeParameters();
        this.setFlags((byte)16, true);
    }

    @Override
    public boolean isValid() {
        return !this.hasFlags((byte)16) && super.isValid();
    }

    private synchronized void onDispose() {
        if (this.scopeRef == null) {
            this.scopeRef = UIDCsmConverter.UIDtoScope(this.scopeUID);
            assert (this.scopeRef != null || this.scopeUID == null) : "empty scope for UID " + this.scopeUID;
        }
    }

    private static boolean initConst(AST node) {
        AST token;
        for (token = node.getFirstChild(); token != null && token.getType() != 508; token = token.getNextSibling()) {
        }
        while (token != null) {
            if (AstRenderer.isConstQualifier(token.getType())) {
                return true;
            }
            token = token.getNextSibling();
        }
        return false;
    }

    protected boolean isConst() {
        return this.hasFlags((byte)4);
    }

    private synchronized CsmScope _getScope() {
        CsmScope scope = this.scopeRef;
        if (scope == null) {
            scope = UIDCsmConverter.UIDtoScope(this.scopeUID);
        }
        return scope;
    }

    private Collection<CsmParameter> _getParameters() {
        if (this.parameterList == null) {
            return Collections.emptyList();
        }
        return this.parameterList.getParameters();
    }

    private int getNrParameters() {
        if (this.isVoidParameterList() || this.parameterList == null) {
            return 0;
        }
        return this.parameterList.getNrParameters();
    }

    private void _disposeParameters() {
        if (this.parameterList != null) {
            this.parameterList.dispose();
        }
    }

    protected final CsmFunction chooseDeclaration(Collection<CsmDeclaration> decls) {
        CsmFunction out = null;
        if (decls.size() == 1) {
            out = (CsmFunction)decls.iterator().next();
        } else {
            CsmFile sortFile = null;
            for (CsmDeclaration decl : decls) {
                CsmFunction fun = (CsmFunction)decl;
                CsmFile containingFile = fun.getContainingFile();
                if (sortFile == null) {
                    sortFile = containingFile;
                    out = fun;
                    continue;
                }
                if (CharSequences.comparator().compare(sortFile.getAbsolutePath(), containingFile.getAbsolutePath()) <= 0) continue;
                sortFile = containingFile;
                out = fun;
            }
        }
        return out;
    }

    @Override
    public void write(RepositoryDataOutput output) throws IOException {
        super.write(output);
        assert (this.name != null);
        PersistentUtils.writeUTF(this.name, output);
        PersistentUtils.writeType(this.returnType, output);
        UIDObjectFactory factory = UIDObjectFactory.getDefaultFactory();
        PersistentUtils.writeParameterList(this.parameterList, output);
        PersistentUtils.writeUTF(this.rawName, output);
        factory.writeUID(this.scopeUID, output);
        PersistentUtils.writeUTF(this.signature, output);
        output.writeByte((int)this.flags);
        PersistentUtils.writeUTF(this.getScopeSuffix(), output);
        PersistentUtils.writeTemplateDescriptor(this.templateDescriptor, output);
    }

    public FunctionImpl(RepositoryDataInput input) throws IOException {
        super(input);
        this.name = PersistentUtils.readUTF(input, QualifiedNameCache.getManager());
        assert (this.name != null);
        this.returnType = PersistentUtils.readType(input);
        UIDObjectFactory factory = UIDObjectFactory.getDefaultFactory();
        this.parameterList = (FunctionParameterListImpl)PersistentUtils.readParameterList(input);
        this.rawName = PersistentUtils.readUTF(input, NameCache.getManager());
        this.scopeUID = factory.readUID(input);
        this.scopeRef = null;
        this.signature = PersistentUtils.readUTF(input, QualifiedNameCache.getManager());
        this.flags = input.readByte();
        this.classTemplateSuffix = PersistentUtils.readUTF(input, NameCache.getManager());
        this.templateDescriptor = PersistentUtils.readTemplateDescriptor(input);
    }
}

