/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.ui;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import javax.swing.Action;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.remote.support.RemoteUtil;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.ConnectionListener;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.remote.ui.HostNodesProvider;
import org.netbeans.modules.remote.ui.HostPropertiesAction;
import org.netbeans.modules.remote.ui.SingleHostAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.SharedClassObject;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;

public final class HostNode
extends AbstractNode
implements ConnectionListener,
PropertyChangeListener {
    private final ExecutionEnvironment env;

    public HostNode(ExecutionEnvironment execEnv) {
        super(HostNode.createChildren(execEnv), Lookups.singleton((Object)execEnv));
        this.env = execEnv;
        ConnectionManager.getInstance().addConnectionListener((ConnectionListener)WeakListeners.create(ConnectionListener.class, (EventListener)this, null));
        ServerList.addPropertyChangeListener((PropertyChangeListener)WeakListeners.propertyChange((PropertyChangeListener)this, null));
    }

    private static Children createChildren(ExecutionEnvironment execEnv) {
        Collection providers = Lookup.getDefault().lookupAll(HostNodesProvider.class);
        if (providers.isEmpty()) {
            return Children.LEAF;
        }
        return Children.create((ChildFactory)new HostSubnodeChildren(execEnv, providers), (boolean)true);
    }

    public void connected(ExecutionEnvironment env) {
        this.fireIconChange();
    }

    public void disconnected(ExecutionEnvironment env) {
        this.fireIconChange();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("DEFAULT_RECORD")) {
            this.refresh();
        }
    }

    void refresh() {
        this.fireDisplayNameChange("", this.getDisplayName());
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    public Image getIcon(int type) {
        if (this.isConnected()) {
            return ImageUtilities.loadImage((String)"org/netbeans/modules/remote/ui/connected_host.png");
        }
        return ImageUtilities.loadImage((String)"org/netbeans/modules/remote/ui/disconnected_host.png");
    }

    private boolean isConnected() {
        return ConnectionManager.getInstance().isConnectedTo(this.env);
    }

    public String getDisplayName() {
        return RemoteUtil.getDisplayName(this.env);
    }

    public String getHtmlDisplayName() {
        String displayName = RemoteUtil.getDisplayName(this.env);
        ServerRecord defRec = ServerList.getDefaultRecord();
        if (defRec != null && defRec.getExecutionEnvironment().equals(this.env)) {
            displayName = "<b>" + displayName + "</b>";
        }
        return displayName;
    }

    public Action[] getActions(boolean context) {
        ArrayList<Action> list = new ArrayList<Action>();
        for (Action action : Utilities.actionsForPath((String)"Remote/Host/Actions")) {
            if (action instanceof SingleHostAction && !((SingleHostAction)((Object)action)).isVisible((Node)this)) continue;
            list.add(action);
        }
        return list.toArray(new Action[list.size()]);
    }

    public Action getPreferredAction() {
        if (this.env.isLocal()) {
            return super.getPreferredAction();
        }
        return (Action)SharedClassObject.findObject(HostPropertiesAction.class, (boolean)true);
    }

    public ExecutionEnvironment getExecutionEnvironment() {
        return (ExecutionEnvironment)this.getLookup().lookup(ExecutionEnvironment.class);
    }

    private static class HostSubnodeChildren
    extends ChildFactory<HostNodesProvider> {
        private final Collection<HostNodesProvider> providers;
        private final ExecutionEnvironment execEnv;

        public HostSubnodeChildren(ExecutionEnvironment execEnv, Collection<? extends HostNodesProvider> providers) {
            this.execEnv = execEnv;
            this.providers = new ArrayList<HostNodesProvider>(providers.size());
            for (HostNodesProvider hostNodesProvider : providers) {
                if (!hostNodesProvider.isApplicable(execEnv)) continue;
                this.providers.add(hostNodesProvider);
            }
        }

        protected boolean createKeys(List<HostNodesProvider> toPopulate) {
            toPopulate.addAll(this.providers);
            return true;
        }

        protected Node createNodeForKey(HostNodesProvider key) {
            return key.createNode(this.execEnv);
        }
    }
}

