/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.palette;

import java.awt.Image;
import java.io.IOException;
import java.util.List;
import org.netbeans.modules.vmd.api.io.DataObjectContext;
import org.netbeans.modules.vmd.api.io.ProjectUtils;
import org.netbeans.modules.vmd.api.model.ComponentProducer;
import org.netbeans.modules.vmd.api.model.DescriptorRegistry;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.common.ActiveDocumentSupport;
import org.netbeans.modules.vmd.palette.PaletteItemDataObject;
import org.netbeans.modules.vmd.palette.PaletteMap;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;

public class PaletteItemDataNode
extends DataNode {
    private static Image errorBadge = ImageUtilities.loadImage((String)"org/netbeans/modules/vmd/palette/resources/error-badge.gif");
    private PaletteItemDataObject obj;
    private Lookup lookup;
    private boolean isValid = true;
    private boolean needCheck = true;

    public PaletteItemDataNode(PaletteItemDataObject obj) {
        this(obj, new InstanceContent());
    }

    private PaletteItemDataNode(PaletteItemDataObject obj, InstanceContent ic) {
        super((DataObject)obj, Children.LEAF, (Lookup)new AbstractLookup((AbstractLookup.Content)ic));
        ic.add((Object)obj);
        ic.add((Object)this);
        this.obj = obj;
        this.lookup = Lookups.singleton((Object)((Object)this));
    }

    public String getDisplayName() {
        return this.obj.getDisplayName();
    }

    public String getShortDescription() {
        return this.obj.getToolTip();
    }

    public Image getIcon(int type) {
        if (this.needCheck) {
            PaletteMap.getInstance().checkValidity(this.getProjectType(), this.lookup);
        }
        if (type == 1 || type == 3) {
            String iconPath = this.obj.getIcon();
            Image icon = null;
            if (iconPath != null) {
                icon = ImageUtilities.loadImage((String)iconPath);
            }
            if (icon == null) {
                icon = super.getIcon(type);
            }
            if (!this.isValid) {
                icon = ImageUtilities.mergeImages((Image)icon, (Image)errorBadge, (int)errorBadge.getWidth(null), (int)errorBadge.getHeight(null));
            }
            return icon;
        }
        String iconPath = this.obj.getBigIcon();
        Image icon = null;
        if (iconPath != null) {
            icon = ImageUtilities.loadImage((String)iconPath);
        }
        if (icon == null) {
            icon = super.getIcon(type);
        }
        if (!this.isValid) {
            icon = ImageUtilities.mergeImages((Image)icon, (Image)errorBadge, (int)errorBadge.getWidth(null), (int)errorBadge.getHeight(null));
        }
        return icon;
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    String getProjectType() {
        return this.obj.getProjectType();
    }

    String getProducerID() {
        return this.obj.getProducerID();
    }

    void setValid(boolean isValid) {
        this.isValid = isValid;
    }

    boolean isValid() {
        return this.isValid;
    }

    void setNeedCheck(boolean needCheck) {
        this.needCheck = needCheck;
    }

    public boolean canRename() {
        return false;
    }

    public boolean canDestroy() {
        DataObjectContext context;
        boolean canDestroy = false;
        DesignDocument document = ActiveDocumentSupport.getDefault().getActiveDocument();
        if (document != null && (context = ProjectUtils.getDataObjectContextForDocument((DesignDocument)document)) != null) {
            final ComponentProducer[] producer = new ComponentProducer[1];
            final DescriptorRegistry registry = DescriptorRegistry.getDescriptorRegistry((String)context.getProjectType(), (String)context.getProjectID());
            registry.readAccess(new Runnable(){

                @Override
                public void run() {
                    List producers = registry.getComponentProducers();
                    for (ComponentProducer p : producers) {
                        if (!p.getProducerID().equals(PaletteItemDataNode.this.obj.getProducerID())) continue;
                        producer[0] = p;
                        break;
                    }
                }
            });
            if (producer[0] != null) {
                canDestroy = "custom".equals(producer[0].getPaletteDescriptor().getCategoryID());
            }
        }
        return canDestroy;
    }

    public void destroy() throws IOException {
        DataObjectContext context;
        super.destroy();
        DesignDocument document = ActiveDocumentSupport.getDefault().getActiveDocument();
        if (document != null && (context = ProjectUtils.getDataObjectContextForDocument((DesignDocument)document)) != null) {
            final ComponentProducer[] producer = new ComponentProducer[1];
            final DescriptorRegistry registry = DescriptorRegistry.getDescriptorRegistry((String)context.getProjectType(), (String)context.getProjectID());
            registry.readAccess(new Runnable(){

                @Override
                public void run() {
                    List producers = registry.getComponentProducers();
                    for (ComponentProducer p : producers) {
                        if (!p.getProducerID().equals(PaletteItemDataNode.this.obj.getProducerID())) continue;
                        producer[0] = p;
                        break;
                    }
                }
            });
            if (producer[0] != null) {
                registry.removeComponentDescriptor(producer[0].getMainComponentTypeID());
            }
        }
    }

    public boolean canCopy() {
        return false;
    }

    public boolean canCut() {
        return false;
    }
}

