/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.navigation.actions;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ui.ElementOpen;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.web.beans.api.model.InjectionPointDefinitionError;
import org.netbeans.modules.web.beans.api.model.Result;
import org.netbeans.modules.web.beans.api.model.WebBeansModel;
import org.netbeans.modules.web.beans.navigation.InjectablesModel;
import org.netbeans.modules.web.beans.navigation.InjectablesPopup;
import org.netbeans.modules.web.beans.navigation.PopupUtil;
import org.netbeans.modules.web.beans.navigation.actions.AbstractInjectableAction;
import org.netbeans.modules.web.beans.navigation.actions.WebBeansActionHelper;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class GoToInjectableAtCaretAction
extends AbstractInjectableAction {
    private static final long serialVersionUID = -6998124281864635094L;
    private static final String GOTO_INJACTABLE_AT_CARET = "go-to-injactable-at-caret";
    private static final String GOTO_INJACTABLE_AT_CARET_POPUP = "go-to-injactable-at-caret-popup";

    public GoToInjectableAtCaretAction() {
        super(NbBundle.getMessage(GoToInjectableAtCaretAction.class, (String)GOTO_INJACTABLE_AT_CARET));
    }

    @Override
    protected String getActionCommand() {
        return GOTO_INJACTABLE_AT_CARET;
    }

    @Override
    protected String getPopupMenuKey() {
        return GOTO_INJACTABLE_AT_CARET_POPUP;
    }

    @Override
    protected void modelAcessAction(WebBeansModel model, final MetadataModel<WebBeansModel> metaModel, Object[] variable, final JTextComponent component, FileObject fileObject) {
        VariableElement var = WebBeansActionHelper.findVariable(model, variable);
        if (var == null) {
            return;
        }
        try {
            if (!model.isInjectionPoint(var)) {
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(GoToInjectableAtCaretAction.class, (String)"LBL_NotInjectionPoint"), 700);
                return;
            }
        }
        catch (InjectionPointDefinitionError e) {
            StatusDisplayer.getDefault().setStatusText(e.getMessage(), 700);
        }
        final Result result = model.getInjectable(var, null);
        if (result == null) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(GoToInjectableAtCaretAction.class, (String)"LBL_InjectableNotFound"), 700);
            return;
        }
        if (result instanceof Result.Error) {
            StatusDisplayer.getDefault().setStatusText(((Result.Error)result).getMessage(), 700);
        }
        if (result.getKind() == Result.ResultKind.DEFINITION_ERROR) {
            return;
        }
        if (result.getKind() == Result.ResultKind.INJECTABLE_RESOLVED) {
            Element injectable = ((Result.InjectableResult)result).getElement();
            final ElementHandle handle = ElementHandle.create((Element)injectable);
            final ClasspathInfo classpathInfo = model.getCompilationController().getClasspathInfo();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ElementOpen.open((ClasspathInfo)classpathInfo, (ElementHandle)handle);
                }
            });
        } else if (result.getKind() == Result.ResultKind.RESOLUTION_ERROR) {
            final CompilationController controller = model.getCompilationController();
            if (SwingUtilities.isEventDispatchThread()) {
                this.showPopup(result, controller, metaModel, component);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        GoToInjectableAtCaretAction.this.showPopup(result, controller, (MetadataModel<WebBeansModel>)metaModel, component);
                    }
                });
            }
        }
    }

    private void showPopup(Result result, CompilationController controller, MetadataModel<WebBeansModel> model, JTextComponent target) {
        if (!(result instanceof Result.ApplicableResult)) {
            return;
        }
        Set<TypeElement> typeElements = ((Result.ApplicableResult)((Object)result)).getTypeElements();
        Set<Element> productions = ((Result.ApplicableResult)((Object)result)).getProductions();
        if (typeElements.size() + productions.size() == 0) {
            return;
        }
        ArrayList<ElementHandle<Element>> handles = new ArrayList<ElementHandle<Element>>(typeElements.size() + productions.size());
        for (TypeElement typeElement : typeElements) {
            if (((Result.ApplicableResult)((Object)result)).isDisabled(typeElement)) continue;
            handles.add(ElementHandle.create((Element)typeElement));
        }
        for (Element element : productions) {
            if (((Result.ApplicableResult)((Object)result)).isDisabled(element)) continue;
            handles.add(ElementHandle.create((Element)element));
        }
        if (handles.size() == 0) {
            return;
        }
        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(InjectablesModel.class, (String)"LBL_WaitNode"));
        try {
            Rectangle rectangle = target.modelToView(target.getCaret().getDot());
            Point point = new Point(rectangle.x, rectangle.y + rectangle.height);
            SwingUtilities.convertPointToScreen(point, target);
            String title = NbBundle.getMessage(GoToInjectableAtCaretAction.class, (String)"LBL_ChooseInjectable");
            PopupUtil.showPopup(new InjectablesPopup(title, handles, controller), title, point.x, point.y);
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

