/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.navigation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelException;
import org.netbeans.modules.web.beans.api.model.Result;
import org.netbeans.modules.web.beans.api.model.WebBeansModel;
import org.netbeans.modules.web.beans.navigation.InjectableTreeNode;
import org.netbeans.modules.web.beans.navigation.JavaHierarchyModel;
import org.netbeans.modules.web.beans.navigation.MethodTreeNode;
import org.netbeans.modules.web.beans.navigation.TypeTreeNode;
import org.openide.filesystems.FileObject;

public final class InjectablesModel
extends DefaultTreeModel
implements JavaHierarchyModel {
    private static final long serialVersionUID = -6845959436250662000L;
    private static final Logger LOG = Logger.getLogger(InjectablesModel.class.getName());
    static Element[] EMPTY_ELEMENTS_ARRAY = new Element[0];
    private List<ElementHandle<TypeElement>> myTypeHandles;
    private Map<ElementHandle<?>, List<TypeMirrorHandle<DeclaredType>>> myProductionHandles;
    private Set<ElementHandle<?>> myDisabledBeans;
    private MetadataModel<WebBeansModel> myModel;

    public InjectablesModel(Result result, CompilationController controller, MetadataModel<WebBeansModel> model) {
        super(null);
        this.myModel = model;
        if (result.getKind() == Result.ResultKind.DEFINITION_ERROR || !(result instanceof Result.ApplicableResult)) {
            this.myTypeHandles = Collections.emptyList();
            this.myProductionHandles = Collections.emptyMap();
            return;
        }
        Result.ApplicableResult applicableResult = (Result.ApplicableResult)((Object)result);
        Set<TypeElement> typeElements = applicableResult.getTypeElements();
        this.myProductionHandles = new HashMap();
        this.myDisabledBeans = new HashSet();
        HashSet<Element> disabled = new HashSet<Element>();
        this.myTypeHandles = new ArrayList<ElementHandle<TypeElement>>(typeElements.size());
        for (TypeElement el : typeElements) {
            ElementHandle handle = ElementHandle.create((Element)el);
            this.myTypeHandles.add((ElementHandle<TypeElement>)handle);
            if (!applicableResult.isDisabled(el)) continue;
            this.myDisabledBeans.add(handle);
            disabled.add(el);
        }
        Map<Element, List<DeclaredType>> allProductions = applicableResult.getAllProductions();
        for (Map.Entry<Element, List<DeclaredType>> entry : allProductions.entrySet()) {
            ElementHandle handleKey = ElementHandle.create((Element)entry.getKey());
            ArrayList<TypeMirrorHandle> list = new ArrayList<TypeMirrorHandle>(entry.getValue().size());
            for (DeclaredType type : entry.getValue()) {
                TypeMirrorHandle typeHandle = TypeMirrorHandle.create((TypeMirror)type);
                list.add(typeHandle);
            }
            this.myProductionHandles.put(handleKey, list);
            if (!applicableResult.isDisabled(entry.getKey())) continue;
            this.myDisabledBeans.add(handleKey);
            disabled.add(entry.getKey());
        }
        this.update(typeElements, allProductions, disabled, controller);
    }

    @Override
    public void update() {
        this.update(this.myTypeHandles, this.myProductionHandles);
    }

    @Override
    public void fireTreeNodesChanged() {
        super.fireTreeNodesChanged(this, this.getPathToRoot((TreeNode)this.getRoot()), null, null);
    }

    private void update(final List<ElementHandle<TypeElement>> typeHandles, final Map<ElementHandle<?>, List<TypeMirrorHandle<DeclaredType>>> productions) {
        try {
            this.getModel().runReadAction((MetadataModelAction)new MetadataModelAction<WebBeansModel, Void>(){

                public Void run(WebBeansModel model) {
                    HashSet disabled = new HashSet();
                    List typesList = InjectablesModel.this.fillTypes(typeHandles, model, disabled);
                    Map productionsMap = InjectablesModel.this.fillProductions(productions, model, disabled);
                    InjectablesModel.this.update(typesList, productionsMap, disabled, model.getCompilationController());
                    return null;
                }
            });
            return;
        }
        catch (MetadataModelException e) {
            LOG.log(Level.WARNING, e.getMessage(), e);
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, e.getMessage(), e);
        }
    }

    private Map<Element, List<DeclaredType>> fillProductions(Map<ElementHandle<?>, List<TypeMirrorHandle<DeclaredType>>> productions, WebBeansModel model, Set<Element> disabled) {
        Map<Element, List<DeclaredType>> result;
        if (productions == null || productions.size() == 0) {
            result = Collections.emptyMap();
        } else {
            result = new HashMap<Element, List<DeclaredType>>();
            for (Map.Entry<ElementHandle<?>, List<TypeMirrorHandle<DeclaredType>>> entry : productions.entrySet()) {
                ElementHandle<?> handle = entry.getKey();
                Element element = handle.resolve((CompilationInfo)model.getCompilationController());
                if (element != null) {
                    if (this.myDisabledBeans.contains(handle)) {
                        disabled.add(element);
                    }
                    ArrayList<DeclaredType> list = new ArrayList<DeclaredType>(entry.getValue().size());
                    for (TypeMirrorHandle<DeclaredType> mirrorHandle : entry.getValue()) {
                        DeclaredType mirror = (DeclaredType)mirrorHandle.resolve((CompilationInfo)model.getCompilationController());
                        if (mirror != null) {
                            list.add(mirror);
                            continue;
                        }
                        LOG.warning(mirrorHandle.toString() + " cannot be resolved using: " + model.getCompilationController().getClasspathInfo());
                    }
                    if (list.size() <= 0) continue;
                    result.put(element, list);
                    continue;
                }
                LOG.warning(handle.toString() + " cannot be resolved using: " + model.getCompilationController().getClasspathInfo());
            }
        }
        return result;
    }

    private List<TypeElement> fillTypes(List<ElementHandle<TypeElement>> typeHandles, WebBeansModel model, Set<Element> disabled) {
        List<TypeElement> typesList;
        if (typeHandles != null && typeHandles.size() != 0) {
            typesList = new ArrayList<TypeElement>(typeHandles.size());
            for (ElementHandle<TypeElement> typeHandle : typeHandles) {
                TypeElement element = (TypeElement)typeHandle.resolve((CompilationInfo)model.getCompilationController());
                if (element != null) {
                    typesList.add(element);
                    if (!this.myDisabledBeans.contains(typeHandle)) continue;
                    disabled.add(element);
                    continue;
                }
                LOG.warning(typeHandle.toString() + " cannot be resolved using: " + model.getCompilationController().getClasspathInfo());
            }
        } else {
            typesList = Collections.emptyList();
        }
        return typesList;
    }

    private void update(Collection<TypeElement> typeElements, Map<Element, List<DeclaredType>> productions, Set<Element> disabledBeans, CompilationController controller) {
        if (typeElements.size() == 0 && productions.size() == 0) {
            return;
        }
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        LinkedHashMap<Element, InjectableTreeNode<? extends Element>> elementMap = new LinkedHashMap<Element, InjectableTreeNode<? extends Element>>();
        for (TypeElement typeElement : typeElements) {
            FileObject fileObject = SourceUtils.getFile((ElementHandle)ElementHandle.create((Element)typeElement), (ClasspathInfo)controller.getClasspathInfo());
            TypeTreeNode node = new TypeTreeNode(fileObject, typeElement, disabledBeans.contains(typeElement), (CompilationInfo)controller);
            this.insertTreeNode(elementMap, typeElement, node, root, disabledBeans.contains(typeElement), controller);
        }
        for (Map.Entry entry : productions.entrySet()) {
            MethodTreeNode node;
            Element element = (Element)entry.getKey();
            FileObject fileObject = SourceUtils.getFile((ElementHandle)ElementHandle.create((Element)element), (ClasspathInfo)controller.getClasspathInfo());
            if (element instanceof ExecutableElement) {
                node = new MethodTreeNode(fileObject, (ExecutableElement)element, (DeclaredType)((List)entry.getValue()).get(0), disabledBeans.contains(element), (CompilationInfo)controller);
                InjectablesModel.insertTreeNode(elementMap, (ExecutableElement)element, node, root, controller);
                if (((List)entry.getValue()).size() <= 1) continue;
            }
            node = new InjectableTreeNode(fileObject, element, (DeclaredType)((List)entry.getValue()).get(0), disabledBeans.contains(element), (CompilationInfo)controller);
            this.insertTreeNode(elementMap, node, root);
            if (((List)entry.getValue()).size() <= 1) continue;
        }
        this.setRoot(root);
    }

    private void insertTreeNode(Map<Element, InjectableTreeNode<? extends Element>> elementMap, TypeElement element, TypeTreeNode node, DefaultMutableTreeNode root, boolean isDisabled, CompilationController controller) {
        DefaultMutableTreeNode parent = null;
        for (Map.Entry<Element, InjectableTreeNode<? extends Element>> entry : elementMap.entrySet()) {
            Element key = entry.getKey();
            if (!(key instanceof TypeElement)) continue;
            TypeTreeNode injectableNode = (TypeTreeNode)entry.getValue();
            TypeElement typeElement = (TypeElement)key;
            if (typeElement == null || !controller.getTypes().isAssignable(element.asType(), typeElement.asType())) continue;
            if (parent == null) {
                parent = injectableNode;
                continue;
            }
            if (!((TypeTreeNode)parent).isAssignableFrom(typeElement, controller)) continue;
            parent = injectableNode;
        }
        DefaultMutableTreeNode parentNode = parent;
        if (parentNode == null) {
            parentNode = root;
        }
        Enumeration<TreeNode> children = parentNode.children();
        LinkedList<TypeTreeNode> movedChildren = new LinkedList<TypeTreeNode>();
        while (children.hasMoreElements()) {
            TypeTreeNode childNode = (TypeTreeNode)children.nextElement();
            if (!childNode.isAssignable(element, controller)) continue;
            movedChildren.add(childNode);
        }
        for (TypeTreeNode typeTreeNode : movedChildren) {
            parentNode.remove(typeTreeNode);
            node.add(typeTreeNode);
        }
        parentNode.add(node);
        elementMap.put(element, node);
    }

    static void insertTreeNode(Map<Element, InjectableTreeNode<? extends Element>> elementMap, ExecutableElement element, MethodTreeNode node, DefaultMutableTreeNode root, CompilationController controller) {
        DefaultMutableTreeNode parentNode;
        DefaultMutableTreeNode parent = null;
        ArrayList<ExecutableElement> overriddenMethods = new ArrayList<ExecutableElement>();
        ExecutableElement overriddenMethod = element;
        while ((overriddenMethod = controller.getElementUtilities().getOverriddenMethod(overriddenMethod)) != null) {
            overriddenMethods.add(overriddenMethod);
        }
        if (overriddenMethods.size() > 0) {
            for (Map.Entry<Element, InjectableTreeNode<? extends Element>> entry : elementMap.entrySet()) {
                int index;
                Element key = entry.getKey();
                if (!(key instanceof ExecutableElement)) continue;
                MethodTreeNode injectableNode = (MethodTreeNode)entry.getValue();
                ExecutableElement method = (ExecutableElement)key;
                if (method == null || (index = overriddenMethods.indexOf(method)) == -1) continue;
                if (parent == null) {
                    parent = injectableNode;
                    continue;
                }
                if (!((MethodTreeNode)parent).isOverridden(index, overriddenMethods, controller)) continue;
                parent = injectableNode;
            }
        }
        if ((parentNode = parent) == null) {
            parentNode = root;
        }
        Enumeration<TreeNode> children = parentNode.children();
        LinkedList<MethodTreeNode> movedChildren = new LinkedList<MethodTreeNode>();
        while (children.hasMoreElements()) {
            MethodTreeNode childNode = (MethodTreeNode)children.nextElement();
            if (!childNode.overridesMethod(element, controller)) continue;
            movedChildren.add(childNode);
        }
        for (MethodTreeNode methodNode : movedChildren) {
            parentNode.remove(methodNode);
            node.add(methodNode);
        }
        parentNode.add(node);
        elementMap.put(element, node);
    }

    private void insertTreeNode(Map<Element, InjectableTreeNode<? extends Element>> elementMap, InjectableTreeNode<Element> node, DefaultMutableTreeNode root) {
        root.add(node);
    }

    private MetadataModel<WebBeansModel> getModel() {
        return this.myModel;
    }
}

