/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.gsf;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeListener;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.Severity;
import org.netbeans.modules.csl.spi.DefaultError;
import org.netbeans.modules.css.editor.LexerUtils;
import org.netbeans.modules.css.gsf.api.CssParserResult;
import org.netbeans.modules.css.parser.ASCII_CharStream;
import org.netbeans.modules.css.parser.CssParser;
import org.netbeans.modules.css.parser.ParseException;
import org.netbeans.modules.css.parser.SimpleNode;
import org.netbeans.modules.css.parser.SimpleNodeUtil;
import org.netbeans.modules.css.parser.Token;
import org.netbeans.modules.css.parser.TokenMgrError;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Task;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.SourceModificationEvent;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class CssGSFParser
extends Parser {
    private final CssParser PARSER = new CssParser();
    private CssParserResult lastResult = null;
    private static final String PARSE_ERROR_KEY = "parse_error";
    private static final int SEARCH_LIMIT = 10;
    private static final String ERROR_MESSAGE_PREFIX = NbBundle.getMessage(CssGSFParser.class, (String)"unexpected_symbols");

    public void parse(Snapshot snapshot, Task task, SourceModificationEvent event) {
        List<ParseException> parseExceptions = new ArrayList<ParseException>(1);
        SimpleNode root = null;
        try {
            this.PARSER.errors().clear();
            this.PARSER.ReInit(new ASCII_CharStream(new StringReader(((Object)snapshot.getText()).toString())));
            root = this.PARSER.styleSheet();
            parseExceptions = this.PARSER.errors();
        }
        catch (ParseException pe) {
            parseExceptions.add(pe);
        }
        catch (TokenMgrError tme) {
            parseExceptions.add(new ParseException(tme.getMessage()));
        }
        ArrayList<Error> errors = new ArrayList<Error>();
        errors.addAll(this.errors(parseExceptions, snapshot, root));
        this.lastResult = new CssParserResult(this, snapshot, root, errors);
    }

    public Parser.Result getResult(Task task) {
        return this.lastResult;
    }

    public void cancel() {
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    public List<Error> errors(List<ParseException> parseExceptions, Snapshot snapshot, SimpleNode root) {
        ArrayList<Error> errors = new ArrayList<Error>(parseExceptions.size());
        for (ParseException pe : parseExceptions) {
            Error e = this.createError(pe, snapshot, root);
            if (e == null) continue;
            errors.add(e);
        }
        return errors;
    }

    public static boolean containsGeneratedCode(CharSequence text) {
        return CharSequenceUtilities.indexOf((CharSequence)text, (CharSequence)"@@@") != -1;
    }

    private Error createError(ParseException pe, Snapshot snapshot, SimpleNode root) {
        FileObject fo = snapshot.getSource().getFileObject();
        Token lastSuccessToken = pe.currentToken;
        if (lastSuccessToken == null) {
            return new DefaultError(PARSE_ERROR_KEY, pe.getMessage(), pe.getMessage(), fo, 0, 0, Severity.ERROR);
        }
        Token errorToken = lastSuccessToken.next;
        int from = errorToken.offset;
        if (!(CssGSFParser.containsGeneratedCode(lastSuccessToken.image) || CssGSFParser.containsGeneratedCode(errorToken.image) || this.filterError(pe, snapshot, errorToken))) {
            String errorMessage = this.buildErrorMessage(pe);
            int documentStartOffset = LexerUtils.findNearestMappableSourcePosition(snapshot, from, false, 10);
            int documentEndOffset = LexerUtils.findNearestMappableSourcePosition(snapshot, from + errorToken.image.length(), true, 10);
            if (root != null) {
                SimpleNode errorNode = SimpleNodeUtil.findDescendant(root, errorToken.offset);
                assert (errorNode != null);
                SimpleNode parent = (SimpleNode)errorNode.jjtGetParent();
                if (parent != null && parent.kind() == 29 && CssGSFParser.containsGeneratedCode(parent.image())) {
                    return null;
                }
            }
            if (documentStartOffset == -1 && documentEndOffset == -1) {
                documentEndOffset = 0;
                documentStartOffset = 0;
            } else if (documentStartOffset == -1) {
                documentStartOffset = documentEndOffset;
            } else if (documentEndOffset == -1) {
                documentEndOffset = documentStartOffset;
            }
            assert (documentStartOffset <= documentEndOffset);
            return new DefaultError(PARSE_ERROR_KEY, errorMessage, errorMessage, fo, documentStartOffset, documentEndOffset, Severity.ERROR);
        }
        return null;
    }

    private boolean filterError(ParseException pe, Snapshot snapshot, Token errorToken) {
        return pe.currentToken.kind == 11 && errorToken.kind == 8 && snapshot.getOriginalOffset(pe.currentToken.offset) == -1;
    }

    private String buildErrorMessage(ParseException pe) {
        StringBuilder buff = new StringBuilder();
        buff.append(ERROR_MESSAGE_PREFIX);
        int maxSize = 0;
        for (int i = 0; i < pe.expectedTokenSequences.length; ++i) {
            if (maxSize >= pe.expectedTokenSequences[i].length) continue;
            maxSize = pe.expectedTokenSequences[i].length;
        }
        Token tok = pe.currentToken.next;
        buff.append('\"');
        for (int i = 0; i < maxSize; ++i) {
            buff.append(tok.image);
            if (i < maxSize - 1) {
                buff.append(',');
                buff.append(' ');
            }
            tok = tok.next;
        }
        buff.append('\"');
        return buff.toString();
    }
}

