/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jackpot.spi;

import com.sun.source.util.TreePath;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.prefs.Preferences;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.jackpot.impl.MessageImpl;
import org.netbeans.modules.java.hints.jackpot.impl.RulesManager;
import org.netbeans.modules.java.hints.jackpot.spi.HintMetadata;
import org.netbeans.modules.java.hints.options.HintsSettings;
import org.netbeans.modules.java.hints.spi.AbstractHint;

public class HintContext {
    private final CompilationInfo info;
    private final Preferences preferences;
    private final AbstractHint.HintSeverity severity;
    private final HintMetadata metadata;
    private final TreePath path;
    private final Map<String, TreePath> variables;
    private final Map<String, Collection<? extends TreePath>> multiVariables;
    private final Map<String, String> variableNames;
    private final Collection<? super MessageImpl> messages;

    public HintContext(CompilationInfo info, HintMetadata metadata, TreePath path, Map<String, TreePath> variables, Map<String, Collection<? extends TreePath>> multiVariables, Map<String, String> variableNames) {
        this(info, metadata, path, variables, multiVariables, variableNames, new LinkedList());
    }

    public HintContext(CompilationInfo info, HintMetadata metadata, TreePath path, Map<String, TreePath> variables, Map<String, Collection<? extends TreePath>> multiVariables, Map<String, String> variableNames, Collection<? super MessageImpl> problems) {
        this.info = info;
        this.preferences = metadata != null ? RulesManager.getPreferences(metadata.id, HintsSettings.getCurrentProfileId()) : null;
        this.severity = this.preferences != null ? HintsSettings.getSeverity(metadata, this.preferences) : AbstractHint.HintSeverity.ERROR;
        this.metadata = metadata;
        this.path = path;
        variables = new HashMap<String, TreePath>(variables);
        variables.put("$_", path);
        this.variables = variables;
        this.multiVariables = multiVariables;
        this.variableNames = variableNames;
        this.messages = problems;
    }

    public CompilationInfo getInfo() {
        return this.info;
    }

    public Preferences getPreferences() {
        return this.preferences;
    }

    public AbstractHint.HintSeverity getSeverity() {
        return this.severity;
    }

    public TreePath getPath() {
        return this.path;
    }

    public Map<String, TreePath> getVariables() {
        return this.variables;
    }

    public Map<String, Collection<? extends TreePath>> getMultiVariables() {
        return this.multiVariables;
    }

    public Map<String, String> getVariableNames() {
        return this.variableNames;
    }

    public HintMetadata getHintMetadata() {
        return this.metadata;
    }

    public void reportMessage(MessageKind kind, String text) {
        this.messages.add(new MessageImpl(kind, text));
    }

    public static HintContext create(CompilationInfo info, HintMetadata metadata, TreePath path, Map<String, TreePath> variables, Map<String, Collection<? extends TreePath>> multiVariables, Map<String, String> variableNames) {
        return new HintContext(info, metadata, path, variables, multiVariables, variableNames);
    }

    public static enum MessageKind {
        WARNING,
        ERROR;

    }
}

