/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jackpot.impl.pm;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.TreeScanner;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.jackpot.impl.Utilities;
import org.netbeans.modules.java.hints.jackpot.impl.pm.BulkSearch;
import org.netbeans.modules.java.hints.jackpot.impl.pm.NFA;
import org.openide.util.Exceptions;

public class NFABasedBulkSearch
extends BulkSearch {
    private static final Map<Tree.Kind, byte[]> kind2Encoded = new EnumMap<Tree.Kind, byte[]>(Tree.Kind.class);
    private static final Map<Integer, Tree.Kind> encoded2Kind = new HashMap<Integer, Tree.Kind>();

    public NFABasedBulkSearch() {
        super(false);
    }

    @Override
    public Map<String, Collection<TreePath>> match(CompilationInfo info, TreePath tree, BulkSearch.BulkPattern patternIn, Map<String, Long> timeLog) {
        BulkPatternImpl pattern = (BulkPatternImpl)patternIn;
        final HashMap<String, Collection<TreePath>> occurringPatterns = new HashMap<String, Collection<TreePath>>();
        final NFA<Input, Res> nfa = pattern.toNFA();
        new TreePathScanner<Void, Void>(){
            private NFA.State active;
            {
                this.active = nfa.getStartingState();
            }

            @Override
            public Void scan(Tree node, Void p) {
                if (node == null) {
                    return null;
                }
                boolean[] goDeeper = new boolean[1];
                NFA.State newActiveAfterVariable = nfa.transition(this.active, new Input(Tree.Kind.IDENTIFIER, "$", false));
                Input[] bypass = new Input[1];
                Input normalizedInput = NFABasedBulkSearch.normalizeInput(node, goDeeper, bypass);
                NFA.State bypassed = bypass[0] != null ? nfa.transition(this.active, bypass[0]) : null;
                this.active = nfa.transition(this.active, normalizedInput);
                if (goDeeper[0]) {
                    super.scan(node, p);
                }
                NFA.State s1 = nfa.transition(this.active, new Input(normalizedInput.kind, normalizedInput.name, true));
                NFA.State s2 = nfa.transition(newActiveAfterVariable, new Input(Tree.Kind.IDENTIFIER, "$", true));
                if (bypassed != null) {
                    NFA.State bypassed2 = nfa.transition(bypassed, new Input(bypass[0].kind, bypass[0].name, true));
                    this.active = nfa.join(nfa.join(s1, s2), bypassed2);
                } else {
                    this.active = nfa.join(s1, s2);
                }
                for (Res r : nfa.getResults(this.active)) {
                    this.addOccurrence(r, node);
                }
                return null;
            }

            private void addOccurrence(Res r, Tree node) {
                LinkedList<TreePath> occurrences = (LinkedList<TreePath>)occurringPatterns.get(r.pattern);
                if (occurrences == null) {
                    occurrences = new LinkedList<TreePath>();
                    occurringPatterns.put(r.pattern, occurrences);
                }
                occurrences.add(new TreePath(this.getCurrentPath(), node));
            }
        }.scan(tree, (Void)null);
        return occurringPatterns;
    }

    @Override
    public BulkSearch.BulkPattern create(Collection<? extends String> code, Collection<? extends Tree> patterns) {
        int startState = 0;
        final int[] nextState = new int[]{1};
        final LinkedHashMap transitionTable = new LinkedHashMap();
        HashMap<Integer, Res> finalStates = new HashMap<Integer, Res>();
        LinkedList identifiers = new LinkedList();
        LinkedList kinds = new LinkedList();
        Iterator<? extends String> codeIt = code.iterator();
        for (final Tree tree : patterns) {
            final int[] currentState = new int[]{startState};
            final HashSet patternIdentifiers = new HashSet();
            final HashSet patternKinds = new HashSet();
            identifiers.add(patternIdentifiers);
            kinds.add(patternKinds);
            class Scanner
            extends TreeScanner<Void, Void> {
                Scanner() {
                }

                @Override
                public Void scan(Tree t, Void v) {
                    Input[] bypass;
                    boolean[] goDeeper;
                    Input i;
                    if (t == null) {
                        return null;
                    }
                    if (Utilities.isMultistatementWildcardTree(t)) {
                        int n = nextState[0];
                        nextState[0] = n + 1;
                        int target = n;
                        NFABasedBulkSearch.setBit(transitionTable, NFA.Key.create(currentState[0], new Input(Tree.Kind.IDENTIFIER, "$", false)), target);
                        NFABasedBulkSearch.setBit(transitionTable, NFA.Key.create(target, new Input(Tree.Kind.IDENTIFIER, "$", true)), currentState[0]);
                        return null;
                    }
                    if (t.getKind() == Tree.Kind.BLOCK) {
                        StatementTree singletonStatement = null;
                        BlockTree bt = (BlockTree)t;
                        if (!bt.isStatic()) {
                            switch (bt.getStatements().size()) {
                                case 1: {
                                    singletonStatement = bt.getStatements().get(0);
                                    break;
                                }
                                case 2: {
                                    if (Utilities.isMultistatementWildcardTree(bt.getStatements().get(0))) {
                                        singletonStatement = bt.getStatements().get(1);
                                        break;
                                    }
                                    if (!Utilities.isMultistatementWildcardTree(bt.getStatements().get(1))) break;
                                    singletonStatement = bt.getStatements().get(0);
                                    break;
                                }
                                case 3: {
                                    if (!Utilities.isMultistatementWildcardTree(bt.getStatements().get(0)) || !Utilities.isMultistatementWildcardTree(bt.getStatements().get(2))) break;
                                    singletonStatement = bt.getStatements().get(1);
                                }
                            }
                        }
                        if (singletonStatement != null) {
                            int backup = currentState[0];
                            this.scan((Tree)singletonStatement, null);
                            int target = currentState[0];
                            nextState[0] = nextState[0] + 1;
                            NFABasedBulkSearch.setBit(transitionTable, NFA.Key.create(backup, new Input(Tree.Kind.BLOCK, null, false)), currentState[0]);
                            for (StatementTree statementTree : bt.getStatements()) {
                                this.scan((Tree)statementTree, null);
                            }
                            NFABasedBulkSearch.setBit(transitionTable, NFA.Key.create(currentState[0], new Input(Tree.Kind.BLOCK, null, true)), target);
                            currentState[0] = target;
                            return null;
                        }
                    }
                    if ((i = NFABasedBulkSearch.normalizeInput(t, goDeeper = new boolean[1], bypass = new Input[1])).name == null) {
                        patternKinds.add(i.kind.name());
                    } else if (!"$".equals(i.name) && !Utilities.isPureMemberSelect(t, false)) {
                        patternIdentifiers.add(i.name);
                    }
                    int backup = currentState[0];
                    this.handleTree(i, goDeeper, t, bypass);
                    if (StatementTree.class.isAssignableFrom(t.getKind().asInterface()) && t != tree) {
                        int target = currentState[0];
                        nextState[0] = nextState[0] + 1;
                        NFABasedBulkSearch.setBit(transitionTable, NFA.Key.create(backup, new Input(Tree.Kind.BLOCK, null, false)), currentState[0]);
                        this.handleTree(i, goDeeper, t, bypass);
                        NFABasedBulkSearch.setBit(transitionTable, NFA.Key.create(currentState[0], new Input(Tree.Kind.BLOCK, null, true)), target);
                        currentState[0] = target;
                    }
                    return null;
                }

                private void handleTree(Input i, boolean[] goDeeper, Tree t, Input[] bypass) {
                    int backup = currentState[0];
                    nextState[0] = nextState[0] + 1;
                    NFABasedBulkSearch.setBit(transitionTable, NFA.Key.create(backup, i), currentState[0]);
                    if (goDeeper[0]) {
                        super.scan(t, null);
                    }
                    if (bypass[0] != null) {
                        NFABasedBulkSearch.setBit(transitionTable, NFA.Key.create(backup, bypass[0]), currentState[0]);
                    }
                    int n = nextState[0];
                    nextState[0] = n + 1;
                    int target = n;
                    NFABasedBulkSearch.setBit(transitionTable, NFA.Key.create(currentState[0], new Input(i.kind, i.name, true)), target);
                    if (bypass[0] != null) {
                        NFABasedBulkSearch.setBit(transitionTable, NFA.Key.create(currentState[0], new Input(bypass[0].kind, bypass[0].name, true)), target);
                    }
                    currentState[0] = target;
                }
            }
            Scanner s = new Scanner();
            s.scan(tree, null);
            finalStates.put(currentState[0], new Res(codeIt.next()));
        }
        NFA nfa = NFA.create(startState, nextState[0], null, transitionTable, finalStates);
        return BulkPatternImpl.create(identifiers, kinds, nfa);
    }

    private static void setBit(Map<NFA.Key<Input>, NFA.State> transitionTable, NFA.Key<Input> input, int state) {
        NFA.State target = transitionTable.get(input);
        if (target == null) {
            target = NFA.State.create();
            transitionTable.put(input, target);
        }
        target.mutableOr(state);
    }

    private static Input normalizeInput(Tree t, boolean[] goDeeper, Input[] bypass) {
        if (t.getKind() == Tree.Kind.IDENTIFIER && ((IdentifierTree)t).getName().toString().startsWith("$")) {
            goDeeper[0] = false;
            return new Input(Tree.Kind.IDENTIFIER, "$", false);
        }
        if (Utilities.getWildcardTreeName(t) != null) {
            goDeeper[0] = false;
            return new Input(Tree.Kind.IDENTIFIER, "$", false);
        }
        if (t.getKind() == Tree.Kind.IDENTIFIER) {
            goDeeper[0] = false;
            String name = ((IdentifierTree)t).getName().toString();
            return new Input(Tree.Kind.IDENTIFIER, name, false);
        }
        if (t.getKind() == Tree.Kind.MEMBER_SELECT) {
            String name = ((MemberSelectTree)t).getIdentifier().toString();
            if (name.startsWith("$")) {
                goDeeper[0] = false;
                return new Input(Tree.Kind.IDENTIFIER, "$", false);
            }
            if (bypass != null && Utilities.isPureMemberSelect(t, true)) {
                bypass[0] = new Input(Tree.Kind.IDENTIFIER, name, false);
            }
            goDeeper[0] = true;
            return new Input(Tree.Kind.MEMBER_SELECT, name, false);
        }
        goDeeper[0] = true;
        return new Input(t.getKind(), null, false);
    }

    @Override
    public boolean matches(CompilationInfo info, TreePath tree, BulkSearch.BulkPattern pattern) {
        return !this.match(info, tree, pattern).isEmpty();
    }

    @Override
    public void encode(Tree tree, final BulkSearch.EncodingContext ctx) {
        final HashSet identifiers = new HashSet();
        final HashSet treeKinds = new HashSet();
        new TreeScanner<Void, Void>(){

            @Override
            public Void scan(Tree t, Void v) {
                if (t == null) {
                    return null;
                }
                if (t instanceof StatementTree && Utilities.isMultistatementWildcardTree((StatementTree)t)) {
                    return null;
                }
                boolean[] goDeeper = new boolean[1];
                Input i = NFABasedBulkSearch.normalizeInput(t, goDeeper, null);
                try {
                    ctx.getOut().write(40);
                    ctx.getOut().write((byte[])kind2Encoded.get((Object)i.kind));
                    if (i.name == null) {
                        treeKinds.add(i.kind.name());
                    } else {
                        identifiers.add(i.name);
                        ctx.getOut().write(36);
                        ctx.getOut().write(i.name.getBytes("UTF-8"));
                        ctx.getOut().write(59);
                    }
                    if (goDeeper[0]) {
                        super.scan(t, v);
                    }
                    ctx.getOut().write(41);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                return null;
            }
        }.scan(tree, (Void)null);
        ctx.setIdentifiers(identifiers);
        ctx.setKinds(treeKinds);
    }

    @Override
    public boolean matches(InputStream encoded, BulkSearch.BulkPattern patternIn) {
        try {
            return this.matchesImpl(encoded, patternIn);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return false;
        }
    }

    private boolean matchesImpl(InputStream encoded, BulkSearch.BulkPattern patternIn) throws IOException {
        BulkPatternImpl pattern = (BulkPatternImpl)patternIn;
        NFA<Input, Res> nfa = pattern.toNFA();
        Stack<Input> unfinished = new Stack<Input>();
        Stack<NFA.State> skips = new Stack<NFA.State>();
        Stack<NFA.State> bypassed = new Stack<NFA.State>();
        NFA.State active = nfa.getStartingState();
        int read = encoded.read();
        while (read != -1) {
            NFA.State bypassedState;
            if (read == 40) {
                String name;
                read = encoded.read();
                Tree.Kind k = encoded2Kind.get((read << 8) + encoded.read());
                read = encoded.read();
                if (read == 36) {
                    read = encoded.read();
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    while (read != 59) {
                        baos.write(read);
                        read = encoded.read();
                    }
                    read = encoded.read();
                    name = new String(baos.toByteArray(), "UTF-8");
                } else {
                    name = null;
                }
                NFA.State newActiveAfterVariable = nfa.transition(active, new Input(Tree.Kind.IDENTIFIER, "$", false));
                Input normalizedInput = new Input(k, name, false);
                bypassedState = k == Tree.Kind.MEMBER_SELECT && name != null ? nfa.transition(active, new Input(Tree.Kind.IDENTIFIER, name, false)) : null;
                active = nfa.transition(active, normalizedInput);
                unfinished.push(normalizedInput);
                skips.push(newActiveAfterVariable);
                bypassed.push(bypassedState);
                continue;
            }
            Input i = (Input)unfinished.pop();
            NFA.State newActiveAfterVariable = (NFA.State)skips.pop();
            NFA.State s1 = nfa.transition(active, new Input(i.kind, i.name, true));
            NFA.State s2 = nfa.transition(newActiveAfterVariable, new Input(Tree.Kind.IDENTIFIER, "$", true));
            bypassedState = (NFA.State)bypassed.pop();
            if (bypassedState != null) {
                NFA.State activeAfterBypassed = nfa.transition(bypassedState, new Input(Tree.Kind.IDENTIFIER, i.name, true));
                active = nfa.join(nfa.join(s1, s2), activeAfterBypassed);
            } else {
                active = nfa.join(s1, s2);
            }
            if (!nfa.getResults(active).isEmpty()) {
                return true;
            }
            read = encoded.read();
        }
        return false;
    }

    static {
        for (Tree.Kind k : Tree.Kind.values()) {
            String enc = Integer.toHexString(k.ordinal());
            if (enc.length() < 2) {
                enc = "0" + enc;
            }
            try {
                byte[] bytes = enc.getBytes("UTF-8");
                assert (bytes.length == 2);
                kind2Encoded.put(k, bytes);
                encoded2Kind.put((bytes[0] << 8) + bytes[1], k);
            }
            catch (UnsupportedEncodingException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    private static final class Input {
        private final Tree.Kind kind;
        private final String name;
        private final boolean end;

        private Input(Tree.Kind kind, String name, boolean end) {
            this.kind = kind;
            this.name = name;
            this.end = end;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Input other = (Input)obj;
            if (this.kind != other.kind) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return this.end == other.end;
        }

        public int hashCode() {
            int hash = 7;
            hash = 47 * hash + (this.kind != null ? this.kind.hashCode() : 17);
            hash = 47 * hash + (this.name != null ? this.name.hashCode() : 0);
            hash = 47 * hash + (this.end ? 1 : 0);
            return hash;
        }

        public String toString() {
            return (Object)((Object)this.kind) + ", " + this.name + ", " + this.end;
        }
    }

    private static final class Res {
        private final String pattern;

        public Res(String pattern) {
            this.pattern = pattern;
        }
    }

    public static class BulkPatternImpl
    extends BulkSearch.BulkPattern {
        private final NFA<Input, Res> nfa;

        private BulkPatternImpl(List<? extends Set<? extends String>> identifiers, List<? extends Set<? extends String>> kinds, NFA<Input, Res> nfa) {
            super(identifiers, kinds);
            this.nfa = nfa;
        }

        NFA<Input, Res> toNFA() {
            return this.nfa;
        }

        private static BulkSearch.BulkPattern create(List<? extends Set<? extends String>> identifiers, List<? extends Set<? extends String>> kinds, NFA<Input, Res> nfa) {
            return new BulkPatternImpl(identifiers, kinds, nfa);
        }
    }
}

