/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.finalize;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import java.util.ArrayList;
import java.util.Collections;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.finalize.Util;
import org.netbeans.modules.java.hints.jackpot.spi.HintContext;
import org.netbeans.modules.java.hints.jackpot.spi.support.ErrorDescriptionFactory;
import org.netbeans.modules.java.hints.spi.support.FixFactory;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class FinalizeDoesNotCallSuper {
    private static final String SUPER = "super";
    private static final String FINALIZE = "finalize";

    public static ErrorDescription hint(HintContext ctx) {
        assert (ctx != null);
        TreePath tp = ctx.getPath();
        MethodTree method = (MethodTree)tp.getLeaf();
        if (method.getBody() == null) {
            return null;
        }
        if (!Util.isFinalize(method)) {
            return null;
        }
        FindSuper scanner = new FindSuper();
        scanner.scan((Tree)method, null);
        if (scanner.found) {
            return null;
        }
        return ErrorDescriptionFactory.forName(ctx, method, NbBundle.getMessage(FinalizeDoesNotCallSuper.class, (String)"TXT_FinalizeDoesNotCallSuper"), new FixImpl(TreePathHandle.create((TreePath)ctx.getPath(), (CompilationInfo)ctx.getInfo())), FixFactory.createSuppressWarningsFix(ctx.getInfo(), tp, "FinalizeDoesntCallSuperFinalize"));
    }

    static class FixImpl
    implements Fix {
        private final TreePathHandle handle;

        public FixImpl(TreePathHandle handle) {
            assert (handle != null);
            this.handle = handle;
        }

        public String getText() {
            return NbBundle.getMessage(FinalizeDoesNotCallSuper.class, (String)"FIX_FinalizeDoesNotCallSuper");
        }

        public ChangeInfo implement() throws Exception {
            JavaSource.forFileObject((FileObject)this.handle.getFileObject()).runModificationTask((Task)new Task<WorkingCopy>(){

                public void run(WorkingCopy wc) throws Exception {
                    wc.toPhase(JavaSource.Phase.RESOLVED);
                    TreePath tp = FixImpl.this.handle.resolve((CompilationInfo)wc);
                    if (tp == null || tp.getLeaf().getKind() != Tree.Kind.METHOD) {
                        return;
                    }
                    BlockTree oldBody = ((MethodTree)tp.getLeaf()).getBody();
                    TreeMaker tm = wc.getTreeMaker();
                    ArrayList<? extends StatementTree> statements = new ArrayList<StatementTree>(1 + oldBody.getStatements().size());
                    statements.add(tm.ExpressionStatement((ExpressionTree)tm.MethodInvocation(Collections.emptyList(), (ExpressionTree)tm.MemberSelect((ExpressionTree)tm.Identifier((CharSequence)FinalizeDoesNotCallSuper.SUPER), (CharSequence)FinalizeDoesNotCallSuper.FINALIZE), Collections.emptyList())));
                    statements.addAll(oldBody.getStatements());
                    wc.rewrite((Tree)oldBody, (Tree)tm.Block(statements, false));
                }
            }).commit();
            return null;
        }
    }

    static final class FindSuper
    extends TreeScanner<Void, Void> {
        boolean found;

        FindSuper() {
        }

        @Override
        public Void scan(Tree node, Void p) {
            return this.found ? null : (Void)super.scan(node, p);
        }

        @Override
        public Void visitMethodInvocation(MethodInvocationTree node, Void p) {
            if (!node.getArguments().isEmpty()) {
                return null;
            }
            ExpressionTree et = node.getMethodSelect();
            if (et.getKind() != Tree.Kind.MEMBER_SELECT) {
                return null;
            }
            MemberSelectTree mst = (MemberSelectTree)et;
            if (!FinalizeDoesNotCallSuper.FINALIZE.contentEquals(mst.getIdentifier())) {
                return null;
            }
            if (mst.getExpression().getKind() != Tree.Kind.IDENTIFIER) {
                return null;
            }
            if (!FinalizeDoesNotCallSuper.SUPER.contentEquals(((IdentifierTree)mst.getExpression()).getName())) {
                return null;
            }
            this.found = true;
            return null;
        }
    }
}

