/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.modules.java.hints.spi.support.FixFactory;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class SerialVersionUID
implements ErrorRule<Void> {
    public static final Set<String> CODES = Collections.singleton("compiler.warn.missing.SVUID");
    private static final String SERIAL = "serial";
    private static final String SVUID = "serialVersionUID";
    private final AtomicBoolean cancel = new AtomicBoolean();

    public Set<Tree.Kind> getTreeKinds() {
        return TreeUtilities.CLASS_TREE_KINDS;
    }

    @Override
    public Set<String> getCodes() {
        return CODES;
    }

    @Override
    public List<Fix> run(CompilationInfo info, String diagnosticKey, int offset, TreePath treePath, ErrorRule.Data<Void> data) {
        if (treePath == null || !TreeUtilities.CLASS_TREE_KINDS.contains((Object)treePath.getLeaf().getKind())) {
            return null;
        }
        TypeElement type = (TypeElement)info.getTrees().getElement(treePath);
        ArrayList<Fix> fixes = new ArrayList<Fix>();
        fixes.add(new FixImpl(TreePathHandle.create((TreePath)treePath, (CompilationInfo)info), false));
        if (!type.getNestingKind().equals((Object)NestingKind.ANONYMOUS)) {
            fixes.addAll(FixFactory.createSuppressWarnings(info, treePath, SERIAL));
        }
        return fixes;
    }

    @Override
    public String getId() {
        return this.getClass().getName();
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(this.getClass(), (String)"DN_SerialVersionUID");
    }

    @Override
    public void cancel() {
        this.cancel.set(true);
    }

    private static class FixImpl
    implements Fix,
    Task<WorkingCopy> {
        private static final int ENUM_FLAG = 16384;
        private final TreePathHandle handle;
        private final boolean generated;

        public FixImpl(TreePathHandle handle, boolean generated) {
            this.handle = handle;
            this.generated = generated;
            if (generated) {
                throw new UnsupportedOperationException("TODO: implement");
            }
        }

        public String getText() {
            if (this.generated) {
                return NbBundle.getMessage(this.getClass(), (String)"HINT_SerialVersionUID_Generated");
            }
            return NbBundle.getMessage(this.getClass(), (String)"HINT_SerialVersionUID");
        }

        public ChangeInfo implement() throws Exception {
            JavaSource js = JavaSource.forFileObject((FileObject)this.handle.getFileObject());
            js.runModificationTask((Task)this).commit();
            return null;
        }

        public void run(WorkingCopy copy) throws Exception {
            if (copy.toPhase(JavaSource.Phase.RESOLVED).compareTo((Enum)JavaSource.Phase.RESOLVED) < 0) {
                return;
            }
            TreePath treePath = this.handle.resolve((CompilationInfo)copy);
            if (treePath == null || !TreeUtilities.CLASS_TREE_KINDS.contains((Object)treePath.getLeaf().getKind())) {
                return;
            }
            ClassTree classTree = (ClassTree)treePath.getLeaf();
            TreeMaker make = copy.getTreeMaker();
            EnumSet<Modifier> modifiers = EnumSet.of(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL);
            VariableTree svuid = make.Variable(make.Modifiers(modifiers), (CharSequence)SerialVersionUID.SVUID, (Tree)make.Identifier((CharSequence)"long"), (ExpressionTree)make.Literal((Object)1L));
            ClassTree decl = GeneratorUtilities.get((WorkingCopy)copy).insertClassMember(classTree, (Tree)svuid);
            copy.rewrite((Tree)classTree, (Tree)decl);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FixImpl other = (FixImpl)obj;
            if (!(this.handle == other.handle || this.handle != null && this.handle.equals((Object)other.handle))) {
                return false;
            }
            return this.generated == other.generated;
        }

        public int hashCode() {
            int hash = 5;
            hash = 41 * hash + (this.handle != null ? this.handle.hashCode() : 0);
            hash = 41 * hash + (this.generated ? 1 : 0);
            return hash;
        }
    }
}

