/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.spi.AbstractHint;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class EmptyCancelForCancellableTask
extends AbstractHint {
    private static Set<String> typesToCheck = new HashSet<String>(Arrays.asList("org.netbeans.api.java.source.CancellableTask<org.netbeans.api.java.source.CompilationInfo>", "org.netbeans.modules.java.hints.spi.Rule"));

    public EmptyCancelForCancellableTask() {
        super(false, true, AbstractHint.HintSeverity.WARNING, new String[0]);
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(EmptyCancelForCancellableTask.class, (String)"DSC_EmptyCancel");
    }

    @Override
    public Set<Tree.Kind> getTreeKinds() {
        return EnumSet.of(Tree.Kind.METHOD);
    }

    @Override
    public List<ErrorDescription> run(CompilationInfo compilationInfo, TreePath treePath) {
        Element e = compilationInfo.getTrees().getElement(treePath);
        if (e == null || e.getKind() != ElementKind.METHOD || !"cancel".equals(e.getSimpleName().toString()) || e.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            return null;
        }
        Element clazz = e.getEnclosingElement();
        if (!clazz.getKind().isClass()) {
            return null;
        }
        boolean found = false;
        block0: for (String toCheck : typesToCheck) {
            TypeElement clazzTE = (TypeElement)clazz;
            TypeMirror clazzTM = clazzTE.asType();
            TypeMirror typeToCheck = compilationInfo.getTreeUtilities().parseType(toCheck, clazzTE);
            if (typeToCheck.getKind() != TypeKind.DECLARED) continue;
            TypeElement typeToCheckTE = (TypeElement)((DeclaredType)typeToCheck).asElement();
            if (!compilationInfo.getTypes().isSubtype(clazzTM, typeToCheck) || ((Object)clazzTM).equals(typeToCheck)) continue;
            for (ExecutableElement ee : ElementFilter.methodsIn(typeToCheckTE.getEnclosedElements())) {
                if (!compilationInfo.getElements().overrides((ExecutableElement)e, ee, clazzTE)) continue;
                found = true;
                break block0;
            }
        }
        if (!found) {
            return null;
        }
        MethodTree mt = (MethodTree)treePath.getLeaf();
        if (!mt.getBody().getStatements().isEmpty()) {
            return null;
        }
        int[] span = compilationInfo.getTreeUtilities().findNameSpan((MethodTree)treePath.getLeaf());
        if (span != null) {
            String message = NbBundle.getMessage(EmptyCancelForCancellableTask.class, (String)"MSG_EmptyCancel");
            ErrorDescription ed = ErrorDescriptionFactory.createErrorDescription((Severity)this.getSeverity().toEditorSeverity(), (String)message, (FileObject)compilationInfo.getFileObject(), (int)span[0], (int)span[1]);
            return Collections.singletonList(ed);
        }
        return null;
    }

    @Override
    public String getId() {
        return EmptyCancelForCancellableTask.class.getName();
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(EmptyCancelForCancellableTask.class, (String)"LBL_EmptyCancel");
    }

    @Override
    public void cancel() {
    }
}

