/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.embedder;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.prefs.Preferences;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.UnknownRepositoryLayoutException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.ModelBuilder;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingResult;
import org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.repository.LocalArtifactRepository;
import org.codehaus.plexus.ContainerConfiguration;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.logging.AbstractLogger;
import org.codehaus.plexus.logging.BaseLoggerManager;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.LoggerManager;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.netbeans.modules.maven.embedder.ArtifactFixer;
import org.netbeans.modules.maven.embedder.EmbedderConfiguration;
import org.netbeans.modules.maven.embedder.MavenEmbedder;
import org.netbeans.modules.maven.embedder.NBRepositoryModelResolver;
import org.openide.ErrorManager;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;

public final class EmbedderFactory {
    private static final java.util.logging.Logger LOG = java.util.logging.Logger.getLogger(EmbedderFactory.class.getName());
    private static MavenEmbedder project;
    private static MavenEmbedder online;

    private EmbedderFactory() {
    }

    public static synchronized void resetProjectEmbedder() {
        project = null;
        online = null;
    }

    private static File localRepoPreference() {
        Preferences prefs = NbPreferences.root().node("org/netbeans/modules/maven");
        String localRepo = prefs.get("localRepository", null);
        if (localRepo != null) {
            File file = new File(localRepo);
            if (file.exists() && file.isDirectory()) {
                return file;
            }
            if (!file.exists()) {
                if (!file.mkdirs()) {
                    LOG.log(Level.WARNING, "Could not create {0}", file);
                }
                return file;
            }
        }
        return null;
    }

    private static <T> void addComponentDescriptor(DefaultPlexusContainer container, Class<T> roleClass, Class<? extends T> implementationClass, String roleHint) {
        ComponentDescriptor componentDescriptor = new ComponentDescriptor();
        componentDescriptor.setRoleClass(roleClass);
        componentDescriptor.setImplementationClass(implementationClass.asSubclass(roleClass));
        componentDescriptor.setRoleHint(roleHint);
        container.addComponentDescriptor(componentDescriptor);
    }

    public static MavenEmbedder createProjectLikeEmbedder() throws PlexusContainerException {
        DefaultPlexusContainer pc;
        block5: {
            String mavenCoreRealmId = "plexus.core";
            ContainerConfiguration dpcreq = new DefaultContainerConfiguration().setClassWorld(new ClassWorld("plexus.core", EmbedderFactory.class.getClassLoader())).setName("maven");
            pc = new DefaultPlexusContainer(dpcreq);
            EmbedderFactory.addComponentDescriptor(pc, LocalArtifactRepository.class, NbLocalArtifactRepository.class, "ide-workspace");
            pc.setLoggerManager((LoggerManager)new NbLoggerManager());
            try {
                assert (pc.lookup(LocalArtifactRepository.class, "ide-workspace") instanceof NbLocalArtifactRepository);
            }
            catch (ComponentLookupException x) {
                if ($assertionsDisabled) break block5;
                throw new AssertionError((Object)x);
            }
        }
        Properties props = new Properties();
        props.putAll((Map<?, ?>)System.getProperties());
        EmbedderConfiguration configuration = new EmbedderConfiguration((PlexusContainer)pc, EmbedderFactory.localRepoPreference(), EmbedderFactory.fillEnvVars(props), true);
        MavenEmbedder embedder = null;
        try {
            embedder = new MavenEmbedder(configuration);
        }
        catch (ComponentLookupException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
        return embedder;
    }

    public static synchronized MavenEmbedder getProjectEmbedder() {
        if (project == null) {
            try {
                project = EmbedderFactory.createProjectLikeEmbedder();
            }
            catch (PlexusContainerException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return project;
    }

    public static synchronized MavenEmbedder getOnlineEmbedder() {
        if (online == null) {
            try {
                online = EmbedderFactory.createOnlineEmbedder();
            }
            catch (PlexusContainerException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return online;
    }

    static MavenEmbedder createOnlineEmbedder() throws PlexusContainerException {
        String mavenCoreRealmId = "plexus.core";
        ContainerConfiguration dpcreq = new DefaultContainerConfiguration().setClassWorld(new ClassWorld("plexus.core", EmbedderFactory.class.getClassLoader())).setName("maven");
        DefaultPlexusContainer pc = new DefaultPlexusContainer(dpcreq);
        pc.setLoggerManager((LoggerManager)new NbLoggerManager());
        Properties props = new Properties();
        props.putAll((Map<?, ?>)System.getProperties());
        EmbedderConfiguration req = new EmbedderConfiguration((PlexusContainer)pc, EmbedderFactory.localRepoPreference(), EmbedderFactory.fillEnvVars(props), false);
        MavenEmbedder embedder = null;
        try {
            embedder = new MavenEmbedder(req);
        }
        catch (ComponentLookupException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
        return embedder;
    }

    public static ArtifactRepository createRemoteRepository(MavenEmbedder embedder, String url, String id) {
        try {
            ArtifactRepositoryFactory fact = embedder.lookupComponent(ArtifactRepositoryFactory.class);
            assert (fact != null) : "ArtifactRepositoryFactory component not found in maven";
            ArtifactRepositoryPolicy snapshotsPolicy = new ArtifactRepositoryPolicy(true, "always", "warn");
            ArtifactRepositoryPolicy releasesPolicy = new ArtifactRepositoryPolicy(true, "always", "warn");
            return fact.createArtifactRepository(id, url, "default", snapshotsPolicy, releasesPolicy);
        }
        catch (UnknownRepositoryLayoutException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public static List<Model> createModelLineage(File pom, MavenEmbedder embedder) throws ModelBuildingException {
        ModelBuilder mb = embedder.lookupComponent(ModelBuilder.class);
        assert (mb != null) : "ModelBuilder component not found in maven";
        DefaultModelBuildingRequest req = new DefaultModelBuildingRequest();
        req.setPomFile(pom);
        req.setProcessPlugins(false);
        req.setValidationLevel(0);
        req.setModelResolver((ModelResolver)new NBRepositoryModelResolver(embedder));
        req.setSystemProperties(embedder.getSystemProperties());
        ModelBuildingResult res = mb.build((ModelBuildingRequest)req);
        ArrayList<Model> toRet = new ArrayList<Model>();
        for (String id : res.getModelIds()) {
            Model m = res.getRawModel(id);
            toRet.add(m);
        }
        return toRet;
    }

    public static Properties fillEnvVars(Properties properties) {
        try {
            Properties envVars = CommandLineUtils.getSystemEnvVars();
            for (Map.Entry<Object, Object> e : envVars.entrySet()) {
                properties.setProperty("env." + e.getKey().toString(), e.getValue().toString());
            }
        }
        catch (IOException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        return properties;
    }

    private static class NbLoggerManager
    extends BaseLoggerManager {
        private NbLoggerManager() {
        }

        protected Logger createLogger(String name) {
            int level = this.levelOf(LOG).intValue();
            return new NbLogger(level <= Level.FINEST.intValue() ? 0 : (level <= Level.FINER.intValue() ? 1 : (level <= Level.FINE.intValue() ? 2 : 5)), name);
        }

        private Level levelOf(java.util.logging.Logger log) {
            Level lvl = log.getLevel();
            if (lvl != null) {
                return lvl;
            }
            java.util.logging.Logger par = log.getParent();
            if (par != null) {
                return this.levelOf(par);
            }
            return Level.INFO;
        }

        private static class NbLogger
        extends AbstractLogger {
            NbLogger(int threshold, String name) {
                super(threshold, name);
                LOG.log(Level.FINEST, "created Plexus logger {0} at threshold {1}", new Object[]{name, threshold});
            }

            private java.util.logging.Logger logger() {
                return java.util.logging.Logger.getLogger(LOG.getName() + "." + this.getName());
            }

            public void debug(String m, Throwable t) {
                this.logger().log(Level.FINEST, m, t);
            }

            public void info(String m, Throwable t) {
                this.logger().log(Level.FINER, m, t);
            }

            public void warn(String m, Throwable t) {
                this.logger().log(Level.FINE, m, t);
            }

            public void error(String m, Throwable t) {
                this.logger().log(Level.FINE, m, t);
            }

            public void fatalError(String m, Throwable t) {
                this.logger().log(Level.FINE, m, t);
            }

            public Logger getChildLogger(String name) {
                return new NbLogger(this.getThreshold(), this.getName() + "." + name);
            }
        }
    }

    public static class NbLocalArtifactRepository
    extends LocalArtifactRepository {
        private final Collection<? extends ArtifactFixer> fixers = Lookup.getDefault().lookupAll(ArtifactFixer.class);

        public Artifact find(Artifact artifact) {
            for (ArtifactFixer artifactFixer : this.fixers) {
                File f = artifactFixer.resolve(artifact);
                if (f == null) continue;
                artifact.setFile(f);
                artifact.setResolved(true);
                artifact.setRepository((ArtifactRepository)this);
                break;
            }
            return artifact;
        }

        public boolean hasLocalMetadata() {
            return false;
        }
    }
}

