/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midpnb.screen.display;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.microedition.m2g.SVGImage;
import org.netbeans.modules.mobility.svgcore.util.Util;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGListCD;
import org.netbeans.modules.vmd.midpnb.screen.display.SVGListCellRenderer;
import org.netbeans.modules.vmd.midpnb.screen.display.UpdatableSVGComponentDisplayPresenter;
import org.w3c.dom.svg.SVGLocatableElement;
import org.w3c.dom.svg.SVGRect;

public class SVGListDisplayPresenter
extends UpdatableSVGComponentDisplayPresenter {
    private static final String CONTENT = "content";
    private static final String HIDDEN_TEXT = "hidden_text";
    private static final String BOUNDS = "bound";
    private static final String CONTENT_SUFFIX = "_content";
    private static final String BOUNDS_SUFIX = "_bound";
    private static final String HIDDEN_TEXT_SUFFIX = "_hidden_text";
    protected static final String TRAIT_FONT_SIZE = "font-size";
    protected static final String TRAIT_FONT_FAMILY = "font-family";
    protected static final String TEXT = "text";
    public static final String METADATA_METADATA = "text";
    public static final String METADATA_DISPLAY = "display";
    public static final String METADATA_NONE = "none";

    @Override
    protected void reloadSVGComponent(SVGImage svgImage, DesignComponent svgComponent, String componentId) {
        SVGLocatableElement myHiddenText = (SVGLocatableElement)Util.getElementById((SVGImage)svgImage, (String)(componentId + HIDDEN_TEXT_SUFFIX));
        SVGLocatableElement myBounds = (SVGLocatableElement)Util.getElementById((SVGImage)svgImage, (String)(componentId + BOUNDS_SUFIX));
        SVGLocatableElement myContent = (SVGLocatableElement)Util.getElementById((SVGImage)svgImage, (String)(componentId + CONTENT_SUFFIX));
        if (myHiddenText == null || myBounds == null) {
            return;
        }
        float itemHeight = myHiddenText.getFloatTrait(TRAIT_FONT_SIZE);
        int listCapacity = (int)(myBounds.getBBox().getHeight() / itemHeight);
        SVGListCellRenderer renderer = new SVGListCellRenderer(svgImage.getDocument(), itemHeight, myHiddenText, myBounds, myContent);
        List<String> items = this.getListModelElements(svgComponent);
        this.renderList(items, renderer, listCapacity);
    }

    private Vector<SVGLocatableElement> renderList(List<String> items, SVGListCellRenderer renderer, int listCapacity) {
        renderer.clearContent();
        Vector<SVGLocatableElement> vector = new Vector<SVGLocatableElement>();
        int itemsCount = items.size();
        if (itemsCount == 0) {
            return vector;
        }
        int i = 0;
        do {
            SVGLocatableElement comp = renderer.getCellRendererComponent(items.get(i), i);
            vector.addElement(comp);
        } while (++i < Math.min(listCapacity, itemsCount));
        return vector;
    }

    public SVGRect getBounds(SVGLocatableElement element) {
        if (element == null) {
            return null;
        }
        SVGRect rect = element.getScreenBBox();
        return rect;
    }

    private List<String> getListModelElements(DesignComponent svgComponent) {
        ArrayList<String> itemsList = new ArrayList<String>();
        if (SVGListCD.TYPEID != svgComponent.getType()) {
            return itemsList;
        }
        PropertyValue model = svgComponent.readProperty("listElements");
        if (model == null) {
            return itemsList;
        }
        if (model.getKind().equals((Object)PropertyValue.Kind.USERCODE)) {
            itemsList.add("<code>");
        } else {
            List propsList = model.getArray();
            if (propsList == null || propsList.isEmpty()) {
                return itemsList;
            }
            for (PropertyValue propertyValue : propsList) {
                PropertyValue stringValue = propertyValue.getComponent().readProperty("name");
                itemsList.add((String)stringValue.getPrimitiveValue());
            }
        }
        return itemsList;
    }
}

