/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midpnb.components.svg.parsers;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.regex.Pattern;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midpnb.components.sources.SVGMenuElementEventSourceCD;
import org.netbeans.modules.vmd.midpnb.components.svg.parsers.AbstractElementsContentHandler;
import org.netbeans.modules.vmd.midpnb.components.svg.parsers.SVGComponentImageParser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public final class SVGMenuImageParser
extends SVGComponentImageParser {
    private static final String MENU_ELEMENT_SEARCH_PATTERN = "menuItem_.*";

    @Override
    public void parse(InputStream svgInputStream, DesignComponent svgComponent) {
        SVGMenuImageParser.parseSVGMenu(svgInputStream, svgComponent);
    }

    public static void parseSVGMenu(InputStream svgInputStream, final DesignComponent svgComponent) {
        final String[] menuItems = SVGMenuImageParser.getMenuItems(svgInputStream);
        if (menuItems != null) {
            svgComponent.getDocument().getTransactionManager().writeAccess(new Runnable(){

                @Override
                public void run() {
                    ArrayList<PropertyValue> list = new ArrayList<PropertyValue>(menuItems.length);
                    for (String item : menuItems) {
                        DesignComponent es = svgComponent.getDocument().createComponent(SVGMenuElementEventSourceCD.TYPEID);
                        es.writeProperty("string", MidpTypes.createStringValue((String)item));
                        list.add(PropertyValue.createComponentReference((DesignComponent)es));
                        svgComponent.addComponent(es);
                    }
                    svgComponent.writeProperty("elements", PropertyValue.createArray((TypeID)SVGMenuElementEventSourceCD.TYPEID, list));
                }
            });
        }
    }

    private static String[] getMenuItems(InputStream svgInputStream) {
        NamedElementsContentHandler ch = new NamedElementsContentHandler(MENU_ELEMENT_SEARCH_PATTERN);
        try {
            XMLReader parser = XMLReaderFactory.createXMLReader();
            parser.setContentHandler(ch);
            parser.setEntityResolver(ch);
            parser.parse(new InputSource(svgInputStream));
        }
        catch (IOException ex) {
            Debug.warning((Object[])new Object[]{ex});
        }
        catch (SAXException ex) {
            Debug.warning((Object[])new Object[]{ex});
        }
        ch.sortNamedElements();
        return ch.getFoundElements();
    }

    private static class NamedElementsContentHandler
    extends AbstractElementsContentHandler {
        private ArrayList<String> foundElements = new ArrayList();
        private Pattern regex;

        public NamedElementsContentHandler(String regex) {
            this.regex = Pattern.compile(regex);
        }

        public void sortNamedElements() {
            Collections.sort(this.foundElements);
        }

        public String[] getFoundElements() {
            return this.foundElements.toArray(new String[this.foundElements.size()]);
        }

        public final void resetFoundElements() {
            this.foundElements.clear();
        }

        @Override
        public final void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            String value = atts.getValue("id");
            if (value != null && this.regex.matcher(value).matches()) {
                this.foundElements.add(value);
            }
        }
    }
}

