/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.selector.java.project.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.project.Project;
import org.netbeans.modules.profiler.projectsupport.utilities.ProjectUtilities;
import org.netbeans.modules.profiler.selector.java.nodes.JavaPackageNode;
import org.netbeans.modules.profiler.selector.spi.nodes.ContainerNode;
import org.netbeans.modules.profiler.selector.spi.nodes.PackageNode;
import org.netbeans.modules.profiler.selector.spi.nodes.SelectorChildren;
import org.netbeans.modules.profiler.selector.spi.nodes.SelectorNode;

class ProjectPackages
extends SelectorChildren<ContainerNode> {
    private final PackageType packageType;
    private final Set<ClassIndex.SearchScope> scope = new HashSet<ClassIndex.SearchScope>();
    private final boolean subprojects;

    public ProjectPackages(PackageType type, boolean includeSubprojects) {
        this.packageType = type;
        switch (type) {
            case Source: {
                this.scope.add(ClassIndex.SearchScope.SOURCE);
                break;
            }
            case Libraries: {
                this.scope.add(ClassIndex.SearchScope.DEPENDENCIES);
            }
        }
        this.subprojects = includeSubprojects;
    }

    protected List<SelectorNode> prepareChildren(ContainerNode parent) {
        ArrayList<SelectorNode> pkgs = new ArrayList<SelectorNode>();
        Project project = (Project)parent.getLookup().lookup(Project.class);
        ClasspathInfo cpInfo = ProjectUtilities.getClasspathInfo((Project)project, (boolean)this.subprojects, (boolean)this.scope.contains(ClassIndex.SearchScope.SOURCE), (boolean)this.scope.contains(ClassIndex.SearchScope.DEPENDENCIES));
        if (cpInfo != null) {
            ClassIndex index = cpInfo.getClassIndex();
            for (String pkgName : index.getPackageNames("", true, this.scope)) {
                pkgs.add((SelectorNode)new JavaPackageNode(cpInfo, pkgName, parent, this.scope));
            }
            Collections.sort(pkgs, PackageNode.COMPARATOR);
        }
        return pkgs;
    }

    public static enum PackageType {
        Libraries,
        Source;

    }
}

