/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.toolchain.ui.compiler;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.netbeans.modules.cnd.api.toolchain.AbstractCompiler;
import org.netbeans.modules.cnd.toolchain.compilers.CCCCompiler;
import org.netbeans.modules.cnd.toolchain.ui.compiler.CodeAssistancePanelController;
import org.netbeans.modules.cnd.toolchain.ui.compiler.ParserSettingsPanel;
import org.netbeans.modules.cnd.utils.ui.FileChooser;
import org.netbeans.modules.cnd.utils.ui.ListEditorPanel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class PredefinedPanel
extends JPanel {
    private static final RequestProcessor RP = new RequestProcessor("Reset Compiler Settings", 2);
    private IncludesPanel includesPanel;
    private DefinitionsPanel definitionsPanel;
    private AbstractCompiler compiler;
    private ParserSettingsPanel parserSettingsPanel;
    private boolean settingsReseted = false;
    private JPanel includes;
    private JLabel jLabel1;
    private JPanel macros;
    private JButton resetButton;

    public PredefinedPanel(AbstractCompiler compiler, ParserSettingsPanel parserSettingsPanel) {
        this.initComponents();
        this.compiler = compiler;
        this.parserSettingsPanel = parserSettingsPanel;
        this.updatePanels(false);
        this.resetButton.getAccessibleContext().setAccessibleDescription(PredefinedPanel.getString("RESET_BUTTON_AD"));
        this.setOpaque(false);
    }

    private void updatePanels(final boolean reset) {
        RP.post(new Runnable(){

            @Override
            public void run() {
                if (reset) {
                    PredefinedPanel.this.compiler.resetSystemProperties();
                }
                final List<String> includesList = PredefinedPanel.this.compiler.getSystemIncludeDirectories();
                final List<String> definesList = PredefinedPanel.this.compiler.getSystemPreprocessorSymbols();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (PredefinedPanel.this.includesPanel != null) {
                            PredefinedPanel.this.includes.remove((Component)((Object)PredefinedPanel.this.includesPanel));
                        }
                        PredefinedPanel.this.includes.add((Component)((Object)(PredefinedPanel.this.includesPanel = new IncludesPanel(includesList))));
                        if (definesList instanceof CCCCompiler.CompilerDefinition) {
                            ((CCCCompiler.CompilerDefinition)definesList).sort();
                        } else {
                            Collections.sort(definesList, new Comparator<String>(){

                                @Override
                                public int compare(String s1, String s2) {
                                    return s1.compareToIgnoreCase(s2);
                                }
                            });
                        }
                        if (PredefinedPanel.this.definitionsPanel != null) {
                            PredefinedPanel.this.macros.remove((Component)((Object)PredefinedPanel.this.definitionsPanel));
                        }
                        PredefinedPanel.this.macros.add((Component)((Object)(PredefinedPanel.this.definitionsPanel = new DefinitionsPanel(definesList))));
                        if (reset) {
                            PredefinedPanel.this.parserSettingsPanel.setModified(true);
                            PredefinedPanel.this.settingsReseted = true;
                        }
                        PredefinedPanel.this.validate();
                        PredefinedPanel.this.repaint();
                    }
                });
            }
        });
    }

    public boolean save() {
        boolean wasChanges = this.settingsReseted;
        this.settingsReseted = false;
        if (this.includesPanel != null && this.definitionsPanel != null) {
            List tmpIncludes = this.includesPanel.getListData();
            wasChanges |= this.compiler.setSystemIncludeDirectories(tmpIncludes);
            List definitions = this.definitionsPanel.getListData();
            wasChanges |= this.compiler.setSystemPreprocessorSymbols(definitions);
        }
        return wasChanges;
    }

    public void update() {
        if (CodeAssistancePanelController.TRACE_CODEASSIST) {
            System.err.println("update for PredefinedPanel " + this.compiler.getName());
        }
        this.updatePanels(false);
    }

    public void updateCompiler(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.updatePanels(false);
    }

    private void initComponents() {
        this.includes = new JPanel();
        this.macros = new JPanel();
        this.resetButton = new JButton();
        this.jLabel1 = new JLabel();
        this.setOpaque(false);
        this.includes.setBackground(new Color(255, 51, 51));
        this.includes.setOpaque(false);
        this.includes.setLayout(new BorderLayout());
        this.macros.setBackground(new Color(204, 204, 0));
        this.macros.setOpaque(false);
        this.macros.setLayout(new BorderLayout());
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/cnd/toolchain/ui/compiler/Bundle");
        Mnemonics.setLocalizedText((AbstractButton)this.resetButton, (String)bundle.getString("RESET_BUTTON_TXT"));
        this.resetButton.setOpaque(false);
        this.resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PredefinedPanel.this.resetButtonActionPerformed(evt);
            }
        });
        this.jLabel1.setText(bundle.getString("CODE_ASSISTANCE_COMMENT"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.includes, -1, 573, Short.MAX_VALUE).addComponent(this.macros, GroupLayout.Alignment.TRAILING, -1, 573, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jLabel1, -1, 444, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.resetButton))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.includes, -1, 149, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.macros, -1, 134, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.resetButton).addComponent(this.jLabel1, -2, 34, -2))));
    }

    private void resetButtonActionPerformed(ActionEvent evt) {
        this.updatePanels(true);
    }

    private static String getString(String s) {
        return NbBundle.getMessage(PredefinedPanel.class, (String)s);
    }

    boolean isChanged() {
        boolean isChanged = this.settingsReseted;
        if (this.includesPanel != null) {
            isChanged |= this.includesPanel.isChanged();
        }
        if (this.definitionsPanel != null) {
            isChanged |= this.definitionsPanel.isChanged();
        }
        if (CodeAssistancePanelController.TRACE_CODEASSIST) {
            System.err.println("isChanged for PredefinedPanel " + this.compiler.getName() + " is " + isChanged);
        }
        return isChanged;
    }

    boolean isDataValid() {
        boolean isDataValid = true;
        if (this.includesPanel != null) {
            isDataValid &= this.includesPanel.isDataValid();
        }
        if (this.definitionsPanel != null) {
            isDataValid &= this.definitionsPanel.isDataValid();
        }
        if (CodeAssistancePanelController.TRACE_CODEASSIST) {
            System.err.println("isDataValid for PredefinedPanel " + this.compiler.getName() + " is " + isDataValid);
        }
        return isDataValid;
    }

    void cancel() {
        if (CodeAssistancePanelController.TRACE_CODEASSIST) {
            System.err.println("cancel for PredefinedPanel " + this.compiler.getName());
        }
    }

    private static final class MyDefaultListCellRenderer
    extends DefaultListCellRenderer {
        private final CCCCompiler.CompilerDefinition defs;
        private final String toolTipSuffix;

        MyDefaultListCellRenderer(CCCCompiler.CompilerDefinition defs, String toolTipSuffix) {
            this.defs = defs;
            this.toolTipSuffix = toolTipSuffix;
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            boolean showToolTip = false;
            if (this.defs != null && this.defs.isUserAdded(index)) {
                label.setIcon(this.getLibraryIcon());
                showToolTip = true;
            }
            label.setText(value.toString());
            if (showToolTip) {
                String message = NbBundle.getMessage(PredefinedPanel.class, (String)("UserAdded.tooltip.text." + this.toolTipSuffix), (Object)value.toString());
                label.setToolTipText(message);
            } else {
                label.setToolTipText(null);
            }
            return label;
        }

        private ImageIcon getLibraryIcon() {
            return ImageUtilities.loadImageIcon((String)"org/netbeans/modules/cnd/toolchain/ui/compiler/key.png", (boolean)false);
        }
    }

    private static class DefinitionsPanel
    extends ListEditorPanel<String> {
        private CCCCompiler.CompilerDefinition defs;

        public DefinitionsPanel(List<String> objects) {
            super(objects);
            if (objects instanceof CCCCompiler.CompilerDefinition) {
                this.defs = (CCCCompiler.CompilerDefinition)objects;
                this.setCustomCellRenderer(new MyDefaultListCellRenderer(this.defs, "macro"));
            }
            this.getDefaultButton().setVisible(false);
            if ("Windows".equals(UIManager.getLookAndFeel().getID())) {
                this.getDataPanel().setOpaque(false);
            }
        }

        public String addAction() {
            NotifyDescriptor.InputLine notifyDescriptor = new NotifyDescriptor.InputLine(PredefinedPanel.getString("EditDialogLabelDef"), PredefinedPanel.getString("AddDialogTitle"));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)notifyDescriptor);
            if (notifyDescriptor.getValue() != NotifyDescriptor.OK_OPTION) {
                return null;
            }
            String def = notifyDescriptor.getInputText();
            if (def.length() != 0) {
                if (this.defs != null) {
                    this.defs.setUserAdded(true, this.getListDataSize());
                }
                return def;
            }
            return null;
        }

        public String getListLabelText() {
            return PredefinedPanel.getString("MacroDefinitionsTxt");
        }

        public char getListLabelMnemonic() {
            return PredefinedPanel.getString("MacroDefinitionsMn").charAt(0);
        }

        public String getAddButtonText() {
            return PredefinedPanel.getString("AddButtonTxt");
        }

        public char getAddButtonMnemonics() {
            return PredefinedPanel.getString("MAddButtonMn").charAt(0);
        }

        public char getCopyButtonMnemonics() {
            return PredefinedPanel.getString("MCopyButtonMn").charAt(0);
        }

        public String copyAction(String o) {
            if (this.defs != null) {
                this.defs.setUserAdded(true, this.getListDataSize());
            }
            return o;
        }

        public char getRenameButtonMnemonics() {
            return PredefinedPanel.getString("MditButtonMn").charAt(0);
        }

        public String getRenameButtonText() {
            return PredefinedPanel.getString("EditButtonTxt");
        }

        public void editAction(String o, int i) {
            String s = o;
            NotifyDescriptor.InputLine notifyDescriptor = new NotifyDescriptor.InputLine(PredefinedPanel.getString("EditDialogLabelDef"), PredefinedPanel.getString("EditDialogTitle"));
            notifyDescriptor.setInputText(s);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)notifyDescriptor);
            if (notifyDescriptor.getValue() != NotifyDescriptor.OK_OPTION) {
                return;
            }
            String newS = notifyDescriptor.getInputText();
            if (this.defs != null) {
                this.defs.setUserAdded(true, i);
            }
            this.replaceElement(o, newS, i);
        }

        public char getRemoveButtonMnemonics() {
            return PredefinedPanel.getString("MRemoveButtonMn").charAt(0);
        }

        public void removeAction(String o, int i) {
            if (this.defs != null) {
                this.defs.setUserAdded(false, i);
                for (int j = i; j < this.getListDataSize() - 1; ++j) {
                    boolean userAdded = this.defs.isUserAdded(j + 1);
                    this.defs.setUserAdded(userAdded, j);
                    this.defs.setUserAdded(false, j + 1);
                }
            }
        }

        public char getUpButtonMnemonics() {
            return PredefinedPanel.getString("MUpButtonMn").charAt(0);
        }

        public void upAction(int from) {
            if (this.defs != null) {
                boolean fromValue = this.defs.isUserAdded(from);
                boolean toValue = this.defs.isUserAdded(from - 1);
                this.defs.setUserAdded(fromValue, from - 1);
                this.defs.setUserAdded(toValue, from);
            }
        }

        public char getDownButtonMnemonics() {
            return PredefinedPanel.getString("MDownButtonMn").charAt(0);
        }

        public void downAction(int from) {
            if (this.defs != null) {
                boolean fromValue = this.defs.isUserAdded(from);
                boolean toValue = this.defs.isUserAdded(from + 1);
                this.defs.setUserAdded(fromValue, from + 1);
                this.defs.setUserAdded(toValue, from);
            }
        }
    }

    private static class IncludesPanel
    extends ListEditorPanel<String> {
        private CCCCompiler.CompilerDefinition defs;

        public IncludesPanel(List<String> objects) {
            super(objects);
            if (objects instanceof CCCCompiler.CompilerDefinition) {
                this.defs = (CCCCompiler.CompilerDefinition)objects;
                this.setCustomCellRenderer(new MyDefaultListCellRenderer(this.defs, "include"));
            }
            this.getDefaultButton().setVisible(false);
            if ("Windows".equals(UIManager.getLookAndFeel().getID())) {
                this.getDataPanel().setOpaque(false);
            }
        }

        public String addAction() {
            FileChooser fileChooser;
            int ret;
            String seed = null;
            if (FileChooser.getCurrentChooserFile() != null) {
                seed = FileChooser.getCurrentChooserFile().getPath();
            }
            if (seed == null) {
                seed = System.getProperty("user.home");
            }
            if ((ret = (fileChooser = new FileChooser(PredefinedPanel.getString("SelectDirectoryTxt"), PredefinedPanel.getString("SelectTxt"), 1, null, seed, true)).showOpenDialog((Component)((Object)this))) == 1) {
                return null;
            }
            String itemPath = fileChooser.getSelectedFile().getPath();
            if (this.defs != null) {
                this.defs.setUserAdded(true, this.getListDataSize());
            }
            return itemPath;
        }

        public String getListLabelText() {
            return PredefinedPanel.getString("IncludeDirectoriesTxt");
        }

        public char getListLabelMnemonic() {
            return PredefinedPanel.getString("IncludeDirectoriesMn").charAt(0);
        }

        public String getAddButtonText() {
            return PredefinedPanel.getString("AddButtonTxt");
        }

        public char getAddButtonMnemonics() {
            return PredefinedPanel.getString("IAddButtonMn").charAt(0);
        }

        public char getCopyButtonMnemonics() {
            return PredefinedPanel.getString("ICopyButtonMn").charAt(0);
        }

        public String copyAction(String o) {
            if (this.defs != null) {
                this.defs.setUserAdded(true, this.getListDataSize());
            }
            return o;
        }

        public String getRenameButtonText() {
            return PredefinedPanel.getString("EditButtonTxt");
        }

        public char getRenameButtonMnemonics() {
            return PredefinedPanel.getString("EditButtonMn").charAt(0);
        }

        public void editAction(String o, int i) {
            String s = o;
            NotifyDescriptor.InputLine notifyDescriptor = new NotifyDescriptor.InputLine(PredefinedPanel.getString("EditDialogLabelDir"), PredefinedPanel.getString("EditDialogTitle"));
            notifyDescriptor.setInputText(s);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)notifyDescriptor);
            if (notifyDescriptor.getValue() != NotifyDescriptor.OK_OPTION) {
                return;
            }
            String newS = notifyDescriptor.getInputText();
            if (this.defs != null) {
                this.defs.setUserAdded(true, i);
            }
            this.replaceElement(o, newS, i);
        }

        public char getRemoveButtonMnemonics() {
            return PredefinedPanel.getString("IRemoveButtonMn").charAt(0);
        }

        public void removeAction(String o, int i) {
            if (this.defs != null) {
                this.defs.setUserAdded(false, i);
                for (int j = i; j < this.getListDataSize() - 1; ++j) {
                    boolean userAdded = this.defs.isUserAdded(j + 1);
                    this.defs.setUserAdded(userAdded, j);
                    this.defs.setUserAdded(false, j + 1);
                }
            }
        }

        public char getUpButtonMnemonics() {
            return PredefinedPanel.getString("IUpButtonMn").charAt(0);
        }

        public void upAction(int from) {
            if (this.defs != null) {
                boolean fromValue = this.defs.isUserAdded(from);
                boolean toValue = this.defs.isUserAdded(from - 1);
                this.defs.setUserAdded(fromValue, from - 1);
                this.defs.setUserAdded(toValue, from);
            }
        }

        public char getDownButtonMnemonics() {
            return PredefinedPanel.getString("IDownButtonMn").charAt(0);
        }

        public void downAction(int from) {
            if (this.defs != null) {
                boolean fromValue = this.defs.isUserAdded(from);
                boolean toValue = this.defs.isUserAdded(from + 1);
                this.defs.setUserAdded(fromValue, from + 1);
                this.defs.setUserAdded(toValue, from);
            }
        }
    }
}

